/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ui.internal.commands.Util;

public final class Path
implements Comparable {
    static final int MAXIMUM_PATH_ITEMS = 16;
    private static final int HASH_INITIAL = 87;
    private static final int HASH_FACTOR = 97;
    private List pathItems;

    static Path create() {
        return new Path(Collections.EMPTY_LIST);
    }

    static Path create(String pathItem) throws IllegalArgumentException {
        return new Path(Collections.singletonList(pathItem));
    }

    static Path create(String[] pathItems) throws IllegalArgumentException {
        return new Path(Arrays.asList(pathItems));
    }

    static Path create(List pathItems) throws IllegalArgumentException {
        return new Path(pathItems);
    }

    private Path(List pathItems) throws IllegalArgumentException {
        if (pathItems == null) {
            throw new IllegalArgumentException();
        }
        this.pathItems = Collections.unmodifiableList(new ArrayList(pathItems));
        if (this.pathItems.size() >= 16) {
            throw new IllegalArgumentException();
        }
        Iterator iterator = this.pathItems.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof String) continue;
            throw new IllegalArgumentException();
        }
    }

    public int compareTo(Object object) {
        return Util.compare(this.pathItems, ((Path)object).pathItems);
    }

    public boolean equals(Object object) {
        return object instanceof Path && this.pathItems.equals(((Path)object).pathItems);
    }

    public List getPathItems() {
        return this.pathItems;
    }

    public int hashCode() {
        int result = 87;
        Iterator iterator = this.pathItems.iterator();
        while (iterator.hasNext()) {
            result = result * 97 + iterator.next().hashCode();
        }
        return result;
    }

    public boolean isChildOf(Path path, boolean equals) {
        if (path == null) {
            return false;
        }
        return Util.isChildOf(this.pathItems, path.pathItems, equals);
    }

    public int match(Path path) throws IllegalArgumentException {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        if (path.isChildOf(this, true)) {
            return path.pathItems.size() - this.pathItems.size();
        }
        return -1;
    }

    public String toString() {
        return this.pathItems.toString();
    }
}

