/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.ui.internal.commands.KeyStroke;
import org.eclipse.ui.internal.commands.Util;

public final class KeySequence
implements Comparable {
    private static final int HASH_INITIAL = 47;
    private static final int HASH_FACTOR = 57;
    private static final String KEY_STROKE_SEPARATOR = " ";
    private List keyStrokes;
    static /* synthetic */ Class class$0;

    public static KeySequence create() {
        return new KeySequence(Collections.EMPTY_LIST);
    }

    public static KeySequence create(KeyStroke keyStroke) throws IllegalArgumentException {
        return new KeySequence(Collections.singletonList(keyStroke));
    }

    public static KeySequence create(KeyStroke[] keyStrokes) throws IllegalArgumentException {
        return new KeySequence(Arrays.asList(keyStrokes));
    }

    public static KeySequence create(List keyStrokes) throws IllegalArgumentException {
        return new KeySequence(keyStrokes);
    }

    public static KeySequence parse(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<KeyStroke> keyStrokes = new ArrayList<KeyStroke>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            keyStrokes.add(KeyStroke.parse(stringTokenizer.nextToken()));
        }
        return KeySequence.create(keyStrokes);
    }

    private KeySequence(List keyStrokes) throws IllegalArgumentException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.commands.KeyStroke");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.keyStrokes = Collections.unmodifiableList(Util.safeCopy(keyStrokes, clazz));
    }

    public int compareTo(Object object) {
        return Util.compare(this.keyStrokes, ((KeySequence)object).keyStrokes);
    }

    public boolean equals(Object object) {
        return object instanceof KeySequence && this.keyStrokes.equals(((KeySequence)object).keyStrokes);
    }

    public List getKeyStrokes() {
        return this.keyStrokes;
    }

    public int hashCode() {
        int result = 47;
        Iterator iterator = this.keyStrokes.iterator();
        while (iterator.hasNext()) {
            result = result * 57 + ((KeyStroke)iterator.next()).hashCode();
        }
        return result;
    }

    public boolean isChildOf(KeySequence keySequence, boolean equals) {
        if (keySequence == null) {
            return false;
        }
        return Util.isChildOf(this.keyStrokes, keySequence.keyStrokes, equals);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.keyStrokes.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            if (i != 0) {
                stringBuffer.append(KEY_STROKE_SEPARATOR);
            }
            stringBuffer.append(iterator.next());
            ++i;
        }
        return stringBuffer.toString();
    }
}

