/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.ui.internal.commands.KeyBinding;
import org.eclipse.ui.internal.commands.KeyBindingMatch;
import org.eclipse.ui.internal.commands.KeySequence;
import org.eclipse.ui.internal.commands.KeyStroke;
import org.eclipse.ui.internal.commands.State;

final class KeyNode {
    KeyBindingMatch bestChildMatch = null;
    SortedMap childMap = new TreeMap();
    KeyBindingMatch match = null;
    SortedMap stateMap = new TreeMap();

    static void add(SortedMap tree, KeyBinding binding, State state) {
        List keyStrokes = binding.getKeySequence().getKeyStrokes();
        SortedMap root = tree;
        KeyNode node = null;
        int i = 0;
        while (i < keyStrokes.size()) {
            KeyStroke keyStroke = (KeyStroke)keyStrokes.get(i);
            node = (KeyNode)root.get(keyStroke);
            if (node == null) {
                node = new KeyNode();
                root.put(keyStroke, node);
            }
            root = node.childMap;
            ++i;
        }
        if (node != null) {
            node.add(binding, state);
        }
    }

    static SortedMap find(SortedMap tree, KeySequence prefix) {
        Iterator iterator = prefix.getKeyStrokes().iterator();
        while (iterator.hasNext()) {
            KeyNode node = (KeyNode)tree.get(iterator.next());
            if (node == null) {
                return null;
            }
            tree = node.childMap;
        }
        return tree;
    }

    static void remove(SortedMap tree, KeyBinding binding, State state) {
        List keyStrokes = binding.getKeySequence().getKeyStrokes();
        SortedMap root = tree;
        KeyNode node = null;
        int i = 0;
        while (i < keyStrokes.size()) {
            KeyStroke keyStroke = (KeyStroke)keyStrokes.get(i);
            node = (KeyNode)root.get(keyStroke);
            if (node == null) break;
            root = node.childMap;
            ++i;
        }
        if (node != null) {
            node.remove(binding, state);
        }
    }

    static void solve(SortedMap tree, State[] stack) {
        Iterator iterator = tree.values().iterator();
        while (iterator.hasNext()) {
            KeyNode node = (KeyNode)iterator.next();
            node.match = KeyNode.solveStateMap(node.stateMap, stack);
            KeyNode.solve(node.childMap, stack);
            node.bestChildMatch = null;
            Iterator iterator2 = node.childMap.values().iterator();
            while (iterator2.hasNext()) {
                KeyNode child = (KeyNode)iterator2.next();
                KeyBindingMatch childMatch = child.match;
                if (childMatch == null || node.bestChildMatch != null && childMatch.getValue() >= node.bestChildMatch.getValue()) continue;
                node.bestChildMatch = childMatch;
            }
        }
    }

    static KeyBinding solveActionMap(Map actionMap) {
        TreeSet bindingSet = (TreeSet)actionMap.get(null);
        if (bindingSet == null) {
            bindingSet = new TreeSet();
            Iterator iterator = actionMap.values().iterator();
            while (iterator.hasNext()) {
                bindingSet.addAll((Set)iterator.next());
            }
        }
        return bindingSet.size() == 1 ? (KeyBinding)bindingSet.iterator().next() : null;
    }

    static KeyBinding solvePluginMap(Map pluginMap) {
        Map actionMap = (Map)pluginMap.get(null);
        if (actionMap != null) {
            return KeyNode.solveActionMap(actionMap);
        }
        TreeSet<KeyBinding> bindingSet = new TreeSet<KeyBinding>();
        Iterator iterator = pluginMap.values().iterator();
        while (iterator.hasNext()) {
            bindingSet.add(KeyNode.solveActionMap((Map)iterator.next()));
        }
        return bindingSet.size() == 1 ? (KeyBinding)bindingSet.iterator().next() : null;
    }

    static KeyBindingMatch solveStateMap(SortedMap stateMap, State state) {
        KeyBindingMatch match = null;
        Iterator iterator = stateMap.entrySet().iterator();
        while (iterator.hasNext()) {
            int testMatch;
            KeyBinding testBinding;
            Map.Entry entry = iterator.next();
            State testState = (State)entry.getKey();
            Map testPluginMap = (Map)entry.getValue();
            if (testPluginMap == null || (testBinding = KeyNode.solvePluginMap(testPluginMap)) == null || (testMatch = testState.match(state)) < 0) continue;
            if (testMatch == 0) {
                return KeyBindingMatch.create(testBinding, 0);
            }
            if (match != null && testMatch >= match.getValue()) continue;
            match = KeyBindingMatch.create(testBinding, testMatch);
        }
        return match;
    }

    static KeyBindingMatch solveStateMap(SortedMap stateMap, State[] stack) {
        int i = 0;
        while (i < stack.length) {
            KeyBindingMatch match = KeyNode.solveStateMap(stateMap, stack[i]);
            if (match != null) {
                return match;
            }
            ++i;
        }
        return null;
    }

    static Map toActionMap(Set matches) {
        HashMap<String, TreeSet<KeyBindingMatch>> actionMap = new HashMap<String, TreeSet<KeyBindingMatch>>();
        Iterator iterator = matches.iterator();
        while (iterator.hasNext()) {
            KeyBindingMatch match = (KeyBindingMatch)iterator.next();
            String action = match.getKeyBinding().getCommand();
            TreeSet<KeyBindingMatch> matchSet = (TreeSet<KeyBindingMatch>)actionMap.get(action);
            if (matchSet == null) {
                matchSet = new TreeSet<KeyBindingMatch>();
                actionMap.put(action, matchSet);
            }
            matchSet.add(match);
        }
        return actionMap;
    }

    static void toBindingSet(SortedMap tree, Set bindingSet) {
        Iterator iterator = tree.values().iterator();
        while (iterator.hasNext()) {
            KeyNode.toBindingSet((KeyNode)iterator.next(), bindingSet);
        }
    }

    static void toBindingSet(KeyNode node, Set bindingSet) {
        KeyNode.toBindingSet(node.childMap, bindingSet);
        Iterator iterator = node.stateMap.values().iterator();
        while (iterator.hasNext()) {
            Map pluginMap = (Map)iterator.next();
            Iterator iterator2 = pluginMap.values().iterator();
            while (iterator2.hasNext()) {
                Map actionMap = (Map)iterator2.next();
                Iterator iterator3 = actionMap.values().iterator();
                while (iterator3.hasNext()) {
                    bindingSet.addAll((Set)iterator3.next());
                }
            }
        }
    }

    static void toMatchSet(SortedMap tree, SortedSet matchSet) {
        Iterator iterator = tree.values().iterator();
        while (iterator.hasNext()) {
            KeyNode.toMatchSet((KeyNode)iterator.next(), matchSet);
        }
    }

    static void toMatchSet(KeyNode node, SortedSet matchSet) {
        if (node.bestChildMatch != null && (node.match == null || node.bestChildMatch.getValue() < node.match.getValue())) {
            KeyNode.toMatchSet(node.childMap, matchSet);
        } else if (node.match != null) {
            matchSet.add(node.match);
        }
    }

    static Map toKeySequenceMap(Set matches) {
        TreeMap<KeySequence, TreeSet<KeyBindingMatch>> keySequenceMap = new TreeMap<KeySequence, TreeSet<KeyBindingMatch>>();
        Iterator iterator = matches.iterator();
        while (iterator.hasNext()) {
            KeyBindingMatch match = (KeyBindingMatch)iterator.next();
            KeySequence keySequence = match.getKeyBinding().getKeySequence();
            TreeSet<KeyBindingMatch> matchSet = (TreeSet<KeyBindingMatch>)keySequenceMap.get(keySequence);
            if (matchSet == null) {
                matchSet = new TreeSet<KeyBindingMatch>();
                keySequenceMap.put(keySequence, matchSet);
            }
            matchSet.add(match);
        }
        return keySequenceMap;
    }

    private KeyNode() {
    }

    void add(KeyBinding binding, State state) {
        String action;
        TreeSet<KeyBinding> bindingSet;
        String plugin;
        HashMap<String, TreeSet<KeyBinding>> actionMap;
        HashMap pluginMap = (HashMap)this.stateMap.get(state);
        if (pluginMap == null) {
            pluginMap = new HashMap();
            this.stateMap.put(state, pluginMap);
        }
        if ((actionMap = (HashMap<String, TreeSet<KeyBinding>>)pluginMap.get(plugin = binding.getPlugin())) == null) {
            actionMap = new HashMap<String, TreeSet<KeyBinding>>();
            pluginMap.put(plugin, actionMap);
        }
        if ((bindingSet = (TreeSet<KeyBinding>)actionMap.get(action = binding.getCommand())) == null) {
            bindingSet = new TreeSet<KeyBinding>();
            actionMap.put(action, bindingSet);
        }
        bindingSet.add(binding);
    }

    void remove(KeyBinding binding, State state) {
        String action;
        Set bindingSet;
        String plugin;
        Map actionMap;
        Map pluginMap = (Map)this.stateMap.get(state);
        if (pluginMap != null && (actionMap = (Map)pluginMap.get(plugin = binding.getPlugin())) != null && (bindingSet = (Set)actionMap.get(action = binding.getCommand())) != null) {
            bindingSet.remove(binding);
            if (bindingSet.isEmpty()) {
                actionMap.remove(action);
                if (actionMap.isEmpty()) {
                    pluginMap.remove(plugin);
                    if (pluginMap.isEmpty()) {
                        this.stateMap.remove(state);
                    }
                }
            }
        }
    }
}

