/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.swt.SWT;
import org.eclipse.ui.internal.commands.CoreRegistry;
import org.eclipse.ui.internal.commands.GestureConfiguration;
import org.eclipse.ui.internal.commands.KeyBinding;
import org.eclipse.ui.internal.commands.KeyBindingMatch;
import org.eclipse.ui.internal.commands.KeyConfiguration;
import org.eclipse.ui.internal.commands.KeyMachine;
import org.eclipse.ui.internal.commands.KeyManager;
import org.eclipse.ui.internal.commands.KeySequence;
import org.eclipse.ui.internal.commands.LocalRegistry;
import org.eclipse.ui.internal.commands.Path;
import org.eclipse.ui.internal.commands.PreferenceRegistry;
import org.eclipse.ui.internal.commands.RegionalKeyBinding;
import org.eclipse.ui.internal.commands.Scope;
import org.eclipse.ui.internal.commands.State;

public class KeyManager {
    private static final String KEY_SEQUENCE_SEPARATOR = ", ";
    private static final String LOCALE_SEPARATOR = "_";
    private static final Locale SYSTEM_LOCALE = Locale.getDefault();
    private static final String SYSTEM_PLATFORM = SWT.getPlatform();
    private static KeyManager instance;
    private KeyMachine keyMachine = KeyMachine.create();

    public static KeyManager getInstance() {
        if (instance == null) {
            instance = new KeyManager();
        }
        return instance;
    }

    private static SortedMap buildPathMapForGestureConfigurationMap(SortedMap gestureConfigurationMap) {
        TreeMap<String, Path> pathMap = new TreeMap<String, Path>();
        Iterator iterator = gestureConfigurationMap.keySet().iterator();
        while (iterator.hasNext()) {
            Path path;
            String id = (String)iterator.next();
            if (id == null || (path = KeyManager.pathForGestureConfiguration(id, gestureConfigurationMap)) == null) continue;
            pathMap.put(id, path);
        }
        return pathMap;
    }

    private static SortedMap buildPathMapForKeyConfigurationMap(SortedMap keyConfigurationMap) {
        TreeMap<String, Path> pathMap = new TreeMap<String, Path>();
        Iterator iterator = keyConfigurationMap.keySet().iterator();
        while (iterator.hasNext()) {
            Path path;
            String id = (String)iterator.next();
            if (id == null || (path = KeyManager.pathForKeyConfiguration(id, keyConfigurationMap)) == null) continue;
            pathMap.put(id, path);
        }
        return pathMap;
    }

    private static SortedMap buildPathMapForScopeMap(SortedMap scopeMap) {
        TreeMap<String, Path> pathMap = new TreeMap<String, Path>();
        Iterator iterator = scopeMap.keySet().iterator();
        while (iterator.hasNext()) {
            Path path;
            String id = (String)iterator.next();
            if (id == null || (path = KeyManager.pathForScope(id, scopeMap)) == null) continue;
            pathMap.put(id, path);
        }
        return pathMap;
    }

    private static Path pathForGestureConfiguration(String id, Map gestureConfigurationMap) {
        Path path = null;
        if (id != null) {
            ArrayList<String> pathItems = new ArrayList<String>();
            while (id != null) {
                if (pathItems.contains(id)) {
                    return null;
                }
                GestureConfiguration gestureConfiguration = (GestureConfiguration)gestureConfigurationMap.get(id);
                if (gestureConfiguration == null) {
                    return null;
                }
                pathItems.add(0, id);
                id = gestureConfiguration.getParent();
            }
            path = Path.create(pathItems);
        }
        return path;
    }

    private static Path pathForKeyConfiguration(String id, Map keyConfigurationMap) {
        Path path = null;
        if (id != null) {
            ArrayList<String> pathItems = new ArrayList<String>();
            while (id != null) {
                if (pathItems.contains(id)) {
                    return null;
                }
                KeyConfiguration keyConfiguration = (KeyConfiguration)keyConfigurationMap.get(id);
                if (keyConfiguration == null) {
                    return null;
                }
                pathItems.add(0, id);
                id = keyConfiguration.getParent();
            }
            path = Path.create(pathItems);
        }
        return path;
    }

    private static Path pathForLocale(String locale) {
        Path path = null;
        if (locale != null) {
            ArrayList<String> pathItems = new ArrayList<String>();
            if ((locale = locale.trim()).length() > 0) {
                StringTokenizer st = new StringTokenizer(locale, LOCALE_SEPARATOR);
                while (st.hasMoreElements()) {
                    String value = ((String)st.nextElement()).trim();
                    if (value == null) continue;
                    pathItems.add(value);
                }
            }
            path = Path.create(pathItems);
        }
        return path;
    }

    private static Path pathForPlatform(String platform) {
        Path path = null;
        if (platform != null) {
            ArrayList<String> pathItems = new ArrayList<String>();
            if ((platform = platform.trim()).length() > 0) {
                pathItems.add(platform);
            }
            path = Path.create(pathItems);
        }
        return path;
    }

    private static Path pathForScope(String id, Map scopeMap) {
        Path path = null;
        if (id != null) {
            ArrayList<String> pathItems = new ArrayList<String>();
            while (id != null) {
                if (pathItems.contains(id)) {
                    return null;
                }
                Scope scope = (Scope)scopeMap.get(id);
                if (scope == null) {
                    return null;
                }
                pathItems.add(0, id);
                id = scope.getParent();
            }
            path = Path.create(pathItems);
        }
        return path;
    }

    static SortedSet solveRegionalKeyBindingSet(SortedSet regionalBindingSet, State[] states) {
        TreeSet<KeyBinding> bindingSet = new TreeSet<KeyBinding>();
        class Key
        implements Comparable {
            private static final int HASH_INITIAL = 17;
            private static final int HASH_FACTOR = 27;
            KeySequence keySequence;
            String configuration;
            String scope;

            Key() {
            }

            public int compareTo(Object object) {
                Key key = (Key)object;
                int compareTo = this.keySequence.compareTo(key.keySequence);
                if (compareTo == 0 && (compareTo = this.configuration.compareTo(key.configuration)) == 0) {
                    compareTo = this.scope.compareTo(key.scope);
                }
                return compareTo;
            }

            public boolean equals(Object object) {
                if (!(object instanceof Key)) {
                    return false;
                }
                Key key = (Key)object;
                return this.keySequence.equals(key.keySequence) && this.configuration.equals(key.configuration) && this.scope.equals(key.scope);
            }

            public int hashCode() {
                int result = 17;
                result = result * 27 + this.keySequence.hashCode();
                result = result * 27 + this.configuration.hashCode();
                result = result * 27 + this.scope.hashCode();
                return result;
            }
        }
        TreeMap map = new TreeMap();
        Iterator iterator = regionalBindingSet.iterator();
        while (iterator.hasNext()) {
            ArrayList<KeyBinding> bindings;
            RegionalKeyBinding regionalBinding = (RegionalKeyBinding)iterator.next();
            KeyBinding binding = regionalBinding.getKeyBinding();
            ArrayList<Path> pathItems = new ArrayList<Path>();
            pathItems.add(KeyManager.pathForPlatform(regionalBinding.getPlatform()));
            pathItems.add(KeyManager.pathForLocale(regionalBinding.getLocale()));
            State state = State.create(pathItems);
            Key key = new Key();
            key.keySequence = binding.getKeySequence();
            key.configuration = binding.getKeyConfiguration();
            key.scope = binding.getScope();
            TreeMap<State, ArrayList<KeyBinding>> stateMap = (TreeMap<State, ArrayList<KeyBinding>>)map.get(key);
            if (stateMap == null) {
                stateMap = new TreeMap<State, ArrayList<KeyBinding>>();
                map.put(key, stateMap);
            }
            if ((bindings = (ArrayList<KeyBinding>)stateMap.get(state)) == null) {
                bindings = new ArrayList<KeyBinding>();
                stateMap.put(state, bindings);
            }
            bindings.add(binding);
        }
        Iterator iterator2 = map.values().iterator();
        while (iterator2.hasNext()) {
            Map stateMap = (Map)iterator2.next();
            int bestMatch = -1;
            List bindings = null;
            Iterator iterator3 = stateMap.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry entry = iterator3.next();
                State testState = (State)entry.getKey();
                List testBindingSet = (List)entry.getValue();
                int testMatch = testState.match(states[0]);
                if (testMatch < 0) continue;
                if (bindings == null || testMatch < bestMatch) {
                    bindings = testBindingSet;
                    bestMatch = testMatch;
                }
                if (bestMatch == 0) break;
            }
            if (bindings == null) continue;
            Iterator iterator4 = bindings.iterator();
            while (iterator4.hasNext()) {
                KeyBinding binding = (KeyBinding)iterator4.next();
                bindingSet.add(KeyBinding.create(binding.getCommand(), binding.getKeyConfiguration(), binding.getKeySequence(), binding.getPlugin(), binding.getRank() + bestMatch, binding.getScope()));
            }
        }
        return bindingSet;
    }

    static Path systemLocale() {
        return SYSTEM_LOCALE != null ? KeyManager.pathForLocale(SYSTEM_LOCALE.toString()) : null;
    }

    static Path systemPlatform() {
        return KeyManager.pathForPlatform(SYSTEM_PLATFORM);
    }

    private KeyManager() {
        this.update();
    }

    public KeyMachine getKeyMachine() {
        return this.keyMachine;
    }

    public String getTextForAction(String action) throws IllegalArgumentException {
        KeyBindingMatch match;
        if (action == null) {
            throw new IllegalArgumentException();
        }
        String text = null;
        Map actionMap = this.getKeyMachine().getActionMap();
        SortedSet matchSet = (SortedSet)actionMap.get(action);
        if (matchSet != null && !matchSet.isEmpty() && (match = (KeyBindingMatch)matchSet.first()) != null) {
            text = match.getKeyBinding().getKeySequence().toString();
        }
        return text;
    }

    public void update() {
        ArrayList<Path> pathItems = new ArrayList<Path>();
        pathItems.add(KeyManager.systemPlatform());
        pathItems.add(KeyManager.systemLocale());
        State[] states = new State[]{State.create(pathItems)};
        CoreRegistry coreRegistry = CoreRegistry.getInstance();
        LocalRegistry localRegistry = LocalRegistry.getInstance();
        PreferenceRegistry preferenceRegistry = PreferenceRegistry.getInstance();
        try {
            coreRegistry.load();
        }
        catch (IOException iOException) {}
        try {
            localRegistry.load();
        }
        catch (IOException iOException) {}
        try {
            preferenceRegistry.load();
        }
        catch (IOException iOException) {}
        ArrayList registryKeyConfigurations = new ArrayList();
        registryKeyConfigurations.addAll(coreRegistry.getKeyConfigurations());
        registryKeyConfigurations.addAll(localRegistry.getKeyConfigurations());
        registryKeyConfigurations.addAll(preferenceRegistry.getKeyConfigurations());
        SortedMap registryKeyConfigurationMap = KeyConfiguration.sortedMapById(registryKeyConfigurations);
        SortedMap keyConfigurationMap = KeyManager.buildPathMapForKeyConfigurationMap(registryKeyConfigurationMap);
        ArrayList registryScopes = new ArrayList();
        registryScopes.addAll(coreRegistry.getScopes());
        registryScopes.addAll(localRegistry.getScopes());
        registryScopes.addAll(preferenceRegistry.getScopes());
        SortedMap registryScopeMap = Scope.sortedMapById(registryScopes);
        SortedMap scopeMap = KeyManager.buildPathMapForScopeMap(registryScopeMap);
        TreeSet coreRegistryKeyBindingSet = new TreeSet();
        coreRegistryKeyBindingSet.addAll(coreRegistry.getKeyBindings());
        TreeSet coreRegistryRegionalKeyBindingSet = new TreeSet();
        coreRegistryRegionalKeyBindingSet.addAll(coreRegistry.getRegionalKeyBindings());
        coreRegistryKeyBindingSet.addAll(KeyManager.solveRegionalKeyBindingSet(coreRegistryRegionalKeyBindingSet, states));
        TreeSet localRegistryKeyBindingSet = new TreeSet();
        localRegistryKeyBindingSet.addAll(localRegistry.getKeyBindings());
        TreeSet localRegistryRegionalKeyBindingSet = new TreeSet();
        localRegistryRegionalKeyBindingSet.addAll(localRegistry.getRegionalKeyBindings());
        localRegistryKeyBindingSet.addAll(KeyManager.solveRegionalKeyBindingSet(localRegistryRegionalKeyBindingSet, states));
        TreeSet preferenceRegistryKeyBindingSet = new TreeSet();
        preferenceRegistryKeyBindingSet.addAll(preferenceRegistry.getKeyBindings());
        TreeSet keyBindingSet = new TreeSet();
        keyBindingSet.addAll(coreRegistryKeyBindingSet);
        keyBindingSet.addAll(localRegistryKeyBindingSet);
        keyBindingSet.addAll(preferenceRegistryKeyBindingSet);
        this.keyMachine.setKeyConfigurationMap(Collections.unmodifiableSortedMap(keyConfigurationMap));
        this.keyMachine.setScopeMap(Collections.unmodifiableSortedMap(scopeMap));
        this.keyMachine.setKeyBindingSet(Collections.unmodifiableSortedSet(keyBindingSet));
    }
}

