/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.ui.internal.commands.KeyBinding;
import org.eclipse.ui.internal.commands.KeyBindingMatch;
import org.eclipse.ui.internal.commands.KeyNode;
import org.eclipse.ui.internal.commands.KeySequence;
import org.eclipse.ui.internal.commands.Path;
import org.eclipse.ui.internal.commands.State;

public final class KeyMachine {
    private Map commandMap;
    private Map commandMapForMode;
    private SortedSet keyBindingSet;
    private String keyConfiguration = "org.eclipse.ui.defaultConfiguration";
    private SortedMap keyConfigurationMap = new TreeMap();
    private Map keySequenceMap;
    private Map keySequenceMapForMode;
    private SortedSet matchSet;
    private SortedSet matchSetForMode;
    private KeySequence mode;
    private SortedMap scopeMap = new TreeMap();
    private String[] scopes;
    private boolean solved;
    private SortedMap tree;

    public static KeyMachine create() {
        return new KeyMachine();
    }

    private KeyMachine() {
        this.keyBindingSet = new TreeSet();
        this.scopes = new String[]{"org.eclipse.ui.globalScope"};
        this.mode = KeySequence.create();
    }

    public Map getActionMap() {
        if (this.commandMap == null) {
            this.commandMap = Collections.unmodifiableMap(KeyNode.toActionMap(this.getMatchSet()));
        }
        return this.commandMap;
    }

    public Map getActionMapForMode() {
        if (this.commandMapForMode == null) {
            this.commandMapForMode = Collections.unmodifiableMap(KeyNode.toActionMap(this.getMatchSetForMode()));
        }
        return this.commandMapForMode;
    }

    public SortedSet getKeyBindingSet() {
        return this.keyBindingSet;
    }

    public String getKeyConfiguration() {
        return this.keyConfiguration;
    }

    public SortedMap getKeyConfigurationMap() {
        return this.keyConfigurationMap;
    }

    public Map getKeySequenceMap() {
        if (this.keySequenceMap == null) {
            this.keySequenceMap = Collections.unmodifiableMap(KeyNode.toKeySequenceMap(this.getMatchSet()));
        }
        return this.keySequenceMap;
    }

    public Map getKeySequenceMapForMode() {
        if (this.keySequenceMapForMode == null) {
            this.keySequenceMapForMode = Collections.unmodifiableMap(KeyNode.toKeySequenceMap(this.getMatchSetForMode()));
        }
        return this.keySequenceMapForMode;
    }

    public SortedSet getMatchSet() {
        if (this.matchSet == null) {
            this.solve();
            TreeSet matchSet = new TreeSet();
            KeyNode.toMatchSet(this.tree, matchSet);
            this.matchSet = Collections.unmodifiableSortedSet(matchSet);
        }
        return this.matchSet;
    }

    public SortedSet getMatchSetForMode() {
        if (this.matchSetForMode == null) {
            TreeSet<KeyBindingMatch> matchSetForMode = new TreeSet<KeyBindingMatch>();
            Iterator iterator = this.getMatchSet().iterator();
            while (iterator.hasNext()) {
                KeyBindingMatch keyBindingMatch = (KeyBindingMatch)iterator.next();
                if (!keyBindingMatch.getKeyBinding().getKeySequence().isChildOf(this.mode, false)) continue;
                matchSetForMode.add(keyBindingMatch);
            }
            this.matchSetForMode = Collections.unmodifiableSortedSet(matchSetForMode);
        }
        return this.matchSetForMode;
    }

    public KeySequence getMode() {
        return this.mode;
    }

    public SortedMap getScopeMap() {
        return this.scopeMap;
    }

    public String[] getScopes() {
        return (String[])this.scopes.clone();
    }

    public boolean setKeyBindingSet(SortedSet keyBindingSet) throws IllegalArgumentException {
        if (keyBindingSet == null) {
            throw new IllegalArgumentException();
        }
        keyBindingSet = new TreeSet(keyBindingSet);
        Iterator iterator = keyBindingSet.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() instanceof KeyBinding) continue;
            throw new IllegalArgumentException();
        }
        if (this.keyBindingSet.equals(keyBindingSet)) {
            return false;
        }
        this.keyBindingSet = Collections.unmodifiableSortedSet(keyBindingSet);
        this.invalidateTree();
        return true;
    }

    public boolean setKeyConfiguration(String keyConfiguration) {
        if (keyConfiguration == null) {
            throw new IllegalArgumentException();
        }
        if (this.keyConfiguration.equals(keyConfiguration)) {
            return false;
        }
        this.keyConfiguration = keyConfiguration;
        this.invalidateSolution();
        return true;
    }

    public boolean setKeyConfigurationMap(SortedMap keyConfigurationMap) throws IllegalArgumentException {
        if (keyConfigurationMap == null) {
            throw new IllegalArgumentException();
        }
        keyConfigurationMap = new TreeMap(keyConfigurationMap);
        Iterator iterator = keyConfigurationMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry.getKey() instanceof String && entry.getValue() instanceof Path) continue;
            throw new IllegalArgumentException();
        }
        if (this.keyConfigurationMap.equals(keyConfigurationMap)) {
            return false;
        }
        this.keyConfigurationMap = Collections.unmodifiableSortedMap(keyConfigurationMap);
        this.invalidateTree();
        return true;
    }

    public boolean setMode(KeySequence mode) throws IllegalArgumentException {
        if (mode == null) {
            throw new IllegalArgumentException();
        }
        if (this.mode.equals(mode)) {
            return false;
        }
        this.mode = mode;
        this.invalidateMode();
        return true;
    }

    public boolean setScopeMap(SortedMap scopeMap) throws IllegalArgumentException {
        if (scopeMap == null) {
            throw new IllegalArgumentException();
        }
        scopeMap = new TreeMap(scopeMap);
        Iterator iterator = scopeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry.getKey() instanceof String && entry.getValue() instanceof Path) continue;
            throw new IllegalArgumentException();
        }
        if (this.scopeMap.equals(scopeMap)) {
            return false;
        }
        this.scopeMap = Collections.unmodifiableSortedMap(scopeMap);
        this.invalidateTree();
        return true;
    }

    public boolean setScopes(String[] scopes) throws IllegalArgumentException {
        if (scopes == null || scopes.length == 0) {
            throw new IllegalArgumentException();
        }
        scopes = (String[])scopes.clone();
        int i = 0;
        while (i < scopes.length) {
            if (scopes[i] == null) {
                throw new IllegalArgumentException();
            }
            ++i;
        }
        if (Arrays.equals(this.scopes, scopes)) {
            return false;
        }
        this.scopes = scopes;
        this.invalidateSolution();
        return true;
    }

    private void build() {
        if (this.tree == null) {
            this.tree = new TreeMap();
            Iterator iterator = this.keyBindingSet.iterator();
            while (iterator.hasNext()) {
                Path keyConfiguration;
                KeyBinding keyBinding = (KeyBinding)iterator.next();
                Path scope = (Path)this.scopeMap.get(keyBinding.getScope());
                if (scope == null || (keyConfiguration = (Path)this.keyConfigurationMap.get(keyBinding.getKeyConfiguration())) == null) continue;
                ArrayList<Path> listPaths = new ArrayList<Path>();
                listPaths.add(scope);
                listPaths.add(keyConfiguration);
                KeyNode.add(this.tree, keyBinding, State.create(listPaths));
            }
        }
    }

    private void invalidateMode() {
        this.commandMapForMode = null;
        this.keySequenceMapForMode = null;
        this.matchSetForMode = null;
    }

    private void invalidateSolution() {
        this.solved = false;
        this.commandMap = null;
        this.keySequenceMap = null;
        this.matchSet = null;
        this.invalidateMode();
    }

    private void invalidateTree() {
        this.tree = null;
        this.invalidateSolution();
    }

    private void solve() {
        if (!this.solved) {
            this.build();
            State[] states = new State[this.scopes.length];
            Path keyConfiguration = (Path)this.keyConfigurationMap.get(this.keyConfiguration);
            if (keyConfiguration == null) {
                keyConfiguration = Path.create();
            }
            int i = 0;
            while (i < this.scopes.length) {
                Path scope = (Path)this.scopeMap.get(this.scopes[i]);
                if (scope == null) {
                    scope = Path.create();
                }
                ArrayList<Path> paths = new ArrayList<Path>();
                paths.add(scope);
                paths.add(keyConfiguration);
                states[i] = State.create(paths);
                ++i;
            }
            KeyNode.solve(this.tree, states);
            this.solved = true;
        }
    }
}

