/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import org.eclipse.ui.internal.commands.KeySequence;
import org.eclipse.ui.internal.commands.Util;

public final class KeyBinding
implements Comparable {
    private static final int HASH_INITIAL = 37;
    private static final int HASH_FACTOR = 47;
    private String command;
    private String keyConfiguration;
    private KeySequence keySequence;
    private String plugin;
    private int rank;
    private String scope;

    public static KeyBinding create(String command, String keyConfiguration, KeySequence keySequence, String plugin, int rank, String scope) throws IllegalArgumentException {
        return new KeyBinding(command, keyConfiguration, keySequence, plugin, rank, scope);
    }

    private KeyBinding(String command, String keyConfiguration, KeySequence keySequence, String plugin, int rank, String scope) throws IllegalArgumentException {
        if (keyConfiguration == null || keySequence == null || rank < 0 || scope == null) {
            throw new IllegalArgumentException();
        }
        this.command = command;
        this.keyConfiguration = keyConfiguration;
        this.keySequence = keySequence;
        this.plugin = plugin;
        this.rank = rank;
        this.scope = scope;
    }

    public int compareTo(Object object) {
        KeyBinding keyBinding = (KeyBinding)object;
        int compareTo = Util.compare((Comparable)((Object)this.command), (Comparable)((Object)keyBinding.command));
        if (compareTo == 0 && (compareTo = this.keyConfiguration.compareTo(keyBinding.keyConfiguration)) == 0 && (compareTo = this.keySequence.compareTo(keyBinding.keySequence)) == 0 && (compareTo = Util.compare((Comparable)((Object)this.plugin), (Comparable)((Object)keyBinding.plugin))) == 0 && (compareTo = this.rank - keyBinding.rank) == 0) {
            compareTo = this.scope.compareTo(keyBinding.scope);
        }
        return compareTo;
    }

    public boolean equals(Object object) {
        if (!(object instanceof KeyBinding)) {
            return false;
        }
        KeyBinding keyBinding = (KeyBinding)object;
        return Util.equals(this.command, keyBinding.command) && this.keyConfiguration.equals(keyBinding.keyConfiguration) && this.keySequence.equals(keyBinding.keySequence) && Util.equals(this.plugin, keyBinding.plugin) && this.rank == keyBinding.rank && this.scope.equals(keyBinding.scope);
    }

    public String getCommand() {
        return this.command;
    }

    public String getKeyConfiguration() {
        return this.keyConfiguration;
    }

    public KeySequence getKeySequence() {
        return this.keySequence;
    }

    public String getPlugin() {
        return this.plugin;
    }

    public int getRank() {
        return this.rank;
    }

    public String getScope() {
        return this.scope;
    }

    public int hashCode() {
        int result = 37;
        result = result * 47 + Util.hashCode(this.command);
        result = result * 47 + this.keyConfiguration.hashCode();
        result = result * 47 + this.keySequence.hashCode();
        result = result * 47 + Util.hashCode(this.plugin);
        result = result * 47 + this.rank;
        result = result * 47 + this.scope.hashCode();
        return result;
    }
}

