/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import org.eclipse.ui.internal.commands.GestureSequence;
import org.eclipse.ui.internal.commands.Util;

public final class GestureBinding
implements Comparable {
    private static final int HASH_INITIAL = 37;
    private static final int HASH_FACTOR = 47;
    private String command;
    private String gestureConfiguration;
    private GestureSequence gestureSequence;
    private String plugin;
    private int rank;
    private String scope;

    public static GestureBinding create(String command, String gestureConfiguration, GestureSequence gestureSequence, String plugin, int rank, String scope) throws IllegalArgumentException {
        return new GestureBinding(command, gestureConfiguration, gestureSequence, plugin, rank, scope);
    }

    private GestureBinding(String command, String gestureConfiguration, GestureSequence gestureSequence, String plugin, int rank, String scope) throws IllegalArgumentException {
        if (gestureConfiguration == null || gestureSequence == null || gestureSequence.getGestureStrokes().size() == 0 || rank < 0 || scope == null) {
            throw new IllegalArgumentException();
        }
        this.command = command;
        this.gestureConfiguration = gestureConfiguration;
        this.gestureSequence = gestureSequence;
        this.plugin = plugin;
        this.rank = rank;
        this.scope = scope;
    }

    public int compareTo(Object object) {
        GestureBinding gestureBinding = (GestureBinding)object;
        int compareTo = Util.compare((Comparable)((Object)this.command), (Comparable)((Object)gestureBinding.command));
        if (compareTo == 0 && (compareTo = this.gestureConfiguration.compareTo(gestureBinding.gestureConfiguration)) == 0 && (compareTo = this.gestureSequence.compareTo(gestureBinding.gestureSequence)) == 0 && (compareTo = Util.compare((Comparable)((Object)this.plugin), (Comparable)((Object)gestureBinding.plugin))) == 0 && (compareTo = this.rank - gestureBinding.rank) == 0) {
            compareTo = this.scope.compareTo(gestureBinding.scope);
        }
        return compareTo;
    }

    public boolean equals(Object object) {
        if (!(object instanceof GestureBinding)) {
            return false;
        }
        GestureBinding gestureBinding = (GestureBinding)object;
        return Util.equals(this.command, gestureBinding.command) && this.gestureConfiguration.equals(gestureBinding.gestureConfiguration) && this.gestureSequence.equals(gestureBinding.gestureSequence) && Util.equals(this.plugin, gestureBinding.plugin) && this.rank == gestureBinding.rank && this.scope.equals(gestureBinding.scope);
    }

    public String getCommand() {
        return this.command;
    }

    public String getGestureConfiguration() {
        return this.gestureConfiguration;
    }

    public GestureSequence getGestureSequence() {
        return this.gestureSequence;
    }

    public String getPlugin() {
        return this.plugin;
    }

    public int getRank() {
        return this.rank;
    }

    public String getScope() {
        return this.scope;
    }

    public int hashCode() {
        int result = 37;
        result = result * 47 + Util.hashCode(this.command);
        result = result * 47 + this.gestureConfiguration.hashCode();
        result = result * 47 + this.gestureSequence.hashCode();
        result = result * 47 + Util.hashCode(this.plugin);
        result = result * 47 + this.rank;
        result = result * 47 + this.scope.hashCode();
        return result;
    }
}

