/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.commands.AbstractRegistry;
import org.eclipse.ui.internal.commands.ActiveGestureConfiguration;
import org.eclipse.ui.internal.commands.ActiveKeyConfiguration;
import org.eclipse.ui.internal.commands.Category;
import org.eclipse.ui.internal.commands.Command;
import org.eclipse.ui.internal.commands.ConfigurationElementMemento;
import org.eclipse.ui.internal.commands.GestureBinding;
import org.eclipse.ui.internal.commands.GestureConfiguration;
import org.eclipse.ui.internal.commands.KeyBinding;
import org.eclipse.ui.internal.commands.KeyConfiguration;
import org.eclipse.ui.internal.commands.KeySequence;
import org.eclipse.ui.internal.commands.Persistence;
import org.eclipse.ui.internal.commands.RegionalGestureBinding;
import org.eclipse.ui.internal.commands.RegionalKeyBinding;
import org.eclipse.ui.internal.commands.Scope;

public final class CoreRegistry
extends AbstractRegistry {
    private static CoreRegistry instance;

    public static CoreRegistry getInstance() {
        if (instance == null) {
            instance = new CoreRegistry();
        }
        return instance;
    }

    private CoreRegistry() {
    }

    public void load() throws IOException {
        new RegistryReader(Platform.getPluginRegistry());
    }

    private final class RegistryReader
    extends org.eclipse.ui.internal.registry.RegistryReader {
        private static final String DEPRECATED_KEY_SEQUENCE_SEPARATOR = "||";
        private static final String DEPRECATED_TAG_ACCELERATOR = "accelerator";
        private static final String DEPRECATED_TAG_ACCELERATOR_CONFIGURATION = "acceleratorConfiguration";
        private static final String DEPRECATED_TAG_ACCELERATOR_CONFIGURATIONS = "acceleratorConfigurations";
        private static final String DEPRECATED_TAG_ACCELERATOR_SCOPE = "acceleratorScope";
        private static final String DEPRECATED_TAG_ACCELERATOR_SCOPES = "acceleratorScopes";
        private static final String DEPRECATED_TAG_ACCELERATOR_SET = "acceleratorSet";
        private static final String DEPRECATED_TAG_ACCELERATOR_SETS = "acceleratorSets";
        private static final String DEPRECATED_TAG_ACTION_DEFINITION = "actionDefinition";
        private static final String DEPRECATED_TAG_ACTION_DEFINITIONS = "actionDefinitions";
        private static final String DEPRECATED_TAG_CONFIGURATION_ID = "configurationId";
        private static final String DEPRECATED_TAG_KEY = "key";
        private static final String DEPRECATED_TAG_SCOPE_ID = "scopeId";
        private static final String TAG_ROOT = "commands";
        private List activeGestureConfigurations = new ArrayList();
        private List activeKeyConfigurations = new ArrayList();
        private List categories = new ArrayList();
        private List commands = new ArrayList();
        private List gestureBindings = new ArrayList();
        private List gestureConfigurations = new ArrayList();
        private List keyBindings = new ArrayList();
        private String keyConfiguration;
        private List keyConfigurations = new ArrayList();
        private List regionalGestureBindings = new ArrayList();
        private List regionalKeyBindings = new ArrayList();
        private String scope;
        private List scopes = new ArrayList();

        RegistryReader(IPluginRegistry pluginRegistry) {
            if (pluginRegistry != null) {
                this.readRegistry(pluginRegistry, "org.eclipse.ui", DEPRECATED_TAG_ACCELERATOR_CONFIGURATIONS);
                this.readRegistry(pluginRegistry, "org.eclipse.ui", DEPRECATED_TAG_ACCELERATOR_SCOPES);
                this.readRegistry(pluginRegistry, "org.eclipse.ui", DEPRECATED_TAG_ACCELERATOR_SETS);
                this.readRegistry(pluginRegistry, "org.eclipse.ui", DEPRECATED_TAG_ACTION_DEFINITIONS);
                this.readRegistry(pluginRegistry, "org.eclipse.ui", TAG_ROOT);
            }
            CoreRegistry.this.activeGestureConfigurations = Collections.unmodifiableList(this.activeGestureConfigurations);
            CoreRegistry.this.activeKeyConfigurations = Collections.unmodifiableList(this.activeKeyConfigurations);
            CoreRegistry.this.categories = Collections.unmodifiableList(this.categories);
            CoreRegistry.this.commands = Collections.unmodifiableList(this.commands);
            CoreRegistry.this.gestureBindings = Collections.unmodifiableList(this.gestureBindings);
            CoreRegistry.this.gestureConfigurations = Collections.unmodifiableList(this.gestureConfigurations);
            CoreRegistry.this.keyBindings = Collections.unmodifiableList(this.keyBindings);
            CoreRegistry.this.keyConfigurations = Collections.unmodifiableList(this.keyConfigurations);
            CoreRegistry.this.regionalGestureBindings = Collections.unmodifiableList(this.regionalGestureBindings);
            CoreRegistry.this.regionalKeyBindings = Collections.unmodifiableList(this.regionalKeyBindings);
            CoreRegistry.this.scopes = Collections.unmodifiableList(this.scopes);
        }

        protected boolean readElement(IConfigurationElement element) {
            String name = element.getName();
            if (DEPRECATED_TAG_ACCELERATOR.equals(name) || DEPRECATED_TAG_ACCELERATOR_SET.equals(name)) {
                if (DEPRECATED_TAG_ACCELERATOR.equals(name)) {
                    return this.readDeprecatedAccelerator(element);
                }
                return this.readDeprecatedAcceleratorSet(element);
            }
            if (DEPRECATED_TAG_ACCELERATOR_CONFIGURATION.equals(name)) {
                return this.readKeyConfiguration(element);
            }
            if (DEPRECATED_TAG_ACCELERATOR_SCOPE.equals(name)) {
                return this.readScope(element);
            }
            if (DEPRECATED_TAG_ACTION_DEFINITION.equals(name)) {
                return this.readCommand(element);
            }
            if ("activeGestureConfiguration".equals(name)) {
                return this.readActiveGestureConfiguration(element);
            }
            if ("activeKeyConfiguration".equals(name)) {
                return this.readActiveKeyConfiguration(element);
            }
            if ("category".equals(name)) {
                return this.readCategory(element);
            }
            if ("command".equals(name)) {
                return this.readCommand(element);
            }
            if ("gestureBinding".equals(name)) {
                return this.readGestureBinding(element);
            }
            if ("gestureConfiguration".equals(name)) {
                return this.readGestureConfiguration(element);
            }
            if ("keyBinding".equals(name)) {
                return this.readKeyBinding(element);
            }
            if ("keyConfiguration".equals(name)) {
                return this.readKeyConfiguration(element);
            }
            if ("regionalGestureBinding".equals(name)) {
                return this.readRegionalGestureBinding(element);
            }
            if ("regionalKeyBinding".equals(name)) {
                return this.readRegionalKeyBinding(element);
            }
            if ("scope".equals(name)) {
                return this.readScope(element);
            }
            return false;
        }

        private String getPlugin(IConfigurationElement element) {
            IPluginDescriptor pluginDescriptor;
            IExtension extension;
            String plugin = null;
            if (element != null && (extension = element.getDeclaringExtension()) != null && (pluginDescriptor = extension.getDeclaringPluginDescriptor()) != null) {
                plugin = pluginDescriptor.getUniqueIdentifier();
            }
            return plugin;
        }

        private boolean readActiveGestureConfiguration(IConfigurationElement element) {
            ActiveGestureConfiguration activeGestureConfiguration = Persistence.readActiveGestureConfiguration(ConfigurationElementMemento.create(element), this.getPlugin(element));
            if (activeGestureConfiguration != null) {
                this.activeGestureConfigurations.add(activeGestureConfiguration);
            }
            return true;
        }

        private boolean readActiveKeyConfiguration(IConfigurationElement element) {
            ActiveKeyConfiguration activeKeyConfiguration = Persistence.readActiveKeyConfiguration(ConfigurationElementMemento.create(element), this.getPlugin(element));
            if (activeKeyConfiguration != null) {
                this.activeKeyConfigurations.add(activeKeyConfiguration);
            }
            return true;
        }

        private boolean readCategory(IConfigurationElement element) {
            Category category = Persistence.readCategory(ConfigurationElementMemento.create(element), this.getPlugin(element));
            if (category != null) {
                this.categories.add(category);
            }
            return true;
        }

        private boolean readCommand(IConfigurationElement element) {
            Command command = Persistence.readCommand(ConfigurationElementMemento.create(element), this.getPlugin(element));
            if (command != null) {
                this.commands.add(command);
            }
            return true;
        }

        private boolean readDeprecatedAccelerator(IConfigurationElement element) {
            if (this.keyConfiguration == null || this.scope == null) {
                return false;
            }
            String id = element.getAttribute("id");
            String key = element.getAttribute(DEPRECATED_TAG_KEY);
            if (key != null) {
                ArrayList<KeySequence> keySequences = new ArrayList<KeySequence>();
                StringTokenizer orTokenizer = new StringTokenizer(key, DEPRECATED_KEY_SEQUENCE_SEPARATOR);
                while (orTokenizer.hasMoreTokens()) {
                    try {
                        KeySequence keySequence = KeySequence.parse(orTokenizer.nextToken());
                        if (keySequence.getKeyStrokes().size() < 1) continue;
                        keySequences.add(keySequence);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
                if (keySequences.size() >= 1) {
                    String platform;
                    String locale = element.getAttribute("locale");
                    if (locale == null) {
                        locale = "";
                    }
                    if ((platform = element.getAttribute("platform")) == null) {
                        platform = "";
                    }
                    String plugin = this.getPlugin(element);
                    String rankString = element.getAttribute("rank");
                    int rank = 0;
                    if (rankString != null) {
                        try {
                            rank = Integer.parseInt(rankString);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    Iterator iterator = keySequences.iterator();
                    while (iterator.hasNext()) {
                        KeySequence keySequence = (KeySequence)iterator.next();
                        KeyBinding keyBinding = KeyBinding.create(id, this.keyConfiguration, keySequence, plugin, rank, this.scope);
                        this.regionalKeyBindings.add(RegionalKeyBinding.create(keyBinding, locale, platform));
                    }
                }
            }
            return true;
        }

        private boolean readDeprecatedAcceleratorSet(IConfigurationElement element) {
            this.keyConfiguration = element.getAttribute(DEPRECATED_TAG_CONFIGURATION_ID);
            this.scope = element.getAttribute(DEPRECATED_TAG_SCOPE_ID);
            if (this.keyConfiguration != null && this.scope != null) {
                this.readElementChildren(element);
            }
            this.keyConfiguration = null;
            this.scope = null;
            return true;
        }

        private boolean readGestureBinding(IConfigurationElement element) {
            GestureBinding gestureBinding = Persistence.readGestureBinding(ConfigurationElementMemento.create(element), this.getPlugin(element));
            if (gestureBinding != null) {
                this.gestureBindings.add(gestureBinding);
            }
            return true;
        }

        private boolean readGestureConfiguration(IConfigurationElement element) {
            GestureConfiguration gestureConfiguration = Persistence.readGestureConfiguration(ConfigurationElementMemento.create(element), this.getPlugin(element));
            if (gestureConfiguration != null) {
                this.gestureConfigurations.add(gestureConfiguration);
            }
            return true;
        }

        private boolean readKeyBinding(IConfigurationElement element) {
            KeyBinding keyBinding = Persistence.readKeyBinding(ConfigurationElementMemento.create(element), this.getPlugin(element));
            if (keyBinding != null) {
                this.keyBindings.add(keyBinding);
            }
            return true;
        }

        private boolean readKeyConfiguration(IConfigurationElement element) {
            KeyConfiguration keyConfiguration = Persistence.readKeyConfiguration(ConfigurationElementMemento.create(element), this.getPlugin(element));
            if (keyConfiguration != null) {
                this.keyConfigurations.add(keyConfiguration);
            }
            return true;
        }

        private boolean readRegionalGestureBinding(IConfigurationElement element) {
            RegionalGestureBinding regionalGestureBinding = Persistence.readRegionalGestureBinding(ConfigurationElementMemento.create(element), this.getPlugin(element));
            if (regionalGestureBinding != null) {
                this.regionalGestureBindings.add(regionalGestureBinding);
            }
            return true;
        }

        private boolean readRegionalKeyBinding(IConfigurationElement element) {
            RegionalKeyBinding regionalKeyBinding = Persistence.readRegionalKeyBinding(ConfigurationElementMemento.create(element), this.getPlugin(element));
            if (regionalKeyBinding != null) {
                this.regionalKeyBindings.add(regionalKeyBinding);
            }
            return true;
        }

        private boolean readScope(IConfigurationElement element) {
            Scope scope = Persistence.readScope(ConfigurationElementMemento.create(element), this.getPlugin(element));
            if (scope != null) {
                this.scopes.add(scope);
            }
            return true;
        }
    }
}

