/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.IMemento;

final class ConfigurationElementMemento
implements IMemento {
    private IConfigurationElement configurationElement;

    static ConfigurationElementMemento create(IConfigurationElement configurationElement) throws IllegalArgumentException {
        return new ConfigurationElementMemento(configurationElement);
    }

    private ConfigurationElementMemento(IConfigurationElement configurationElement) throws IllegalArgumentException {
        if (configurationElement == null) {
            throw new IllegalArgumentException();
        }
        this.configurationElement = configurationElement;
    }

    public IMemento createChild(String type) {
        return null;
    }

    public IMemento createChild(String type, String id) {
        return null;
    }

    public IMemento getChild(String type) {
        IConfigurationElement[] configurationElements = this.configurationElement.getChildren(type);
        if (configurationElements != null && configurationElements.length >= 1) {
            return ConfigurationElementMemento.create(configurationElements[0]);
        }
        return null;
    }

    public IMemento[] getChildren(String type) {
        IConfigurationElement[] configurationElements = this.configurationElement.getChildren(type);
        if (configurationElements != null && configurationElements.length >= 1) {
            IMemento[] mementos = new ConfigurationElementMemento[configurationElements.length];
            int i = 0;
            while (i < configurationElements.length) {
                mementos[i] = ConfigurationElementMemento.create(configurationElements[i]);
                ++i;
            }
            return mementos;
        }
        return new IMemento[0];
    }

    public Float getFloat(String key) {
        String string = this.configurationElement.getAttribute(key);
        if (string != null) {
            try {
                return new Float(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }

    public String getID() {
        return this.configurationElement.getAttribute("IMemento.internal.id");
    }

    public Integer getInteger(String key) {
        String string = this.configurationElement.getAttribute(key);
        if (string != null) {
            try {
                return new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }

    public String getString(String key) {
        return this.configurationElement.getAttribute(key);
    }

    public String getTextData() {
        return this.configurationElement.getValue();
    }

    public void putFloat(String key, float value) {
    }

    public void putInteger(String key, int value) {
    }

    public void putMemento(IMemento memento) {
    }

    public void putString(String key, String value) {
    }

    public void putTextData(String data) {
    }
}

