/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.internal.commands.CaptureEvent;
import org.eclipse.ui.internal.commands.CaptureListener;
import org.eclipse.ui.internal.commands.Point;

public final class Capture {
    private List captureListeners = new ArrayList();
    private boolean capturing;
    private Control control;
    private int data;
    private MouseListener mouseListener = new MouseListener(){

        public void mouseDoubleClick(MouseEvent mouseEvent) {
        }

        public void mouseDown(MouseEvent mouseEvent) {
            if (!Capture.this.capturing) {
                Capture.this.capturing = true;
                Capture.this.data = mouseEvent.stateMask;
                Capture.this.pen = mouseEvent.button;
                Capture.this.points.clear();
                Capture.this.points.add(Point.create(mouseEvent.x, mouseEvent.y));
                Capture.this.control.addMouseMoveListener(Capture.this.mouseMoveListener);
            }
        }

        public void mouseUp(MouseEvent mouseEvent) {
            if (Capture.this.capturing && mouseEvent.button == Capture.this.pen) {
                Capture.this.control.removeMouseMoveListener(Capture.this.mouseMoveListener);
                Capture.this.points.add(Point.create(mouseEvent.x, mouseEvent.y));
                CaptureEvent captureEvent = CaptureEvent.create(Capture.this.data, Capture.this.pen, Capture.this.points.toArray(new Point[Capture.this.points.size()]));
                Capture.this.capturing = false;
                Capture.this.data = 0;
                Capture.this.pen = 0;
                Capture.this.points.clear();
                Iterator iterator = Capture.this.captureListeners.iterator();
                while (iterator.hasNext()) {
                    ((CaptureListener)iterator.next()).capture(captureEvent);
                }
            }
        }
    };
    private MouseMoveListener mouseMoveListener = new MouseMoveListener(){

        public void mouseMove(MouseEvent mouseEvent) {
            if (Capture.this.capturing) {
                Capture.this.points.add(Point.create(mouseEvent.x, mouseEvent.y));
            }
        }
    };
    private int pen;
    private List points = new ArrayList();

    public static Capture create() {
        return new Capture();
    }

    private Capture() {
    }

    public void addCaptureListener(CaptureListener captureListener) {
        this.captureListeners.add(captureListener);
    }

    public Control getControl() {
        return this.control;
    }

    public void removeCaptureListener(CaptureListener captureListener) {
        this.captureListeners.remove(captureListener);
    }

    public void setControl(Control control) {
        if (this.control != control) {
            if (this.control != null) {
                control.removeMouseMoveListener(this.mouseMoveListener);
                control.removeMouseListener(this.mouseListener);
            }
            this.control = control;
            this.capturing = false;
            this.data = 0;
            this.pen = 0;
            this.points.clear();
            if (this.control != null) {
                control.addMouseListener(this.mouseListener);
            }
        }
    }
}

