/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkingSetFilterActionGroup;
import org.eclipse.ui.dialogs.IWorkingSetEditWizard;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;

public class EditWorkingSetAction
extends Action {
    private Shell shell;
    private WorkingSetFilterActionGroup actionGroup;

    public EditWorkingSetAction(WorkingSetFilterActionGroup actionGroup, Shell shell) {
        super(WorkbenchMessages.getString("EditWorkingSetAction.text"));
        Assert.isNotNull((Object)actionGroup);
        this.setToolTipText(WorkbenchMessages.getString("EditWorkingSetAction.toolTip"));
        this.shell = shell;
        this.actionGroup = actionGroup;
        WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.edit_working_set_action_context");
    }

    public void run() {
        if (this.shell == null) {
            this.shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        IWorkingSetManager manager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet workingSet = this.actionGroup.getWorkingSet();
        if (workingSet == null) {
            this.setEnabled(false);
            return;
        }
        IWorkingSetEditWizard wizard = manager.createWorkingSetEditWizard(workingSet);
        if (wizard == null) {
            String title = WorkbenchMessages.getString("EditWorkingSetAction.error.nowizard.title");
            String message = WorkbenchMessages.getString("EditWorkingSetAction.error.nowizard.message");
            MessageDialog.openError((Shell)this.shell, (String)title, (String)message);
            return;
        }
        WizardDialog dialog = new WizardDialog(this.shell, (IWizard)wizard);
        dialog.create();
        if (dialog.open() == 0) {
            this.actionGroup.setWorkingSet(wizard.getSelection());
        }
    }
}

