/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.AcceleratorMenu;
import org.eclipse.ui.internal.KeyBindingService;
import org.eclipse.ui.internal.PluginActionSet;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.commands.KeyBindingMatch;
import org.eclipse.ui.internal.commands.KeyMachine;
import org.eclipse.ui.internal.commands.KeyManager;
import org.eclipse.ui.internal.commands.KeySequence;
import org.eclipse.ui.internal.commands.KeyStroke;
import org.eclipse.ui.internal.commands.Util;
import org.eclipse.ui.internal.registry.IActionSet;

public class WWinKeyBindingService {
    private HashMap globalActionDefIdToAction = new HashMap();
    private HashMap actionSetDefIdToAction = new HashMap();
    private IPropertyChangeListener propertyListener;
    private KeyBindingService activeService;
    private WorkbenchWindow window;
    private AcceleratorMenu accMenu;
    private VerifyListener verifyListener = new VerifyListener(){

        public void verifyText(VerifyEvent event) {
            event.doit = false;
            WWinKeyBindingService.this.clear();
        }
    };

    private void setStatusLineMessage(KeySequence keySequence) {
        StringBuffer stringBuffer = new StringBuffer();
        if (keySequence != null) {
            Iterator iterator = keySequence.getKeyStrokes().iterator();
            int i = 0;
            while (iterator.hasNext()) {
                if (i != 0) {
                    stringBuffer.append(' ');
                }
                KeyStroke keyStroke = (KeyStroke)iterator.next();
                int accelerator = keyStroke.getValue();
                stringBuffer.append(Action.convertAccelerator((int)accelerator));
                ++i;
            }
        }
        this.window.getActionBars().getStatusLineManager().setMessage(stringBuffer.toString());
    }

    public void clear() {
        KeyManager keyManager = KeyManager.getInstance();
        KeyMachine keyMachine = keyManager.getKeyMachine();
        keyMachine.setMode(KeySequence.create());
        this.setStatusLineMessage(null);
        this.updateAccelerators();
    }

    public void pressed(KeyStroke keyStroke, Event event) {
        KeyManager keyManager = KeyManager.getInstance();
        KeyMachine keyMachine = keyManager.getKeyMachine();
        Map keySequenceMapForMode = keyMachine.getKeySequenceMapForMode();
        KeySequence mode = keyMachine.getMode();
        ArrayList<KeyStroke> keyStrokes = new ArrayList<KeyStroke>(mode.getKeyStrokes());
        keyStrokes.add(keyStroke);
        KeySequence keySequence = KeySequence.create(keyStrokes);
        SortedSet matchSet = (SortedSet)keySequenceMapForMode.get(keySequence);
        if (matchSet != null && matchSet.size() == 1) {
            this.clear();
            KeyBindingMatch match = (KeyBindingMatch)matchSet.iterator().next();
            this.invoke(match.getKeyBinding().getCommand(), event);
        } else {
            keyMachine.setMode(keySequence);
            this.setStatusLineMessage(keySequence);
            keySequenceMapForMode = keyMachine.getKeySequenceMapForMode();
            if (keySequenceMapForMode.isEmpty()) {
                this.clear();
            } else {
                this.updateAccelerators();
            }
        }
    }

    public void invoke(String action, Event event) {
        IAction a;
        if (this.activeService != null && (a = this.activeService.getAction(action)) != null && a.isEnabled()) {
            a.runWithEvent(event);
        }
    }

    public WWinKeyBindingService(final WorkbenchWindow window) {
        this.window = window;
        IWorkbenchPage[] pages = window.getPages();
        final IPartListener partListener = new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
                WWinKeyBindingService.this.update(part, false);
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
                WWinKeyBindingService.this.clear();
            }

            public void partOpened(IWorkbenchPart part) {
            }
        };
        ShellAdapter shellListener = new ShellAdapter(){

            public void shellDeactivated(ShellEvent e) {
                WWinKeyBindingService.this.clear();
            }
        };
        int i = 0;
        while (i < pages.length) {
            pages[i].addPartListener(partListener);
            ++i;
        }
        window.addPageListener(new IPageListener((ShellListener)shellListener){
            private final /* synthetic */ ShellListener val$shellListener;
            {
                this.val$shellListener = shellListener;
            }

            public void pageActivated(IWorkbenchPage page) {
            }

            public void pageClosed(IWorkbenchPage page) {
            }

            public void pageOpened(IWorkbenchPage page) {
                page.addPartListener(partListener);
                partListener.partActivated(page.getActivePart());
                window.getShell().removeShellListener(this.val$shellListener);
                window.getShell().addShellListener(this.val$shellListener);
            }
        });
        this.propertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("org.eclipse.ui.commands")) {
                    IWorkbenchPart part;
                    IWorkbenchPage page = window.getActivePage();
                    if (page != null && (part = page.getActivePart()) != null) {
                        WWinKeyBindingService.this.update(part, true);
                        return;
                    }
                    MenuManager menuManager = window.getMenuManager();
                    menuManager.updateAll(true);
                }
            }
        };
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        store.addPropertyChangeListener(this.propertyListener);
    }

    public void dispose() {
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        store.removePropertyChangeListener(this.propertyListener);
    }

    public void registerGlobalAction(IAction action) {
        this.globalActionDefIdToAction.put(action.getActionDefinitionId(), action);
    }

    public void registerActionSets(IActionSet[] sets) {
        this.actionSetDefIdToAction.clear();
        int i = 0;
        while (i < sets.length) {
            if (sets[i] instanceof PluginActionSet) {
                PluginActionSet set = (PluginActionSet)sets[i];
                IAction[] actions = set.getPluginActions();
                int j = 0;
                while (j < actions.length) {
                    Action action = (Action)actions[j];
                    String defId = action.getActionDefinitionId();
                    if (defId != null) {
                        this.actionSetDefIdToAction.put(action.getActionDefinitionId(), action);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public HashMap getMapping() {
        HashMap result = (HashMap)this.globalActionDefIdToAction.clone();
        result.putAll(this.actionSetDefIdToAction);
        return result;
    }

    public IWorkbenchWindow getWindow() {
        return this.window;
    }

    public void update(IWorkbenchPart part, boolean force) {
        if (part == null) {
            return;
        }
        String[] oldScopeIds = new String[]{};
        if (this.activeService != null) {
            oldScopeIds = this.activeService.getScopeIds();
        }
        this.activeService = (KeyBindingService)part.getSite().getKeyBindingService();
        this.clear();
        String[] newScopeIds = new String[]{};
        if (this.activeService != null) {
            newScopeIds = this.activeService.getScopeIds();
        }
        if (force || Util.compare((Comparable[])oldScopeIds, (Comparable[])newScopeIds) != 0) {
            KeyManager keyManager = KeyManager.getInstance();
            KeyMachine keyMachine = keyManager.getKeyMachine();
            if (newScopeIds == null || newScopeIds.length == 0) {
                newScopeIds = new String[]{"org.eclipse.ui.globalScope"};
            }
            try {
                keyMachine.setScopes(newScopeIds);
            }
            catch (IllegalArgumentException eIllegalArgument) {
                System.err.println(eIllegalArgument);
            }
            WorkbenchWindow w = (WorkbenchWindow)this.getWindow();
            MenuManager menuManager = w.getMenuManager();
            menuManager.update("text");
        }
    }

    public String getDefinitionId(int accelerator) {
        if (this.activeService == null) {
            return null;
        }
        KeyManager keyManager = KeyManager.getInstance();
        KeyMachine keyMachine = keyManager.getKeyMachine();
        KeySequence mode = keyMachine.getMode();
        ArrayList<KeyStroke> keyStrokes = new ArrayList<KeyStroke>(mode.getKeyStrokes());
        keyStrokes.add(KeyStroke.create(accelerator));
        KeySequence keySequence = KeySequence.create(keyStrokes);
        Map keySequenceMapForMode = keyMachine.getKeySequenceMapForMode();
        SortedSet matchSet = (SortedSet)keySequenceMapForMode.get(keySequence);
        if (matchSet != null && matchSet.size() == 1) {
            KeyBindingMatch match = (KeyBindingMatch)matchSet.iterator().next();
            return match.getKeyBinding().getCommand();
        }
        return null;
    }

    public void updateAccelerators() {
        KeyManager keyManager = KeyManager.getInstance();
        KeyMachine keyMachine = keyManager.getKeyMachine();
        KeySequence mode = keyMachine.getMode();
        List keyStrokes = mode.getKeyStrokes();
        int size = keyStrokes.size();
        Map keySequenceMapForMode = keyMachine.getKeySequenceMapForMode();
        TreeSet keyStrokeSetForMode = new TreeSet();
        Iterator<Object> iterator = keySequenceMapForMode.keySet().iterator();
        while (iterator.hasNext()) {
            KeySequence keySequence = (KeySequence)iterator.next();
            if (!keySequence.isChildOf(mode, false)) continue;
            keyStrokeSetForMode.add(keySequence.getKeyStrokes().get(size));
        }
        iterator = keyStrokeSetForMode.iterator();
        int[] accelerators = new int[keyStrokeSetForMode.size()];
        int i = 0;
        while (iterator.hasNext()) {
            KeyStroke keyStroke = (KeyStroke)iterator.next();
            accelerators[i++] = keyStroke.getValue();
        }
        if (this.accMenu == null || this.accMenu.isDisposed()) {
            Menu parent = this.window.getShell().getMenuBar();
            if (parent == null || parent.getItemCount() < 1) {
                return;
            }
            MenuItem parentItem = parent.getItem(parent.getItemCount() - 1);
            parent = parentItem.getMenu();
            this.accMenu = new AcceleratorMenu(parent);
        }
        if (this.accMenu == null) {
            return;
        }
        this.accMenu.setAccelerators(accelerators);
        this.accMenu.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Event event = new Event();
                event.item = selectionEvent.item;
                event.detail = selectionEvent.detail;
                event.x = selectionEvent.x;
                event.y = selectionEvent.y;
                event.width = selectionEvent.width;
                event.height = selectionEvent.height;
                event.stateMask = selectionEvent.stateMask;
                event.doit = selectionEvent.doit;
                event.data = selectionEvent.data;
                event.display = selectionEvent.display;
                event.time = selectionEvent.time;
                event.widget = selectionEvent.widget;
                WWinKeyBindingService.this.pressed(KeyStroke.create(selectionEvent.detail), event);
            }
        });
        if (mode.getKeyStrokes().size() == 0) {
            this.accMenu.removeVerifyListener(this.verifyListener);
        } else {
            this.accMenu.addVerifyListener(this.verifyListener);
        }
    }
}

