/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;

public class ToggleEditorsVisibilityAction
extends Action {
    private IWorkbenchWindow workbenchWindow;

    public ToggleEditorsVisibilityAction(IWorkbenchWindow window) {
        super(WorkbenchMessages.getString("ToggleEditor.hideEditors"));
        this.setToolTipText(WorkbenchMessages.getString("ToggleEditor.toolTip"));
        WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.target_editors_visibility_action_context");
        this.setEnabled(false);
        this.workbenchWindow = window;
        window.addPerspectiveListener(new IPerspectiveListener(){

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                if (page.isEditorAreaVisible()) {
                    ToggleEditorsVisibilityAction.this.setText(WorkbenchMessages.getString("ToggleEditor.hideEditors"));
                } else {
                    ToggleEditorsVisibilityAction.this.setText(WorkbenchMessages.getString("ToggleEditor.showEditors"));
                }
            }

            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
                if (changeId == "reset" || changeId == "editorAreaHide" || changeId == "editorAreaShow") {
                    if (page.isEditorAreaVisible()) {
                        ToggleEditorsVisibilityAction.this.setText(WorkbenchMessages.getString("ToggleEditor.hideEditors"));
                    } else {
                        ToggleEditorsVisibilityAction.this.setText(WorkbenchMessages.getString("ToggleEditor.showEditors"));
                    }
                }
            }
        });
    }

    public void run() {
        boolean visible = this.workbenchWindow.getActivePage().isEditorAreaVisible();
        if (visible) {
            this.workbenchWindow.getActivePage().setEditorAreaVisible(false);
            this.setText(WorkbenchMessages.getString("ToggleEditor.showEditors"));
        } else {
            this.workbenchWindow.getActivePage().setEditorAreaVisible(true);
            this.setText(WorkbenchMessages.getString("ToggleEditor.hideEditors"));
        }
    }
}

