/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import org.eclipse.core.internal.plugins.ConfigurationElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IActionDelegateWithEvent;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.internal.SelectionEnabler;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;

public abstract class PluginAction
extends Action
implements ISelectionListener,
ISelectionChangedListener,
INullSelectionListener {
    private IActionDelegate delegate;
    private SelectionEnabler enabler;
    private ISelection selection;
    private IConfigurationElement configElement;
    private String runAttribute;
    private static int actionCount = 0;
    boolean isAdaptableAction = false;
    boolean adaptableNotChecked = true;
    static /* synthetic */ Class class$0;

    public PluginAction(IConfigurationElement actionElement, String runAttribute, String definitionId, int style) {
        super(null, style);
        this.setId("PluginAction." + Integer.toString(actionCount));
        ++actionCount;
        this.setActionDefinitionId(definitionId);
        this.configElement = actionElement;
        this.runAttribute = runAttribute;
        if (this.configElement.getAttribute("enablesFor") != null) {
            this.enabler = new SelectionEnabler(this.configElement);
        } else {
            IConfigurationElement[] kids = this.configElement.getChildren("enablement");
            if (kids.length > 0) {
                this.enabler = new SelectionEnabler(this.configElement);
            }
        }
        this.selectionChanged((ISelection)new StructuredSelection());
    }

    protected final void createDelegate() {
        if (this.delegate == null) {
            try {
                Object obj = WorkbenchPlugin.createExtension(this.configElement, this.runAttribute);
                this.delegate = this.validateDelegate(obj);
                this.initDelegate();
                this.refreshEnablement();
            }
            catch (CoreException e) {
                WorkbenchPlugin.log("Could not create action delegate.", e.getStatus());
                return;
            }
        }
    }

    protected IActionDelegate validateDelegate(Object obj) throws WorkbenchException {
        if (obj instanceof IActionDelegate) {
            return (IActionDelegate)obj;
        }
        throw new WorkbenchException("Action must implement IActionDelegate");
    }

    protected void initDelegate() {
        if (this.delegate instanceof IActionDelegate2) {
            ((IActionDelegate2)this.delegate).init((IAction)this);
        }
    }

    protected IActionDelegate getDelegate() {
        return this.delegate;
    }

    protected boolean isOkToCreateDelegate() {
        IPluginDescriptor plugin = this.configElement.getDeclaringExtension().getDeclaringPluginDescriptor();
        return plugin.isPluginActivated();
    }

    private boolean hasAdaptableType() {
        if (this.adaptableNotChecked) {
            Class<?> resourceClass;
            Object parentConfig = ((ConfigurationElement)this.configElement).getParent();
            String typeName = null;
            if (parentConfig != null && parentConfig instanceof IConfigurationElement) {
                typeName = ((IConfigurationElement)parentConfig).getAttribute("objectClass");
            }
            if (typeName == null) {
                this.adaptableNotChecked = false;
                return false;
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (typeName.equals((resourceClass = clazz).getName())) {
                this.isAdaptableAction = true;
                this.adaptableNotChecked = false;
                return this.isAdaptableAction;
            }
            Class<?>[] children = resourceClass.getDeclaredClasses();
            int i = 0;
            while (i < children.length) {
                if (children[i].getName().equals(typeName)) {
                    this.isAdaptableAction = true;
                    this.adaptableNotChecked = false;
                    return this.isAdaptableAction;
                }
                ++i;
            }
            this.adaptableNotChecked = false;
        }
        return this.isAdaptableAction;
    }

    protected void refreshEnablement() {
        if (this.enabler != null) {
            this.setEnabled(this.enabler.isEnabledForSelection(this.selection));
        }
        if (this.delegate != null) {
            this.delegate.selectionChanged((IAction)this, this.selection);
        }
    }

    public void run() {
        this.runWithEvent(null);
    }

    public void runWithEvent(Event event) {
        if (this.delegate == null) {
            this.createDelegate();
            if (this.delegate == null) {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)WorkbenchMessages.getString("Information"), (String)WorkbenchMessages.getString("PluginAction.operationNotAvailableMessage"));
                return;
            }
            if (!this.isEnabled()) {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)WorkbenchMessages.getString("Information"), (String)WorkbenchMessages.getString("PluginAction.disabledMessage"));
                return;
            }
        }
        if (event != null) {
            if (this.delegate instanceof IActionDelegate2) {
                ((IActionDelegate2)this.delegate).runWithEvent((IAction)this, event);
                return;
            }
            if (this.delegate instanceof IActionDelegateWithEvent) {
                ((IActionDelegateWithEvent)((Object)this.delegate)).runWithEvent((IAction)this, event);
                return;
            }
        }
        this.delegate.run((IAction)this);
    }

    public void selectionChanged(ISelection newSelection) {
        this.selection = newSelection;
        if (this.selection == null) {
            this.selection = StructuredSelection.EMPTY;
        }
        if (this.hasAdaptableType()) {
            this.selection = this.getResourceAdapters(this.selection);
        }
        if (this.delegate == null && this.isOkToCreateDelegate()) {
            this.createDelegate();
        } else {
            this.refreshEnablement();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection sel = event.getSelection();
        this.selectionChanged(sel);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection sel) {
        this.selectionChanged(sel);
    }

    private ISelection getResourceAdapters(ISelection sel) {
        if (sel instanceof IStructuredSelection) {
            ArrayList<Object> adaptables = new ArrayList<Object>();
            Object[] elements = ((IStructuredSelection)sel).toArray();
            int i = 0;
            while (i < elements.length) {
                Object originalValue = elements[i];
                if (originalValue instanceof IAdaptable) {
                    Object adaptedValue;
                    IAdaptable iAdaptable = (IAdaptable)originalValue;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((adaptedValue = iAdaptable.getAdapter((Class)clazz)) != null) {
                        adaptables.add(adaptedValue);
                    }
                }
                ++i;
            }
            return new StructuredSelection(adaptables);
        }
        return sel;
    }
}

