/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;

public class NewWizardShortcutAction
extends Action {
    private WorkbenchWizardElement wizardElement;
    private IWorkbench workbench;

    public NewWizardShortcutAction(IWorkbench workbench, WorkbenchWizardElement element) {
        super(element.getLabel(element));
        this.setToolTipText(element.getDescription());
        this.setImageDescriptor(element.getImageDescriptor());
        this.setId("new");
        this.wizardElement = element;
        this.workbench = workbench;
    }

    public void run() {
        INewWizard wizard;
        try {
            wizard = (INewWizard)this.wizardElement.createExecutableExtension();
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.workbench.getActiveWorkbenchWindow().getShell(), (String)WorkbenchMessages.getString("NewWizardShortcutAction.errorTitle"), (String)WorkbenchMessages.getString("NewWizardShortcutAction.errorMessage"), (IStatus)e.getStatus());
            return;
        }
        ISelection selection = this.workbench.getActiveWorkbenchWindow().getSelectionService().getSelection();
        StructuredSelection selectionToPass = StructuredSelection.EMPTY;
        if (selection instanceof IStructuredSelection) {
            selectionToPass = this.wizardElement.adaptedSelection((IStructuredSelection)selection);
        } else {
            IEditorInput input;
            IWorkbenchPart part = this.workbench.getActiveWorkbenchWindow().getPartService().getActivePart();
            if (part instanceof IEditorPart && (input = ((IEditorPart)part).getEditorInput()) instanceof IFileEditorInput) {
                selectionToPass = new StructuredSelection((Object)((IFileEditorInput)input).getFile());
            }
        }
        wizard.init(this.workbench, (IStructuredSelection)selectionToPass);
        Shell parent = this.workbench.getActiveWorkbenchWindow().getShell();
        WizardDialog dialog = new WizardDialog(parent, (IWizard)wizard);
        dialog.create();
        WorkbenchHelp.setHelp((Control)dialog.getShell(), "org.eclipse.ui.new_wizard_shortcut_context");
        dialog.open();
    }
}

