/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.LayoutPart;
import org.eclipse.ui.internal.PageLayout;
import org.eclipse.ui.internal.PartPlaceholder;
import org.eclipse.ui.internal.PartTabFolder;
import org.eclipse.ui.internal.ViewFactory;
import org.eclipse.ui.internal.ViewPane;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.IViewDescriptor;
import org.eclipse.ui.internal.registry.IViewRegistry;

public class FolderLayout
implements IFolderLayout {
    private ViewFactory viewFactory;
    private PartTabFolder folder;
    private PageLayout pageLayout;

    public FolderLayout(PageLayout pageLayout, PartTabFolder folder, ViewFactory viewFactory) {
        this.folder = folder;
        this.viewFactory = viewFactory;
        this.pageLayout = pageLayout;
    }

    public void addPlaceholder(String viewId) {
        if (this.pageLayout.checkPartInLayout(viewId)) {
            return;
        }
        IViewRegistry reg = WorkbenchPlugin.getDefault().getViewRegistry();
        IViewDescriptor desc = reg.find(viewId);
        if (desc == null) {
            WorkbenchPlugin.log("Unable to find view label: " + viewId);
            return;
        }
        PartPlaceholder newPart = new PartPlaceholder(viewId);
        this.linkPartToPageLayout(viewId, newPart);
        String label = desc.getLabel();
        this.folder.add(label, this.folder.getItemCount(), newPart);
    }

    public void addView(String viewId) {
        if (this.pageLayout.checkPartInLayout(viewId)) {
            return;
        }
        try {
            WorkbenchPartReference ref = (WorkbenchPartReference)((Object)this.viewFactory.createView(viewId));
            ViewPane newPart = (ViewPane)ref.getPane();
            if (newPart == null) {
                newPart = new ViewPane((IViewReference)((Object)ref), (WorkbenchPage)ref.getPage());
                ref.setPane(newPart);
            }
            this.linkPartToPageLayout(viewId, newPart);
            this.folder.add(newPart);
        }
        catch (PartInitException e) {
            WorkbenchPlugin.log(((Throwable)((Object)e)).getMessage());
        }
    }

    private void linkPartToPageLayout(String viewId, LayoutPart newPart) {
        this.pageLayout.setRefPart(viewId, newPart);
        this.pageLayout.setFolderPart(viewId, this.folder);
    }
}

