/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.EditorHistoryItem;

public class EditorHistory {
    private int size;
    private ArrayList fifoList;

    public EditorHistory() {
        this(10);
    }

    public EditorHistory(int size) {
        this.size = size;
        this.fifoList = new ArrayList(size);
    }

    public void add(IEditorInput input) {
        this.add(input, null);
    }

    public void add(IEditorInput input, IEditorDescriptor desc) {
        this.add(new EditorHistoryItem(input, desc), 0);
    }

    private void add(EditorHistoryItem newItem, int index) {
        if (newItem.isRestored()) {
            this.remove(newItem.getInput());
        }
        this.fifoList.add(index, newItem);
        if (this.fifoList.size() > this.size) {
            this.fifoList.remove(this.size);
        }
    }

    public EditorHistoryItem[] getItems() {
        this.refresh();
        EditorHistoryItem[] array = new EditorHistoryItem[this.fifoList.size()];
        this.fifoList.toArray(array);
        return array;
    }

    public int getSize() {
        return this.fifoList.size();
    }

    public void refresh() {
        Iterator iter = ((AbstractList)this.fifoList).iterator();
        while (iter.hasNext()) {
            IEditorInput input;
            EditorHistoryItem item = (EditorHistoryItem)iter.next();
            if (!item.isRestored() || (input = item.getInput()) == null || input.exists()) continue;
            iter.remove();
        }
    }

    public void remove(EditorHistoryItem item) {
        ((AbstractCollection)this.fifoList).remove(item);
    }

    public void remove(IEditorInput input) {
        if (input == null) {
            return;
        }
        Iterator iter = ((AbstractList)this.fifoList).iterator();
        while (iter.hasNext()) {
            EditorHistoryItem item = (EditorHistoryItem)iter.next();
            if (!item.matches(input)) continue;
            iter.remove();
        }
    }

    public void reset(int size) {
        this.size = size;
        while (this.fifoList.size() > size) {
            this.fifoList.remove(size);
        }
    }

    public IStatus restoreState(IMemento memento) {
        IMemento[] mementos = memento.getChildren("file");
        int i = 0;
        while (i < mementos.length) {
            EditorHistoryItem item = new EditorHistoryItem(mementos[i]);
            if (!"".equals(item.getName()) || !"".equals(item.getToolTipText())) {
                this.add(item, this.fifoList.size());
            }
            ++i;
        }
        return new Status(0, "org.eclipse.ui", 0, "", null);
    }

    public IStatus saveState(IMemento memento) {
        Iterator iterator = ((AbstractList)this.fifoList).iterator();
        while (iterator.hasNext()) {
            EditorHistoryItem item = (EditorHistoryItem)iterator.next();
            if (!item.canSave()) continue;
            IMemento itemMemento = memento.createChild("file");
            item.saveState(itemMemento);
        }
        return new Status(0, "org.eclipse.ui", 0, "", null);
    }
}

