/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.internal.CoolBarContributionItem;
import org.eclipse.ui.internal.CoolBarManager;

public class CoolItemToolBarManager
extends ToolBarManager {
    CoolBarManager parentManager;
    CoolBarContributionItem coolBarItem;

    public CoolItemToolBarManager(int style) {
        super(style);
    }

    public ToolBar createControl(Composite parent) {
        ToolBar tBar = super.createControl(parent);
        tBar.setMenu(this.parentManager.getCoolBarMenu());
        return tBar;
    }

    public void dispose() {
        ToolBar tBar = this.getControl();
        if (tBar != null) {
            tBar.setMenu(null);
        }
        super.dispose();
    }

    protected CoolBarContributionItem getCoolBarItem() {
        return this.coolBarItem;
    }

    protected CoolBarManager getParentManager() {
        return this.parentManager;
    }

    protected boolean isVisible() {
        if (this.coolBarItem == null) {
            return false;
        }
        return this.coolBarItem.isVisible();
    }

    protected void itemAdded(IContributionItem item) {
        super.itemAdded(item);
        this.update(true);
        this.parentManager.updateSizeFor(this.coolBarItem);
    }

    protected void itemRemoved(IContributionItem item) {
        super.itemRemoved(item);
        this.update(true);
        this.parentManager.updateSizeFor(this.coolBarItem);
    }

    protected void relayout(ToolBar toolBar, int oldCount, int newCount) {
        if (oldCount == newCount) {
            return;
        }
        CoolBar coolBar = (CoolBar)toolBar.getParent();
        CoolItem[] coolItems = coolBar.getItems();
        CoolItem coolItem = null;
        int i = 0;
        while (i < coolItems.length) {
            CoolItem item = coolItems[i];
            if (item.getControl() == toolBar) {
                coolItem = item;
                break;
            }
            ++i;
        }
        if (coolItem != null) {
            Point size = toolBar.computeSize(-1, -1);
            Point coolSize = coolItem.computeSize(size.x, size.y);
            coolItem.setPreferredSize(coolSize);
        }
        coolBar.layout();
    }

    protected void setCoolBarItem(CoolBarContributionItem coolBarItem) {
        this.coolBarItem = coolBarItem;
    }

    protected void setParentMgr(CoolBarManager parentManager) {
        this.parentManager = parentManager;
    }

    protected void setVisible(boolean set) {
        if (this.coolBarItem != null) {
            this.coolBarItem.setVisible(set);
        }
    }

    protected void setVisible(boolean set, boolean forceVisibility) {
        if (this.coolBarItem != null) {
            this.coolBarItem.setVisible(set, forceVisibility);
        }
    }
}

