/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.PartEventAction;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;

public class CloseAllSavedAction
extends PartEventAction
implements IPageListener,
IPropertyListener {
    private IWorkbenchWindow workbench;

    public CloseAllSavedAction(IWorkbenchWindow aWorkbench) {
        super(WorkbenchMessages.getString("CloseAllSavedAction.text"));
        this.workbench = aWorkbench;
        this.setToolTipText(WorkbenchMessages.getString("CloseAllSavedAction.toolTip"));
        this.setId("closeAllSaved");
        this.updateState();
        aWorkbench.addPageListener(this);
        WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.close_all_saved_action_context");
    }

    public void pageActivated(IWorkbenchPage page) {
        this.updateState();
    }

    public void pageClosed(IWorkbenchPage page) {
        this.updateState();
    }

    public void pageOpened(IWorkbenchPage page) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            part.removePropertyListener(this);
            this.updateState();
        }
    }

    public void partOpened(IWorkbenchPart part) {
        if (part instanceof IEditorPart) {
            part.addPropertyListener(this);
            this.updateState();
        }
    }

    public void propertyChanged(Object source, int propID) {
        if (source instanceof IEditorPart && propID == 257) {
            this.updateState();
        }
    }

    public void run() {
        WorkbenchPage page = (WorkbenchPage)this.workbench.getActivePage();
        if (page != null) {
            page.closeAllSavedEditors();
        }
    }

    private void updateState() {
        WorkbenchPage page = (WorkbenchPage)this.workbench.getActivePage();
        if (page == null) {
            this.setEnabled(false);
            return;
        }
        IEditorReference[] editors = page.getSortedEditors();
        int i = 0;
        while (i < editors.length) {
            if (!editors[i].isDirty()) {
                this.setEnabled(true);
                return;
            }
            ++i;
        }
        this.setEnabled(false);
    }
}

