/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.help;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.IContext;
import org.eclipse.help.IHelp;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.help.IContextComputer;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class WorkbenchHelp {
    private static final String HELP_KEY = "org.eclipse.ui.help";
    private static final String HELP_SYSTEM_EXTENSION_ID = "org.eclipse.help.support";
    private static final String HELP_SYSTEM_CLASS_ATTRIBUTE = "class";
    private static IHelp helpSupport;
    private static boolean isIntialized;
    private static HelpListener helpListener;

    static {
        isIntialized = false;
        helpListener = null;
    }

    private WorkbenchHelp() {
    }

    private static Point computePopUpLocation(Display display) {
        Point point = display.getCursorLocation();
        return new Point(point.x + 15, point.y);
    }

    private static void displayHelp(String helpContext, Point point) {
        IHelp helpSupport = WorkbenchHelp.getHelpSupport();
        if (helpSupport == null) {
            return;
        }
        helpSupport.displayContext(helpContext, point.x, point.y);
    }

    private static void displayHelp(IContext helpContext, Point point) {
        IHelp helpSupport = WorkbenchHelp.getHelpSupport();
        if (helpSupport == null) {
            return;
        }
        helpSupport.displayContext(helpContext, point.x, point.y);
    }

    public static void displayHelp(String contextId) {
        Point point = WorkbenchHelp.computePopUpLocation(Display.getCurrent());
        WorkbenchHelp.displayHelp(contextId, point);
    }

    public static void displayHelp(IContext context) {
        Point point = WorkbenchHelp.computePopUpLocation(Display.getCurrent());
        WorkbenchHelp.displayHelp(context, point);
    }

    public static Object getHelp(Control control) {
        return control.getData(HELP_KEY);
    }

    public static Object getHelp(Menu menu) {
        return menu.getData(HELP_KEY);
    }

    public static Object getHelp(MenuItem menuItem) {
        return menuItem.getData(HELP_KEY);
    }

    private static HelpListener getHelpListener() {
        if (helpListener == null) {
            WorkbenchHelp.initializeHelpListener();
        }
        return helpListener;
    }

    public static IHelp getHelpSupport() {
        if (!isIntialized) {
            isIntialized = true;
            WorkbenchHelp.initializeHelpSupport();
        }
        return helpSupport;
    }

    private static void initializeHelpListener() {
        helpListener = new HelpListener(){

            public void helpRequested(HelpEvent event) {
                if (WorkbenchHelp.getHelpSupport() == null) {
                    return;
                }
                Object object = event.widget.getData(WorkbenchHelp.HELP_KEY);
                if (object instanceof String) {
                    Point point = WorkbenchHelp.computePopUpLocation(event.widget.getDisplay());
                    WorkbenchHelp.displayHelp((String)object, point);
                    return;
                }
                Object[] helpContext = null;
                if (object instanceof IContextComputer) {
                    helpContext = ((IContextComputer)object).computeContexts(event);
                } else if (object instanceof Object[]) {
                    helpContext = (Object[])object;
                }
                if (helpContext != null) {
                    Point point = WorkbenchHelp.computePopUpLocation(event.widget.getDisplay());
                    WorkbenchHelp.displayHelp(helpContext, point);
                }
            }
        };
    }

    private static void displayHelp(Object[] helpContexts, Point point) {
        if (WorkbenchHelp.getHelpSupport() == null) {
            return;
        }
        if (helpContexts[0] instanceof IContext) {
            WorkbenchHelp.getHelpSupport().displayContext((IContext)helpContexts[0], point.x, point.y);
        } else {
            WorkbenchHelp.getHelpSupport().displayContext((String)helpContexts[0], point.x, point.y);
        }
    }

    private static void initializeHelpSupport() {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            public void run() {
                IPluginRegistry pluginRegistry = Platform.getPluginRegistry();
                IExtensionPoint point = pluginRegistry.getExtensionPoint(WorkbenchHelp.HELP_SYSTEM_EXTENSION_ID);
                if (point == null) {
                    return;
                }
                IExtension[] extensions = point.getExtensions();
                if (extensions.length == 0) {
                    return;
                }
                IConfigurationElement[] elements = extensions[0].getConfigurationElements();
                if (elements.length == 0) {
                    return;
                }
                try {
                    helpSupport = (IHelp)WorkbenchPlugin.createExtension(elements[0], WorkbenchHelp.HELP_SYSTEM_CLASS_ATTRIBUTE);
                }
                catch (CoreException e) {
                    WorkbenchPlugin.log("Unable to instantiate help support system" + e.getStatus());
                }
            }
        });
    }

    public static boolean isContextHelpDisplayed() {
        return helpSupport != null && helpSupport.isContextHelpDisplayed();
    }

    public static void setHelp(IAction action, final Object[] contexts) {
        int i = 0;
        while (i < contexts.length) {
            Assert.isTrue((contexts[i] instanceof String || contexts[i] instanceof IContext ? 1 : 0) != 0);
            ++i;
        }
        action.setHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                if (WorkbenchHelp.getHelpSupport() != null) {
                    Point point = WorkbenchHelp.computePopUpLocation(event.widget.getDisplay());
                    WorkbenchHelp.displayHelp(contexts, point);
                }
            }
        });
    }

    public static void setHelp(IAction action, final IContextComputer computer) {
        action.setHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                Object[] helpContext = computer.computeContexts(event);
                if (helpContext != null && WorkbenchHelp.getHelpSupport() != null) {
                    Point point = WorkbenchHelp.computePopUpLocation(event.widget.getDisplay());
                    WorkbenchHelp.displayHelp(helpContext, point);
                }
            }
        });
    }

    public static void setHelp(Control control, Object[] contexts) {
        int i = 0;
        while (i < contexts.length) {
            Assert.isTrue((contexts[i] instanceof String || contexts[i] instanceof IContext ? 1 : 0) != 0);
            ++i;
        }
        control.setData(HELP_KEY, (Object)contexts);
        control.removeHelpListener(WorkbenchHelp.getHelpListener());
        control.addHelpListener(WorkbenchHelp.getHelpListener());
    }

    public static void setHelp(Control control, IContextComputer computer) {
        control.setData(HELP_KEY, (Object)computer);
        control.removeHelpListener(WorkbenchHelp.getHelpListener());
        control.addHelpListener(WorkbenchHelp.getHelpListener());
    }

    public static void setHelp(Menu menu, Object[] contexts) {
        int i = 0;
        while (i < contexts.length) {
            Assert.isTrue((contexts[i] instanceof String || contexts[i] instanceof IContext ? 1 : 0) != 0);
            ++i;
        }
        menu.setData(HELP_KEY, (Object)contexts);
        menu.removeHelpListener(WorkbenchHelp.getHelpListener());
        menu.addHelpListener(WorkbenchHelp.getHelpListener());
    }

    public static void setHelp(Menu menu, IContextComputer computer) {
        menu.setData(HELP_KEY, (Object)computer);
        menu.removeHelpListener(WorkbenchHelp.getHelpListener());
        menu.addHelpListener(WorkbenchHelp.getHelpListener());
    }

    public static void setHelp(MenuItem item, Object[] contexts) {
        int i = 0;
        while (i < contexts.length) {
            Assert.isTrue((contexts[i] instanceof String || contexts[i] instanceof IContext ? 1 : 0) != 0);
            ++i;
        }
        item.setData(HELP_KEY, (Object)contexts);
        item.removeHelpListener(WorkbenchHelp.getHelpListener());
        item.addHelpListener(WorkbenchHelp.getHelpListener());
    }

    public static void setHelp(MenuItem item, IContextComputer computer) {
        item.setData(HELP_KEY, (Object)computer);
        item.removeHelpListener(WorkbenchHelp.getHelpListener());
        item.addHelpListener(WorkbenchHelp.getHelpListener());
    }

    public static void setHelp(IAction action, final String contextId) {
        action.setHelpListener(new HelpListener(){

            public void helpRequested(HelpEvent event) {
                if (WorkbenchHelp.getHelpSupport() != null) {
                    Point point = WorkbenchHelp.computePopUpLocation(event.widget.getDisplay());
                    WorkbenchHelp.displayHelp(contextId, point);
                }
            }
        });
    }

    public static void setHelp(Control control, String contextId) {
        control.setData(HELP_KEY, (Object)contextId);
        control.removeHelpListener(WorkbenchHelp.getHelpListener());
        control.addHelpListener(WorkbenchHelp.getHelpListener());
    }

    public static void setHelp(Menu menu, String contextId) {
        menu.setData(HELP_KEY, (Object)contextId);
        menu.removeHelpListener(WorkbenchHelp.getHelpListener());
        menu.addHelpListener(WorkbenchHelp.getHelpListener());
    }

    public static void setHelp(MenuItem item, String contextId) {
        item.setData(HELP_KEY, (Object)contextId);
        item.removeHelpListener(WorkbenchHelp.getHelpListener());
        item.addHelpListener(WorkbenchHelp.getHelpListener());
    }
}

