/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ContainerGenerator;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.CreateLinkedResourceGroup;
import org.eclipse.ui.internal.misc.ResourceAndContainerGroup;

public class WizardNewFolderMainPage
extends WizardPage
implements Listener {
    private static final int SIZING_CONTAINER_GROUP_HEIGHT = 250;
    private IStructuredSelection currentSelection;
    private IContainer currentParent;
    private IFolder newFolder;
    private IPath linkTargetPath;
    private ResourceAndContainerGroup resourceGroup;
    private Button advancedButton;
    private CreateLinkedResourceGroup linkedResourceGroup;
    private boolean linkedResourceGroupVisible = false;
    private int linkedResourceGroupHeight = -1;
    private boolean firstLinkCheck = true;
    static /* synthetic */ Class class$0;

    public WizardNewFolderMainPage(String pageName, IStructuredSelection selection) {
        super("newFolderPage1");
        this.setTitle(pageName);
        this.setDescription(WorkbenchMessages.getString("WizardNewFolderMainPage.description"));
        this.currentSelection = selection;
    }

    protected void createAdvancedControls(Composite parent) {
        this.advancedButton = new Button(parent, 8);
        this.advancedButton.setFont(parent.getFont());
        this.advancedButton.setText(WorkbenchMessages.getString("WizardNewFolderMainPage.advancedButtonCollapsed"));
        GridData data = this.setButtonLayoutData(this.advancedButton);
        data.horizontalAlignment = 1;
        this.advancedButton.setLayoutData((Object)data);
        this.advancedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardNewFolderMainPage.this.handleAdvancedButtonSelect();
            }
        });
        this.linkedResourceGroup = new CreateLinkedResourceGroup(2, new Listener(){

            public void handleEvent(Event e) {
                WizardNewFolderMainPage.this.setPageComplete(WizardNewFolderMainPage.this.validatePage());
                WizardNewFolderMainPage.this.firstLinkCheck = false;
            }
        });
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        WorkbenchHelp.setHelp((Control)composite, "org.eclipse.ui.new_folder_wizard_page_context");
        this.resourceGroup = new ResourceAndContainerGroup(composite, this, WorkbenchMessages.getString("WizardNewFolderMainPage.folderName"), WorkbenchMessages.getString("WizardNewFolderMainPage.folderLabel"), false, 250);
        this.resourceGroup.setAllowExistingResources(false);
        this.createAdvancedControls(composite);
        this.initializePage();
        this.validatePage();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    protected void createFolder(IFolder folderHandle, IProgressMonitor monitor) throws CoreException {
        try {
            if (!folderHandle.exists()) {
                IContainer parent = folderHandle.getParent();
                if (parent instanceof IFolder && !((IFolder)parent).exists()) {
                    this.createFolder((IFolder)parent, monitor);
                }
                if (this.linkTargetPath != null) {
                    folderHandle.createLink(this.linkTargetPath, 16, monitor);
                } else {
                    folderHandle.create(false, true, monitor);
                }
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                folderHandle.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
            }
            throw e;
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected IFolder createFolderHandle(IPath folderPath) {
        return WorkbenchPlugin.getPluginWorkspace().getRoot().getFolder(folderPath);
    }

    protected void createLinkTarget() {
        String linkTarget = this.linkedResourceGroup.getLinkTarget();
        this.linkTargetPath = linkTarget != null ? new Path(linkTarget) : null;
    }

    public IFolder createNewFolder() {
        if (this.newFolder != null) {
            return this.newFolder;
        }
        final IPath containerPath = this.resourceGroup.getContainerFullPath();
        IPath newFolderPath = containerPath.append(this.resourceGroup.getResource());
        final IFolder newFolderHandle = this.createFolderHandle(newFolderPath);
        this.createLinkTarget();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) throws CoreException {
                try {
                    monitor.beginTask(WorkbenchMessages.getString("WizardNewFolderCreationPage.progress"), 2000);
                    ContainerGenerator generator = new ContainerGenerator(containerPath);
                    generator.generateContainer((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                    WizardNewFolderMainPage.this.createFolder(newFolderHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                Object var3_5 = null;
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)WorkbenchMessages.getString("WizardNewFolderCreationPage.errorTitle"), null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                WorkbenchPlugin.log(MessageFormat.format("Exception in {0}.getNewFolder(): {1}", ((Object)((Object)this)).getClass().getName(), e.getTargetException()));
                MessageDialog.openError((Shell)this.getContainer().getShell(), (String)WorkbenchMessages.getString("WizardNewFolderCreationPage.internalErrorTitle"), (String)WorkbenchMessages.format("WizardNewFolder.internalError", new Object[]{e.getTargetException().getMessage()}));
            }
            return null;
        }
        this.newFolder = newFolderHandle;
        return this.newFolder;
    }

    protected void handleAdvancedButtonSelect() {
        Shell shell = this.getShell();
        Point shellSize = shell.getSize();
        Composite composite = (Composite)this.getControl();
        if (this.linkedResourceGroupHeight == -1) {
            Composite linkedResourceComposite = this.linkedResourceGroup.createContents(composite);
            Point groupSize = linkedResourceComposite.computeSize(-1, -1, true);
            this.linkedResourceGroupHeight = groupSize.y;
        }
        if (this.linkedResourceGroupVisible) {
            this.linkedResourceGroupVisible = false;
            shell.setSize(shellSize.x, shellSize.y - this.linkedResourceGroupHeight);
            this.advancedButton.setText(WorkbenchMessages.getString("WizardNewFolderMainPage.advancedButtonCollapsed"));
        } else {
            this.linkedResourceGroupVisible = true;
            shell.setSize(shellSize.x, shellSize.y + this.linkedResourceGroupHeight);
            composite.layout();
            this.advancedButton.setText(WorkbenchMessages.getString("WizardNewFolderMainPage.advancedButtonExpanded"));
        }
    }

    public void handleEvent(Event ev) {
        this.setPageComplete(this.validatePage());
    }

    protected void initializePage() {
        Iterator iterator = this.currentSelection.iterator();
        if (iterator.hasNext()) {
            Object next = iterator.next();
            IResource selectedResource = null;
            if (next instanceof IResource) {
                selectedResource = (IResource)next;
            } else if (next instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)next;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                selectedResource = (IResource)iAdaptable.getAdapter((Class)clazz);
            }
            if (selectedResource != null) {
                if (selectedResource.getType() == 1) {
                    selectedResource = selectedResource.getParent();
                }
                if (selectedResource.isAccessible()) {
                    this.resourceGroup.setContainerFullPath(selectedResource.getFullPath());
                }
            }
        }
        this.setPageComplete(false);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.resourceGroup.setFocus();
        }
    }

    protected IStatus validateLinkedResource() {
        IPath containerPath = this.resourceGroup.getContainerFullPath();
        IPath newFolderPath = containerPath.append(this.resourceGroup.getResource());
        IFolder newFolderHandle = this.createFolderHandle(newFolderPath);
        IStatus status = this.linkedResourceGroup.validateLinkLocation((IResource)newFolderHandle);
        if (status.getSeverity() == 4) {
            if (this.firstLinkCheck) {
                this.setMessage(status.getMessage());
            } else {
                this.setErrorMessage(status.getMessage());
            }
        } else if (status.getSeverity() == 2) {
            this.setMessage(status.getMessage(), 2);
            this.setErrorMessage(null);
        }
        return status;
    }

    protected boolean validatePage() {
        boolean valid = true;
        IWorkspace workspace = WorkbenchPlugin.getPluginWorkspace();
        IStatus nameStatus = null;
        String folderName = this.resourceGroup.getResource();
        if (folderName.indexOf(47) != -1) {
            StringTokenizer tok = new StringTokenizer(folderName, String.valueOf('/'));
            while (tok.hasMoreTokens()) {
                String pathFragment = tok.nextToken();
                nameStatus = workspace.validateName(pathFragment, 2);
                if (!nameStatus.isOK()) break;
            }
        }
        if (nameStatus == null && folderName.length() > 0) {
            nameStatus = workspace.validateName(folderName, 2);
        }
        if (nameStatus != null && !nameStatus.isOK()) {
            this.setErrorMessage(nameStatus.getMessage());
            return false;
        }
        if (!this.resourceGroup.areAllValuesValid()) {
            if (this.resourceGroup.getProblemType() == 1 || this.resourceGroup.getProblemType() == 5) {
                this.setMessage(this.resourceGroup.getProblemMessage());
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage(this.resourceGroup.getProblemMessage());
            }
            valid = false;
        }
        IStatus linkedResourceStatus = null;
        if (valid && (linkedResourceStatus = this.validateLinkedResource()).getSeverity() == 4) {
            valid = false;
        }
        if (valid && (linkedResourceStatus == null || linkedResourceStatus.isOK())) {
            this.setMessage(null);
            this.setErrorMessage(null);
        }
        return valid;
    }
}

