/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.misc.CheckboxTreeAndListGroup;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.model.WorkbenchViewerSorter;

public class FileSelectionDialog
extends SelectionDialog {
    private FileSystemElement root;
    private CheckboxTreeAndListGroup selectionGroup;
    private boolean expandAllOnOpen = false;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 500;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 250;

    public FileSelectionDialog(Shell parentShell, FileSystemElement fileSystemElement, String message) {
        super(parentShell);
        this.setTitle(WorkbenchMessages.getString("FileSelectionDialog.title"));
        this.root = fileSystemElement;
        if (message != null) {
            this.setMessage(message);
        } else {
            this.setMessage(WorkbenchMessages.getString("FileSelectionDialog.message"));
        }
    }

    private void addSelectionButtons(Composite composite) {
        Font font = composite.getFont();
        Composite buttonComposite = new Composite(composite, 131072);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        buttonComposite.setLayout((Layout)layout);
        GridData data = new GridData(128);
        composite.setData((Object)data);
        Button selectButton = new Button(buttonComposite, 8);
        selectButton.setFont(font);
        selectButton.setText(SelectionDialog.SELECT_ALL_TITLE);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileSelectionDialog.this.selectionGroup.setAllSelections(true);
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        Button deselectButton = new Button(buttonComposite, 8);
        deselectButton.setFont(font);
        deselectButton.setText(SelectionDialog.DESELECT_ALL_TITLE);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileSelectionDialog.this.selectionGroup.setAllSelections(false);
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
    }

    private void checkInitialSelections() {
        Iterator itemsToCheck = this.getInitialElementSelections().iterator();
        while (itemsToCheck.hasNext()) {
            FileSystemElement currentElement = (FileSystemElement)itemsToCheck.next();
            if (currentElement.isDirectory()) {
                this.selectionGroup.initialCheckTreeItem(currentElement);
                continue;
            }
            this.selectionGroup.initialCheckListItem(currentElement);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        WorkbenchHelp.setHelp((Control)shell, "org.eclipse.ui.file_selection_dialog_context");
    }

    public void create() {
        super.create();
        this.initializeDialog();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createMessageArea(composite);
        FileSystemElement input = new FileSystemElement("", null, true);
        input.addChild(this.root);
        this.root.setParent(input);
        this.selectionGroup = new CheckboxTreeAndListGroup(composite, input, this.getFolderProvider(), (ILabelProvider)new WorkbenchLabelProvider(), (IStructuredContentProvider)this.getFileProvider(), (ILabelProvider)new WorkbenchLabelProvider(), 0, 500, 250);
        ICheckStateListener listener = new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                FileSelectionDialog.this.getOkButton().setEnabled(FileSelectionDialog.this.selectionGroup.getCheckedElementCount() > 0);
            }
        };
        WorkbenchViewerSorter sorter = new WorkbenchViewerSorter();
        this.selectionGroup.setTreeSorter(sorter);
        this.selectionGroup.setListSorter(sorter);
        this.selectionGroup.addCheckStateListener(listener);
        this.addSelectionButtons(composite);
        return composite;
    }

    public boolean getExpandAllOnOpen() {
        return this.expandAllOnOpen;
    }

    private ITreeContentProvider getFileProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof FileSystemElement) {
                    return ((FileSystemElement)o).getFiles().getChildren(o);
                }
                return new Object[0];
            }
        };
    }

    private ITreeContentProvider getFolderProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof FileSystemElement) {
                    return ((FileSystemElement)o).getFolders().getChildren(o);
                }
                return new Object[0];
            }
        };
    }

    private void initializeDialog() {
        if (this.getInitialElementSelections().isEmpty()) {
            this.getOkButton().setEnabled(false);
        } else {
            this.checkInitialSelections();
        }
        this.selectionGroup.aboutToOpen();
        if (this.expandAllOnOpen) {
            this.selectionGroup.expandAll();
        }
    }

    protected void okPressed() {
        Iterator resultEnum = this.selectionGroup.getAllCheckedListItems();
        ArrayList list = new ArrayList();
        while (resultEnum.hasNext()) {
            list.add(resultEnum.next());
        }
        this.setResult(list);
        super.okPressed();
    }

    public void setExpandAllOnOpen(boolean expandAll) {
        this.expandAllOnOpen = expandAll;
    }
}

