/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.MultiStepWizardDialog;
import org.eclipse.ui.internal.dialogs.NewProjectWizard;
import org.eclipse.ui.internal.misc.Assert;
import org.eclipse.ui.internal.registry.Capability;
import org.eclipse.ui.internal.registry.CapabilityRegistry;
import org.eclipse.ui.internal.registry.ICategory;

public class CreateProjectAction
extends Action {
    private static final int SIZING_WIZARD_WIDTH = 500;
    private static final int SIZING_WIZARD_HEIGHT = 500;
    private IWorkbenchWindow window;
    private String initialProjectName;
    private Capability[] initialProjectCapabilities;
    private ICategory[] initialSelectedCategories;

    public CreateProjectAction(IWorkbenchWindow window) {
        super(WorkbenchMessages.getString("CreateProjectAction.text"));
        Assert.isNotNull(window);
        this.window = window;
        this.setImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_CTOOL_NEW_WIZ"));
        this.setHoverImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_CTOOL_NEW_WIZ_HOVER"));
        this.setDisabledImageDescriptor(WorkbenchImages.getImageDescriptor("IMG_CTOOL_NEW_WIZ_DIS"));
        this.setToolTipText(WorkbenchMessages.getString("CreateProjectAction.toolTip"));
        WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.new_action_context");
    }

    protected IStructuredSelection getInitialSelection() {
        ISelection selection = this.window.getSelectionService().getSelection();
        StructuredSelection selectionToPass = StructuredSelection.EMPTY;
        if (selection instanceof IStructuredSelection) {
            selectionToPass = (IStructuredSelection)selection;
        }
        return selectionToPass;
    }

    public void setInitialSelectedCategories(String[] ids) {
        if (ids == null || ids.length == 0) {
            this.initialSelectedCategories = null;
        } else {
            CapabilityRegistry reg = WorkbenchPlugin.getDefault().getCapabilityRegistry();
            ArrayList<ICategory> results = new ArrayList<ICategory>(ids.length);
            int i = 0;
            while (i < ids.length) {
                ICategory cat = reg.findCategory(ids[i]);
                if (cat != null) {
                    results.add(cat);
                }
                ++i;
            }
            if (results.isEmpty()) {
                this.initialSelectedCategories = null;
            } else {
                this.initialSelectedCategories = new ICategory[results.size()];
                results.toArray(this.initialSelectedCategories);
            }
        }
    }

    public void setInitialProjectCapabilities(String[] ids) {
        if (ids == null || ids.length == 0) {
            this.initialProjectCapabilities = null;
        } else {
            CapabilityRegistry reg = WorkbenchPlugin.getDefault().getCapabilityRegistry();
            ArrayList<Capability> results = new ArrayList<Capability>(ids.length);
            int i = 0;
            while (i < ids.length) {
                Capability cap = reg.findCapability(ids[i]);
                if (cap != null && cap.isValid()) {
                    results.add(cap);
                }
                ++i;
            }
            if (results.isEmpty()) {
                this.initialProjectCapabilities = null;
            } else {
                this.initialProjectCapabilities = new Capability[results.size()];
                results.toArray(this.initialProjectCapabilities);
            }
        }
    }

    public void setInitialProjectName(String name) {
        this.initialProjectName = name == null ? null : name.trim();
    }

    public void run() {
        NewProjectWizard wizard = new NewProjectWizard();
        wizard.init(this.window.getWorkbench(), this.getInitialSelection());
        wizard.setInitialProjectName(this.initialProjectName);
        wizard.setInitialProjectCapabilities(this.initialProjectCapabilities);
        wizard.setInitialSelectedCategories(this.initialSelectedCategories);
        MultiStepWizardDialog dialog = new MultiStepWizardDialog(this.window.getShell(), wizard);
        dialog.create();
        dialog.getShell().setSize(Math.max(500, dialog.getShell().getSize().x), 500);
        WorkbenchHelp.setHelp((Control)dialog.getShell(), "org.eclipse.ui.new_project_wizard_context");
        dialog.open();
    }
}

