/*
 * Decompiled with CFR 0.152.
 */
package org.drools.smf;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.drools.smf.NoSuchSemanticModuleException;
import org.drools.smf.SemanticModule;
import org.drools.smf.SemanticsReader;
import org.drools.smf.SemanticsRepository;
import org.drools.smf.SimpleSemanticsRepository;

public final class DefaultSemanticsRepository
implements SemanticsRepository {
    private static SemanticsRepository INSTANCE = null;
    private Set loadedSemantics = new HashSet();
    private SimpleSemanticsRepository repository = new SimpleSemanticsRepository();

    public static synchronized SemanticsRepository getInstance() throws Exception {
        if (INSTANCE == null) {
            INSTANCE = new DefaultSemanticsRepository();
        }
        return INSTANCE;
    }

    private DefaultSemanticsRepository() throws Exception {
        this.init();
    }

    protected void init() throws Exception {
        String droolsConfigProp;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        if ((droolsConfigProp = System.getProperty("drools.config")) != null) {
            this.loadConfig(droolsConfigProp);
        }
        Enumeration<URL> configUrls = cl.getResources("META-INF/drools.conf");
        while (configUrls.hasMoreElements()) {
            URL configUrl = configUrls.nextElement();
            this.loadConfig(configUrl);
        }
    }

    protected void loadConfig(String path) throws Exception {
        URL url;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        if ((url = cl.getResource(path)) == null) {
            System.err.println("INVALID PATH: [" + path + "]");
            return;
        }
        this.loadConfig(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void loadConfig(URL url) throws Exception {
        InputStream config = url.openStream();
        BufferedReader in = new BufferedReader(new InputStreamReader(config));
        try {
            String line;
            while ((line = in.readLine()) != null) {
                void var4_4;
                line = var4_4.trim();
                if (line.equals("") || line.startsWith("#")) continue;
                this.loadSemantics(line);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            in.close();
            throw throwable;
        }
        in.close();
    }

    protected void loadSemantics(String semanticsName) throws Exception {
        String semanticsFile;
        URL descriptor;
        if (this.loadedSemantics.contains(semanticsName)) {
            return;
        }
        this.loadedSemantics.add(semanticsName);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        if ((descriptor = cl.getResource(semanticsFile = "META-INF/" + semanticsName + ".conf")) == null) {
            System.err.println("cannot load " + semanticsFile);
            return;
        }
        SemanticsReader semanticsReader = new SemanticsReader();
        SemanticModule module = semanticsReader.read(descriptor);
        this.repository.registerSemanticModule(module);
    }

    public SemanticModule lookupSemanticModule(String uri) throws NoSuchSemanticModuleException {
        return this.repository.lookupSemanticModule(uri);
    }

    public SemanticModule[] getSemanticModules() {
        return this.repository.getSemanticModules();
    }
}

