/*
 * Decompiled with CFR 0.152.
 */
package org.drools.smf;

import java.net.URL;
import java.util.Enumeration;
import org.drools.smf.NoSuchSemanticModuleException;
import org.drools.smf.SemanticModule;
import org.drools.smf.SemanticsReader;
import org.drools.smf.SemanticsRepository;
import org.drools.smf.SimpleSemanticsRepository;

public final class DefaultSemanticsRepository
implements SemanticsRepository {
    private static SemanticsRepository INSTANCE = null;
    private SimpleSemanticsRepository repository = new SimpleSemanticsRepository();

    public static synchronized SemanticsRepository getInstance() throws Exception {
        if (INSTANCE == null) {
            INSTANCE = new DefaultSemanticsRepository();
        }
        return INSTANCE;
    }

    private DefaultSemanticsRepository() throws Exception {
        this.init();
    }

    protected void init() throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> moduleDescriptors = cl.getResources("META-INF/drools-semantics.properties");
        SemanticsReader semanticsReader = new SemanticsReader();
        while (moduleDescriptors.hasMoreElements()) {
            URL moduleDescriptor = moduleDescriptors.nextElement();
            SemanticModule module = semanticsReader.read(moduleDescriptor);
            this.repository.registerSemanticModule(module);
        }
    }

    public SemanticModule lookupSemanticModule(String uri) throws NoSuchSemanticModuleException {
        return this.repository.lookupSemanticModule(uri);
    }

    public SemanticModule[] getSemanticModules() {
        return this.repository.getSemanticModules();
    }
}

