/*
 * Decompiled with CFR 0.152.
 */
package zio.internal.metrics;

import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import zio.Unsafe;
import zio.internal.metrics.ConcurrentMetricHooks$;
import zio.internal.metrics.MetricHook;
import zio.metrics.MetricKey;
import zio.metrics.MetricKeyType;
import zio.metrics.MetricKeyType$Counter$;
import zio.metrics.MetricKeyType$Frequency$;
import zio.metrics.MetricKeyType$Gauge$;
import zio.metrics.MetricPair;
import zio.metrics.MetricPair$;
import zio.metrics.MetricState;

@ScalaSignature(bytes="\u0006\u0005\u0005Ec!B\u0006\r\u0001A\u0011\u0002\"B\r\u0001\t\u0003Y\u0002b\u0002\u0010\u0001\u0005\u0004%Ia\b\u0005\u0007s\u0001\u0001\u000b\u0011\u0002\u0011\t\u000bi\u0002A\u0011A\u001e\t\u000bU\u0003A\u0011\u0001,\t\u000bI\u0004A\u0011B:\t\u000f\u0005\u0005\u0001\u0001\"\u0003\u0002\u0004!9\u0011Q\u0003\u0001\u0005\n\u0005]\u0001bBA\u0015\u0001\u0011%\u00111\u0006\u0005\b\u0003{\u0001A\u0011BA \u0005a\u0019uN\\2veJ,g\u000e^'fiJL7MU3hSN$(/\u001f\u0006\u0003\u001b9\tq!\\3ue&\u001c7O\u0003\u0002\u0010!\u0005A\u0011N\u001c;fe:\fGNC\u0001\u0012\u0003\rQ\u0018n\\\n\u0003\u0001M\u0001\"\u0001F\f\u000e\u0003UQ\u0011AF\u0001\u0006g\u000e\fG.Y\u0005\u00031U\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003q\u0001\"!\b\u0001\u000e\u00031\t1!\\1q+\u0005\u0001\u0003\u0003B\u0011)UIj\u0011A\t\u0006\u0003G\u0011\n!bY8oGV\u0014(/\u001a8u\u0015\t)c%\u0001\u0003vi&d'\"A\u0014\u0002\t)\fg/Y\u0005\u0003S\t\u0012\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\rYSfL\u0007\u0002Y)\u0011Q\u0002E\u0005\u0003]1\u0012\u0011\"T3ue&\u001c7*Z=\u0011\u0005-\u0002\u0014BA\u0019-\u00055iU\r\u001e:jG.+\u0017\u0010V=qKB\u00111G\u000e\b\u0003;QJ!!\u000e\u0007\u0002\u00155+GO]5d\u0011>|7.\u0003\u00028q\t!!k\\8u\u0015\t)D\"\u0001\u0003nCB\u0004\u0013\u0001C:oCB\u001c\bn\u001c;\u0015\u0003q\"\"!P(\u0011\u0007y*\u0005J\u0004\u0002@\u0007B\u0011\u0001)F\u0007\u0002\u0003*\u0011!IG\u0001\u0007yI|w\u000e\u001e \n\u0005\u0011+\u0012A\u0002)sK\u0012,g-\u0003\u0002G\u000f\n\u00191+\u001a;\u000b\u0005\u0011+\u0002CA%M\u001d\tY#*\u0003\u0002LY\u0005QQ*\u001a;sS\u000e\u0004\u0016-\u001b:\n\u00055s%aB+oif\u0004X\r\u001a\u0006\u0003\u00172BQ\u0001\u0015\u0003A\u0004E\u000ba!\u001e8tC\u001a,\u0007C\u0001*T\u001b\u0005\u0001\u0012B\u0001+\u0011\u0005\u0019)fn]1gK\u0006\u0019q-\u001a;\u0016\u0005]#GC\u0001-a)\tI\u0016\u000f\u0005\u0003\u001e5rs\u0017BA.\r\u0005)iU\r\u001e:jG\"{wn\u001b\t\u0003;2t!A\u00186\u000f\u0005}\u0003G\u0002\u0001\u0005\u0006C\u0016\u0001\rAY\u0001\u0004W\u0016L\bcA\u0016.GB\u0011q\f\u001a\u0003\u0006K\u0016\u0011\rA\u001a\u0002\u0005)f\u0004X-\u0005\u0002h_A\u0011A\u0003[\u0005\u0003SV\u0011qAT8uQ&tw-\u0003\u0002l[\u000591.Z=UsB,\u0017BA71\u0005\tIe\u000e\u0005\u0002^_&\u0011\u0001\u000f\r\u0002\u0004\u001fV$\b\"\u0002)\u0006\u0001\b\t\u0016AC4fi\u000e{WO\u001c;feR\u0011A/\u001f\u000b\u0003kb\u0004\"a\r<\n\u0005]D$aB\"pk:$XM\u001d\u0005\u0006!\u001a\u0001\u001d!\u0015\u0005\u0006C\u001a\u0001\rA\u001f\t\u0003wzt!a\u000b?\n\u0005ud\u0013!C'fiJL7mS3z\u0013\t9xP\u0003\u0002~Y\u0005Aq-\u001a;HCV<W\r\u0006\u0003\u0002\u0006\u0005=A\u0003BA\u0004\u0003\u001b\u00012aMA\u0005\u0013\r\tY\u0001\u000f\u0002\u0006\u000f\u0006,x-\u001a\u0005\u0006!\u001e\u0001\u001d!\u0015\u0005\u0007C\u001e\u0001\r!!\u0005\u0011\u0007m\f\u0019\"C\u0002\u0002\f}\fAbZ3u\u0011&\u001cHo\\4sC6$B!!\u0007\u0002$Q!\u00111DA\u0011!\r\u0019\u0014QD\u0005\u0004\u0003?A$!\u0003%jgR|wM]1n\u0011\u0015\u0001\u0006\u0002q\u0001R\u0011\u0019\t\u0007\u00021\u0001\u0002&A\u001910a\n\n\u0007\u0005}q0\u0001\u0006hKR\u001cV/\\7bef$B!!\f\u00028Q!\u0011qFA\u001b!\r\u0019\u0014\u0011G\u0005\u0004\u0003gA$aB*v[6\f'/\u001f\u0005\u0006!&\u0001\u001d!\u0015\u0005\u0007C&\u0001\r!!\u000f\u0011\u0007m\fY$C\u0002\u00024}\f1bZ3u'\u0016$8i\\;oiR!\u0011\u0011IA&)\u0011\t\u0019%!\u0013\u0011\u0007M\n)%C\u0002\u0002Ha\u0012\u0011B\u0012:fcV,gnY=\t\u000bAS\u00019A)\t\r\u0005T\u0001\u0019AA'!\rY\u0018qJ\u0005\u0004\u0003\u000fz\b")
public class ConcurrentMetricRegistry {
    private final ConcurrentHashMap<MetricKey<MetricKeyType>, MetricHook<?, MetricState<Object>>> map = new ConcurrentHashMap();

    private ConcurrentHashMap<MetricKey<MetricKeyType>, MetricHook<?, MetricState<Object>>> map() {
        return this.map;
    }

    public scala.collection.immutable.Set<MetricPair<MetricKeyType, Object>> snapshot(Unsafe unsafe) {
        Iterator<Map.Entry<MetricKey<MetricKeyType>, MetricHook<?, MetricState<Object>>>> iterator = this.map().entrySet().iterator();
        Set result = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (iterator.hasNext()) {
            Map.Entry<MetricKey<MetricKeyType>, MetricHook<?, MetricState<Object>>> value = iterator.next();
            MetricKey<MetricKeyType> key = value.getKey();
            MetricHook<?, MetricState<Object>> hook = value.getValue();
            result.add(MetricPair$.MODULE$.make(key, (MetricState)hook.get().apply(), unsafe));
        }
        return result.toSet();
    }

    public <Type extends MetricKeyType> MetricHook<Object, Object> get(MetricKey<Type> key, Unsafe unsafe) {
        MetricHook<Object, Object> hook0 = this.map().get(key);
        if (hook0 == null) {
            MetricKeyType metricKeyType = (MetricKeyType)key.keyType();
            if (MetricKeyType$Counter$.MODULE$.equals(metricKeyType)) {
                return this.getCounter(key, unsafe);
            }
            if (MetricKeyType$Frequency$.MODULE$.equals(metricKeyType)) {
                return this.getSetCount(key, unsafe);
            }
            if (MetricKeyType$Gauge$.MODULE$.equals(metricKeyType)) {
                return this.getGauge(key, unsafe);
            }
            if (metricKeyType instanceof MetricKeyType.Histogram) {
                return this.getHistogram(key, unsafe);
            }
            if (metricKeyType instanceof MetricKeyType.Summary) {
                return this.getSummary(key, unsafe);
            }
            throw new MatchError((Object)metricKeyType);
        }
        return hook0;
    }

    private MetricHook<Object, MetricState.Counter> getCounter(MetricKey<MetricKeyType$Counter$> key, Unsafe unsafe) {
        MetricHook<?, MetricState<Object>> value = this.map().get(key);
        if (value == null) {
            MetricHook<Object, MetricState.Counter> counter = ConcurrentMetricHooks$.MODULE$.counter(key);
            this.map().putIfAbsent(key, counter);
            value = this.map().get(key);
        }
        return value;
    }

    private MetricHook<Object, MetricState.Gauge> getGauge(MetricKey<MetricKeyType$Gauge$> key, Unsafe unsafe) {
        MetricHook<?, MetricState<Object>> value = this.map().get(key);
        if (value == null) {
            MetricHook<Object, MetricState.Gauge> gauge = ConcurrentMetricHooks$.MODULE$.gauge(key, 0.0);
            this.map().putIfAbsent(key, gauge);
            value = this.map().get(key);
        }
        return value;
    }

    private MetricHook<Object, MetricState.Histogram> getHistogram(MetricKey<MetricKeyType.Histogram> key, Unsafe unsafe) {
        MetricHook<?, MetricState<Object>> value = this.map().get(key);
        if (value == null) {
            MetricHook<Object, MetricState.Histogram> histogram = ConcurrentMetricHooks$.MODULE$.histogram(key);
            this.map().putIfAbsent(key, histogram);
            value = this.map().get(key);
        }
        return value;
    }

    private MetricHook<Tuple2<Object, Instant>, MetricState.Summary> getSummary(MetricKey<MetricKeyType.Summary> key, Unsafe unsafe) {
        MetricHook<?, MetricState<Object>> value = this.map().get(key);
        if (value == null) {
            MetricHook<Tuple2<Object, Instant>, MetricState.Summary> summary = ConcurrentMetricHooks$.MODULE$.summary(key);
            this.map().putIfAbsent(key, summary);
            value = this.map().get(key);
        }
        return value;
    }

    private MetricHook<String, MetricState.Frequency> getSetCount(MetricKey<MetricKeyType$Frequency$> key, Unsafe unsafe) {
        MetricHook<?, MetricState<Object>> value = this.map().get(key);
        if (value == null) {
            MetricHook<String, MetricState.Frequency> frequency = ConcurrentMetricHooks$.MODULE$.frequency(key);
            this.map().putIfAbsent(key, frequency);
            value = this.map().get(key);
        }
        return value;
    }
}

