/*
 * Decompiled with CFR 0.152.
 */
package zio.internal.metrics;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import zio.Chunk;
import zio.ChunkBuilder;
import zio.ChunkBuilder$;
import zio.ChunkLike;
import zio.internal.metrics.ConcurrentHistogram$;

@ScalaSignature(bytes="\u0006\u0005\u00113aAC\u0006\u0002\"=\t\u0002\"\u0002\r\u0001\t\u0003Q\u0002\"B\u000f\u0001\r\u0003q\u0002\"\u0002\u0012\u0001\r\u0003\u0019\u0003\"\u0002\u0017\u0001\r\u0003i\u0003\"B\u001b\u0001\r\u00031tAB\u001e\f\u0011\u0003yAH\u0002\u0004\u000b\u0017!\u0005q\"\u0010\u0005\u00061\u001d!\tA\u0010\u0005\u0006\u007f\u001d!\t\u0001\u0011\u0002\u0014\u0007>t7-\u001e:sK:$\b*[:u_\u001e\u0014\u0018-\u001c\u0006\u0003\u00195\tq!\\3ue&\u001c7O\u0003\u0002\u000f\u001f\u0005A\u0011N\u001c;fe:\fGNC\u0001\u0011\u0003\rQ\u0018n\\\n\u0003\u0001I\u0001\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003m\u0001\"\u0001\b\u0001\u000e\u0003-\t\u0001bZ3u\u0007>,h\u000e\u001e\u000b\u0002?A\u00111\u0003I\u0005\u0003CQ\u0011A\u0001T8oO\u00069qNY:feZ,GC\u0001\u0013(!\t\u0019R%\u0003\u0002')\t!QK\\5u\u0011\u0015A3\u00011\u0001*\u0003\u00151\u0018\r\\;f!\t\u0019\"&\u0003\u0002,)\t1Ai\\;cY\u0016\f\u0001b\u001d8baNDw\u000e\u001e\u000b\u0002]A\u0019q\u0006\r\u001a\u000e\u0003=I!!M\b\u0003\u000b\rCWO\\6\u0011\tM\u0019\u0014fH\u0005\u0003iQ\u0011a\u0001V;qY\u0016\u0014\u0014AB4fiN+X\u000eF\u0001*S\t\u0001\u0001H\u0002\u0003:\u0001\u0001Q$!\u0004\u001fm_\u000e\fG\u000eI2iS2$gh\u0005\u000297\u0005\u00192i\u001c8dkJ\u0014XM\u001c;ISN$xn\u001a:b[B\u0011AdB\n\u0003\u000fI!\u0012\u0001P\u0001\u0007[\u0006tW/\u00197\u0015\u0005m\t\u0005\"\u0002\"\n\u0001\u0004\u0019\u0015A\u00022pk:$7\u000fE\u00020a%\u0002")
public abstract class ConcurrentHistogram {
    public static ConcurrentHistogram manual(Chunk<Object> bounds) {
        return new ConcurrentHistogram(bounds){
            private final long[] values;
            private final double[] boundaries;
            private long count;
            private double sum;
            private final int size;

            public long getCount() {
                return this.count;
            }

            public void observe(double value) {
                int from = 0;
                int to = this.size;
                while (from != to) {
                    int mid = from + (to - from) / 2;
                    double boundary = this.boundaries[mid];
                    if (value <= boundary) {
                        to = mid;
                    } else {
                        from = mid;
                    }
                    if (to != from + 1) continue;
                    if (value <= this.boundaries[from]) {
                        to = from;
                        continue;
                    }
                    from = to;
                }
                this.values[from] = this.values[from] + 1L;
                ++this.count;
                this.sum += value;
            }

            public Chunk<Tuple2<Object, Object>> snapshot() {
                ChunkBuilder<A> builder = ChunkBuilder$.MODULE$.make();
                long cumulated = 0L;
                for (int i = 0; i != this.size; ++i) {
                    double boundary = this.boundaries[i];
                    long value = this.values[i];
                    builder.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)boundary)), (Object)BoxesRunTime.boxToLong((long)(cumulated += value))));
                }
                return (Chunk)builder.result();
            }

            public double getSum() {
                return this.sum;
            }

            public static final /* synthetic */ void $anonfun$new$1($anon$1 $this, Tuple2 x0$1) {
                if (x0$1 != null) {
                    double n = x0$1._1$mcD$sp();
                    int i = x0$1._2$mcI$sp();
                    $this.boundaries[i] = n;
                    return;
                }
                throw new MatchError(null);
            }
            {
                this.values = new long[bounds$1.length() + 1];
                this.boundaries = (double[])Array$.MODULE$.ofDim(bounds$1.length(), (ClassTag)ClassTag$.MODULE$.Double());
                this.count = 0L;
                this.sum = 0.0;
                this.size = bounds$1.length();
                ((ChunkLike)bounds$1.sorted((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$)).zipWithIndex().foreach((Function1 & Serializable)x0$1 -> {
                    $anon$1.$anonfun$new$1(this, x0$1);
                    return BoxedUnit.UNIT;
                });
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1$adapted(zio.internal.metrics.ConcurrentHistogram$$anon$1 scala.Tuple2 )}, serializedLambda);
            }
        };
    }

    public abstract long getCount();

    public abstract void observe(double var1);

    public abstract Chunk<Tuple2<Object, Object>> snapshot();

    public abstract double getSum();
}

