/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.io.Serializable;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.Nothing$;
import zio.Cause$;
import zio.Fiber;
import zio.Fiber$Status$Done$;
import zio.FiberId;
import zio.FiberId$None$;
import zio.UIO$;
import zio.ZIO;

public final class FiberRenderer$ {
    public static final FiberRenderer$ MODULE$ = new FiberRenderer$();

    public ZIO<Object, Nothing$, String> prettyPrint(Fiber.Dump dump, Object trace) {
        return UIO$.MODULE$.apply((Function0 & Serializable)() -> MODULE$.unsafePrettyPrint(dump, System.currentTimeMillis()), trace);
    }

    private String unsafePrettyPrint(Fiber.Dump dump, long now) {
        FiberId blockingOn;
        long millis = now - (long)(dump.fiberId().startTimeSeconds() * 1000);
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        String name = new StringBuilder(2).append("\"").append(dump.fiberId().threadName()).append("\"").toString();
        String lifeMsg = new StringBuilder(0).append(hours == 0L ? "" : new StringBuilder(1).append(hours).append("h").toString()).append((Object)(hours == 0L && minutes == 0L ? "" : new StringBuilder(1).append(minutes).append("m").toString())).append((Object)(hours == 0L && minutes == 0L && seconds == 0L ? "" : new StringBuilder(1).append(seconds).append("s").toString())).append(new StringBuilder(2).append(millis).append("ms").toString()).toString();
        Fiber.Status status = dump.status();
        String string = status instanceof Fiber.Status.Suspended ? ((blockingOn = ((Fiber.Status.Suspended)status).blockingOn()) != FiberId$None$.MODULE$ ? new StringBuilder(11).append("waiting on ").append(new StringBuilder(1).append("#").append(blockingOn.ids().mkString(", ")).toString()).toString() : "") : "";
        String statMsg = this.renderStatus(dump.status());
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(53).append("\n       |\"").append(name).append("\" (").append(lifeMsg).append(") ").append(string).append("\n       |   Status: ").append(statMsg).append("\n       |").append(Cause$.MODULE$.fail(Cause$.MODULE$.empty(), dump.trace()).prettyPrint()).append("\n       |").toString()));
    }

    private String renderStatus(Fiber.Status status) {
        String string;
        if (Fiber$Status$Done$.MODULE$.equals(status)) {
            string = "Done";
        } else if (status instanceof Fiber.Status.Finishing) {
            boolean b = ((Fiber.Status.Finishing)status).interrupting();
            string = new StringBuilder(11).append("Finishing(").append((Object)(b ? "interrupting" : "")).append(")").toString();
        } else if (status instanceof Fiber.Status.Running) {
            boolean b = ((Fiber.Status.Running)status).interrupting();
            string = new StringBuilder(9).append("Running(").append((Object)(b ? "interrupting" : "")).append(")").toString();
        } else if (status instanceof Fiber.Status.Suspended) {
            Fiber.Status.Suspended suspended = (Fiber.Status.Suspended)status;
            boolean interruptible = suspended.interruptible();
            long epoch = suspended.epoch();
            Object asyncTrace = suspended.asyncTrace();
            String in = interruptible ? "interruptible" : "uninterruptible";
            String ep = new StringBuilder(7).append(epoch).append(" asyncs").toString();
            String as = asyncTrace.toString();
            string = new StringBuilder(15).append("Suspended(").append(in).append(", ").append(ep).append(", ").append(as).append(")").toString();
        } else {
            throw new MatchError((Object)status);
        }
        return string;
    }

    private FiberRenderer$() {
    }
}

