/*
 * Decompiled with CFR 0.152.
 */
package zio;

import java.time.Instant;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import zio.FiberId;
import zio.LogLevel;
import zio.LogSpan;
import zio.ZFiberRef;
import zio.ZLogger;
import zio.Zippable;
import zio.internal.stacktracer.ZTraceElement;

public final class ZLogger$ {
    public static final ZLogger$ MODULE$ = new ZLogger$();
    private static final ZLogger<String> defaultFormatter = new ZLogger<String>(){

        public <B> ZLogger<Object> $plus$plus(ZLogger<B> that, Zippable<String, B> zippable) {
            return ZLogger.$plus$plus$(this, that, zippable);
        }

        public final ZLogger<Option<String>> filterLogLevel(Function1<LogLevel, Object> f) {
            return ZLogger.filterLogLevel$(this, f);
        }

        public final <B> ZLogger<B> map(Function1<String, B> f) {
            return ZLogger.map$(this, f);
        }

        public final String apply(ZTraceElement trace, FiberId fiberId, LogLevel logLevel, Function0<String> message, Map<ZFiberRef.Runtime<?>, Object> context, List<LogSpan> spans) {
            return ZLogger$.zio$ZLogger$$$anonfun$defaultFormatter$1(trace, fiberId, logLevel, message, context, spans);
        }
        {
            ZLogger.$init$(this);
        }
    };

    public ZLogger<String> defaultFormatter() {
        return defaultFormatter;
    }

    private StringBuilder appendQuoted(String label, StringBuilder sb) {
        if (label.indexOf(" ") < 0) {
            sb.append(label);
        } else {
            sb.append("\"").append(label).append("\"");
        }
        return sb;
    }

    public static final /* synthetic */ String zio$ZLogger$$$anonfun$defaultFormatter$1(ZTraceElement trace, FiberId fiberId, LogLevel logLevel, Function0 message0, Map context, List spans0) {
        StringBuilder sb = new StringBuilder();
        Instant now = Instant.now();
        long nowMillis = System.currentTimeMillis();
        sb.append("timestamp=").append(now.toString()).append(" level=").append(logLevel.label()).append(" thread=#").append(Long.toString(fiberId.seqNumber())).append(" message=\"").append((String)message0.apply()).append("\"");
        if (spans0.nonEmpty()) {
            sb.append(" ");
            Iterator it = spans0.iterator();
            boolean first = true;
            while (it.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(" ");
                }
                ((LogSpan)it.next()).unsafeRender(sb, nowMillis);
            }
        }
        if (!(trace instanceof ZTraceElement.NoLocation)) {
            if (trace instanceof ZTraceElement.SourceLocation) {
                ZTraceElement.SourceLocation sourceLocation = (ZTraceElement.SourceLocation)trace;
                String file = sourceLocation.file();
                String clazz = sourceLocation.clazz();
                String method = sourceLocation.method();
                int line = sourceLocation.line();
                sb.append(" file=");
                MODULE$.appendQuoted(file, sb);
                sb.append(" line=").append(line).append(" class=");
                MODULE$.appendQuoted(clazz, sb);
                sb.append(" method=").append(method);
            } else {
                throw new MatchError((Object)trace);
            }
        }
        return sb.toString();
    }

    private ZLogger$() {
    }
}

