/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import zio.Fiber;
import zio.Fiber$Status$Done$;
import zio.UIO$;
import zio.ZIO;
import zio.ZIO$;
import zio.internal.stacktracer.ZTraceElement;

public final class FiberRenderer$ {
    public static final FiberRenderer$ MODULE$ = new FiberRenderer$();

    public ZIO<Object, Nothing$, String> dumpStr(Seq<Fiber.Runtime<?, ?>> fibers, boolean withTrace) {
        return ZIO$.MODULE$.foreach(fibers, (Function1 & Serializable)f -> f.dumpWith(withTrace), BuildFrom$.MODULE$.buildFromIterableOps()).flatMap((Function1 & Serializable)dumps -> UIO$.MODULE$.apply((JFunction0.mcJ.sp & Serializable)() -> System.currentTimeMillis()).map((Function1 & Serializable)now -> FiberRenderer$.$anonfun$dumpStr$4(dumps, withTrace, BoxesRunTime.unboxToLong((Object)now))));
    }

    public ZIO<Object, Nothing$, String> prettyPrintM(Fiber.Dump dump) {
        return UIO$.MODULE$.apply((Function0 & Serializable)() -> MODULE$.prettyPrint(dump, System.currentTimeMillis()));
    }

    private <A> Iterable<Tuple2<A, Object>> zipWithHasNext(Iterable<A> it) {
        if (it.isEmpty()) {
            return (Iterable)Seq$.MODULE$.empty();
        }
        return (Iterable)package$.MODULE$.Iterable().concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Iterable[]{(Iterable)((IterableOps)it.dropRight(1)).map((Function1 & Serializable)x$1 -> new Tuple2(x$1, (Object)BoxesRunTime.boxToBoolean((boolean)true))), new .colon.colon((Object)new Tuple2(it.last(), (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)Nil$.MODULE$)}));
    }

    private String prettyPrint(Fiber.Dump dump, long now) {
        List<Fiber.Id> blockingOn;
        long millis = now - dump.fiberId().startTimeMillis();
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        String name2 = (String)dump.fiberName().fold((Function0 & Serializable)() -> "", (Function1 & Serializable)name -> new StringBuilder(3).append("\"").append((String)name).append("\" ").toString());
        String lifeMsg = new StringBuilder(0).append(hours == 0L ? "" : new StringBuilder(1).append(hours).append("h").toString()).append((Object)(hours == 0L && minutes == 0L ? "" : new StringBuilder(1).append(minutes).append("m").toString())).append((Object)(hours == 0L && minutes == 0L && seconds == 0L ? "" : new StringBuilder(1).append(seconds).append("s").toString())).append(new StringBuilder(2).append(millis).append("ms").toString()).toString();
        Fiber.Status status = dump.status();
        String string = status instanceof Fiber.Status.Suspended ? ((blockingOn = ((Fiber.Status.Suspended)status).blockingOn()).nonEmpty() ? new StringBuilder(11).append("waiting on ").append(blockingOn.map((Function1 & Serializable)id -> new StringBuilder(1).append("#").append(id.seqNumber()).toString()).mkString(", ")).toString() : "") : "";
        String statMsg = this.renderStatus(dump.status());
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(52).append("\n       |").append(name2).append("#").append(dump.fiberId().seqNumber()).append(" (").append(lifeMsg).append(") ").append(string).append("\n       |   Status: ").append(statMsg).append("\n       |").append(dump.trace().fold((Function0 & Serializable)() -> "", (Function1 & Serializable)x$2 -> x$2.prettyPrint())).append("\n       |").toString()));
    }

    private String renderStatus(Fiber.Status status) {
        String string;
        if (Fiber$Status$Done$.MODULE$.equals(status)) {
            string = "Done";
        } else if (status instanceof Fiber.Status.Finishing) {
            boolean b = ((Fiber.Status.Finishing)status).interrupting();
            string = new StringBuilder(11).append("Finishing(").append((Object)(b ? "interrupting" : "")).append(")").toString();
        } else if (status instanceof Fiber.Status.Running) {
            boolean b = ((Fiber.Status.Running)status).interrupting();
            string = new StringBuilder(9).append("Running(").append((Object)(b ? "interrupting" : "")).append(")").toString();
        } else if (status instanceof Fiber.Status.Suspended) {
            Fiber.Status.Suspended suspended = (Fiber.Status.Suspended)status;
            boolean interruptible = suspended.interruptible();
            long epoch = suspended.epoch();
            Option<ZTraceElement> asyncTrace = suspended.asyncTrace();
            String in = interruptible ? "interruptible" : "uninterruptible";
            String ep = new StringBuilder(7).append(epoch).append(" asyncs").toString();
            String as = (String)asyncTrace.map((Function1 & Serializable)x$3 -> x$3.prettyPrint()).getOrElse((Function0 & Serializable)() -> "");
            string = new StringBuilder(15).append("Suspended(").append(in).append(", ").append(ep).append(", ").append(as).append(")").toString();
        } else {
            throw new MatchError((Object)status);
        }
        return string;
    }

    private String renderHierarchy(Iterable<Fiber.Dump> trees) {
        return ((IterableOnceOps)this.zipWithHasNext(trees).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            Fiber.Dump tree = (Fiber.Dump)x0$1._1();
            String string = MODULE$.renderOne(tree);
            return string;
        })).mkString();
    }

    private String renderOne(Fiber.Dump tree) {
        return this.go$1(tree, "");
    }

    private Vector<String> collectTraces(Iterable<Fiber.Dump> dumps, long now) {
        return ((IterableOnceOps)dumps.map((Function1 & Serializable)x$4 -> MODULE$.prettyPrint((Fiber.Dump)x$4, now))).toVector();
    }

    public static final /* synthetic */ String $anonfun$dumpStr$4(Seq dumps$1, boolean withTrace$1, long now) {
        String treeString = MODULE$.renderHierarchy((Iterable<Fiber.Dump>)dumps$1);
        return ((IterableOnceOps)(withTrace$1 ? MODULE$.collectTraces((Iterable<Fiber.Dump>)dumps$1, now) : (Vector<String>)Seq$.MODULE$.empty()).$plus$colon((Object)treeString)).mkString("\n");
    }

    private final String go$1(Fiber.Dump t, String prefix) {
        String nameStr = (String)t.fiberName().fold((Function0 & Serializable)() -> "", (Function1 & Serializable)n -> new StringBuilder(3).append("\"").append((String)n).append("\" ").toString());
        String statusMsg = this.renderStatus(t.status());
        return new StringBuilder(15).append(prefix).append("+---").append(nameStr).append("#").append(t.fiberId().seqNumber()).append(" Status: ").append(statusMsg).append("\n").toString();
    }

    private FiberRenderer$() {
    }
}

