/*
 * Decompiled with CFR 0.152.
 */
package zio.internal.impls;

import dotty.runtime.function.JFunction1;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import scala.Function1;
import scala.Predef$;
import scala.runtime.RichInt$;
import zio.internal.impls.RingBuffer$;
import zio.internal.impls.padding.HeadPadding;
import zio.internal.impls.padding.MutableQueueFieldsPadding;
import zio.internal.impls.padding.TailPadding;

public abstract class RingBuffer<A>
extends MutableQueueFieldsPadding<A> {
    private final int capacity;
    private final Object[] buf;
    private final AtomicLongArray seq;

    public static <A> RingBuffer<A> apply(int n) {
        return RingBuffer$.MODULE$.apply(n);
    }

    public static int nextPow2(int n) {
        return RingBuffer$.MODULE$.nextPow2(n);
    }

    public <A> RingBuffer(int capacity) {
        this.capacity = capacity;
        this.buf = new Object[capacity];
        this.seq = new AtomicLongArray(capacity);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), capacity).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> this.seq().set(i, i));
    }

    @Override
    public final int capacity() {
        return this.capacity;
    }

    private Object[] buf() {
        return this.buf;
    }

    private AtomicLongArray seq() {
        return this.seq;
    }

    public abstract int posToIdx(long var1, int var3);

    @Override
    public final int size() {
        return (int)(MutableQueueFieldsPadding.tailUpdater.get(this) - MutableQueueFieldsPadding.headUpdater.get(this));
    }

    @Override
    public final long enqueuedCount() {
        return MutableQueueFieldsPadding.tailUpdater.get(this);
    }

    @Override
    public final long dequeuedCount() {
        return MutableQueueFieldsPadding.headUpdater.get(this);
    }

    @Override
    public final boolean offer(A a) {
        boolean bl;
        int aCapacity = this.capacity();
        AtomicLongArray aSeq = this.seq();
        long curSeq = 0L;
        AtomicLongFieldUpdater<HeadPadding> aHead = MutableQueueFieldsPadding.headUpdater;
        long curHead = 0L;
        AtomicLongFieldUpdater<TailPadding> aTail = MutableQueueFieldsPadding.tailUpdater;
        long curTail = aTail.get(this);
        int curIdx = 0;
        int state = 0;
        while (state == 0) {
            curIdx = this.posToIdx(curTail, aCapacity);
            curSeq = aSeq.get(curIdx);
            if (curSeq < curTail) {
                curHead = aHead.get(this);
                if (curTail >= curHead + (long)aCapacity) {
                    state = -2;
                    continue;
                }
                state = 0;
                continue;
            }
            if (curSeq == curTail) {
                if (aTail.compareAndSet(this, curTail, curTail + 1L)) {
                    state = 1;
                    continue;
                }
                ++curTail;
                state = 0;
                continue;
            }
            curTail = aTail.get(this);
            state = 0;
        }
        if (state == 1) {
            this.buf()[curIdx] = a;
            aSeq.lazySet(curIdx, curTail + 1L);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public final A poll(A a) {
        Object object;
        int aCapacity = this.capacity();
        Object[] aBuf = this.buf();
        AtomicLongArray aSeq = this.seq();
        long curSeq = 0L;
        AtomicLongFieldUpdater<HeadPadding> aHead = MutableQueueFieldsPadding.headUpdater;
        long curHead = aHead.get(this);
        int curIdx = 0;
        AtomicLongFieldUpdater<TailPadding> aTail = MutableQueueFieldsPadding.tailUpdater;
        long curTail = 0L;
        int state = 0;
        while (state == 0) {
            curIdx = this.posToIdx(curHead, aCapacity);
            curSeq = aSeq.get(curIdx);
            if (curSeq <= curHead) {
                curTail = aTail.get(this);
                if (curHead >= curTail) {
                    state = -1;
                    continue;
                }
                state = 0;
                continue;
            }
            if (curSeq == curHead + 1L) {
                if (aHead.compareAndSet(this, curHead, curHead + 1L)) {
                    state = 1;
                    continue;
                }
                ++curHead;
                state = 0;
                continue;
            }
            curHead = aHead.get(this);
            state = 0;
        }
        if (state == 1) {
            Object deqElement = aBuf[curIdx];
            aBuf[curIdx] = null;
            aSeq.lazySet(curIdx, curHead + (long)aCapacity);
            object = deqElement;
        } else {
            object = a;
        }
        return object;
    }

    @Override
    public final boolean isEmpty() {
        return MutableQueueFieldsPadding.tailUpdater.get(this) == MutableQueueFieldsPadding.headUpdater.get(this);
    }

    @Override
    public final boolean isFull() {
        return MutableQueueFieldsPadding.tailUpdater.get(this) == MutableQueueFieldsPadding.headUpdater.get(this) + (long)this.capacity();
    }
}

