/*
 * Decompiled with CFR 0.152.
 */
package zio.duration;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.concurrent.duration.FiniteDuration$;
import scala.math.Ordered;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import zio.duration.Duration$;
import zio.duration.Duration$Finite$;
import zio.duration.Duration$Infinity$;

public interface Duration
extends Ordered<Duration>,
Serializable,
Product {
    public Duration $plus(Duration var1);

    public Duration $times(double var1);

    default public Duration max(Duration other) {
        return this.$greater(other) ? this : other;
    }

    default public Duration min(Duration other) {
        return this.$less(other) ? this : other;
    }

    default public <Z> Z fold(Function0<Z> infinity, Function1<Finite, Z> finite) {
        Object object;
        Duration duration = this;
        if (Duration$Infinity$.MODULE$.equals(duration)) {
            object = infinity.apply();
        } else if (duration instanceof Finite) {
            Finite f = (Finite)duration;
            object = finite.apply((Object)f);
        } else {
            throw new MatchError((Object)duration);
        }
        return (Z)object;
    }

    public long toMillis();

    public long toNanos();

    public boolean isZero();

    public scala.concurrent.duration.Duration asScala();

    public java.time.Duration asJava();

    public String render();

    public static final class Finite
    implements Duration {
        private final long nanos;

        public static Duration apply(long l) {
            return Duration$Finite$.MODULE$.apply(l);
        }

        public static Finite fromProduct(Product product) {
            return Duration$Finite$.MODULE$.fromProduct(product);
        }

        public static Finite unapply(Finite finite) {
            return Duration$Finite$.MODULE$.unapply(finite);
        }

        public Finite(long nanos) {
            this.nanos = nanos;
            Ordered.$init$((Ordered)this);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.nanos()));
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Finite)) return false;
            Finite finite = (Finite)object;
            if (this.nanos() != finite.nanos()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Finite;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Finite";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
            }
            return BoxesRunTime.boxToLong((long)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
            }
            return "nanos";
        }

        public long nanos() {
            return this.nanos;
        }

        @Override
        public final Duration $plus(Duration other) {
            Duration duration;
            Duration duration2 = other;
            if (duration2 instanceof Finite) {
                long l;
                Finite finite = Duration$Finite$.MODULE$.unapply((Finite)duration2);
                long otherNanos = l = finite._1();
                long sum = this.nanos() + otherNanos;
                duration = sum >= 0L ? Duration$Finite$.MODULE$.apply(sum) : Duration$Infinity$.MODULE$;
            } else if (Duration$Infinity$.MODULE$.equals(duration2)) {
                duration = Duration$Infinity$.MODULE$;
            } else {
                throw new MatchError((Object)duration2);
            }
            return duration;
        }

        @Override
        public final Duration $times(double factor) {
            return !(factor > 0.0) || this.nanos() <= 0L ? Duration$.MODULE$.Zero() : (factor < 1.0 ? Duration$Finite$.MODULE$.apply(RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper((double)this.nanos() * factor))) : (factor < (double)(Long.MAX_VALUE / this.nanos()) ? Duration$Finite$.MODULE$.apply(RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper((double)this.nanos() * factor))) : Duration$Infinity$.MODULE$));
        }

        public final int compare(Duration other) {
            int n;
            Duration duration = other;
            if (duration instanceof Finite) {
                long l;
                Finite finite = Duration$Finite$.MODULE$.unapply((Finite)duration);
                long otherNanos = l = finite._1();
                n = new RichLong(Predef$.MODULE$.longWrapper(this.nanos())).compare((Object)BoxesRunTime.boxToLong((long)otherNanos));
            } else if (Duration$Infinity$.MODULE$.equals(duration)) {
                n = -1;
            } else {
                throw new MatchError((Object)duration);
            }
            return n;
        }

        public final Duration copy(long nanos) {
            return Duration$Finite$.MODULE$.apply(nanos);
        }

        public long copy$default$1() {
            return this.nanos();
        }

        @Override
        public final boolean isZero() {
            return this.nanos() == 0L;
        }

        @Override
        public final long toMillis() {
            return TimeUnit.NANOSECONDS.toMillis(this.nanos());
        }

        @Override
        public final long toNanos() {
            return this.nanos();
        }

        @Override
        public scala.concurrent.duration.Duration asScala() {
            return FiniteDuration$.MODULE$.apply(this.nanos(), TimeUnit.NANOSECONDS);
        }

        @Override
        public java.time.Duration asJava() {
            return java.time.Duration.ofNanos(this.nanos());
        }

        @Override
        public String render() {
            String string;
            long l = this.toMillis();
            if (0L == l) {
                string = "" + this.nanos() + " ns";
            } else {
                long millis = l;
                if (millis < 1000L) {
                    string = "" + millis + " ms";
                } else {
                    long millis2 = l;
                    if (millis2 < 60000L && millis2 % 1000L == 0L) {
                        string = "" + millis2 / 1000L + " s";
                    } else {
                        long millis3 = l;
                        if (millis3 < 60000L) {
                            string = "" + millis3 / 1000L + " s " + millis3 % 1000L + " ms";
                        } else {
                            long millis4 = l;
                            if (millis4 % 60000L / 1000L == 0L) {
                                string = "" + millis4 / 60000L + " m";
                            } else {
                                long millis5 = l;
                                string = "" + millis5 / 60000L + " m " + millis5 % 60000L / 1000L + " s";
                            }
                        }
                    }
                }
            }
            return string;
        }

        public long _1() {
            return this.nanos();
        }
    }
}

