/*
 * Decompiled with CFR 0.152.
 */
package zio.test;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.collection.immutable.List;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import zio.CanFail$;
import zio.IsSubtypeOfError$;
import zio.ZIO;
import zio.ZIO$;
import zio.test.ExecutionEvent;
import zio.test.TestDebugFileLock;

public final class TestDebug$ {
    public static final TestDebug$ MODULE$ = new TestDebug$();
    private static final String outputDirectory = "target/test-reports-zio";

    private String outputDirectory() {
        return outputDirectory;
    }

    private String outputFileForTask(String task) {
        return new StringBuilder(11).append(this.outputDirectory()).append("/").append(task).append("_debug.txt").toString();
    }

    public ZIO<Object, Nothing$, BoxedUnit> createDebugFile(String fullyQualifiedTaskName) {
        return ZIO$.MODULE$.succeed((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            MODULE$.makeOutputDirectory();
            File file = new File(MODULE$.outputFileForTask(fullyQualifiedTaskName));
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
        }, (Object)"zio.test.TestDebug.createDebugFile(TestDebug.scala:12)");
    }

    private Path makeOutputDirectory() {
        return Files.createDirectories(Paths.get(this.outputDirectory(), new String[0]).getParent(), new FileAttribute[0]);
    }

    public ZIO<Object, Nothing$, BoxedUnit> deleteIfEmpty(String fullyQualifiedTaskName) {
        return ZIO$.MODULE$.succeed((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            File file = new File(MODULE$.outputFileForTask(fullyQualifiedTaskName));
            if (file.exists()) {
                BufferedSource source = Source$.MODULE$.fromFile(file, Codec$.MODULE$.fallbackSystemCodec());
                List nonBlankLines = source.getLines().filterNot((Function1 & Serializable)input -> BoxesRunTime.boxToBoolean((boolean)TestDebug$.MODULE$.isBlank(input))).toList();
                source.close();
                if (nonBlankLines.isEmpty()) {
                    file.delete();
                    return;
                }
                return;
            }
        }, (Object)"zio.test.TestDebug.deleteIfEmpty(TestDebug.scala:24)");
    }

    private boolean isBlank(String input) {
        return input.chars().allMatch(x$1 -> Character.isWhitespace(x$1));
    }

    public ZIO<Object, Nothing$, BoxedUnit> print(ExecutionEvent executionEvent, TestDebugFileLock lock) {
        if (executionEvent instanceof ExecutionEvent.TestStarted) {
            ExecutionEvent.TestStarted testStarted = (ExecutionEvent.TestStarted)executionEvent;
            return this.write(testStarted.fullyQualifiedName(), new StringBuilder(9).append(testStarted.labels().mkString(" - ")).append(" STARTED\n").toString(), true, lock);
        }
        if (executionEvent instanceof ExecutionEvent.Test) {
            ExecutionEvent.Test test = (ExecutionEvent.Test)executionEvent;
            return this.removeLine(test.fullyQualifiedName(), new StringBuilder(8).append(test.labels().mkString(" - ")).append(" STARTED").toString(), lock);
        }
        return ZIO$.MODULE$.unit();
    }

    private ZIO<Object, Nothing$, BoxedUnit> write(String fullyQualifiedTaskName, String content, boolean append, TestDebugFileLock lock) {
        return lock.updateFile((ZIO<Object, Nothing$, BoxedUnit>)ZIO.Acquire$.MODULE$.apply$extension(ZIO$.MODULE$.acquireReleaseWith((Function0 & Serializable)() -> ZIO$.MODULE$.attemptBlockingIO((Function0 & Serializable)() -> new FileWriter(MODULE$.outputFileForTask(fullyQualifiedTaskName), append), (Object)"zio.test.TestDebug.write(TestDebug.scala:59)")), (Function1 & Serializable)f -> ZIO$.MODULE$.attemptBlocking((Function0)(JFunction0.mcV.sp & Serializable)() -> f.close(), (Object)"zio.test.TestDebug.write(TestDebug.scala:60)").orDie(IsSubtypeOfError$.MODULE$.impl((.less.colon.less)$less$colon$less$.MODULE$.refl()), CanFail$.MODULE$.canFail(), (Object)"zio.test.TestDebug.write(TestDebug.scala:60)")).apply((Function1 & Serializable)f -> ZIO$.MODULE$.attemptBlockingIO((Function0 & Serializable)() -> f.append(content), (Object)"zio.test.TestDebug.write(TestDebug.scala:61)"), (Object)"zio.test.TestDebug.write(TestDebug.scala:60)").ignore((Object)"zio.test.TestDebug.write(TestDebug.scala:63)"));
    }

    private ZIO<Object, Nothing$, BoxedUnit> removeLine(String fullyQualifiedTaskName, String searchString, TestDebugFileLock lock) {
        return lock.updateFile((ZIO<Object, Nothing$, BoxedUnit>)ZIO$.MODULE$.succeed((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            BufferedSource source = Source$.MODULE$.fromFile(MODULE$.outputFileForTask(fullyQualifiedTaskName), Codec$.MODULE$.fallbackSystemCodec());
            List remainingLines = source.getLines().filterNot((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains(searchString))).toList();
            PrintWriter pw = new PrintWriter(MODULE$.outputFileForTask(fullyQualifiedTaskName));
            pw.write(new StringBuilder(1).append(remainingLines.mkString("\n")).append("\n").toString());
            pw.close();
            source.close();
        }, (Object)"zio.test.TestDebug.removeLine(TestDebug.scala:68)"));
    }

    private TestDebug$() {
    }
}

