/*
 * Decompiled with CFR 0.152.
 */
package zio.test.internal;

import java.io.Serializable;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.Integral;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import zio.test.Arrow;
import zio.test.Arrow$;
import zio.test.ErrorMessage;
import zio.test.ErrorMessage$;
import zio.test.PrettyPrint$;
import zio.test.Result$;
import zio.test.Trace;
import zio.test.Trace$;
import zio.test.Trace$Node$;
import zio.test.diff.Diff;
import zio.test.internal.OptionalImplicit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class SmartAssertions$ {
    public static final SmartAssertions$ MODULE$ = new SmartAssertions$();
    private static final Arrow<Object, Throwable> throws = Arrow$.MODULE$.makeEither((Function1 & Serializable)value -> Trace$.MODULE$.succeed(value), (Function1 & Serializable)x$7 -> Trace$.MODULE$.halt("Expected failure"));

    public <A> Arrow<Option<A>, A> isSome() {
        return Arrow$.MODULE$.make((Function1 & Serializable)x0$1 -> {
            Trace<Object> trace;
            if (x0$1 instanceof Some) {
                Object value = ((Some)x0$1).value();
                trace = Trace$.MODULE$.succeed(value);
            } else if (None$.MODULE$.equals(x0$1)) {
                trace = Trace$.MODULE$.halt("Option was None");
            } else {
                throw new MatchError(x0$1);
            }
            return trace;
        });
    }

    public <A> Arrow<Either<?, A>, A> asRight() {
        return Arrow$.MODULE$.make((Function1 & Serializable)x0$1 -> {
            Trace<Object> trace;
            if (x0$1 instanceof Right) {
                Object value = ((Right)x0$1).value();
                trace = Trace$.MODULE$.succeed(value);
            } else if (x0$1 instanceof Left) {
                trace = Trace$.MODULE$.halt("Either was Left");
            } else {
                throw new MatchError(x0$1);
            }
            return trace;
        });
    }

    public <A> Arrow<Either<A, ?>, A> asLeft() {
        return Arrow$.MODULE$.make((Function1 & Serializable)x0$1 -> {
            Trace<Object> trace;
            if (x0$1 instanceof Left) {
                Object value = ((Left)x0$1).value();
                trace = Trace$.MODULE$.succeed(value);
            } else if (x0$1 instanceof Right) {
                trace = Trace$.MODULE$.halt("Either was Right");
            } else {
                throw new MatchError(x0$1);
            }
            return trace;
        });
    }

    public <A> Arrow<Iterable<A>, Object> isEmptyIterable() {
        return Arrow$.MODULE$.make((Function1 & Serializable)as -> Trace$.MODULE$.boolean(as.isEmpty(), MODULE$.className((Iterable)as).$plus(ErrorMessage$.MODULE$.was()).$plus("empty").$plus(ErrorMessage$.MODULE$.text(new StringBuilder(7).append("(size ").append(as.size()).append(")").toString()))));
    }

    public <A> Arrow<Iterable<A>, Object> isNonEmptyIterable() {
        return Arrow$.MODULE$.make((Function1 & Serializable)as -> Trace$.MODULE$.boolean(as.nonEmpty(), MODULE$.className((Iterable)as).$plus(ErrorMessage$.MODULE$.choice("was not", "was")).$plus("empty")));
    }

    public <A> Arrow<Option<A>, Object> isEmptyOption() {
        return Arrow$.MODULE$.make((Function1 & Serializable)option -> Trace$.MODULE$.boolean(option.isEmpty(), MODULE$.className((Option)option).$plus(ErrorMessage$.MODULE$.was()).$plus("empty")));
    }

    public <A> Arrow<Option<A>, Object> isDefinedOption() {
        return Arrow$.MODULE$.make((Function1 & Serializable)option -> Trace$.MODULE$.boolean(option.isDefined(), MODULE$.className((Option)option).$plus(ErrorMessage$.MODULE$.was()).$plus("defined")));
    }

    public <A> Arrow<Iterable<A>, Object> forallIterable(Arrow<A, Object> predicate) {
        return Arrow$.MODULE$.make((Function1 & Serializable)seq -> {
            Iterable failures = (Iterable)((Iterable)seq.map((Function1 & Serializable)a -> Arrow$.MODULE$.run(predicate, package$.MODULE$.Right().apply(a)))).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isFailure()));
            String elements = failures.size() == 1 ? "element" : "elements";
            return new Trace.Node<Boolean>(Result$.MODULE$.succeed(BoxesRunTime.boxToBoolean((boolean)failures.isEmpty())), ErrorMessage$.MODULE$.value(BoxesRunTime.boxToInteger((int)failures.size())).$plus(ErrorMessage$.MODULE$.choice(new StringBuilder(21).append(elements).append(" failed the predicate").toString(), new StringBuilder(21).append(elements).append(" failed the predicate").toString())), (Option<Trace<Object>>)(failures.isEmpty() ? None$.MODULE$ : new Some(failures.reduce((Function2 & Serializable)(x$2, x$3) -> x$2.$amp$amp((Trace<Object>)x$3, $less$colon$less$.MODULE$.refl())))), Trace$Node$.MODULE$.apply$default$4(), Trace$Node$.MODULE$.apply$default$5(), Trace$Node$.MODULE$.apply$default$6(), Trace$Node$.MODULE$.apply$default$7(), Trace$Node$.MODULE$.apply$default$8());
        });
    }

    public <A> Arrow<Iterable<A>, Object> existsIterable(Arrow<A, Object> predicate) {
        return Arrow$.MODULE$.make((Function1 & Serializable)seq -> {
            Iterable successes = (Iterable)((Iterable)seq.map((Function1 & Serializable)a -> Arrow$.MODULE$.run(predicate, package$.MODULE$.Right().apply(a)))).filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isSuccess()));
            String elements = successes.size() == 1 ? "element" : "elements";
            return new Trace.Node<Boolean>(Result$.MODULE$.succeed(BoxesRunTime.boxToBoolean((boolean)successes.nonEmpty())), ErrorMessage$.MODULE$.value(BoxesRunTime.boxToInteger((int)successes.size())).$plus(ErrorMessage$.MODULE$.choice(new StringBuilder(24).append(elements).append(" satisfied the predicate").toString(), new StringBuilder(24).append(elements).append(" satisfied the predicate").toString())), (Option<Trace<Object>>)(successes.isEmpty() ? None$.MODULE$ : new Some(successes.reduce((Function2 & Serializable)(x$5, x$6) -> x$5.$amp$amp((Trace<Object>)x$6, $less$colon$less$.MODULE$.refl())))), Trace$Node$.MODULE$.apply$default$4(), Trace$Node$.MODULE$.apply$default$5(), Trace$Node$.MODULE$.apply$default$6(), Trace$Node$.MODULE$.apply$default$7(), Trace$Node$.MODULE$.apply$default$8());
        });
    }

    public <A> Arrow<Seq<A>, Object> containsSeq(A value) {
        return Arrow$.MODULE$.make((Function1 & Serializable)seq -> Trace$.MODULE$.boolean(seq.contains(value), MODULE$.className((Iterable)seq).$plus(ErrorMessage$.MODULE$.did()).$plus("contain").$plus(ErrorMessage$.MODULE$.value(value))));
    }

    public <A> Arrow<Option<A>, Object> containsOption(A value) {
        return Arrow$.MODULE$.make((Function1 & Serializable)option -> Trace$.MODULE$.boolean(option.contains(value), MODULE$.className((Option)option).$plus(ErrorMessage$.MODULE$.did()).$plus("contain").$plus(ErrorMessage$.MODULE$.value(value))));
    }

    public Arrow<String, Object> containsString(String value) {
        return Arrow$.MODULE$.make((Function1 & Serializable)str -> Trace$.MODULE$.boolean(str.contains(value), ErrorMessage$.MODULE$.value(str).$plus(ErrorMessage$.MODULE$.did()).$plus("contain").$plus(ErrorMessage$.MODULE$.value(value))));
    }

    public <A> Arrow<Seq<A>, A> hasAt(int index) {
        return Arrow$.MODULE$.make((Function1 & Serializable)as -> {
            Trace<Object> trace;
            Option option = Try$.MODULE$.apply((Function0 & Serializable)() -> as.apply(index)).toOption();
            if (option instanceof Some) {
                Object value = ((Some)option).value();
                trace = Trace$.MODULE$.succeed(value);
            } else if (None$.MODULE$.equals(option)) {
                trace = Trace$.MODULE$.halt(ErrorMessage$.MODULE$.text("Invalid index").$plus(ErrorMessage$.MODULE$.value(BoxesRunTime.boxToInteger((int)index))).$plus("for").$plus(MODULE$.className((Iterable)as)).$plus("of size").$plus(ErrorMessage$.MODULE$.value(BoxesRunTime.boxToInteger((int)as.length()))));
            } else {
                throw new MatchError((Object)option);
            }
            return trace;
        });
    }

    public <K, V> Arrow<Map<K, V>, V> hasKey(K key) {
        return Arrow$.MODULE$.make((Function1 & Serializable)mapKV -> {
            Trace<Object> trace;
            Option option = Try$.MODULE$.apply((Function0 & Serializable)() -> mapKV.apply(key)).toOption();
            if (option instanceof Some) {
                Object value = ((Some)option).value();
                trace = Trace$.MODULE$.succeed(value);
            } else if (None$.MODULE$.equals(option)) {
                trace = Trace$.MODULE$.halt(ErrorMessage$.MODULE$.text("Missing key").$plus(ErrorMessage$.MODULE$.value(key)));
            } else {
                throw new MatchError((Object)option);
            }
            return trace;
        });
    }

    public <A> Arrow<Iterable<A>, A> head() {
        return Arrow$.MODULE$.make((Function1 & Serializable)as -> {
            Trace<Object> trace;
            Option option = as.headOption();
            if (option instanceof Some) {
                Object value = ((Some)option).value();
                trace = Trace$.MODULE$.succeed(value);
            } else if (None$.MODULE$.equals(option)) {
                trace = Trace$.MODULE$.halt(MODULE$.className((Iterable)as).$plus("was empty"));
            } else {
                throw new MatchError((Object)option);
            }
            return trace;
        });
    }

    public <A> Arrow<A, Object> isEven(Integral<A> integral) {
        return Arrow$.MODULE$.make((Function1 & Serializable)a -> Trace$.MODULE$.boolean(BoxesRunTime.equals((Object)integral.rem(a, integral.fromInt(2)), (Object)integral.fromInt(0)), ErrorMessage$.MODULE$.value(a).$plus(ErrorMessage$.MODULE$.was()).$plus("even")));
    }

    public <A> Arrow<A, Object> isOdd(Integral<A> integral) {
        return Arrow$.MODULE$.make((Function1 & Serializable)a -> Trace$.MODULE$.boolean(BoxesRunTime.equals((Object)integral.rem(a, integral.fromInt(2)), (Object)integral.fromInt(1)), ErrorMessage$.MODULE$.value(a).$plus(ErrorMessage$.MODULE$.was()).$plus("odd")));
    }

    public <A> Arrow<A, Object> greaterThan(A that, Ordering<A> ordering) {
        return Arrow$.MODULE$.make((Function1 & Serializable)a -> Trace$.MODULE$.boolean(ordering.gt(a, that), ErrorMessage$.MODULE$.value(a).$plus(ErrorMessage$.MODULE$.was()).$plus("greater than").$plus(ErrorMessage$.MODULE$.value(that))));
    }

    public <A> Arrow<A, Object> greaterThanOrEqualTo(A that, Ordering<A> ordering) {
        return Arrow$.MODULE$.make((Function1 & Serializable)a -> Trace$.MODULE$.boolean(ordering.gteq(a, that), ErrorMessage$.MODULE$.value(a).$plus(ErrorMessage$.MODULE$.was()).$plus(new StringBuilder(25).append("greater than or equal to ").append(that).toString())));
    }

    public <A> Arrow<A, Object> lessThan(A that, Ordering<A> ordering) {
        return Arrow$.MODULE$.make((Function1 & Serializable)a -> Trace$.MODULE$.boolean(ordering.lt(a, that), ErrorMessage$.MODULE$.value(a).$plus(ErrorMessage$.MODULE$.was()).$plus("less than").$plus(ErrorMessage$.MODULE$.value(that))));
    }

    public <A> Arrow<A, Object> lessThanOrEqualTo(A that, Ordering<A> ordering) {
        return Arrow$.MODULE$.make((Function1 & Serializable)a -> Trace$.MODULE$.boolean(ordering.lteq(a, that), ErrorMessage$.MODULE$.value(a).$plus(ErrorMessage$.MODULE$.was()).$plus("less than or equal to").$plus(ErrorMessage$.MODULE$.value(that))));
    }

    public <A> Arrow<A, Object> equalTo(A that, OptionalImplicit<Diff<A>> diff) {
        return Arrow$.MODULE$.make((Function1 & Serializable)a -> {
            Diff diff;
            boolean bl = ScalaRunTime$.MODULE$.isArray(a, 1) && ScalaRunTime$.MODULE$.isArray(that, 1) ? Predef$.MODULE$.genericWrapArray(a).sameElements((IterableOnce)Predef$.MODULE$.genericWrapArray(that)) : BoxesRunTime.equals((Object)a, (Object)that);
            Option option = diff.value();
            ErrorMessage errorMessage = option instanceof Some && !(diff = (Diff)((Some)option).value()).isLowPriority() && !bl ? ErrorMessage$.MODULE$.text("Expected:").$plus("\n").$plus$div(ErrorMessage$.MODULE$.value(PrettyPrint$.MODULE$.apply(that))).$plus("\n").$plus$div(ErrorMessage$.MODULE$.text("Diff:")).$plus("\n").$plus$div(ErrorMessage$.MODULE$.text(diff.diff(that, a).render())) : ErrorMessage$.MODULE$.value(a).$plus(ErrorMessage$.MODULE$.equals()).$plus(ErrorMessage$.MODULE$.value(that));
            return Trace$.MODULE$.boolean(bl, errorMessage);
        });
    }

    public Arrow<Object, Throwable> throws() {
        return throws;
    }

    public <A, B> Arrow<A, B> as(ClassTag<B> CB) {
        return Arrow$.MODULE$.make((Function1 & Serializable)a -> {
            Trace<Object> trace;
            Option option = CB.unapply(a);
            if (option instanceof Some) {
                Object value = ((Some)option).value();
                trace = Trace$.MODULE$.succeed(value);
            } else if (None$.MODULE$.equals(option)) {
                trace = Trace$.MODULE$.halt(ErrorMessage$.MODULE$.value(a.getClass().getSimpleName()).$plus("is not an instance of").$plus(ErrorMessage$.MODULE$.value(MODULE$.className(CB))));
            } else {
                throw new MatchError((Object)option);
            }
            return trace;
        });
    }

    public <A, B> Arrow<A, Object> is(ClassTag<B> CB) {
        return Arrow$.MODULE$.make((Function1 & Serializable)a -> Trace$.MODULE$.boolean(CB.unapply(a).isDefined(), ErrorMessage$.MODULE$.value(a.getClass().getSimpleName()).$plus(ErrorMessage$.MODULE$.is()).$plus("an instance of").$plus(ErrorMessage$.MODULE$.value(MODULE$.className(CB)))));
    }

    private <A> String className(ClassTag<A> C) {
        try {
            return C.runtimeClass().getSimpleName();
        }
        catch (Throwable throwable) {
            block5: {
                block4: {
                    if (!(throwable instanceof InternalError)) break block4;
                    String string = ((InternalError)throwable).getMessage();
                    String string2 = "Malformed class name";
                    if (string != null && string.equals(string2)) break block5;
                }
                throw throwable;
            }
            String string = C.runtimeClass().getName();
            return string;
        }
    }

    private <A> ErrorMessage className(Iterable<A> a) {
        return ErrorMessage$.MODULE$.value(StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(a.toString()), (Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)SmartAssertions$.$anonfun$className$1(BoxesRunTime.unboxToChar((Object)x$8)))));
    }

    private <A> ErrorMessage className(Option<A> a) {
        return ErrorMessage$.MODULE$.value(StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(a.toString()), (Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)SmartAssertions$.$anonfun$className$2(BoxesRunTime.unboxToChar((Object)x$9)))));
    }

    public static final /* synthetic */ boolean $anonfun$className$1(char x$8) {
        return x$8 != '(';
    }

    public static final /* synthetic */ boolean $anonfun$className$2(char x$9) {
        return x$9 != '(';
    }

    private SmartAssertions$() {
    }
}

