/*
 * Decompiled with CFR 0.152.
 */
package zio.test;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.function.IntPredicate;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import zio.CanFail$;
import zio.IsSubtypeOfError$;
import zio.ZIO;
import zio.ZIO$;
import zio.test.ExecutionEvent;
import zio.test.TestDebug$;
import zio.test.TestDebugFileLock;

public final class TestDebug$ {
    public static final TestDebug$ MODULE$;
    private final String outputDirectory;

    static {
        new TestDebug$();
    }

    private String outputDirectory() {
        return this.outputDirectory;
    }

    public String zio$test$TestDebug$$outputFileForTask(String task) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "_debug.txt"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.outputDirectory(), task}));
    }

    public ZIO<Object, Nothing$, BoxedUnit> createDebugFile(String fullyQualifiedTaskName) {
        return ZIO$.MODULE$.succeed((Function0)new Serializable(fullyQualifiedTaskName){
            public static final long serialVersionUID = 0L;
            private final String fullyQualifiedTaskName$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TestDebug$.MODULE$.zio$test$TestDebug$$makeOutputDirectory();
                File file = new File(TestDebug$.MODULE$.zio$test$TestDebug$$outputFileForTask(this.fullyQualifiedTaskName$1));
                Object object = file.exists() ? BoxesRunTime.boxToBoolean((boolean)file.delete()) : BoxedUnit.UNIT;
                file.createNewFile();
            }
            {
                this.fullyQualifiedTaskName$1 = fullyQualifiedTaskName$1;
            }
        }, (Object)"zio.test.TestDebug.createDebugFile(TestDebug.scala:12)");
    }

    public Path zio$test$TestDebug$$makeOutputDirectory() {
        Path fp = Paths.get(this.outputDirectory(), new String[0]);
        return Files.createDirectories(fp.getParent(), new FileAttribute[0]);
    }

    public ZIO<Object, Nothing$, BoxedUnit> deleteIfEmpty(String fullyQualifiedTaskName) {
        return ZIO$.MODULE$.succeed((Function0)new Serializable(fullyQualifiedTaskName){
            public static final long serialVersionUID = 0L;
            private final String fullyQualifiedTaskName$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                File file = new File(TestDebug$.MODULE$.zio$test$TestDebug$$outputFileForTask(this.fullyQualifiedTaskName$2));
                if (file.exists()) {
                    BufferedSource source = Source$.MODULE$.fromFile(file, Codec$.MODULE$.fallbackSystemCodec());
                    List nonBlankLines = source.getLines().filterNot((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(String input) {
                            return TestDebug$.MODULE$.zio$test$TestDebug$$isBlank(input);
                        }
                    }).toList();
                    source.close();
                    if (nonBlankLines.isEmpty()) {
                        file.delete();
                    }
                }
            }
            {
                this.fullyQualifiedTaskName$2 = fullyQualifiedTaskName$2;
            }
        }, (Object)"zio.test.TestDebug.deleteIfEmpty(TestDebug.scala:24)");
    }

    public boolean zio$test$TestDebug$$isBlank(String input) {
        return input.chars().allMatch(new IntPredicate(){
            public static final long serialVersionUID = 0L;

            public final boolean test(int x$1) {
                return TestDebug$.MODULE$.zio$test$TestDebug$$test$body$1(x$1);
            }
        });
    }

    public ZIO<Object, Nothing$, BoxedUnit> print(ExecutionEvent executionEvent, TestDebugFileLock lock) {
        ZIO<Object, Nothing$, BoxedUnit> zIO;
        ExecutionEvent executionEvent2 = executionEvent;
        if (executionEvent2 instanceof ExecutionEvent.TestStarted) {
            ExecutionEvent.TestStarted testStarted = (ExecutionEvent.TestStarted)executionEvent2;
            zIO = this.write(testStarted.fullyQualifiedName(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " STARTED\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{testStarted.labels().mkString(" - ")})), true, lock);
        } else if (executionEvent2 instanceof ExecutionEvent.Test) {
            ExecutionEvent.Test test = (ExecutionEvent.Test)executionEvent2;
            zIO = this.removeLine(test.fullyQualifiedName(), new StringBuilder().append((Object)test.labels().mkString(" - ")).append((Object)" STARTED").toString(), lock);
        } else {
            zIO = ZIO$.MODULE$.unit();
        }
        return zIO;
    }

    private ZIO<Object, Nothing$, BoxedUnit> write(String fullyQualifiedTaskName, String content, boolean append, TestDebugFileLock lock) {
        return lock.updateFile((ZIO<Object, Nothing$, BoxedUnit>)ZIO.Acquire$.MODULE$.apply$extension(ZIO$.MODULE$.acquireReleaseWith((Function0)new Serializable(fullyQualifiedTaskName, append){
            public static final long serialVersionUID = 0L;
            public final String fullyQualifiedTaskName$3;
            public final boolean append$1;

            public final ZIO<Object, IOException, FileWriter> apply() {
                return ZIO$.MODULE$.attemptBlockingIO((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.write.1 $outer;

                    public final FileWriter apply() {
                        return new FileWriter(TestDebug$.MODULE$.zio$test$TestDebug$$outputFileForTask(this.$outer.fullyQualifiedTaskName$3), this.$outer.append$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, (Object)"zio.test.TestDebug.write(TestDebug.scala:59)");
            }
            {
                this.fullyQualifiedTaskName$3 = fullyQualifiedTaskName$3;
                this.append$1 = append$1;
            }
        }), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ZIO<Object, Nothing$, BoxedUnit> apply(FileWriter f) {
                return ZIO$.MODULE$.attemptBlocking((Function0)new Serializable(this, f){
                    public static final long serialVersionUID = 0L;
                    private final FileWriter f$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.f$1.close();
                    }
                    {
                        this.f$1 = f$1;
                    }
                }, (Object)"zio.test.TestDebug.write(TestDebug.scala:60)").orDie(IsSubtypeOfError$.MODULE$.impl(Predef$.MODULE$.$conforms()), CanFail$.MODULE$.canFail(), (Object)"zio.test.TestDebug.write(TestDebug.scala:60)");
            }
        }).apply((Function1)new Serializable(content){
            public static final long serialVersionUID = 0L;
            public final String content$1;

            public final ZIO<Object, IOException, Writer> apply(FileWriter f) {
                return ZIO$.MODULE$.attemptBlockingIO((Function0)new Serializable(this, f){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.write.3 $outer;
                    private final FileWriter f$2;

                    public final Writer apply() {
                        return this.f$2.append(this.$outer.content$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.f$2 = f$2;
                    }
                }, (Object)"zio.test.TestDebug.write(TestDebug.scala:61)");
            }
            {
                this.content$1 = content$1;
            }
        }, (Object)"zio.test.TestDebug.write(TestDebug.scala:60)").ignore((Object)"zio.test.TestDebug.write(TestDebug.scala:63)"));
    }

    private ZIO<Object, Nothing$, BoxedUnit> removeLine(String fullyQualifiedTaskName, String searchString, TestDebugFileLock lock) {
        return lock.updateFile((ZIO<Object, Nothing$, BoxedUnit>)ZIO$.MODULE$.succeed((Function0)new Serializable(fullyQualifiedTaskName, searchString){
            public static final long serialVersionUID = 0L;
            private final String fullyQualifiedTaskName$4;
            public final String searchString$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                BufferedSource source = Source$.MODULE$.fromFile(TestDebug$.MODULE$.zio$test$TestDebug$$outputFileForTask(this.fullyQualifiedTaskName$4), Codec$.MODULE$.fallbackSystemCodec());
                List remainingLines = source.getLines().filterNot((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.removeLine.1 $outer;

                    public final boolean apply(String x$2) {
                        return x$2.contains(this.$outer.searchString$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).toList();
                PrintWriter pw = new PrintWriter(TestDebug$.MODULE$.zio$test$TestDebug$$outputFileForTask(this.fullyQualifiedTaskName$4));
                pw.write(new StringBuilder().append((Object)remainingLines.mkString("\n")).append((Object)"\n").toString());
                pw.close();
                source.close();
            }
            {
                this.fullyQualifiedTaskName$4 = fullyQualifiedTaskName$4;
                this.searchString$1 = searchString$1;
            }
        }, (Object)"zio.test.TestDebug.removeLine(TestDebug.scala:68)"));
    }

    public final boolean zio$test$TestDebug$$test$body$1(int x$1) {
        return Character.isWhitespace(x$1);
    }

    private TestDebug$() {
        MODULE$ = this;
        this.outputDirectory = "target/test-reports-zio";
    }
}

