/*
 * Decompiled with CFR 0.152.
 */
package zio.test.internal;

import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenSeq;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.IterableView$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Integral;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import zio.Cause;
import zio.Exit;
import zio.internal.ansi;
import zio.internal.ansi$;
import zio.test.ConsoleUtils$;
import zio.test.CustomAssertion;
import zio.test.ErrorMessage;
import zio.test.ErrorMessage$;
import zio.test.PrettyPrint$;
import zio.test.Result$;
import zio.test.TestArrow;
import zio.test.TestArrow$;
import zio.test.TestTrace;
import zio.test.TestTrace$;
import zio.test.TestTrace$Node$;
import zio.test.diff.Diff;
import zio.test.diff.DiffResult;
import zio.test.internal.OptionalImplicit;
import zio.test.internal.SmartAssertions$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class SmartAssertions$ {
    public static final SmartAssertions$ MODULE$;
    private final TestArrow<Object, Object> anything;
    private final TestArrow<Object, Throwable> throws;

    static {
        new SmartAssertions$();
    }

    public TestArrow<Object, Object> anything() {
        return this.anything;
    }

    public <A> TestArrow<A, Object> approximatelyEquals(A reference, A tolerance, Numeric<A> evidence$1) {
        return TestArrow$.MODULE$.make(new Serializable(reference, tolerance, evidence$1){
            public static final long serialVersionUID = 0L;
            private final Object reference$1;
            private final Object tolerance$1;
            private final Numeric evidence$1$1;

            public final TestTrace<Object> apply(A actual) {
                Numeric referenceType = (Numeric)Predef$.MODULE$.implicitly((Object)this.evidence$1$1);
                Object max = referenceType.plus(this.reference$1, this.tolerance$1);
                Object min = referenceType.minus(this.reference$1, this.tolerance$1);
                boolean result2 = referenceType.gteq(actual, min) && referenceType.lteq(actual, max);
                return TestTrace$.MODULE$.boolean(result2, ErrorMessage$.MODULE$.pretty(actual).$plus(ErrorMessage$.MODULE$.did()).$plus("approximately equal").$plus(ErrorMessage$.MODULE$.pretty(this.reference$1)).$plus("with a tolerance of").$plus(ErrorMessage$.MODULE$.pretty(this.tolerance$1)));
            }
            {
                this.reference$1 = reference$1;
                this.tolerance$1 = tolerance$1;
                this.evidence$1$1 = evidence$1$1;
            }
        });
    }

    public <A, B> TestArrow<A, B> custom(CustomAssertion<A, B> customAssertion) {
        return TestArrow$.MODULE$.make(new Serializable(customAssertion){
            public static final long serialVersionUID = 0L;
            private final CustomAssertion customAssertion$1;

            public final TestTrace<B> apply(A a) {
                Either either2;
                block4: {
                    TestTrace<Object> testTrace;
                    block3: {
                        block2: {
                            either2 = (Either)this.customAssertion$1.run().apply(a);
                            if (!(either2 instanceof Left)) break block2;
                            Left left = (Left)either2;
                            String error = (String)left.a();
                            testTrace = TestTrace$.MODULE$.fail(error);
                            break block3;
                        }
                        if (!(either2 instanceof Right)) break block4;
                        Right right = (Right)either2;
                        Object value = right.b();
                        testTrace = TestTrace$.MODULE$.succeed(value);
                    }
                    return testTrace;
                }
                throw new MatchError((Object)either2);
            }
            {
                this.customAssertion$1 = customAssertion$1;
            }
        });
    }

    public <A> TestArrow<Option<A>, A> isSome() {
        return TestArrow$.MODULE$.make(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TestTrace<A> apply(Option<A> x0$1) {
                Option<A> option2;
                block4: {
                    TestTrace<Object> testTrace;
                    block3: {
                        block2: {
                            option2 = x0$1;
                            if (!(option2 instanceof Some)) break block2;
                            Some some2 = (Some)option2;
                            Object value = some2.x();
                            testTrace = TestTrace$.MODULE$.succeed(value);
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option2)) break block4;
                        testTrace = TestTrace$.MODULE$.fail("Option was None");
                    }
                    return testTrace;
                }
                throw new MatchError(option2);
            }
        });
    }

    public <A> TestArrow<Either<?, A>, A> asRight() {
        return TestArrow$.MODULE$.make(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TestTrace<A> apply(Either<?, A> x0$2) {
                Either<?, A> either2;
                block4: {
                    TestTrace<Object> testTrace;
                    block3: {
                        block2: {
                            either2 = x0$2;
                            if (!(either2 instanceof Right)) break block2;
                            Right right = (Right)either2;
                            Object value = right.b();
                            testTrace = TestTrace$.MODULE$.succeed(value);
                            break block3;
                        }
                        if (!(either2 instanceof Left)) break block4;
                        testTrace = TestTrace$.MODULE$.fail("Either was Left");
                    }
                    return testTrace;
                }
                throw new MatchError(either2);
            }
        });
    }

    public <A> TestArrow<Either<A, ?>, A> asLeft() {
        return TestArrow$.MODULE$.make(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TestTrace<A> apply(Either<A, ?> x0$3) {
                Either<A, ?> either2;
                block4: {
                    TestTrace<Object> testTrace;
                    block3: {
                        block2: {
                            either2 = x0$3;
                            if (!(either2 instanceof Left)) break block2;
                            Left left = (Left)either2;
                            Object value = left.a();
                            testTrace = TestTrace$.MODULE$.succeed(value);
                            break block3;
                        }
                        if (!(either2 instanceof Right)) break block4;
                        testTrace = TestTrace$.MODULE$.fail("Either was Right");
                    }
                    return testTrace;
                }
                throw new MatchError(either2);
            }
        });
    }

    public <A> TestArrow<Iterable<A>, Object> isEmptyIterable() {
        return TestArrow$.MODULE$.make(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TestTrace<Object> apply(Iterable<A> as2) {
                return TestTrace$.MODULE$.boolean(as2.isEmpty(), SmartAssertions$.MODULE$.zio$test$internal$SmartAssertions$$className(as2).$plus(ErrorMessage$.MODULE$.was()).$plus("empty").$plus(ErrorMessage$.MODULE$.text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(size ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)as2.size())})))));
            }
        });
    }

    public TestArrow<String, Object> isEmptyString() {
        return TestArrow$.MODULE$.make(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TestTrace<Object> apply(String string2) {
                return TestTrace$.MODULE$.boolean(string2.isEmpty(), ErrorMessage$.MODULE$.pretty(string2).$plus(ErrorMessage$.MODULE$.was()).$plus("empty").$plus(ErrorMessage$.MODULE$.text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(length ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)string2.length())})))));
            }
        });
    }

    public TestArrow<Iterable<Object>, Object> isNonEmptyIterable() {
        return TestArrow$.MODULE$.make(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TestTrace<Object> apply(Iterable<Object> as2) {
                return TestTrace$.MODULE$.boolean(as2.nonEmpty(), SmartAssertions$.MODULE$.zio$test$internal$SmartAssertions$$className(as2).$plus(ErrorMessage$.MODULE$.choice("was not", "was")).$plus("empty"));
            }
        });
    }

    public TestArrow<String, Object> isNonEmptyString() {
        return TestArrow$.MODULE$.make(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TestTrace<Object> apply(String string2) {
                return TestTrace$.MODULE$.boolean(new StringOps(Predef$.MODULE$.augmentString(string2)).nonEmpty(), ErrorMessage$.MODULE$.pretty(string2).$plus(ErrorMessage$.MODULE$.choice("was not", "was")).$plus("empty"));
            }
        });
    }

    public TestArrow<Option<Object>, Object> isEmptyOption() {
        return TestArrow$.MODULE$.make(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TestTrace<Object> apply(Option<Object> option2) {
                return TestTrace$.MODULE$.boolean(option2.isEmpty(), SmartAssertions$.MODULE$.zio$test$internal$SmartAssertions$$className(option2).$plus(ErrorMessage$.MODULE$.was()).$plus("empty"));
            }
        });
    }

    public TestArrow<Option<Object>, Object> isDefinedOption() {
        return TestArrow$.MODULE$.make(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TestTrace<Object> apply(Option<Object> option2) {
                return TestTrace$.MODULE$.boolean(option2.isDefined(), SmartAssertions$.MODULE$.zio$test$internal$SmartAssertions$$className(option2).$plus(ErrorMessage$.MODULE$.was()).$plus("defined"));
            }
        });
    }

    public <A> TestArrow<Iterable<A>, Object> forallIterable(TestArrow<A, Object> predicate) {
        return TestArrow$.MODULE$.make(new Serializable(predicate){
            public static final long serialVersionUID = 0L;
            public final TestArrow predicate$2;

            public final TestTrace.Node<Object> apply(Iterable<A> seq) {
                Iterable results = (Iterable)seq.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.forallIterable.1 $outer;

                    public final TestTrace<Object> apply(A a) {
                        return TestArrow$.MODULE$.run(this.$outer.predicate$2, package$.MODULE$.Right().apply(a));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Iterable$.MODULE$.canBuildFrom());
                Iterable failures2 = (Iterable)results.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(TestTrace<Object> x$2) {
                        return x$2.isFailure((Predef.$less$colon$less<Object, Object>)Predef$.MODULE$.$conforms());
                    }
                });
                String elements = failures2.size() == 1 ? "element" : "elements";
                return new TestTrace.Node<Object>(Result$.MODULE$.succeed(BoxesRunTime.boxToBoolean((boolean)failures2.isEmpty())), ErrorMessage$.MODULE$.pretty(BoxesRunTime.boxToInteger((int)failures2.size())).$plus(ErrorMessage$.MODULE$.text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " failed the predicate"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{elements})))), (Option<TestTrace<Object>>)(failures2.isEmpty() ? None$.MODULE$ : new Some(failures2.reduce((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final TestTrace<Object> apply(TestTrace<Object> x$3, TestTrace<Object> x$4) {
                        return x$3.$amp$amp(x$4, (Predef.$less$colon$less<Object, Object>)Predef$.MODULE$.$conforms());
                    }
                }))), TestTrace$Node$.MODULE$.apply$default$4(), TestTrace$Node$.MODULE$.apply$default$5(), TestTrace$Node$.MODULE$.apply$default$6(), TestTrace$Node$.MODULE$.apply$default$7(), TestTrace$Node$.MODULE$.apply$default$8(), TestTrace$Node$.MODULE$.apply$default$9(), TestTrace$Node$.MODULE$.apply$default$10(), TestTrace$Node$.MODULE$.apply$default$11());
            }
            {
                this.predicate$2 = predicate$2;
            }
        });
    }

    public <A> TestArrow<Iterable<A>, Object> existsIterable(TestArrow<A, Object> predicate) {
        return TestArrow$.MODULE$.make(new Serializable(predicate){
            public static final long serialVersionUID = 0L;
            public final TestArrow predicate$1;

            public final TestTrace.Node<Object> apply(Iterable<A> seq) {
                Option result2 = ((IterableLike)seq.view().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.existsIterable.1 $outer;

                    public final TestTrace<Object> apply(A a) {
                        return TestArrow$.MODULE$.run(this.$outer.predicate$1, package$.MODULE$.Right().apply(a));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, IterableView$.MODULE$.canBuildFrom())).find((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(TestTrace<Object> tt) {
                        return tt.isSuccess((Predef.$less$colon$less<Object, Object>)Predef$.MODULE$.$conforms()) || tt.isDie();
                    }
                });
                Option success = result2.filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(TestTrace<Object> x$5) {
                        return x$5.isSuccess((Predef.$less$colon$less<Object, Object>)Predef$.MODULE$.$conforms());
                    }
                });
                String elements = success.nonEmpty() ? "element" : "elements";
                ErrorMessage elementsSatisfiedPredicateMsg = result2.exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(TestTrace<Object> x$6) {
                        return x$6.isDie();
                    }
                }) ? ErrorMessage$.MODULE$.text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " satisfied the predicate before it threw an exception"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{elements}))) : ErrorMessage$.MODULE$.text(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " satisfied the predicate"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{elements})));
                return new TestTrace.Node<Object>(Result$.MODULE$.succeed(BoxesRunTime.boxToBoolean((boolean)success.nonEmpty())), ErrorMessage$.MODULE$.pretty(BoxesRunTime.boxToInteger((int)Option$.MODULE$.option2Iterable(success).size())).$plus(elementsSatisfiedPredicateMsg), (Option<TestTrace<Object>>)result2, TestTrace$Node$.MODULE$.apply$default$4(), TestTrace$Node$.MODULE$.apply$default$5(), TestTrace$Node$.MODULE$.apply$default$6(), TestTrace$Node$.MODULE$.apply$default$7(), TestTrace$Node$.MODULE$.apply$default$8(), TestTrace$Node$.MODULE$.apply$default$9(), TestTrace$Node$.MODULE$.apply$default$10(), TestTrace$Node$.MODULE$.apply$default$11());
            }
            {
                this.predicate$1 = predicate$1;
            }
        });
    }

    public <A> TestArrow<Seq<A>, Object> containsSeq(A value) {
        return TestArrow$.MODULE$.make(new Serializable(value){
            public static final long serialVersionUID = 0L;
            private final Object value$3;

            public final TestTrace<Object> apply(Seq<A> seq) {
                return TestTrace$.MODULE$.boolean(seq.contains(this.value$3), SmartAssertions$.MODULE$.zio$test$internal$SmartAssertions$$className(seq).$plus(ErrorMessage$.MODULE$.did()).$plus("contain").$plus(ErrorMessage$.MODULE$.pretty(this.value$3)));
            }
            {
                this.value$3 = value$3;
            }
        });
    }

    public <A> TestArrow<Iterable<A>, Object> containsIterable(A value) {
        return TestArrow$.MODULE$.make(new Serializable(value){
            public static final long serialVersionUID = 0L;
            public final Object value$1;

            public final TestTrace<Object> apply(Iterable<A> seq) {
                return TestTrace$.MODULE$.boolean(seq.exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.containsIterable.1 $outer;

                    public final boolean apply(A x$7) {
                        return BoxesRunTime.equals(x$7, (Object)this.$outer.value$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }), SmartAssertions$.MODULE$.zio$test$internal$SmartAssertions$$className(seq).$plus(ErrorMessage$.MODULE$.did()).$plus("contain").$plus(ErrorMessage$.MODULE$.pretty(this.value$1)));
            }
            {
                this.value$1 = value$1;
            }
        });
    }

    public <E> TestArrow<Cause<E>, Object> containsCause(Cause<E> expected) {
        return TestArrow$.MODULE$.make(new Serializable(expected){
            public static final long serialVersionUID = 0L;
            private final Cause expected$1;

            public final TestTrace<Object> apply(Cause<E> cause) {
                return TestTrace$.MODULE$.boolean(cause.contains(this.expected$1), ErrorMessage$.MODULE$.pretty(cause).$plus(ErrorMessage$.MODULE$.did()).$plus("contain").$plus(ErrorMessage$.MODULE$.pretty(this.expected$1)));
            }
            {
                this.expected$1 = expected$1;
            }
        });
    }

    public <A> TestArrow<Option<A>, Object> containsOption(A value) {
        return TestArrow$.MODULE$.make(new Serializable(value){
            public static final long serialVersionUID = 0L;
            private final Object value$4;

            public final TestTrace<Object> apply(Option<A> option2) {
                return TestTrace$.MODULE$.boolean(option2.contains(this.value$4), SmartAssertions$.MODULE$.zio$test$internal$SmartAssertions$$className(option2).$plus(ErrorMessage$.MODULE$.did()).$plus("contain").$plus(ErrorMessage$.MODULE$.pretty(this.value$4)));
            }
            {
                this.value$4 = value$4;
            }
        });
    }

    public TestArrow<String, Object> containsString(String value) {
        return TestArrow$.MODULE$.make(new Serializable(value){
            public static final long serialVersionUID = 0L;
            private final String value$2;

            public final TestTrace<Object> apply(String str) {
                return TestTrace$.MODULE$.boolean(str.contains(this.value$2), ErrorMessage$.MODULE$.pretty(str).$plus(ErrorMessage$.MODULE$.did()).$plus("contain").$plus(ErrorMessage$.MODULE$.pretty(this.value$2)));
            }
            {
                this.value$2 = value$2;
            }
        });
    }

    public <A> TestArrow<Seq<A>, A> hasAt(int index) {
        return TestArrow$.MODULE$.make(new Serializable(index){
            public static final long serialVersionUID = 0L;
            public final int index$1;

            public final TestTrace<A> apply(Seq<A> as2) {
                Option option2;
                block4: {
                    TestTrace<Object> testTrace;
                    block3: {
                        block2: {
                            option2 = Try$.MODULE$.apply((Function0)new Serializable(this, as2){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.hasAt.1 $outer;
                                private final Seq as$1;

                                public final A apply() {
                                    return (A)this.as$1.apply(this.$outer.index$1);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.as$1 = as$1;
                                }
                            }).toOption();
                            if (!(option2 instanceof Some)) break block2;
                            Some some2 = (Some)option2;
                            Object value = some2.x();
                            testTrace = TestTrace$.MODULE$.succeed(value);
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option2)) break block4;
                        testTrace = TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.text("Invalid index").$plus(ErrorMessage$.MODULE$.value(BoxesRunTime.boxToInteger((int)this.index$1))).$plus("for").$plus(SmartAssertions$.MODULE$.zio$test$internal$SmartAssertions$$className(as2)).$plus("of size").$plus(ErrorMessage$.MODULE$.value(BoxesRunTime.boxToInteger((int)as2.length()))));
                    }
                    return testTrace;
                }
                throw new MatchError((Object)option2);
            }
            {
                this.index$1 = index$1;
            }
        });
    }

    public <A, B> TestArrow<A, B> hasField(String name, Function1<A, B> proj) {
        return TestArrow$.MODULE$.make(new Serializable(proj){
            public static final long serialVersionUID = 0L;
            private final Function1 proj$1;

            public final TestTrace<B> apply(A a) {
                return TestTrace$.MODULE$.succeed(this.proj$1.apply(a));
            }
            {
                this.proj$1 = proj$1;
            }
        });
    }

    public <K, V> TestArrow<Map<K, V>, V> hasKey(K key) {
        return TestArrow$.MODULE$.make(new Serializable(key){
            public static final long serialVersionUID = 0L;
            public final Object key$1;

            public final TestTrace<V> apply(Map<K, V> mapKV) {
                Option option2;
                block4: {
                    TestTrace<Object> testTrace;
                    block3: {
                        block2: {
                            option2 = Try$.MODULE$.apply((Function0)new Serializable(this, mapKV){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.hasKey.1 $outer;
                                private final Map mapKV$1;

                                public final V apply() {
                                    return (V)this.mapKV$1.apply(this.$outer.key$1);
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.mapKV$1 = mapKV$1;
                                }
                            }).toOption();
                            if (!(option2 instanceof Some)) break block2;
                            Some some2 = (Some)option2;
                            Object value = some2.x();
                            testTrace = TestTrace$.MODULE$.succeed(value);
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option2)) break block4;
                        testTrace = TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.text("Missing key").$plus(ErrorMessage$.MODULE$.pretty(this.key$1)));
                    }
                    return testTrace;
                }
                throw new MatchError((Object)option2);
            }
            {
                this.key$1 = key$1;
            }
        });
    }

    public <A> TestArrow<Iterable<A>, A> head() {
        return TestArrow$.MODULE$.make(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TestTrace<A> apply(Iterable<A> as2) {
                Option option2;
                block4: {
                    TestTrace<Object> testTrace;
                    block3: {
                        block2: {
                            option2 = as2.headOption();
                            if (!(option2 instanceof Some)) break block2;
                            Some some2 = (Some)option2;
                            Object value = some2.x();
                            testTrace = TestTrace$.MODULE$.succeed(value);
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option2)) break block4;
                        testTrace = TestTrace$.MODULE$.fail(SmartAssertions$.MODULE$.zio$test$internal$SmartAssertions$$className(as2).$plus("was empty"));
                    }
                    return testTrace;
                }
                throw new MatchError((Object)option2);
            }
        });
    }

    public <A> TestArrow<Iterable<A>, A> last() {
        return TestArrow$.MODULE$.make(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TestTrace<A> apply(Iterable<A> as2) {
                Option option2;
                block4: {
                    TestTrace<Object> testTrace;
                    block3: {
                        block2: {
                            option2 = as2.lastOption();
                            if (!(option2 instanceof Some)) break block2;
                            Some some2 = (Some)option2;
                            Object value = some2.x();
                            testTrace = TestTrace$.MODULE$.succeed(value);
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option2)) break block4;
                        testTrace = TestTrace$.MODULE$.fail(SmartAssertions$.MODULE$.zio$test$internal$SmartAssertions$$className(as2).$plus("was empty"));
                    }
                    return testTrace;
                }
                throw new MatchError((Object)option2);
            }
        });
    }

    public <A> TestArrow<A, Object> isEven(Integral<A> integral) {
        return TestArrow$.MODULE$.make(new Serializable(integral){
            public static final long serialVersionUID = 0L;
            private final Integral integral$1;

            public final TestTrace<Object> apply(A a) {
                return TestTrace$.MODULE$.boolean(BoxesRunTime.equals((Object)this.integral$1.rem(a, this.integral$1.fromInt(2)), (Object)this.integral$1.fromInt(0)), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("even"));
            }
            {
                this.integral$1 = integral$1;
            }
        });
    }

    public <A> TestArrow<A, Object> isOdd(Integral<A> integral) {
        return TestArrow$.MODULE$.make(new Serializable(integral){
            public static final long serialVersionUID = 0L;
            private final Integral integral$2;

            public final TestTrace<Object> apply(A a) {
                return TestTrace$.MODULE$.boolean(BoxesRunTime.equals((Object)this.integral$2.rem(a, this.integral$2.fromInt(2)), (Object)this.integral$2.fromInt(1)), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("odd"));
            }
            {
                this.integral$2 = integral$2;
            }
        });
    }

    public <A> TestArrow<A, Object> greaterThan(A that, Ordering<A> ordering) {
        return TestArrow$.MODULE$.make(new Serializable(that, ordering){
            public static final long serialVersionUID = 0L;
            private final Object that$3;
            private final Ordering ordering$3;

            public final TestTrace<Object> apply(A a) {
                return TestTrace$.MODULE$.boolean(this.ordering$3.gt(a, this.that$3), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("greater than").$plus(ErrorMessage$.MODULE$.pretty(this.that$3)));
            }
            {
                this.that$3 = that$3;
                this.ordering$3 = ordering$3;
            }
        });
    }

    public <A> TestArrow<A, Object> greaterThanOrEqualTo(A that, Ordering<A> ordering) {
        return TestArrow$.MODULE$.make(new Serializable(that, ordering){
            public static final long serialVersionUID = 0L;
            private final Object that$4;
            private final Ordering ordering$4;

            public final TestTrace<Object> apply(A a) {
                return TestTrace$.MODULE$.boolean(this.ordering$4.gteq(a, this.that$4), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"greater than or equal to"})).s((Seq)Nil$.MODULE$)).$plus(ErrorMessage$.MODULE$.pretty(this.that$4)));
            }
            {
                this.that$4 = that$4;
                this.ordering$4 = ordering$4;
            }
        });
    }

    public <A> TestArrow<A, Object> lessThan(A that, Ordering<A> ordering) {
        return TestArrow$.MODULE$.make(new Serializable(that, ordering){
            public static final long serialVersionUID = 0L;
            private final Object that$1;
            private final Ordering ordering$1;

            public final TestTrace<Object> apply(A a) {
                return TestTrace$.MODULE$.boolean(this.ordering$1.lt(a, this.that$1), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("less than").$plus(ErrorMessage$.MODULE$.pretty(this.that$1)));
            }
            {
                this.that$1 = that$1;
                this.ordering$1 = ordering$1;
            }
        });
    }

    public <A> TestArrow<A, Object> lessThanOrEqualTo(A that, Ordering<A> ordering) {
        return TestArrow$.MODULE$.make(new Serializable(that, ordering){
            public static final long serialVersionUID = 0L;
            private final Object that$2;
            private final Ordering ordering$2;

            public final TestTrace<Object> apply(A a) {
                return TestTrace$.MODULE$.boolean(this.ordering$2.lteq(a, this.that$2), ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.was()).$plus("less than or equal to").$plus(ErrorMessage$.MODULE$.pretty(this.that$2)));
            }
            {
                this.that$2 = that$2;
                this.ordering$2 = ordering$2;
            }
        });
    }

    public <A> TestArrow<A, Object> equalTo(A that, OptionalImplicit<Diff<A>> diff) {
        return TestArrow$.MODULE$.make(new Serializable(that, diff){
            public static final long serialVersionUID = 0L;
            private final Object that$5;
            private final OptionalImplicit diff$1;

            /*
             * Unable to fully structure code
             */
            public final TestTrace<Object> apply(A a) {
                var3_2 = new Tuple2(a, this.that$5);
                if (var3_2 == null) ** GOTO lbl-1000
                a = var3_2._1();
                that = var3_2._2();
                if (!ScalaRunTime$.MODULE$.isArray(a, 1)) ** GOTO lbl-1000
                var6_5 = a;
                if (ScalaRunTime$.MODULE$.isArray(that, 1)) {
                    var7_6 = that;
                    var8_7 = Predef$.MODULE$.genericArrayOps(var6_5).sameElements((GenIterable)Predef$.MODULE$.genericWrapArray(var7_6));
                } else lbl-1000:
                // 3 sources

                {
                    var8_7 = BoxesRunTime.equals(a, (Object)this.that$5) != false;
                }
                result = var8_7;
                var9_9 = this.diff$1.value();
                if (var9_9 instanceof Some && !(diff = (Diff)(var10_10 = (Some)var9_9).x()).isLowPriority() && !result) {
                    diffResult = diff.diff(this.that$5, a);
                    var14_13 = diffResult;
                    var17_16 = var14_13 instanceof DiffResult.Different != false && None$.MODULE$.equals(var16_15 = (var15_14 = (DiffResult.Different)var14_13).customRender()) != false ? ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.equals()).$plus(ErrorMessage$.MODULE$.pretty(this.that$5)) : ErrorMessage$.MODULE$.choice("There was no difference", "There was a difference").$plus$plus(ErrorMessage$.MODULE$.custom(ConsoleUtils$.MODULE$.underlined("Expected"))).$plus$plus(ErrorMessage$.MODULE$.custom(PrettyPrint$.MODULE$.apply(this.that$5))).$plus$plus(ErrorMessage$.MODULE$.custom(new StringBuilder().append((Object)ConsoleUtils$.MODULE$.underlined("Diff")).append((Object)ansi.AnsiStringOps$.MODULE$.faint$extension(ansi$.MODULE$.AnsiStringOps(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", "-expected ", "+obtained"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"\u001b[31m", "\u001b[32m"}))))).toString())).$plus$plus(ErrorMessage$.MODULE$.custom(new StringBuilder().append((Object)"\u001b[0m").append((Object)var14_13.render()).toString()));
                    var12_17 = var17_16;
                } else {
                    var12_17 = ErrorMessage$.MODULE$.pretty(a).$plus(ErrorMessage$.MODULE$.equals()).$plus(ErrorMessage$.MODULE$.pretty(this.that$5));
                }
                return TestTrace$.MODULE$.boolean(result, var12_17);
            }
            {
                this.that$5 = that$5;
                this.diff$1 = diff$1;
            }
        });
    }

    public <E> TestArrow<Cause<E>, Throwable> asCauseDie() {
        return TestArrow$.MODULE$.make(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TestTrace<Throwable> apply(Cause<E> x0$4) {
                Cause<E> cause = x0$4;
                TestTrace<Object> testTrace = cause.dieOption().isDefined() ? TestTrace$.MODULE$.succeed(cause.dieOption().get()) : TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Cause").$plus(ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(ErrorMessage$.MODULE$.value("Die")));
                return testTrace;
            }
        });
    }

    public <E> TestArrow<Cause<E>, E> asCauseFailure() {
        return TestArrow$.MODULE$.make(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TestTrace<E> apply(Cause<E> x0$5) {
                Cause<E> cause = x0$5;
                TestTrace<Object> testTrace = cause.failureOption().isDefined() ? TestTrace$.MODULE$.succeed(cause.failureOption().get()) : TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Cause").$plus(ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(ErrorMessage$.MODULE$.value("Fail")));
                return testTrace;
            }
        });
    }

    public <E> TestArrow<Cause<E>, Object> asCauseInterrupted() {
        return TestArrow$.MODULE$.make(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TestTrace<Object> apply(Cause<E> x0$6) {
                Cause<E> cause = x0$6;
                TestTrace<Object> testTrace = cause.isInterrupted() ? TestTrace$.MODULE$.succeed(BoxesRunTime.boxToBoolean((boolean)true)) : TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Cause").$plus(ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(ErrorMessage$.MODULE$.value("Interrupt")));
                return testTrace;
            }
        });
    }

    public <E, A> TestArrow<Exit<E, A>, Throwable> asExitDie() {
        return TestArrow$.MODULE$.make(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TestTrace<Throwable> apply(Exit<E, A> x0$7) {
                Exit<E, A> exit;
                block5: {
                    TestTrace<Object> testTrace;
                    block3: {
                        boolean bl;
                        block4: {
                            block2: {
                                bl = false;
                                Exit.Failure failure = null;
                                exit = x0$7;
                                if (!(exit instanceof Exit.Failure)) break block2;
                                bl = true;
                                failure = (Exit.Failure)exit;
                                Cause cause = failure.cause();
                                if (!cause.dieOption().isDefined()) break block2;
                                testTrace = TestTrace$.MODULE$.succeed(cause.dieOption().get());
                                break block3;
                            }
                            if (!(exit instanceof Exit.Success)) break block4;
                            testTrace = TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit.Success").$plus(ErrorMessage$.MODULE$.was()).$plus("a").$plus(ErrorMessage$.MODULE$.value("Cause.Die")));
                            break block3;
                        }
                        if (!bl) break block5;
                        testTrace = TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit.Failure").$plus(ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(ErrorMessage$.MODULE$.value("Cause.Die")));
                    }
                    return testTrace;
                }
                throw new MatchError(exit);
            }
        });
    }

    public <E> TestArrow<Exit<E, Object>, Cause<E>> asExitCause() {
        return TestArrow$.MODULE$.make(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TestTrace<Cause<E>> apply(Exit<E, Object> x0$8) {
                Exit<E, Object> exit;
                block4: {
                    TestTrace<Cause<E>> testTrace;
                    block3: {
                        block2: {
                            exit = x0$8;
                            if (!(exit instanceof Exit.Failure)) break block2;
                            Exit.Failure failure = (Exit.Failure)exit;
                            Cause cause = failure.cause();
                            testTrace = TestTrace$.MODULE$.succeed(cause);
                            break block3;
                        }
                        if (!(exit instanceof Exit.Success)) break block4;
                        testTrace = TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit.Success").$plus(ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(ErrorMessage$.MODULE$.value("Cause")));
                    }
                    return testTrace;
                }
                throw new MatchError(exit);
            }
        });
    }

    public <E> TestArrow<Exit<E, Object>, E> asExitFailure() {
        return TestArrow$.MODULE$.make(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TestTrace<E> apply(Exit<E, Object> x0$9) {
                Exit<E, Object> exit;
                block5: {
                    TestTrace<Object> testTrace;
                    block3: {
                        boolean bl;
                        block4: {
                            block2: {
                                bl = false;
                                Exit.Failure failure = null;
                                exit = x0$9;
                                if (!(exit instanceof Exit.Failure)) break block2;
                                bl = true;
                                failure = (Exit.Failure)exit;
                                Cause cause = failure.cause();
                                if (!cause.failureOption().isDefined()) break block2;
                                testTrace = TestTrace$.MODULE$.succeed(cause.failureOption().get());
                                break block3;
                            }
                            if (!(exit instanceof Exit.Success)) break block4;
                            testTrace = TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit.Success").$plus(ErrorMessage$.MODULE$.was()).$plus("a").$plus(ErrorMessage$.MODULE$.value("Failure")));
                            break block3;
                        }
                        if (!bl) break block5;
                        testTrace = TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit.Failure").$plus(ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(ErrorMessage$.MODULE$.value("Cause.Fail")));
                    }
                    return testTrace;
                }
                throw new MatchError(exit);
            }
        });
    }

    public <E, A> TestArrow<Exit<E, A>, Object> asExitInterrupted() {
        return TestArrow$.MODULE$.make(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TestTrace<Object> apply(Exit<E, A> x0$10) {
                Exit<E, A> exit;
                block5: {
                    TestTrace<Object> testTrace;
                    block3: {
                        boolean bl;
                        block4: {
                            block2: {
                                bl = false;
                                Exit.Failure failure = null;
                                exit = x0$10;
                                if (!(exit instanceof Exit.Failure)) break block2;
                                bl = true;
                                failure = (Exit.Failure)exit;
                                Cause cause = failure.cause();
                                if (!cause.isInterrupted()) break block2;
                                testTrace = TestTrace$.MODULE$.succeed(BoxesRunTime.boxToBoolean((boolean)true));
                                break block3;
                            }
                            if (!(exit instanceof Exit.Success)) break block4;
                            testTrace = TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit.Success").$plus(ErrorMessage$.MODULE$.was()).$plus("interrupted"));
                            break block3;
                        }
                        if (!bl) break block5;
                        testTrace = TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit.Failure").$plus(ErrorMessage$.MODULE$.did()).$plus("contain a").$plus(ErrorMessage$.MODULE$.value("Cause.Interrupt")));
                    }
                    return testTrace;
                }
                throw new MatchError(exit);
            }
        });
    }

    public <E, A> TestArrow<Exit<E, A>, A> asExitSuccess() {
        return TestArrow$.MODULE$.make(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TestTrace<A> apply(Exit<E, A> x0$11) {
                Exit<E, A> exit;
                block4: {
                    TestTrace<Object> testTrace;
                    block3: {
                        block2: {
                            exit = x0$11;
                            if (!(exit instanceof Exit.Success)) break block2;
                            Exit.Success success = (Exit.Success)exit;
                            Object value = success.value();
                            testTrace = TestTrace$.MODULE$.succeed(value);
                            break block3;
                        }
                        if (!(exit instanceof Exit.Failure)) break block4;
                        testTrace = TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value("Exit").$plus(ErrorMessage$.MODULE$.was()).$plus("a").$plus(ErrorMessage$.MODULE$.value("Success")));
                    }
                    return testTrace;
                }
                throw new MatchError(exit);
            }
        });
    }

    public TestArrow<Object, Throwable> throws() {
        return this.throws;
    }

    public <A, B> TestArrow<A, B> as(ClassTag<B> CB) {
        return TestArrow$.MODULE$.make(new Serializable(CB){
            public static final long serialVersionUID = 0L;
            private final ClassTag CB$1;

            public final TestTrace<B> apply(A a) {
                Option option2;
                block4: {
                    TestTrace<Object> testTrace;
                    block3: {
                        block2: {
                            option2 = this.CB$1.unapply(a);
                            if (!(option2 instanceof Some)) break block2;
                            Some some2 = (Some)option2;
                            Object value = some2.x();
                            testTrace = TestTrace$.MODULE$.succeed(value);
                            break block3;
                        }
                        if (!None$.MODULE$.equals(option2)) break block4;
                        testTrace = TestTrace$.MODULE$.fail(ErrorMessage$.MODULE$.value(a.getClass().getSimpleName()).$plus("is not an instance of").$plus(ErrorMessage$.MODULE$.value(SmartAssertions$.MODULE$.zio$test$internal$SmartAssertions$$className(this.CB$1))));
                    }
                    return testTrace;
                }
                throw new MatchError((Object)option2);
            }
            {
                this.CB$1 = CB$1;
            }
        });
    }

    public <A, B> TestArrow<A, Object> is(ClassTag<B> CB) {
        return TestArrow$.MODULE$.make(new Serializable(CB){
            public static final long serialVersionUID = 0L;
            private final ClassTag CB$2;

            public final TestTrace<Object> apply(A a) {
                return TestTrace$.MODULE$.boolean(this.CB$2.unapply(a).isDefined(), ErrorMessage$.MODULE$.value(a.getClass().getSimpleName()).$plus(ErrorMessage$.MODULE$.was()).$plus("an instance of").$plus(ErrorMessage$.MODULE$.value(SmartAssertions$.MODULE$.zio$test$internal$SmartAssertions$$className(this.CB$2))));
            }
            {
                this.CB$2 = CB$2;
            }
        });
    }

    public <A> TestArrow<Seq<A>, Object> startsWithSeq(Seq<A> prefix) {
        return TestArrow$.MODULE$.make(new Serializable(prefix){
            public static final long serialVersionUID = 0L;
            private final Seq prefix$1;

            public final TestTrace<Object> apply(Seq<A> seq) {
                return TestTrace$.MODULE$.boolean(seq.startsWith((GenSeq)this.prefix$1), ErrorMessage$.MODULE$.pretty(seq).$plus(ErrorMessage$.MODULE$.did()).$plus("start with").$plus(ErrorMessage$.MODULE$.pretty(this.prefix$1)));
            }
            {
                this.prefix$1 = prefix$1;
            }
        });
    }

    public TestArrow<String, Object> startsWithString(String prefix) {
        return TestArrow$.MODULE$.make(new Serializable(prefix){
            public static final long serialVersionUID = 0L;
            private final String prefix$2;

            public final TestTrace<Object> apply(String string2) {
                return TestTrace$.MODULE$.boolean(string2.startsWith(this.prefix$2), ErrorMessage$.MODULE$.value(string2).$plus(ErrorMessage$.MODULE$.did()).$plus("start with").$plus(ErrorMessage$.MODULE$.value(this.prefix$2)));
            }
            {
                this.prefix$2 = prefix$2;
            }
        });
    }

    public <A> TestArrow<Seq<A>, Object> endsWithSeq(Seq<A> postfix) {
        return TestArrow$.MODULE$.make(new Serializable(postfix){
            public static final long serialVersionUID = 0L;
            private final Seq postfix$1;

            public final TestTrace<Object> apply(Seq<A> seq) {
                return TestTrace$.MODULE$.boolean(seq.endsWith((GenSeq)this.postfix$1), ErrorMessage$.MODULE$.value(seq).$plus(ErrorMessage$.MODULE$.did()).$plus("end with").$plus(ErrorMessage$.MODULE$.value(seq)));
            }
            {
                this.postfix$1 = postfix$1;
            }
        });
    }

    public TestArrow<String, Object> endsWithString(String postfix) {
        return TestArrow$.MODULE$.make(new Serializable(postfix){
            public static final long serialVersionUID = 0L;
            private final String postfix$2;

            public final TestTrace<Object> apply(String string2) {
                return TestTrace$.MODULE$.boolean(string2.endsWith(this.postfix$2), ErrorMessage$.MODULE$.value(string2).$plus(ErrorMessage$.MODULE$.did()).$plus("end with").$plus(ErrorMessage$.MODULE$.value(this.postfix$2)));
            }
            {
                this.postfix$2 = postfix$2;
            }
        });
    }

    public <A> String zio$test$internal$SmartAssertions$$className(ClassTag<A> C) {
        Throwable throwable22;
        block2: {
            String string2;
            try {
                string2 = C.runtimeClass().getSimpleName();
            }
            catch (Throwable throwable22) {
                String string3;
                Throwable throwable3 = throwable22;
                if (!(throwable3 instanceof InternalError)) break block2;
                InternalError internalError = (InternalError)throwable3;
                String string4 = internalError.getMessage();
                String string5 = "Malformed class name";
                if (string4 != null ? !string4.equals(string5) : string5 != null) break block2;
                string2 = string3 = C.runtimeClass().getName();
            }
            return string2;
        }
        throw throwable22;
    }

    public <A> ErrorMessage zio$test$internal$SmartAssertions$$className(Iterable<A> a) {
        return ErrorMessage$.MODULE$.value(new StringOps(Predef$.MODULE$.augmentString(a.toString())).takeWhile((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char x$9) {
                return x$9 != '(';
            }
        }));
    }

    public <A> ErrorMessage zio$test$internal$SmartAssertions$$className(Option<A> a) {
        return ErrorMessage$.MODULE$.value(new StringOps(Predef$.MODULE$.augmentString(a.toString())).takeWhile((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char x$10) {
                return x$10 != '(';
            }
        }));
    }

    private SmartAssertions$() {
        MODULE$ = this;
        this.anything = TestArrow$.MODULE$.make(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TestTrace<Object> apply(Object x$1) {
                return TestTrace$.MODULE$.boolean(true, ErrorMessage$.MODULE$.was().$plus("anything"));
            }
        });
        this.throws = TestArrow$.MODULE$.makeEither(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TestTrace<Throwable> apply(Throwable value) {
                return TestTrace$.MODULE$.succeed(value);
            }
        }, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TestTrace<Nothing$> apply(Object x$8) {
                return TestTrace$.MODULE$.fail("Expected failure");
            }
        });
    }
}

