/*
 * Decompiled with CFR 0.152.
 */
package zio.test;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Right;
import zio.test.BoolAlgebra;
import zio.test.DefaultTestReporter$;
import zio.test.ExecutedSpec;
import zio.test.ExecutedSpec$;
import zio.test.ExecutedSpec$SuiteCase$;
import zio.test.ExecutedSpec$TestCase$;
import zio.test.Summary;
import zio.test.Summary$;
import zio.test.TestAnnotationMap;
import zio.test.TestAnnotationRenderer$;
import zio.test.TestFailure;
import zio.test.TestSuccess;
import zio.test.TestSuccess$Ignored$;
import zio.test.TestSuccess$Succeeded$;

public final class SummaryBuilder$
implements Serializable {
    public static final SummaryBuilder$ MODULE$ = new SummaryBuilder$();

    private SummaryBuilder$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SummaryBuilder$.class);
    }

    public <E> Summary buildSummary(ExecutedSpec<E> executedSpec) {
        int success = this.countTestResults(executedSpec, (Function1 & Serializable)x$1 -> {
            boolean bl;
            Either either = x$1;
            if (either instanceof Right && ((Right)either).value() instanceof TestSuccess.Succeeded) {
                TestSuccess.Succeeded succeeded = TestSuccess$Succeeded$.MODULE$.unapply((TestSuccess.Succeeded)((Right)either).value());
                BoolAlgebra<BoxedUnit> boolAlgebra = succeeded._1();
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        });
        int fail = this.countTestResults(executedSpec, (Function1 & Serializable)_$1 -> _$1.isLeft());
        int ignore = this.countTestResults(executedSpec, (Function1 & Serializable)x$1 -> {
            Either either = x$1;
            return either instanceof Right && TestSuccess$Ignored$.MODULE$.equals(((Right)either).value());
        });
        Seq<ExecutedSpec<E>> failures = this.extractFailures(executedSpec);
        String rendered = ((IterableOnceOps)((IterableOps)failures.flatMap((Function1 & Serializable)_$2 -> DefaultTestReporter$.MODULE$.render(_$2, TestAnnotationRenderer$.MODULE$.silent(), false))).flatMap((Function1 & Serializable)_$3 -> _$3.rendered())).mkString("\n");
        return Summary$.MODULE$.apply(success, fail, ignore, rendered);
    }

    private <E> int countTestResults(ExecutedSpec<E> executedSpec, Function1<Either<TestFailure<E>, TestSuccess>, Object> pred) {
        return BoxesRunTime.unboxToInt(executedSpec.fold((Function1 & Serializable)c -> {
            int n;
            ExecutedSpec.SpecCase specCase = c;
            if (specCase instanceof ExecutedSpec.SuiteCase) {
                Vector vector;
                ExecutedSpec.SuiteCase suiteCase = ExecutedSpec$SuiteCase$.MODULE$.unapply((ExecutedSpec.SuiteCase)specCase);
                String string = suiteCase._1();
                Vector counts = vector = suiteCase._2();
                n = BoxesRunTime.unboxToInt((Object)counts.sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            } else if (specCase instanceof ExecutedSpec.TestCase) {
                ExecutedSpec.TestCase testCase = ExecutedSpec$TestCase$.MODULE$.unapply((ExecutedSpec.TestCase)specCase);
                String string = testCase._1();
                Either either = testCase._2();
                TestAnnotationMap testAnnotationMap = testCase._3();
                Either test = either;
                n = BoxesRunTime.unboxToBoolean((Object)pred.apply(test)) ? 1 : 0;
            } else {
                throw new MatchError((Object)specCase);
            }
            return n;
        }));
    }

    private <E> Seq<ExecutedSpec<E>> extractFailures(ExecutedSpec<E> executedSpec) {
        return (Seq)executedSpec.fold((Function1 & Serializable)c -> {
            Seq seq;
            ExecutedSpec.SpecCase specCase = c;
            if (specCase instanceof ExecutedSpec.SuiteCase) {
                ExecutedSpec.SuiteCase suiteCase = ExecutedSpec$SuiteCase$.MODULE$.unapply((ExecutedSpec.SuiteCase)specCase);
                String string = suiteCase._1();
                Vector vector = suiteCase._2();
                String label = string;
                Vector specs = vector;
                Vector newSpecs = (Vector)specs.flatten(Predef$.MODULE$.$conforms());
                seq = newSpecs.nonEmpty() ? (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExecutedSpec[]{ExecutedSpec$.MODULE$.apply(ExecutedSpec$SuiteCase$.MODULE$.apply(label, newSpecs))})) : (Seq)package$.MODULE$.Seq().empty();
            } else if (specCase instanceof ExecutedSpec.TestCase) {
                ExecutedSpec.TestCase testCase = (ExecutedSpec.TestCase)specCase;
                ExecutedSpec.TestCase testCase2 = ExecutedSpec$TestCase$.MODULE$.unapply(testCase);
                String string = testCase2._1();
                Either either = testCase2._2();
                TestAnnotationMap testAnnotationMap = testCase2._3();
                Either test = either;
                ExecutedSpec.TestCase c2 = testCase;
                seq = test.isLeft() ? (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ExecutedSpec[]{ExecutedSpec$.MODULE$.apply(c2)})) : (Seq)package$.MODULE$.Seq().empty();
            } else {
                throw new MatchError((Object)specCase);
            }
            return seq;
        });
    }
}

