/*
 * Decompiled with CFR 0.152.
 */
package zio.test;

import dotty.runtime.function.JFunction1;
import dotty.runtime.function.JProcedure1;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Product;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import zio.Cause;
import zio.Exit;
import zio.FiberFailure$;
import zio.Runtime;
import zio.Runtime$;
import zio.ZIO;
import zio.clock.Clock;
import zio.console.Console;
import zio.duration.Duration;
import zio.internal.Platform;
import zio.test.ExecutionStrategy;
import zio.test.ExecutionStrategy$ParallelN$;
import zio.test.Spec;
import zio.test.TestFailure;
import zio.test.TestLogger;
import zio.test.TestLogger$;
import zio.test.TestRunner$;
import zio.test.TestSuccess;

public class TestRunner<R, L, T, E, S>
implements Product,
Serializable {
    private final Function2 executor;
    private final Platform platform;
    private final Function2 reporter;
    private final TestLogger defaultTestLogger;

    public static <R, L, T, E, S> TestRunner<R, L, T, E, S> apply(Function2<Spec<R, E, L, T>, ExecutionStrategy, ZIO<Object, Nothing, Spec<Object, Nothing, L, Either<TestFailure<E>, TestSuccess<S>>>>> function2, Platform platform, Function2<Duration, Spec<Object, Nothing, L, Either<TestFailure<E>, TestSuccess<S>>>, ZIO<TestLogger, Nothing, BoxedUnit>> function22) {
        return TestRunner$.MODULE$.apply(function2, platform, function22);
    }

    public static TestRunner fromProduct(Product product) {
        return TestRunner$.MODULE$.fromProduct(product);
    }

    public static <R, L, T, E, S> TestRunner<R, L, T, E, S> unapply(TestRunner<R, L, T, E, S> testRunner) {
        return TestRunner$.MODULE$.unapply(testRunner);
    }

    public static Platform $lessinit$greater$default$2() {
        return TestRunner$.MODULE$.$lessinit$greater$default$2();
    }

    public static Function2 $lessinit$greater$default$3() {
        return TestRunner$.MODULE$.$lessinit$greater$default$3();
    }

    public <R, L, T, E, S> TestRunner(Function2<Spec<R, E, L, T>, ExecutionStrategy, ZIO<Object, Nothing, Spec<Object, Nothing, L, Either<TestFailure<E>, TestSuccess<S>>>>> executor, Platform platform, Function2<Duration, Spec<Object, Nothing, L, Either<TestFailure<E>, TestSuccess<S>>>, ZIO<TestLogger, Nothing, BoxedUnit>> reporter) {
        this.executor = executor;
        this.platform = platform;
        this.reporter = reporter;
        this.defaultTestLogger = TestLogger$.MODULE$.fromConsole((Console)Console.Live$.MODULE$);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof TestRunner)) return false;
        TestRunner testRunner = (TestRunner)object;
        Function2<Spec<R, E, L, T>, ExecutionStrategy, ZIO<Object, Nothing, Spec<Object, Nothing, L, Either<TestFailure<E>, TestSuccess<S>>>>> function2 = this.executor();
        Function2<Spec<R, E, L, T>, ExecutionStrategy, ZIO<Object, Nothing, Spec<Object, Nothing, L, Either<TestFailure<E>, TestSuccess<S>>>>> function22 = testRunner.executor();
        if (function2 == null) {
            if (function22 != null) {
                return false;
            }
        } else if (!function2.equals(function22)) return false;
        Platform platform = this.platform();
        Platform platform2 = testRunner.platform();
        if (platform == null) {
            if (platform2 != null) {
                return false;
            }
        } else if (!platform.equals(platform2)) return false;
        Function2<Duration, Spec<Object, Nothing, L, Either<TestFailure<E>, TestSuccess<S>>>, ZIO<TestLogger, Nothing, BoxedUnit>> function23 = this.reporter();
        Function2<Duration, Spec<Object, Nothing, L, Either<TestFailure<E>, TestSuccess<S>>>, ZIO<TestLogger, Nothing, BoxedUnit>> function24 = testRunner.reporter();
        if (function23 == null) {
            if (function24 == null) return true;
            return false;
        } else {
            if (!function23.equals(function24)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof TestRunner;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "TestRunner";
    }

    public Object productElement(int n) {
        Function2<Duration, Spec<Object, Nothing, L, Either<TestFailure<E>, TestSuccess<S>>>, ZIO<TestLogger, Nothing, BoxedUnit>> function2;
        int n2 = n;
        switch (n2) {
            case 0: {
                function2 = this._1();
                break;
            }
            case 1: {
                function2 = this._2();
                break;
            }
            case 2: {
                function2 = this._3();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
            }
        }
        return function2;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        switch (n2) {
            case 0: {
                string = "executor";
                break;
            }
            case 1: {
                string = "platform";
                break;
            }
            case 2: {
                string = "reporter";
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
            }
        }
        return string;
    }

    public Function2<Spec<R, E, L, T>, ExecutionStrategy, ZIO<Object, Nothing, Spec<Object, Nothing, L, Either<TestFailure<E>, TestSuccess<S>>>>> executor() {
        return this.executor;
    }

    public Platform platform() {
        return this.platform;
    }

    public Function2<Duration, Spec<Object, Nothing, L, Either<TestFailure<E>, TestSuccess<S>>>, ZIO<TestLogger, Nothing, BoxedUnit>> reporter() {
        return this.reporter;
    }

    public final TestLogger defaultTestLogger() {
        return this.defaultTestLogger;
    }

    public final ZIO<TestLogger, Nothing, Spec<Object, Nothing, L, Either<TestFailure<E>, TestSuccess<S>>>> run(Spec<R, E, L, T> spec) {
        return ((ZIO)this.executor().apply(spec, (Object)ExecutionStrategy$ParallelN$.MODULE$.apply(4))).timed().flatMap((Function1)(JFunction1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Duration duration = (Duration)tuple2._1();
            Spec results = (Spec)tuple2._2();
            return ((ZIO)this.reporter().apply((Object)duration, (Object)results)).as(() -> TestRunner.run$$anonfun$2$$anonfun$1(results));
        });
    }

    public final Spec<Object, Nothing, L, Either<TestFailure<E>, TestSuccess<S>>> unsafeRun(Spec<R, E, L, T> spec, TestLogger testLogger, Clock clock) {
        return (Spec)this.buildRuntime(testLogger, clock).unsafeRun(() -> this.unsafeRun$$anonfun$1(spec));
    }

    public TestLogger unsafeRun$default$2() {
        return this.defaultTestLogger();
    }

    public Clock.Live$ unsafeRun$default$3() {
        return Clock.Live$.MODULE$;
    }

    public final void unsafeRunAsync(Spec<R, E, L, T> spec, TestLogger testLogger, Clock clock, Function1<Spec<Object, Nothing, L, Either<TestFailure<E>, TestSuccess<S>>>, BoxedUnit> k) {
        this.buildRuntime(testLogger, clock).unsafeRunAsync(() -> this.unsafeRunAsync$$anonfun$1(spec), (Function1)(JProcedure1 & Serializable)x$1 -> {
            Spec spec;
            Exit exit = x$1;
            if (!(exit instanceof Exit.Success)) {
                if (exit instanceof Exit.Failure) {
                    Cause cause;
                    Exit.Failure failure = Exit.Failure$.MODULE$.unapply((Exit.Failure)exit);
                    Cause c = cause = failure._1();
                    throw FiberFailure$.MODULE$.apply(c);
                }
                throw new MatchError((Object)exit);
            }
            Exit.Success success = Exit.Success$.MODULE$.unapply((Exit.Success)exit);
            Spec v = spec = (Spec)success._1();
            k.apply((Object)v);
        });
    }

    public TestLogger unsafeRunAsync$default$2() {
        return this.defaultTestLogger();
    }

    public Clock.Live$ unsafeRunAsync$default$3() {
        return Clock.Live$.MODULE$;
    }

    public final Exit<Nothing, Spec<Object, Nothing, L, Either<TestFailure<E>, TestSuccess<S>>>> unsafeRunSync(Spec<R, E, L, T> spec, TestLogger testLogger, Clock clock) {
        return this.buildRuntime(testLogger, clock).unsafeRunSync(() -> this.unsafeRunSync$$anonfun$1(spec));
    }

    public TestLogger unsafeRunSync$default$2() {
        return this.defaultTestLogger();
    }

    public Clock.Live$ unsafeRunSync$default$3() {
        return Clock.Live$.MODULE$;
    }

    public final <L1, E1, S1> TestRunner<R, L, T, E, S> withReporter(Function2<Duration, Spec<Object, Nothing, L1, Either<TestFailure<E1>, TestSuccess<S1>>>, ZIO<TestLogger, Nothing, BoxedUnit>> reporter) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), reporter);
    }

    public Runtime<TestLogger> buildRuntime(TestLogger loggerSvc, Clock clockSvc) {
        return Runtime$.MODULE$.apply((Object)this.buildEnv(loggerSvc, clockSvc), this.platform());
    }

    public TestLogger buildRuntime$default$1() {
        return this.defaultTestLogger();
    }

    public Clock.Live$ buildRuntime$default$2() {
        return Clock.Live$.MODULE$;
    }

    private TestLogger buildEnv(TestLogger loggerSvc, Clock clockSvc) {
        return new TestLogger(loggerSvc, clockSvc){
            private final TestLogger loggerSvc$1;
            private final Clock.Service clock;
            {
                this.loggerSvc$1 = loggerSvc$1;
                this.clock = clockSvc$1.clock();
            }

            public TestLogger.Service testLogger() {
                return this.loggerSvc$1.testLogger();
            }

            public Clock.Service clock() {
                return this.clock;
            }
        };
    }

    public <R, L, T, E, S> TestRunner<R, L, T, E, S> copy(Function2<Spec<R, E, L, T>, ExecutionStrategy, ZIO<Object, Nothing, Spec<Object, Nothing, L, Either<TestFailure<E>, TestSuccess<S>>>>> executor, Platform platform, Function2<Duration, Spec<Object, Nothing, L, Either<TestFailure<E>, TestSuccess<S>>>, ZIO<TestLogger, Nothing, BoxedUnit>> reporter) {
        return new TestRunner<R, L, T, E, S>(executor, platform, reporter);
    }

    public <R, L, T, E, S> Function2<Spec<R, E, L, T>, ExecutionStrategy, ZIO<Object, Nothing, Spec<Object, Nothing, L, Either<TestFailure<E>, TestSuccess<S>>>>> copy$default$1() {
        return this.executor();
    }

    public <R, L, T, E, S> Platform copy$default$2() {
        return this.platform();
    }

    public <R, L, T, E, S> Function2<Duration, Spec<Object, Nothing, L, Either<TestFailure<E>, TestSuccess<S>>>, ZIO<TestLogger, Nothing, BoxedUnit>> copy$default$3() {
        return this.reporter();
    }

    public Function2<Spec<R, E, L, T>, ExecutionStrategy, ZIO<Object, Nothing, Spec<Object, Nothing, L, Either<TestFailure<E>, TestSuccess<S>>>>> _1() {
        return this.executor();
    }

    public Platform _2() {
        return this.platform();
    }

    public Function2<Duration, Spec<Object, Nothing, L, Either<TestFailure<E>, TestSuccess<S>>>, ZIO<TestLogger, Nothing, BoxedUnit>> _3() {
        return this.reporter();
    }

    private static final Spec run$$anonfun$2$$anonfun$1(Spec results$3) {
        return results$3;
    }

    private final ZIO unsafeRun$$anonfun$1(Spec spec$2) {
        return this.run(spec$2);
    }

    private final ZIO unsafeRunAsync$$anonfun$1(Spec spec$3) {
        return this.run(spec$3);
    }

    private final ZIO unsafeRunSync$$anonfun$1(Spec spec$4) {
        return this.run(spec$4);
    }
}

