/*
 * Decompiled with CFR 0.152.
 */
package zio.test.sbt;

import java.io.Serializable;
import sbt.testing.Runner;
import sbt.testing.Task;
import sbt.testing.TaskDef;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import zio.ZIO;
import zio.test.Summary;
import zio.test.TestArgs$;
import zio.test.sbt.SummaryProtocol$;
import zio.test.sbt.ZTestTask$;
import zio.test.sbt.package$;

public abstract class ZTestRunner
implements Runner {
    private final String[] args;
    private final String[] remoteArgs;
    private final ClassLoader testClassLoader;
    private final String runnerType;
    private final Buffer summaries;

    public ZTestRunner(String[] args, String[] remoteArgs, ClassLoader testClassLoader, String runnerType) {
        this.args = args;
        this.remoteArgs = remoteArgs;
        this.testClassLoader = testClassLoader;
        this.runnerType = runnerType;
        this.summaries = (Buffer)Buffer$.MODULE$.empty();
    }

    public String[] args() {
        return this.args;
    }

    public String[] remoteArgs() {
        return this.remoteArgs;
    }

    public abstract ZIO sendSummary();

    public Buffer<Summary> summaries() {
        return this.summaries;
    }

    public String done() {
        int total = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.summaries().map((Function1 & Serializable)_$1 -> _$1.total())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int ignore = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.summaries().map((Function1 & Serializable)_$2 -> _$2.ignore())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        return this.summaries().isEmpty() || total == ignore ? new StringBuilder(31).append("\u001b[33m").append("No tests were executed").append("\u001b[0m").toString() : ((IterableOnceOps)((IterableOps)((IterableOps)this.summaries().map((Function1 & Serializable)_$3 -> _$3.summary())).filter((Function1 & Serializable)_$4 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$4)))).flatMap((Function1 & Serializable)s -> {
            String string = package$.MODULE$.colored((String)s);
            return scala.package$.MODULE$.Nil().$colon$colon((Object)"\n").$colon$colon((Object)string);
        })).mkString("", "", "Done");
    }

    public Task[] tasks(TaskDef[] defs) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])defs);
        return (Task[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$5 -> ZTestTask$.MODULE$.apply((TaskDef)_$5, this.testClassLoader, this.runnerType, this.sendSummary(), TestArgs$.MODULE$.parse(this.args())), ClassTag$.MODULE$.apply(Task.class));
    }

    public Option<String> receiveMessage(String summary) {
        SummaryProtocol$.MODULE$.deserialize(summary).foreach((Function1 & Serializable)s -> (Buffer)this.summaries().$plus$eq(s));
        return None$.MODULE$;
    }

    public String serializeTask(Task task, Function1<TaskDef, String> serializer) {
        return (String)serializer.apply((Object)task.taskDef());
    }

    public Task deserializeTask(String task, Function1<String, TaskDef> deserializer) {
        return ZTestTask$.MODULE$.apply((TaskDef)deserializer.apply((Object)task), this.testClassLoader, this.runnerType, this.sendSummary(), TestArgs$.MODULE$.parse(this.args()));
    }
}

