/*
 * Decompiled with CFR 0.152.
 */
package zio.intellij.testsupport;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Vector;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import zio.Has;
import zio.Ref$;
import zio.UIO$;
import zio.ZIO;
import zio.ZManaged;
import zio.ZRef;
import zio.ZRef$;
import zio.duration.Duration;
import zio.intellij.testsupport.TestRunnerAspects$;
import zio.test.DefaultTestReporter$;
import zio.test.RenderedResult;
import zio.test.Spec;
import zio.test.TestAnnotationMap;
import zio.test.TestAnnotationRenderer$;
import zio.test.TestFailure;
import zio.test.TestSuccess;
import zio.test.package;

public final class TestRunnerReporter$ {
    public static final TestRunnerReporter$ MODULE$ = new TestRunnerReporter$();

    public <E> Function2<Duration, Spec<Object, Nothing$, Either<TestFailure<E>, TestSuccess>>, ZIO<Has<package.TestLogger.Service>, Nothing$, BoxedUnit>> apply() {
        return (Function2 & Serializable)(x$4, executedSpec) -> MODULE$.render((Spec)executedSpec).flatMap((Function1 & Serializable)rendered -> package.TestLogger$.MODULE$.logLine(rendered.mkString("\n")).map((Function1 & Serializable)x$5 -> {
            TestRunnerReporter$.$anonfun$apply$3(x$5);
            return BoxedUnit.UNIT;
        }));
    }

    public <E> ZIO<Object, Nothing$, Seq<String>> render(Spec<Object, Nothing$, Either<TestFailure<E>, TestSuccess>> executedSpec) {
        return Ref$.MODULE$.make((Object)BoxesRunTime.boxToInteger((int)0)).flatMap((Function1 & Serializable)idCounter -> TestRunnerReporter$.loop$1(executedSpec, 0, idCounter));
    }

    private String suiteStarted(String label, int id, int parentId) {
        return this.tc(new StringBuilder(0).append(new StringBuilder(51).append("testSuiteStarted name='").append(this.escapeString(label)).append("' nodeId='").append(id).append("' parentNodeId='").append(parentId).append("' ").toString()).append("captureStandardOutput='false'").toString());
    }

    private String suiteFinished(String label, int id) {
        return this.tc(new StringBuilder(35).append("testSuiteFinished name='").append(this.escapeString(label)).append("' nodeId='").append(id).append("'").toString());
    }

    private String testStarted(String label, int id, int parentId) {
        return this.tc(new StringBuilder(0).append(new StringBuilder(46).append("testStarted name='").append(this.escapeString(label)).append("' nodeId='").append(id).append("' parentNodeId='").append(parentId).append("' ").toString()).append("captureStandardOutput='false'").toString());
    }

    private String testFinished(String label, int id, Option<String> timing) {
        String m = new StringBuilder(30).append("testFinished name='").append(this.escapeString(label)).append("' nodeId='").append(id).append("'").toString();
        return this.tc((String)timing.fold((Function0 & Serializable)() -> m, (Function1 & Serializable)t -> new StringBuilder(0).append(m).append(new StringBuilder(12).append(" duration='").append((String)t).append("'").toString()).toString()));
    }

    private String testIgnored(String label, int id) {
        return this.tc(new StringBuilder(29).append("testIgnored name='").append(this.escapeString(label)).append("' nodeId='").append(id).append("'").toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String testFailed(String label, int id, List<RenderedResult<String>> res) {
        if (!(res instanceof .colon.colon)) return this.tc(new StringBuilder(55).append("testFailed name='").append(this.escapeString(label)).append("' message='Assertion failed' nodeId='").append(id).append("'").toString());
        .colon.colon colon2 = (.colon.colon)res;
        RenderedResult r = (RenderedResult)colon2.head();
        List list = colon2.next$access$1();
        if (!Nil$.MODULE$.equals(list)) return this.tc(new StringBuilder(55).append("testFailed name='").append(this.escapeString(label)).append("' message='Assertion failed' nodeId='").append(id).append("'").toString());
        return this.tc(new StringBuilder(0).append(new StringBuilder(57).append("testFailed name='").append(this.escapeString(label)).append("' nodeId='").append(id).append("' message='Assertion failed:' ").toString()).append(new StringBuilder(10).append("details='").append(this.escapeString(((IterableOnceOps)r.rendered().drop(1)).mkString("\n"))).append("'").toString()).toString());
    }

    public String tc(String message) {
        return new StringBuilder(12).append("##teamcity[").append(message).append("]").toString();
    }

    public String escapeString(String str) {
        return str.replaceAll("[|]", "||").replaceAll("[']", "|'").replaceAll("[\n]", "|n").replaceAll("[\r]", "|r").replaceAll("]", "|]").replaceAll("\\[", "|[");
    }

    public static final /* synthetic */ void $anonfun$apply$3(BoxedUnit x$5) {
    }

    private static final ZIO newId$1(ZRef idCounter$1) {
        return ZRef.UnifiedSyntax$.MODULE$.updateAndGet$extension(ZRef$.MODULE$.UnifiedSyntax(idCounter$1), (Function1)(JFunction1.mcII.sp & Serializable)x$6 -> x$6 + 1);
    }

    public static final /* synthetic */ ZIO $anonfun$render$3(ZManaged executedSpecs$1, String label$1, int pid$1, ZRef idCounter$1, int id) {
        return executedSpecs$1.useNow().map((Function1 & Serializable)specs -> {
            String started = MODULE$.suiteStarted(label$1, id, pid$1);
            String finished = MODULE$.suiteFinished(label$1, id);
            return new Tuple3(specs, (Object)started, (Object)finished);
        }).flatMap((Function1 & Serializable)x$9 -> {
            if (x$9 == null) {
                throw new MatchError(null);
            }
            Vector specs = (Vector)x$9._1();
            String started = (String)x$9._2();
            String finished = (String)x$9._3();
            ZIO zIO = UIO$.MODULE$.foreach((Iterable)specs, (Function1 & Serializable)x$7 -> TestRunnerReporter$.loop$1(x$7, id, idCounter$1)).map((Function1 & Serializable)x$8 -> (List)x$8.flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)rest -> (List)((SeqOps)rest.$plus$colon((Object)started)).$colon$plus((Object)finished));
            return zIO;
        });
    }

    public static final /* synthetic */ ZIO $anonfun$render$9(Spec executedSpec$1, String label$2, int pid$1, ZIO result$1, TestAnnotationMap annotations$1, int id) {
        return DefaultTestReporter$.MODULE$.render(executedSpec$1, TestAnnotationRenderer$.MODULE$.default()).map((Function1 & Serializable)results -> {
            String started = MODULE$.testStarted(label$2, id, pid$1);
            return new Tuple2(results, (Object)started);
        }).flatMap((Function1 & Serializable)x$10 -> {
            if (x$10 == null) {
                throw new MatchError(null);
            }
            Seq results = (Seq)x$10._1();
            String started = (String)x$10._2();
            ZIO zIO = result$1.map((Function1 & Serializable)x0$1 -> {
                TestSuccess testSuccess;
                boolean bl = false;
                Right right = null;
                if (x0$1 instanceof Right) {
                    bl = true;
                    right = (Right)x0$1;
                    if ((TestSuccess)right.value() instanceof TestSuccess.Succeeded) {
                        List timing = TestRunnerAspects$.MODULE$.renderTiming().run((List)Nil$.MODULE$, annotations$1);
                        return (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{MODULE$.testFinished(label$2, id, (Option<String>)timing.headOption())}));
                    }
                }
                if (bl && TestSuccess.Ignored$.MODULE$.equals(testSuccess = (TestSuccess)right.value())) {
                    return (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{MODULE$.testIgnored(label$2, id)}));
                }
                if (!(x0$1 instanceof Left)) throw new MatchError(x0$1);
                return (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{MODULE$.testFailed(label$2, id, (List<RenderedResult<String>>)results.toList())}));
            }).map((Function1 & Serializable)finished -> (Seq)finished.$plus$colon((Object)started));
            return zIO;
        });
    }

    private static final ZIO loop$1(Spec executedSpec, int pid, ZRef idCounter$1) {
        ZIO zIO;
        Spec.SpecCase specCase = executedSpec.caseValue();
        if (specCase instanceof Spec.SuiteCase) {
            Spec.SuiteCase suiteCase = (Spec.SuiteCase)specCase;
            String label = suiteCase.label();
            ZManaged executedSpecs = suiteCase.specs();
            zIO = TestRunnerReporter$.newId$1(idCounter$1).flatMap((Function1 & Serializable)id -> TestRunnerReporter$.$anonfun$render$3(executedSpecs, label, pid, idCounter$1, BoxesRunTime.unboxToInt((Object)id)));
        } else if (specCase instanceof Spec.TestCase) {
            Spec.TestCase testCase = (Spec.TestCase)specCase;
            String label = testCase.label();
            ZIO result = testCase.test();
            TestAnnotationMap annotations = testCase.annotations();
            zIO = TestRunnerReporter$.newId$1(idCounter$1).flatMap((Function1 & Serializable)id -> TestRunnerReporter$.$anonfun$render$9(executedSpec, label, pid, result, annotations, BoxesRunTime.unboxToInt((Object)id)));
        } else {
            throw new MatchError((Object)specCase);
        }
        return zIO;
    }

    private TestRunnerReporter$() {
    }
}

