/*
 * Decompiled with CFR 0.152.
 */
package zio.stream.internal;

import java.io.Reader;
import scala.Option;
import scala.collection.Iterator;
import scala.package$;
import scala.runtime.BoxesRunTime;
import zio.Chunk;
import zio.Chunk$;
import zio.Runtime;
import zio.ZIO;
import zio.stream.internal.ZReader$;

public class ZReader
extends Reader {
    private Iterator chunks;
    private Chunk<Object> current;
    private int currentPos;
    private int currentChunkLen;
    private boolean done;

    public static <R> ZReader fromPull(Runtime<R> runtime, ZIO<R, Option<Throwable>, Chunk<Object>> zIO, Object object) {
        return ZReader$.MODULE$.fromPull(runtime, zIO, object);
    }

    public ZReader(Iterator<Chunk<Object>> chunks) {
        this.chunks = chunks;
        this.current = Chunk$.MODULE$.empty();
        this.currentPos = 0;
        this.currentChunkLen = 0;
        this.done = false;
    }

    private Iterator<Chunk<Object>> chunks() {
        return this.chunks;
    }

    private void chunks_$eq(Iterator<Chunk<Object>> x$0) {
        this.chunks = x$0;
    }

    private int availableInCurrentChunk() {
        return this.currentChunkLen - this.currentPos;
    }

    private char readOne() {
        char res = BoxesRunTime.unboxToChar((Object)this.current.apply(this.currentPos));
        ++this.currentPos;
        return res;
    }

    private void loadNext() {
        if (this.chunks().hasNext()) {
            this.current = (Chunk)this.chunks().next();
            this.currentChunkLen = this.current.length();
            this.currentPos = 0;
            return;
        }
        this.done = true;
    }

    @Override
    public int read() {
        return this.go$1();
    }

    @Override
    public int read(char[] cbuf, int off, int len) {
        if (this.done) {
            return -1;
        }
        if (len != 0) {
            int written = this.doRead(cbuf, off, len, 0);
            if (written == 0) {
                return -1;
            }
            return written;
        }
        return 0;
    }

    private int doRead(char[] cbuf, int off, int len, int written) {
        while (true) {
            if (len <= this.availableInCurrentChunk()) {
                this.readFromCurrentChunk(cbuf, off, len);
                return written + len;
            }
            int av = this.availableInCurrentChunk();
            this.readFromCurrentChunk(cbuf, off, av);
            this.loadNext();
            if (this.done) {
                return written + av;
            }
            int n = off + av;
            int n2 = len - av;
            int n3 = written + av;
            off = n;
            len = n2;
            written = n3;
        }
    }

    private void readFromCurrentChunk(char[] cbuf, int off, int len) {
        for (int i = 0; i < len; ++i) {
            cbuf[off + i] = this.readOne();
        }
    }

    @Override
    public void close() {
        this.chunks_$eq((Iterator<Chunk<Object>>)package$.MODULE$.Iterator().empty());
        this.loadNext();
    }

    private final int go$1() {
        while (!this.done) {
            if (this.availableInCurrentChunk() > 0) {
                return this.readOne();
            }
            this.loadNext();
        }
        return -1;
    }
}

