/*
 * Decompiled with CFR 0.152.
 */
package zio.internal.stacktracer.impl;

import java.io.DataInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;
import zio.internal.stacktracer.impl.AkkaLineNumbers;
import zio.internal.stacktracer.impl.AkkaLineNumbers$NoSourceInfo$;

public final class AkkaLineNumbers$ {
    public static final AkkaLineNumbers$ MODULE$ = new AkkaLineNumbers$();

    public final AkkaLineNumbers.Result apply(Object obj) {
        AkkaLineNumbers.Result result;
        Tuple3 tuple3;
        Option option = this.getStreamForLambda(obj).orElse((Function0 & Serializable)() -> MODULE$.getStreamForClass(obj.getClass()));
        if (option instanceof Some && (tuple3 = (Tuple3)((Some)option).value()) != null) {
            InputStream stream = (InputStream)tuple3._1();
            String className = (String)tuple3._2();
            Option methodName = (Option)tuple3._3();
            result = this.getInfo(stream, className, (Option<String>)methodName);
        } else if (None$.MODULE$.equals(option)) {
            result = AkkaLineNumbers$NoSourceInfo$.MODULE$;
        } else {
            throw new MatchError((Object)option);
        }
        return result;
    }

    private AkkaLineNumbers.Result getInfo(InputStream stream, String className, Option<String> methodName) {
        AkkaLineNumbers.UnknownSourceFormat unknownSourceFormat;
        block18: {
            AkkaLineNumbers.Result result;
            DataInputStream dis;
            block16: {
                dis = new DataInputStream(stream);
                try {
                    try {
                        Tuple2 tuple2;
                        AkkaLineNumbers.Result result2;
                        this.skipID(dis);
                        this.skipVersion(dis);
                        AkkaLineNumbers.Constants constants = this.getConstants(dis);
                        this.skipClassInfo(dis, constants);
                        this.skipInterfaceInfo(dis, constants);
                        this.skipFields(dis, constants);
                        Option<Tuple2<Object, Object>> lines = this.readMethods(dis, methodName, constants);
                        Option<String> source = this.readAttributes(dis, constants);
                        if (source.isEmpty()) {
                            result = AkkaLineNumbers$NoSourceInfo$.MODULE$;
                            break block16;
                        }
                        if (None$.MODULE$.equals(lines)) {
                            result2 = new AkkaLineNumbers.SourceFile((String)source.get());
                        } else if (lines instanceof Some && (tuple2 = (Tuple2)((Some)lines).value()) != null) {
                            int from = tuple2._1$mcI$sp();
                            int to = tuple2._2$mcI$sp();
                            result2 = new AkkaLineNumbers.SourceFileLines((String)source.get(), from, to, className, (String)methodName.getOrElse((Function0 & Serializable)() -> "apply"));
                        } else {
                            throw new MatchError(lines);
                        }
                        result = result2;
                    }
                    catch (Throwable throwable) {
                        if (!NonFatal$.MODULE$.apply(throwable)) {
                            throw throwable;
                        }
                        AkkaLineNumbers.UnknownSourceFormat unknownSourceFormat2 = new AkkaLineNumbers.UnknownSourceFormat(new StringBuilder(13).append("parse error: ").append(throwable.getMessage()).toString());
                        result = unknownSourceFormat2;
                    }
                }
                catch (Throwable throwable) {
                    block17: {
                        try {
                            dis.close();
                        }
                        catch (Throwable throwable2) {
                            if (throwable2 instanceof InterruptedException) {
                                throw (InterruptedException)throwable2;
                            }
                            if (throwable2 != null && !NonFatal$.MODULE$.unapply(throwable2).isEmpty()) break block17;
                            throw throwable2;
                        }
                    }
                    throw throwable;
                }
            }
            unknownSourceFormat = result;
            try {
                dis.close();
            }
            catch (Throwable throwable) {
                if (throwable instanceof InterruptedException) {
                    throw (InterruptedException)throwable;
                }
                if (throwable != null && !NonFatal$.MODULE$.unapply(throwable).isEmpty()) break block18;
                throw throwable;
            }
        }
        return unknownSourceFormat;
    }

    private Option<Tuple3<InputStream, String, None$>> getStreamForClass(Class<?> c) {
        None$ none$;
        try {
            InputStream r;
            String name = c.getName();
            String resource = new StringBuilder(6).append(name.replace('.', '/')).append(".class").toString();
            ClassLoader cl = c.getClassLoader();
            InputStream inputStream = r = cl != null ? cl.getResourceAsStream(resource) : null;
            if (r == null) {
                return None$.MODULE$;
            }
            none$ = new Some((Object)new Tuple3((Object)r, (Object)name, (Object)None$.MODULE$));
        }
        catch (Throwable throwable) {
            if (!NonFatal$.MODULE$.apply(throwable)) {
                throw throwable;
            }
            None$ none$2 = None$.MODULE$;
            none$ = none$2;
        }
        return none$;
    }

    private Option<Tuple3<InputStream, String, Some<String>>> getStreamForLambda(Object l) {
        try {
            None$ none$;
            Class<?> c = l.getClass();
            Method writeReplace = c.getDeclaredMethod("writeReplace", new Class[0]);
            writeReplace.setAccessible(true);
            Object object = writeReplace.invoke(l, new Object[0]);
            if (object instanceof SerializedLambda) {
                SerializedLambda serializedLambda = (SerializedLambda)object;
                InputStream r = c.getClassLoader().getResourceAsStream(new StringBuilder(6).append(serializedLambda.getImplClass()).append(".class").toString());
                none$ = r != null ? new Some((Object)new Tuple3((Object)r, (Object)serializedLambda.getImplClass(), (Object)new Some((Object)serializedLambda.getImplMethodName()))) : None$.MODULE$;
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        }
        catch (Throwable throwable) {
            if (!NonFatal$.MODULE$.apply(throwable)) {
                throw throwable;
            }
            None$ none$ = None$.MODULE$;
            return none$;
        }
    }

    private void skipID(DataInputStream d) {
        if (d.readInt() != -889275714) {
            throw new IllegalArgumentException("not a Java class file");
        }
    }

    private void skipVersion(DataInputStream d) {
        d.readShort();
        d.readShort();
    }

    /*
     * WARNING - void declaration
     */
    private AkkaLineNumbers.Constants getConstants(DataInputStream d) {
        void var3_3;
        int count = d.readUnsignedShort();
        AkkaLineNumbers.Constants c = new AkkaLineNumbers.Constants(count);
        while (!c.isDone()) {
            c.readOne(d);
        }
        c.resolve();
        return var3_3;
    }

    private void skipClassInfo(DataInputStream d, AkkaLineNumbers.Constants c) {
        this.zio$internal$stacktracer$impl$AkkaLineNumbers$$skip(d, 2);
        d.readUnsignedShort();
        this.zio$internal$stacktracer$impl$AkkaLineNumbers$$skip(d, 2);
    }

    private void skipInterfaceInfo(DataInputStream d, AkkaLineNumbers.Constants c) {
        int count = d.readUnsignedShort();
        for (int i = 1; i <= count; ++i) {
            d.readUnsignedShort();
        }
    }

    private void skipFields(DataInputStream d, AkkaLineNumbers.Constants c) {
        int count = d.readUnsignedShort();
        for (int i = 1; i <= count; ++i) {
            this.skipMethodOrField(d, c);
        }
    }

    private void skipMethodOrField(DataInputStream d, AkkaLineNumbers.Constants c) {
        this.zio$internal$stacktracer$impl$AkkaLineNumbers$$skip(d, 2);
        d.readUnsignedShort();
        this.zio$internal$stacktracer$impl$AkkaLineNumbers$$skip(d, 2);
        int attributes = d.readUnsignedShort();
        for (int i = 1; i <= attributes; ++i) {
            this.skipAttribute(d);
        }
    }

    private void skipAttribute(DataInputStream d) {
        this.zio$internal$stacktracer$impl$AkkaLineNumbers$$skip(d, 2);
        int length = d.readInt();
        this.zio$internal$stacktracer$impl$AkkaLineNumbers$$skip(d, length);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option<Tuple2<Object, Object>> readMethods(DataInputStream d, Option<String> methodName, AkkaLineNumbers.Constants c) {
        int count = d.readUnsignedShort();
        if (c.contains("Code") && c.contains("LineNumberTable")) {
            Tuple2 tuple2 = (Tuple2)((IterableOnceOps)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), count).flatMap((Function1 & Serializable)x$1 -> AkkaLineNumbers$.$anonfun$readMethods$1(d, c, methodName, BoxesRunTime.unboxToInt((Object)x$1)))).foldLeft((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)), (Object)BoxesRunTime.boxToInteger((int)0)), (Function2 & Serializable)(x0$1, x1$1) -> {
                int high;
                int low;
                block3: {
                    Tuple2 tuple2;
                    block2: {
                        tuple2 = new Tuple2(x0$1, x1$1);
                        if (x0$1 == null) break block2;
                        low = x0$1._1$mcI$sp();
                        high = x0$1._2$mcI$sp();
                        if (x1$1 != null) break block3;
                    }
                    throw new MatchError((Object)tuple2);
                }
                int start = x1$1._1$mcI$sp();
                int end = x1$1._2$mcI$sp();
                Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(Math.min(low, start), Math.max(high, end));
                return sp2;
            });
            if (tuple2 == null) return new Some((Object)tuple2);
            int n = tuple2._1$mcI$sp();
            int n2 = tuple2._2$mcI$sp();
            if (Integer.MAX_VALUE != n) return new Some((Object)tuple2);
            if (0 != n2) return new Some((Object)tuple2);
            return None$.MODULE$;
        }
        int i = 1;
        while (i <= count) {
            ++i;
            this.skipMethodOrField(d, c);
        }
        return None$.MODULE$;
    }

    private Option<Tuple2<Object, Object>> readMethod(DataInputStream d, int codeTag, int lineNumberTableTag, Option<String> methodName, AkkaLineNumbers.Constants c) {
        this.zio$internal$stacktracer$impl$AkkaLineNumbers$$skip(d, 2);
        int name = d.readUnsignedShort();
        this.zio$internal$stacktracer$impl$AkkaLineNumbers$$skip(d, 2);
        return RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), d.readUnsignedShort()).map((Function1 & Serializable)x$4 -> AkkaLineNumbers$.$anonfun$readMethod$1(d, codeTag, methodName, c, name, lineNumberTableTag, BoxesRunTime.unboxToInt((Object)x$4))).find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isDefined())).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Option<String> readAttributes(DataInputStream d, AkkaLineNumbers.Constants c) {
        int count = d.readUnsignedShort();
        if (c.contains("SourceFile")) {
            int s = c.apply("SourceFile");
            return ((IndexedSeqOps)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), count).map((Function1 & Serializable)x$6 -> AkkaLineNumbers$.$anonfun$readAttributes$1(d, s, c, BoxesRunTime.unboxToInt((Object)x$6))).flatten(Predef$.MODULE$.$conforms())).headOption();
        }
        return None$.MODULE$;
    }

    public void zio$internal$stacktracer$impl$AkkaLineNumbers$$skip(DataInputStream d, int length) {
        if (d.skipBytes(length) != length) {
            throw new IllegalArgumentException("class file ends prematurely");
        }
    }

    public static final /* synthetic */ List $anonfun$readMethods$1(DataInputStream d$1, AkkaLineNumbers.Constants c$1, Option methodName$1, int x$1) {
        return MODULE$.readMethod(d$1, c$1.apply("Code"), c$1.apply("LineNumberTable"), (Option<String>)methodName$1, c$1).toList();
    }

    public static final /* synthetic */ Option $anonfun$readMethod$2(DataInputStream d$2, int lineNumberTableTag$1, int x$3) {
        int tag = d$2.readUnsignedShort();
        int length = d$2.readInt();
        if (tag != lineNumberTableTag$1) {
            MODULE$.zio$internal$stacktracer$impl$AkkaLineNumbers$$skip(d$2, length);
            return None$.MODULE$;
        }
        IndexedSeq lines = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), d$2.readUnsignedShort()).map((Function1)(JFunction1.mcII.sp & Serializable)x$2 -> {
            MODULE$.zio$internal$stacktracer$impl$AkkaLineNumbers$$skip(d$2, 2);
            return d$2.readUnsignedShort();
        });
        return new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(lines.min((Ordering)Ordering.Int$.MODULE$)), lines.max((Ordering)Ordering.Int$.MODULE$)));
    }

    public static final /* synthetic */ Option $anonfun$readMethod$1(DataInputStream d$2, int codeTag$1, Option methodName$2, AkkaLineNumbers.Constants c$2, int name$1, int lineNumberTableTag$1, int x$4) {
        block3: {
            int length;
            block2: {
                int tag = d$2.readUnsignedShort();
                length = d$2.readInt();
                if (tag != codeTag$1) break block2;
                if (!methodName$2.isDefined()) break block3;
                String string = c$2.apply(name$1);
                Object object = methodName$2.get();
                if (!(string == null ? object != null : !string.equals(object))) break block3;
            }
            MODULE$.zio$internal$stacktracer$impl$AkkaLineNumbers$$skip(d$2, length);
            return None$.MODULE$;
        }
        MODULE$.zio$internal$stacktracer$impl$AkkaLineNumbers$$skip(d$2, 4);
        MODULE$.zio$internal$stacktracer$impl$AkkaLineNumbers$$skip(d$2, d$2.readInt());
        MODULE$.zio$internal$stacktracer$impl$AkkaLineNumbers$$skip(d$2, 8 * d$2.readUnsignedShort());
        return ((IndexedSeqOps)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), d$2.readUnsignedShort()).map((Function1 & Serializable)x$3 -> AkkaLineNumbers$.$anonfun$readMethod$2(d$2, lineNumberTableTag$1, BoxesRunTime.unboxToInt((Object)x$3))).flatten(Predef$.MODULE$.$conforms())).headOption();
    }

    public static final /* synthetic */ Option $anonfun$readAttributes$1(DataInputStream d$3, int s$1, AkkaLineNumbers.Constants c$3, int x$6) {
        int tag = d$3.readUnsignedShort();
        int length = d$3.readInt();
        if (tag != s$1) {
            MODULE$.zio$internal$stacktracer$impl$AkkaLineNumbers$$skip(d$3, length);
            return None$.MODULE$;
        }
        int name = d$3.readUnsignedShort();
        return new Some((Object)c$3.apply(name));
    }

    private AkkaLineNumbers$() {
    }
}

