/*
 * Decompiled with CFR 0.152.
 */
package zio.schema.validation;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.deriving.Mirror;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichChar;
import zio.schema.validation.Regex;
import zio.schema.validation.Regex$Alternate$;
import zio.schema.validation.Regex$Between$;
import zio.schema.validation.Regex$CharacterSet$;
import zio.schema.validation.Regex$Digit$;
import zio.schema.validation.Regex$Empty$;
import zio.schema.validation.Regex$Letter$;
import zio.schema.validation.Regex$Literal$;
import zio.schema.validation.Regex$Repeat$;
import zio.schema.validation.Regex$Sequence$;

public final class Regex$
implements Mirror.Sum,
Serializable {
    public static final Regex$CharacterSet$ CharacterSet;
    public static final Regex$Literal$ Literal;
    public static final Regex$Between$ Between;
    public static final Regex$Repeat$ Repeat;
    public static final Regex$Sequence$ Sequence;
    public static final Regex$Letter$ Letter;
    public static final Regex$Digit$ Digit;
    public static final Regex$Empty$ Empty;
    public static final Regex$Alternate$ Alternate;
    private static final Regex digit;
    private static final Regex digitNonZero;
    private static final Regex letter;
    private static final Regex digitOrLetter;
    private static final Regex hexDigit;
    private static final Regex hexDigitNonZero;
    public static final Regex$ MODULE$;

    private Regex$() {
    }

    static {
        MODULE$ = new Regex$();
        digit = Regex$Digit$.MODULE$;
        digitNonZero = MODULE$.between('1', '9');
        letter = Regex$Letter$.MODULE$;
        digitOrLetter = MODULE$.digit().$bar(MODULE$.letter());
        hexDigit = Regex$Digit$.MODULE$.$bar(MODULE$.between('a', 'f')).$bar(MODULE$.between('A', 'F'));
        hexDigitNonZero = MODULE$.digitNonZero().$bar(MODULE$.between('a', 'f')).$bar(MODULE$.between('A', 'F'));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Regex$.class);
    }

    public Regex between(char minChar, char maxChar) {
        return Regex$Between$.MODULE$.apply(minChar, maxChar);
    }

    public Regex filter(Function1<Object, Object> f) {
        return Regex$CharacterSet$.MODULE$.apply((Set<Object>)((IterableOnceOps)new RichChar(Predef$.MODULE$.charWrapper('\u0000')).to((Object)BoxesRunTime.boxToCharacter((char)'\uffff')).filter(f)).toSet());
    }

    public Regex literal(String str) {
        return Regex$Literal$.MODULE$.apply(str);
    }

    public Regex oneOf(Seq<Object> chars) {
        return Regex$CharacterSet$.MODULE$.apply((Set<Object>)chars.toSet());
    }

    public Regex digit() {
        return digit;
    }

    public Regex digitNonZero() {
        return digitNonZero;
    }

    public Regex letter() {
        return letter;
    }

    public Regex digitOrLetter() {
        return digitOrLetter;
    }

    public Regex hexDigit() {
        return hexDigit;
    }

    public Regex hexDigitNonZero() {
        return hexDigitNonZero;
    }

    private String escapeChar(char ch) {
        char c = ch;
        switch (c) {
            case '.': {
                return "\\.";
            }
            case '^': {
                return "\\^";
            }
            case '$': {
                return "\\$";
            }
            case '|': {
                return "\\|";
            }
            case '*': {
                return "\\*";
            }
            case '+': {
                return "\\+";
            }
            case '?': {
                return "\\?";
            }
            case '(': {
                return "\\(";
            }
            case ')': {
                return "\\)";
            }
            case '[': {
                return "\\[";
            }
            case ']': {
                return "\\]";
            }
            case '{': {
                return "\\{";
            }
            case '}': {
                return "\\}";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return BoxesRunTime.boxToCharacter((char)ch).toString();
    }

    public String toRegexString(Regex regex) {
        return this.loop$1(regex);
    }

    public int ordinal(Regex x$0) {
        Regex regex = x$0;
        if (regex instanceof Regex.CharacterSet) {
            return 0;
        }
        if (regex instanceof Regex.Literal) {
            return 1;
        }
        if (regex instanceof Regex.Between) {
            return 2;
        }
        if (regex instanceof Regex.Repeat) {
            return 3;
        }
        if (regex instanceof Regex.Sequence) {
            return 4;
        }
        if (regex == Regex$Letter$.MODULE$) {
            return 5;
        }
        if (regex == Regex$Digit$.MODULE$) {
            return 6;
        }
        if (regex == Regex$Empty$.MODULE$) {
            return 7;
        }
        if (regex instanceof Regex.Alternate) {
            return 8;
        }
        throw new MatchError((Object)regex);
    }

    private final /* synthetic */ String loop$1$$anonfun$1(char ch) {
        return this.escapeChar(ch);
    }

    private final /* synthetic */ String $anonfun$1(char ch) {
        return this.escapeChar(ch);
    }

    private final String loop$1(Regex regex) {
        Regex regex2 = regex;
        if (regex2 instanceof Regex.CharacterSet) {
            Regex.CharacterSet characterSet = Regex$CharacterSet$.MODULE$.unapply((Regex.CharacterSet)regex2);
            Set<Object> set = characterSet._1();
            Set<Object> elem = set;
            if (elem.size() == 1) {
                return this.escapeChar(BoxesRunTime.unboxToChar((Object)elem.head()));
            }
            Set<Object> set2 = set;
            return ((List)set2.toList().sorted((Ordering)Ordering.Char$.MODULE$)).map((Function1 & Serializable)ch -> this.loop$1$$anonfun$1(BoxesRunTime.unboxToChar((Object)ch))).mkString("[", "", "]");
        }
        if (regex2 instanceof Regex.Literal) {
            String string;
            Regex.Literal literal = Regex$Literal$.MODULE$.unapply((Regex.Literal)regex2);
            String str = string = literal._1();
            String escaped = StringOps$.MODULE$.flatMap$extension(Predef$.MODULE$.augmentString(str), (Function1 & Serializable)ch -> this.$anonfun$1(BoxesRunTime.unboxToChar((Object)ch)));
            return new StringBuilder(2).append("(").append(escaped).append(")").toString();
        }
        if (regex2 instanceof Regex.Between) {
            Regex.Between between = Regex$Between$.MODULE$.unapply((Regex.Between)regex2);
            char c = between._1();
            char c2 = between._2();
            char start = c;
            char end = c2;
            String escapedStart = this.escapeChar(start);
            String escapedEnd = this.escapeChar(end);
            return new StringBuilder(3).append("[").append(escapedStart).append("-").append(escapedEnd).append("]").toString();
        }
        if (regex2 instanceof Regex.Repeat) {
            Regex.Repeat repeat = Regex$Repeat$.MODULE$.unapply((Regex.Repeat)regex2);
            Regex regex3 = repeat._1();
            Option<Object> option = repeat._2();
            Option<Object> option2 = repeat._3();
            Regex regex4 = regex3;
            if (option instanceof Some) {
                int n = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                if (0 == n && None$.MODULE$.equals(option2)) {
                    return new StringBuilder(3).append("(").append(this.loop$1(regex4)).append(")*").toString();
                }
                Regex regex5 = regex3;
                if (1 == n && None$.MODULE$.equals(option2)) {
                    return new StringBuilder(3).append("(").append(this.loop$1(regex5)).append(")+").toString();
                }
            }
            Regex regex6 = regex3;
            if (None$.MODULE$.equals(option) && option2 instanceof Some && 1 == BoxesRunTime.unboxToInt((Object)((Some)option2).value())) {
                return new StringBuilder(3).append("(").append(this.loop$1(regex6)).append(")?").toString();
            }
            Regex regex7 = regex3;
            if (option instanceof Some) {
                int m;
                int n;
                int n2 = n = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                if (option2 instanceof Some && n2 == (m = BoxesRunTime.unboxToInt((Object)((Some)option2).value()))) {
                    return new StringBuilder(4).append("(").append(this.loop$1(regex7)).append("){").append(n2).append("}").toString();
                }
                Regex regex8 = regex3;
                int n3 = n;
                if (None$.MODULE$.equals(option2)) {
                    return new StringBuilder(5).append("(").append(this.loop$1(regex8)).append("){").append(n3).append(",}").toString();
                }
            }
            Regex regex9 = regex3;
            if (None$.MODULE$.equals(option) && option2 instanceof Some) {
                int m = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                return new StringBuilder(6).append("(").append(this.loop$1(regex9)).append("){0,").append(m).append("}").toString();
            }
            Regex regex10 = regex3;
            if (option instanceof Some) {
                int n = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                if (option2 instanceof Some) {
                    int m = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                    return new StringBuilder(5).append("(").append(this.loop$1(regex10)).append("){").append(n).append(",").append(m).append("}").toString();
                }
            }
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                throw new IllegalArgumentException("Cannot have no repeat count");
            }
        }
        if (Regex$Empty$.MODULE$.equals(regex2)) {
            return "";
        }
        if (regex2 instanceof Regex.Alternate) {
            Regex.Alternate alternate = Regex$Alternate$.MODULE$.unapply((Regex.Alternate)regex2);
            Regex regex11 = alternate._1();
            Regex regex12 = alternate._2();
            Regex left = regex11;
            Regex right = regex12;
            return new StringBuilder(7).append("((").append(this.loop$1(left)).append(")|(").append(this.loop$1(right)).append("))").toString();
        }
        if (Regex$Letter$.MODULE$.equals(regex2)) {
            return "[a-zA-Z]";
        }
        if (Regex$Digit$.MODULE$.equals(regex2)) {
            return "\\d";
        }
        if (regex2 instanceof Regex.Sequence) {
            Regex.Sequence sequence = Regex$Sequence$.MODULE$.unapply((Regex.Sequence)regex2);
            Regex regex13 = sequence._1();
            Regex regex14 = sequence._2();
            Regex first = regex13;
            Regex second = regex14;
            return new StringBuilder(0).append(this.loop$1(first)).append(this.loop$1(second)).toString();
        }
        throw new MatchError((Object)regex2);
    }
}

