/*
 * Decompiled with CFR 0.152.
 */
package zio.schema.ast;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import zio.Chunk;
import zio.Chunk$;
import zio.schema.StandardType;
import zio.schema.TypeId;
import zio.schema.ast.NodePath$;
import zio.schema.ast.NodePath$NodePathSyntax$;
import zio.schema.ast.SchemaAst;
import zio.schema.ast.SchemaAst$Dictionary$;
import zio.schema.ast.SchemaAst$Dynamic$;
import zio.schema.ast.SchemaAst$Either$;
import zio.schema.ast.SchemaAst$FailNode$;
import zio.schema.ast.SchemaAst$ListNode$;
import zio.schema.ast.SchemaAst$Product$;
import zio.schema.ast.SchemaAst$Ref$;
import zio.schema.ast.SchemaAst$Sum$;
import zio.schema.ast.SchemaAst$Tuple$;
import zio.schema.ast.SchemaAst$Value$;

public final class AstRenderer$
implements Serializable {
    private static final int INDENT_STEP;
    public static final AstRenderer$ MODULE$;

    private AstRenderer$() {
    }

    static {
        MODULE$ = new AstRenderer$();
        INDENT_STEP = 2;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(AstRenderer$.class);
    }

    public String render(SchemaAst ast) {
        String string;
        SchemaAst schemaAst = ast;
        if (schemaAst instanceof SchemaAst.Value) {
            SchemaAst.Value value = SchemaAst$Value$.MODULE$.unapply((SchemaAst.Value)schemaAst);
            StandardType<?> standardType = value._1();
            Chunk chunk = value._2();
            boolean bl = value._3();
            SchemaAst.Value v = (SchemaAst.Value)schemaAst;
            string = this.renderValue(v, 0, (Option<String>)None$.MODULE$);
        } else if (schemaAst instanceof SchemaAst.FailNode) {
            SchemaAst.FailNode failNode = SchemaAst$FailNode$.MODULE$.unapply((SchemaAst.FailNode)schemaAst);
            String string2 = failNode._1();
            Chunk chunk = failNode._2();
            boolean bl = failNode._3();
            SchemaAst.FailNode f = (SchemaAst.FailNode)schemaAst;
            string = this.renderFail(f, 0, (Option<String>)None$.MODULE$);
        } else if (schemaAst instanceof SchemaAst.Product) {
            SchemaAst.Product product = SchemaAst$Product$.MODULE$.unapply((SchemaAst.Product)schemaAst);
            TypeId typeId = product._1();
            Chunk chunk = product._2();
            Chunk<Tuple2<String, SchemaAst>> chunk2 = product._3();
            boolean bl = product._4();
            Chunk<Tuple2<String, SchemaAst>> fields = chunk2;
            boolean optional = bl;
            StringBuffer buffer = new StringBuffer();
            buffer.append("product");
            if (optional) {
                buffer.append("?");
            }
            string = buffer.append("\n").append(fields.map((Function1 & Serializable)_$44 -> this.renderField((Tuple2<String, SchemaAst>)_$44, INDENT_STEP)).mkString("\n")).toString();
        } else if (schemaAst instanceof SchemaAst.Tuple) {
            SchemaAst.Tuple tuple = SchemaAst$Tuple$.MODULE$.unapply((SchemaAst.Tuple)schemaAst);
            Chunk chunk = tuple._1();
            SchemaAst schemaAst2 = tuple._2();
            SchemaAst schemaAst3 = tuple._3();
            boolean bl = tuple._4();
            SchemaAst left = schemaAst2;
            SchemaAst right = schemaAst3;
            boolean optional = bl;
            StringBuffer buffer = new StringBuffer();
            buffer.append("tuple");
            if (optional) {
                buffer.append("?");
            }
            Object[] objectArray = new Tuple2[2];
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"left");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)left);
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"right");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)right);
            string = buffer.append("\n").append(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).map((Function1 & Serializable)_$45 -> this.renderField((Tuple2<String, SchemaAst>)_$45, INDENT_STEP)).mkString("\n")).toString();
        } else if (schemaAst instanceof SchemaAst.Sum) {
            SchemaAst.Sum sum = SchemaAst$Sum$.MODULE$.unapply((SchemaAst.Sum)schemaAst);
            TypeId typeId = sum._1();
            Chunk chunk = sum._2();
            Chunk<Tuple2<String, SchemaAst>> chunk3 = sum._3();
            boolean bl = sum._4();
            Chunk<Tuple2<String, SchemaAst>> cases = chunk3;
            boolean optional = bl;
            StringBuffer buffer = new StringBuffer();
            buffer.append("enum");
            if (optional) {
                buffer.append("?");
            }
            string = buffer.append("\n").append(cases.map((Function1 & Serializable)_$46 -> this.renderField((Tuple2<String, SchemaAst>)_$46, INDENT_STEP)).mkString("\n")).toString();
        } else if (schemaAst instanceof SchemaAst.Either) {
            SchemaAst.Either either = SchemaAst$Either$.MODULE$.unapply((SchemaAst.Either)schemaAst);
            Chunk chunk = either._1();
            SchemaAst schemaAst4 = either._2();
            SchemaAst schemaAst5 = either._3();
            boolean bl = either._4();
            SchemaAst left = schemaAst4;
            SchemaAst right = schemaAst5;
            boolean optional = bl;
            StringBuffer buffer = new StringBuffer();
            buffer.append("either");
            if (optional) {
                buffer.append("?");
            }
            Object[] objectArray = new Tuple2[2];
            String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"left");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)left);
            String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"right");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)right);
            string = buffer.append("\n").append(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).map((Function1 & Serializable)_$47 -> this.renderField((Tuple2<String, SchemaAst>)_$47, INDENT_STEP)).mkString("\n")).toString();
        } else if (schemaAst instanceof SchemaAst.ListNode) {
            SchemaAst.ListNode listNode = SchemaAst$ListNode$.MODULE$.unapply((SchemaAst.ListNode)schemaAst);
            SchemaAst schemaAst6 = listNode._1();
            Chunk chunk = listNode._2();
            boolean bl = listNode._3();
            SchemaAst items = schemaAst6;
            boolean optional = bl;
            StringBuffer buffer = new StringBuffer();
            buffer.append("list");
            if (optional) {
                buffer.append("?");
            }
            Object[] objectArray = new Tuple2[1];
            String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)"item");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, (Object)items);
            string = buffer.append("\n").append(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).map((Function1 & Serializable)_$48 -> this.renderField((Tuple2<String, SchemaAst>)_$48, INDENT_STEP)).mkString("\n")).toString();
        } else if (schemaAst instanceof SchemaAst.Dictionary) {
            SchemaAst.Dictionary dictionary = SchemaAst$Dictionary$.MODULE$.unapply((SchemaAst.Dictionary)schemaAst);
            SchemaAst schemaAst7 = dictionary._1();
            SchemaAst schemaAst8 = dictionary._2();
            Chunk chunk = dictionary._3();
            boolean bl = dictionary._4();
            SchemaAst keys = schemaAst7;
            SchemaAst values = schemaAst8;
            boolean optional = bl;
            StringBuffer buffer = new StringBuffer();
            buffer.append("map");
            if (optional) {
                buffer.append("?");
            }
            Object[] objectArray = new Tuple2[2];
            String string8 = (String)Predef$.MODULE$.ArrowAssoc((Object)"keys");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string8, (Object)keys);
            String string9 = (String)Predef$.MODULE$.ArrowAssoc((Object)"values");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string9, (Object)values);
            string = buffer.append("\n").append(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).map((Function1 & Serializable)_$49 -> this.renderField((Tuple2<String, SchemaAst>)_$49, INDENT_STEP)).mkString("\n")).toString();
        } else if (schemaAst instanceof SchemaAst.Ref) {
            SchemaAst.Ref ref = SchemaAst$Ref$.MODULE$.unapply((SchemaAst.Ref)schemaAst);
            Chunk chunk = ref._1();
            Chunk chunk4 = ref._2();
            boolean bl = ref._3();
            Chunk refPath = chunk;
            boolean optional = bl;
            StringBuffer buffer = new StringBuffer();
            buffer.append(new StringBuilder(4).append("ref#").append(refPath).toString());
            if (optional) {
                buffer.append("?");
            }
            string = buffer.toString();
        } else if (schemaAst instanceof SchemaAst.Dynamic) {
            SchemaAst.Dynamic dynamic = SchemaAst$Dynamic$.MODULE$.unapply((SchemaAst.Dynamic)schemaAst);
            boolean bl = dynamic._1();
            Chunk chunk = dynamic._2();
            boolean bl2 = dynamic._3();
            boolean withSchema = bl;
            boolean optional = bl2;
            StringBuffer buffer = new StringBuffer();
            buffer.append("list");
            if (optional) {
                buffer.append("?");
            }
            StringBuffer stringBuffer = withSchema ? buffer.append("semidynamic") : buffer.append("dynamic");
            string = buffer.toString();
        } else {
            throw new MatchError((Object)schemaAst);
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String renderField(Tuple2<String, SchemaAst> value, int indent) {
        String string;
        StringBuffer buffer = new StringBuffer();
        Tuple2<String, SchemaAst> tuple2 = value;
        if (tuple2 == null) throw Predef$.MODULE$.$qmark$qmark$qmark();
        String string2 = (String)tuple2._1();
        SchemaAst schemaAst = (SchemaAst)tuple2._2();
        String label = string2;
        if (schemaAst instanceof SchemaAst.Value) {
            SchemaAst.Value value2 = SchemaAst$Value$.MODULE$.unapply((SchemaAst.Value)schemaAst);
            StandardType<?> standardType = value2._1();
            Chunk chunk = value2._2();
            boolean bl = value2._3();
            SchemaAst.Value value3 = (SchemaAst.Value)schemaAst;
            string = this.renderValue(value3, indent, (Option<String>)Some$.MODULE$.apply((Object)label));
            return string;
        } else {
            String label2 = string2;
            if (schemaAst instanceof SchemaAst.FailNode) {
                SchemaAst.FailNode failNode = SchemaAst$FailNode$.MODULE$.unapply((SchemaAst.FailNode)schemaAst);
                String string3 = failNode._1();
                Chunk chunk = failNode._2();
                boolean bl = failNode._3();
                SchemaAst.FailNode fail = (SchemaAst.FailNode)schemaAst;
                string = this.renderFail(fail, indent, (Option<String>)Some$.MODULE$.apply((Object)label2));
                return string;
            } else {
                String label3 = string2;
                if (schemaAst instanceof SchemaAst.Product) {
                    SchemaAst.Product product = SchemaAst$Product$.MODULE$.unapply((SchemaAst.Product)schemaAst);
                    TypeId typeId = product._1();
                    Chunk chunk = product._2();
                    Chunk<Tuple2<String, SchemaAst>> chunk2 = product._3();
                    boolean bl = product._4();
                    Chunk<Tuple2<String, SchemaAst>> fields = chunk2;
                    boolean optional = bl;
                    this.pad(buffer, indent);
                    buffer.append(new StringBuilder(8).append(label3).append(": record").toString());
                    if (optional) {
                        buffer.append("?");
                    }
                    string = buffer.append("\n").append(fields.map((Function1 & Serializable)_$50 -> this.renderField((Tuple2<String, SchemaAst>)_$50, indent + INDENT_STEP)).mkString("\n")).toString();
                    return string;
                } else {
                    String label4 = string2;
                    if (schemaAst instanceof SchemaAst.Tuple) {
                        SchemaAst.Tuple tuple = SchemaAst$Tuple$.MODULE$.unapply((SchemaAst.Tuple)schemaAst);
                        Chunk chunk = tuple._1();
                        SchemaAst schemaAst2 = tuple._2();
                        SchemaAst schemaAst3 = tuple._3();
                        boolean bl = tuple._4();
                        SchemaAst left = schemaAst2;
                        SchemaAst right = schemaAst3;
                        boolean optional = bl;
                        this.pad(buffer, indent);
                        buffer.append(new StringBuilder(7).append(label4).append(": tuple").toString());
                        if (optional) {
                            buffer.append("?");
                        }
                        Object[] objectArray = new Tuple2[2];
                        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"left");
                        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)left);
                        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"right");
                        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)right);
                        string = buffer.append("\n").append(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).map((Function1 & Serializable)_$51 -> this.renderField((Tuple2<String, SchemaAst>)_$51, indent + INDENT_STEP)).mkString("\n")).toString();
                        return string;
                    } else {
                        String label5 = string2;
                        if (schemaAst instanceof SchemaAst.Sum) {
                            SchemaAst.Sum sum = SchemaAst$Sum$.MODULE$.unapply((SchemaAst.Sum)schemaAst);
                            TypeId typeId = sum._1();
                            Chunk chunk = sum._2();
                            Chunk<Tuple2<String, SchemaAst>> chunk3 = sum._3();
                            boolean bl = sum._4();
                            Chunk<Tuple2<String, SchemaAst>> cases = chunk3;
                            boolean optional = bl;
                            this.pad(buffer, indent);
                            buffer.append(new StringBuilder(6).append(label5).append(": enum").toString());
                            if (optional) {
                                buffer.append("?");
                            }
                            string = buffer.append("\n").append(cases.map((Function1 & Serializable)_$52 -> this.renderField((Tuple2<String, SchemaAst>)_$52, indent + INDENT_STEP)).mkString("\n")).toString();
                            return string;
                        } else {
                            String label6 = string2;
                            if (schemaAst instanceof SchemaAst.Either) {
                                SchemaAst.Either either = SchemaAst$Either$.MODULE$.unapply((SchemaAst.Either)schemaAst);
                                Chunk chunk = either._1();
                                SchemaAst schemaAst4 = either._2();
                                SchemaAst schemaAst5 = either._3();
                                boolean bl = either._4();
                                SchemaAst left = schemaAst4;
                                SchemaAst right = schemaAst5;
                                boolean optional = bl;
                                this.pad(buffer, indent);
                                buffer.append(new StringBuilder(8).append(label6).append(": either").toString());
                                if (optional) {
                                    buffer.append("?");
                                }
                                Object[] objectArray = new Tuple2[2];
                                String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"left");
                                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)left);
                                String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)"right");
                                objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, (Object)right);
                                string = buffer.append("\n").append(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).map((Function1 & Serializable)_$53 -> this.renderField((Tuple2<String, SchemaAst>)_$53, indent + INDENT_STEP)).mkString("\n")).toString();
                                return string;
                            } else {
                                String label7 = string2;
                                if (schemaAst instanceof SchemaAst.ListNode) {
                                    SchemaAst.ListNode listNode = SchemaAst$ListNode$.MODULE$.unapply((SchemaAst.ListNode)schemaAst);
                                    SchemaAst schemaAst6 = listNode._1();
                                    Chunk chunk = listNode._2();
                                    boolean bl = listNode._3();
                                    SchemaAst items = schemaAst6;
                                    boolean optional = bl;
                                    StringBuffer buffer2 = new StringBuffer();
                                    buffer2.append(new StringBuilder(6).append(label7).append(": list").toString());
                                    if (optional) {
                                        buffer2.append("?");
                                    }
                                    Object[] objectArray = new Tuple2[1];
                                    String string8 = (String)Predef$.MODULE$.ArrowAssoc((Object)"item");
                                    objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string8, (Object)items);
                                    string = buffer2.append("\n").append(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).map((Function1 & Serializable)_$54 -> this.renderField((Tuple2<String, SchemaAst>)_$54, INDENT_STEP)).mkString("\n")).toString();
                                    return string;
                                } else {
                                    String label8 = string2;
                                    if (schemaAst instanceof SchemaAst.Dictionary) {
                                        SchemaAst.Dictionary dictionary = SchemaAst$Dictionary$.MODULE$.unapply((SchemaAst.Dictionary)schemaAst);
                                        SchemaAst schemaAst7 = dictionary._1();
                                        SchemaAst schemaAst8 = dictionary._2();
                                        Chunk chunk = dictionary._3();
                                        boolean bl = dictionary._4();
                                        SchemaAst keys = schemaAst7;
                                        SchemaAst values = schemaAst8;
                                        boolean optional = bl;
                                        StringBuffer buffer3 = new StringBuffer();
                                        buffer3.append(new StringBuilder(5).append(label8).append(": map").toString());
                                        if (optional) {
                                            buffer3.append("?");
                                        }
                                        Object[] objectArray = new Tuple2[2];
                                        String string9 = (String)Predef$.MODULE$.ArrowAssoc((Object)"keys");
                                        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string9, (Object)keys);
                                        String string10 = (String)Predef$.MODULE$.ArrowAssoc((Object)"values");
                                        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string10, (Object)values);
                                        string = buffer3.append("\n").append(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).map((Function1 & Serializable)_$55 -> this.renderField((Tuple2<String, SchemaAst>)_$55, INDENT_STEP)).mkString("\n")).toString();
                                        return string;
                                    } else {
                                        String label9 = string2;
                                        if (schemaAst instanceof SchemaAst.Ref) {
                                            SchemaAst.Ref ref = SchemaAst$Ref$.MODULE$.unapply((SchemaAst.Ref)schemaAst);
                                            Chunk chunk = ref._1();
                                            Chunk chunk4 = ref._2();
                                            boolean bl = ref._3();
                                            Chunk refPath = chunk;
                                            boolean optional = bl;
                                            this.pad(buffer, indent);
                                            buffer.append(new StringBuilder(2).append(label9).append(": ").toString());
                                            if (optional) {
                                                buffer.append("?");
                                            }
                                            string = buffer.append(new StringBuilder(6).append("{ref#").append(NodePath$NodePathSyntax$.MODULE$.render$extension(NodePath$.MODULE$.NodePathSyntax(refPath))).append("}").toString()).toString();
                                            return string;
                                        } else {
                                            String label10 = string2;
                                            if (!(schemaAst instanceof SchemaAst.Dynamic)) throw Predef$.MODULE$.$qmark$qmark$qmark();
                                            SchemaAst.Dynamic dynamic = SchemaAst$Dynamic$.MODULE$.unapply((SchemaAst.Dynamic)schemaAst);
                                            boolean bl = dynamic._1();
                                            Chunk chunk = dynamic._2();
                                            boolean bl2 = dynamic._3();
                                            boolean withSchema = bl;
                                            boolean optional = bl2;
                                            this.pad(buffer, indent);
                                            buffer.append(new StringBuilder(2).append(label10).append(": ").toString());
                                            if (optional) {
                                                buffer.append("?");
                                            }
                                            StringBuffer stringBuffer = withSchema ? buffer.append("semidynamic") : buffer.append("dynamic");
                                            string = buffer.toString();
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return string;
    }

    public String renderValue(SchemaAst.Value value, int indent, Option<String> label) {
        StringBuffer buffer = new StringBuffer();
        this.pad(buffer, indent);
        label.foreach((Function1 & Serializable)l -> buffer.append(new StringBuilder(2).append((String)l).append(": ").toString()));
        if (value.optional()) {
            buffer.append("?");
        }
        return buffer.append(value.valueType().tag()).toString();
    }

    public String renderFail(SchemaAst.FailNode fail, int indent, Option<String> label) {
        StringBuffer buffer = new StringBuffer();
        this.pad(buffer, indent);
        label.foreach((Function1 & Serializable)l -> buffer.append(new StringBuilder(2).append((String)l).append(": ").toString()));
        if (fail.optional()) {
            buffer.append("?");
        }
        return buffer.append(new StringBuilder(6).append("FAIL: ").append(fail.message()).toString()).toString();
    }

    private StringBuffer pad(StringBuffer buffer, int indent) {
        if (indent > 0) {
            buffer.append("|");
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), indent).foreach((Function1 & Serializable)x$1 -> this.pad$$anonfun$1(buffer, BoxesRunTime.unboxToInt((Object)x$1)));
        }
        return buffer;
    }

    private final /* synthetic */ StringBuffer pad$$anonfun$1(StringBuffer buffer$3, int x$1) {
        int n = x$1;
        return buffer$3.append("-");
    }
}

