/*
 * Decompiled with CFR 0.152.
 */
package zio.schema;

import java.io.Serializable;
import java.math.BigInteger;
import java.math.MathContext;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.Nil$;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import zio.Chunk;
import zio.Chunk$;
import zio.schema.Diff$;
import zio.schema.Diff$BigDecimal$;
import zio.schema.Diff$BigInt$;
import zio.schema.Diff$Bool$;
import zio.schema.Diff$EitherDiff$;
import zio.schema.Diff$Identical$;
import zio.schema.Diff$LCS$;
import zio.schema.Diff$NotComparable$;
import zio.schema.Diff$Number$;
import zio.schema.Diff$Record$;
import zio.schema.Diff$SchemaMigration$;
import zio.schema.Diff$Temporal$;
import zio.schema.Diff$Total$;
import zio.schema.Diff$Transform$;
import zio.schema.Diff$Tuple$;
import zio.schema.Diff$ZonedDateTime$;
import zio.schema.DynamicValue;
import zio.schema.DynamicValue$Record$;
import zio.schema.Schema;
import zio.schema.StandardType;
import zio.schema.StandardType$DayOfWeekType$;
import zio.schema.StandardType$DurationType$;
import zio.schema.StandardType$MonthDayType$;
import zio.schema.StandardType$MonthType$;
import zio.schema.StandardType$PeriodType$;
import zio.schema.StandardType$YearMonthType$;
import zio.schema.StandardType$YearType$;
import zio.schema.StandardType$ZoneOffsetType$;
import zio.schema.TypeId;
import zio.schema.ast.Migration;
import zio.schema.diff.Edit;
import zio.schema.diff.Edit$Delete$;
import zio.schema.diff.Edit$Insert$;
import zio.schema.diff.Edit$Keep$;

public interface Diff<A> {
    public static <A> Identical<A> identical() {
        return Diff$.MODULE$.identical();
    }

    public static <A> NotComparable<A> notComparable() {
        return Diff$.MODULE$.notComparable();
    }

    public static Diff $less$times$greater$(Diff $this, Diff that) {
        return $this.$less$times$greater(that);
    }

    default public <B> Diff<Tuple2<A, B>> $less$times$greater(Diff<B> that) {
        return this.zip(that);
    }

    public static Diff zip$(Diff $this, Diff that) {
        return $this.zip(that);
    }

    default public <B> Diff<Tuple2<A, B>> zip(Diff<B> that) {
        return Diff$Tuple$.MODULE$.apply(this, that);
    }

    public Either<String, A> patch(A var1);

    public static boolean isIdentical$(Diff $this) {
        return $this.isIdentical();
    }

    default public boolean isIdentical() {
        return false;
    }

    public static boolean isComparable$(Diff $this) {
        return $this.isComparable();
    }

    default public boolean isComparable() {
        return true;
    }

    public static final class BigDecimal
    implements Diff<java.math.BigDecimal>,
    Product,
    Serializable {
        private final java.math.BigDecimal distance;
        private final int precision;

        public static BigDecimal apply(java.math.BigDecimal bigDecimal, int n) {
            return Diff$BigDecimal$.MODULE$.apply(bigDecimal, n);
        }

        public static BigDecimal fromProduct(Product product) {
            return Diff$BigDecimal$.MODULE$.fromProduct(product);
        }

        public static BigDecimal unapply(BigDecimal bigDecimal) {
            return Diff$BigDecimal$.MODULE$.unapply(bigDecimal);
        }

        public BigDecimal(java.math.BigDecimal distance, int precision) {
            this.distance = distance;
            this.precision = precision;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.distance()));
            n = Statics.mix((int)n, (int)this.precision());
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof BigDecimal)) return false;
            BigDecimal bigDecimal = (BigDecimal)object;
            if (this.precision() != bigDecimal.precision()) return false;
            if (!BoxesRunTime.equals((Object)this.distance(), (Object)bigDecimal.distance())) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof BigDecimal;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "BigDecimal";
        }

        public Object productElement(int n) {
            java.lang.Number number;
            int n2 = n;
            if (0 == n2) {
                number = this._1();
            } else if (1 == n2) {
                number = BoxesRunTime.boxToInteger((int)this._2());
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return number;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "distance";
            } else if (1 == n2) {
                string = "precision";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public java.math.BigDecimal distance() {
            return this.distance;
        }

        public int precision() {
            return this.precision;
        }

        @Override
        public Either<String, java.math.BigDecimal> patch(java.math.BigDecimal input) {
            MathContext mc = new MathContext(this.precision());
            return package$.MODULE$.Right().apply((Object)input.round(mc).subtract(this.distance(), mc));
        }

        public BigDecimal copy(java.math.BigDecimal distance, int precision) {
            return new BigDecimal(distance, precision);
        }

        public java.math.BigDecimal copy$default$1() {
            return this.distance();
        }

        public int copy$default$2() {
            return this.precision();
        }

        public java.math.BigDecimal _1() {
            return this.distance();
        }

        public int _2() {
            return this.precision();
        }
    }

    public static final class BigInt
    implements Diff<BigInteger>,
    Product,
    Serializable {
        private final BigInteger distance;

        public static BigInt apply(BigInteger bigInteger) {
            return Diff$BigInt$.MODULE$.apply(bigInteger);
        }

        public static BigInt fromProduct(Product product) {
            return Diff$BigInt$.MODULE$.fromProduct(product);
        }

        public static BigInt unapply(BigInt bigInt) {
            return Diff$BigInt$.MODULE$.unapply(bigInt);
        }

        public BigInt(BigInteger distance) {
            this.distance = distance;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof BigInt)) return false;
            BigInt bigInt = (BigInt)object;
            if (!BoxesRunTime.equals((Object)this.distance(), (Object)bigInt.distance())) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof BigInt;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "BigInt";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "distance";
        }

        public BigInteger distance() {
            return this.distance;
        }

        @Override
        public Either<String, BigInteger> patch(BigInteger input) {
            return package$.MODULE$.Right().apply((Object)input.subtract(this.distance()));
        }

        public BigInt copy(BigInteger distance) {
            return new BigInt(distance);
        }

        public BigInteger copy$default$1() {
            return this.distance();
        }

        public BigInteger _1() {
            return this.distance();
        }
    }

    public static final class Bool
    implements Diff<Object>,
    Product,
    Serializable {
        private final boolean xor;

        public static Bool apply(boolean bl) {
            return Diff$Bool$.MODULE$.apply(bl);
        }

        public static Bool fromProduct(Product product) {
            return Diff$Bool$.MODULE$.fromProduct(product);
        }

        public static Bool unapply(Bool bool) {
            return Diff$Bool$.MODULE$.unapply(bool);
        }

        public Bool(boolean xor) {
            this.xor = xor;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)(this.xor() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Bool)) return false;
            Bool bool = (Bool)object;
            if (this.xor() != bool.xor()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Bool;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Bool";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToBoolean((boolean)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "xor";
        }

        public boolean xor() {
            return this.xor;
        }

        @Override
        public Either<String, Object> patch(boolean a) {
            return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToBoolean((boolean)(a ^ this.xor())));
        }

        public Bool copy(boolean xor) {
            return new Bool(xor);
        }

        public boolean copy$default$1() {
            return this.xor();
        }

        public boolean _1() {
            return this.xor();
        }
    }

    public static final class EitherDiff<A, B>
    implements Diff<Either<A, B>>,
    Product,
    Serializable {
        private final Either diff;

        public static <A, B> EitherDiff<A, B> apply(Either<Diff<A>, Diff<B>> either) {
            return Diff$EitherDiff$.MODULE$.apply(either);
        }

        public static EitherDiff<?, ?> fromProduct(Product product) {
            return Diff$EitherDiff$.MODULE$.fromProduct(product);
        }

        public static <A, B> EitherDiff<A, B> unapply(EitherDiff<A, B> eitherDiff) {
            return Diff$EitherDiff$.MODULE$.unapply(eitherDiff);
        }

        public EitherDiff(Either<Diff<A>, Diff<B>> diff) {
            this.diff = diff;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof EitherDiff)) return false;
            EitherDiff eitherDiff = (EitherDiff)object;
            Either<Diff<A>, Diff<B>> either = this.diff();
            Either<Diff<A>, Diff<B>> either2 = eitherDiff.diff();
            if (either != null) {
                if (!either.equals(either2)) return false;
                return true;
            }
            if (either2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof EitherDiff;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "EitherDiff";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "diff";
        }

        public Either<Diff<A>, Diff<B>> diff() {
            return this.diff;
        }

        @Override
        public boolean isIdentical() {
            return BoxesRunTime.unboxToBoolean((Object)this.diff().fold((Function1 & Serializable)_$19 -> _$19.isIdentical(), (Function1 & Serializable)_$20 -> _$20.isIdentical()));
        }

        @Override
        public boolean isComparable() {
            return BoxesRunTime.unboxToBoolean((Object)this.diff().fold((Function1 & Serializable)_$21 -> _$21.isComparable(), (Function1 & Serializable)_$22 -> _$22.isComparable()));
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public Either<String, Either<A, B>> patch(Either<A, B> input) {
            Left left;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(input, this.diff());
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Either either = (Either)tuple2._1();
            Either either2 = (Either)tuple2._2();
            if (either instanceof Left && either2 instanceof Right) {
                left = package$.MODULE$.Left().apply((Object)"Cannot apply a right diff to a left value");
                return left;
            }
            if (either instanceof Right && either2 instanceof Left) {
                left = package$.MODULE$.Left().apply((Object)"Cannot apply a left diff to a right value");
                return left;
            }
            if (either instanceof Left) {
                Object in = ((Left)either).value();
                if (either2 instanceof Left) {
                    Diff diff = (Diff)((Left)either2).value();
                    left = diff.patch(in).map((Function1 & Serializable)_$23 -> package$.MODULE$.Left().apply(_$23));
                    return left;
                }
            }
            if (!(either instanceof Right)) throw new MatchError((Object)tuple2);
            Object in = ((Right)either).value();
            if (!(either2 instanceof Right)) throw new MatchError((Object)tuple2);
            Diff diff = (Diff)((Right)either2).value();
            left = diff.patch(in).map((Function1 & Serializable)_$24 -> package$.MODULE$.Right().apply(_$24));
            return left;
        }

        public <A, B> EitherDiff<A, B> copy(Either<Diff<A>, Diff<B>> diff) {
            return new EitherDiff<A, B>(diff);
        }

        public <A, B> Either<Diff<A>, Diff<B>> copy$default$1() {
            return this.diff();
        }

        public Either<Diff<A>, Diff<B>> _1() {
            return this.diff();
        }
    }

    public static final class Identical<A>
    implements Diff<A>,
    Product,
    Serializable {
        public static <A> Identical<A> apply() {
            return Diff$Identical$.MODULE$.apply();
        }

        public static Identical<?> fromProduct(Product product) {
            return Diff$Identical$.MODULE$.fromProduct(product);
        }

        public static <A> boolean unapply(Identical<A> identical) {
            return Diff$Identical$.MODULE$.unapply(identical);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Identical)) return false;
            Identical identical = (Identical)object;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Identical;
        }

        public int productArity() {
            return 0;
        }

        public String productPrefix() {
            return "Identical";
        }

        public Object productElement(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Either<String, A> patch(A a) {
            return package$.MODULE$.Right().apply(a);
        }

        @Override
        public boolean isIdentical() {
            return true;
        }

        public <A> Identical<A> copy() {
            return new Identical<A>();
        }
    }

    public static final class LCS<A>
    implements Diff<Chunk<A>>,
    Product,
    Serializable {
        private final Chunk edits;

        public static <A> LCS<A> apply(Chunk<Edit<A>> chunk) {
            return Diff$LCS$.MODULE$.apply(chunk);
        }

        public static LCS<?> fromProduct(Product product) {
            return Diff$LCS$.MODULE$.fromProduct(product);
        }

        public static <A> LCS<A> unapply(LCS<A> lCS) {
            return Diff$LCS$.MODULE$.unapply(lCS);
        }

        public LCS(Chunk<Edit<A>> edits) {
            this.edits = edits;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof LCS)) return false;
            LCS lCS = (LCS)object;
            Chunk<Edit<A>> chunk = this.edits();
            Chunk<Edit<A>> chunk2 = lCS.edits();
            if (chunk != null) {
                if (!chunk.equals(chunk2)) return false;
                return true;
            }
            if (chunk2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof LCS;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "LCS";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "edits";
        }

        public Chunk<Edit<A>> edits() {
            return this.edits;
        }

        @Override
        public Either<String, Chunk<A>> patch(Chunk<A> as) {
            return this.calc$1(as.toList(), this.edits().toList(), (List)package$.MODULE$.Nil());
        }

        public <A> LCS<A> copy(Chunk<Edit<A>> edits) {
            return new LCS<A>(edits);
        }

        public <A> Chunk<Edit<A>> copy$default$1() {
            return this.edits();
        }

        public Chunk<Edit<A>> _1() {
            return this.edits();
        }

        /*
         * Enabled aggressive block sorting
         */
        private final Either calc$1(List in, List edits, List result) {
            Left left;
            List list;
            List list2;
            Tuple2 tuple2;
            List list3;
            block24: {
                list3 = result;
                List list4 = edits;
                List list5 = in;
                while ((tuple2 = Tuple2$.MODULE$.apply((Object)list5, (Object)list4)) != null) {
                    list2 = (List)tuple2._1();
                    list = (List)tuple2._2();
                    if (list2 instanceof .colon.colon) {
                        List list6 = ((.colon.colon)list2).next$access$1();
                        Nil$ nil$ = package$.MODULE$.Nil();
                        List list7 = list;
                        if (!(nil$ != null ? !nil$.equals(list7) : list7 != null)) {
                            left = package$.MODULE$.Left().apply((Object)new StringBuilder(51).append("Incorrect Diff - no instructions for these items: ").append(list5.mkString()).append(".").toString());
                            return left;
                        }
                        Object h = ((.colon.colon)list2).head();
                        if (list instanceof .colon.colon) {
                            Edit.Delete delete;
                            Object a;
                            Object s;
                            Edit edit = (Edit)((.colon.colon)list).head();
                            List list8 = ((.colon.colon)list).next$access$1();
                            if (edit instanceof Edit.Delete && !BoxesRunTime.equals(s = (a = (delete = Edit$Delete$.MODULE$.unapply((Edit.Delete)edit))._1()), (Object)h)) {
                                left = package$.MODULE$.Left().apply((Object)new StringBuilder(36).append("Cannot Delete ").append(s).append(" - current letter is ").append(h).append(".").toString());
                                return left;
                            }
                        }
                    }
                    Nil$ nil$ = package$.MODULE$.Nil();
                    List list9 = list2;
                    if (!(nil$ != null ? !nil$.equals(list9) : list9 != null) && list instanceof .colon.colon) {
                        Edit edit = (Edit)((.colon.colon)list).head();
                        List list10 = ((.colon.colon)list).next$access$1();
                        if (edit instanceof Edit.Delete) {
                            Object a;
                            Edit.Delete delete = Edit$Delete$.MODULE$.unapply((Edit.Delete)edit);
                            Object s = a = delete._1();
                            left = package$.MODULE$.Left().apply((Object)new StringBuilder(41).append("Cannot Delete ").append(s).append(" - no items left to delete.").toString());
                            return left;
                        }
                    }
                    if (list2 instanceof .colon.colon) {
                        List list11;
                        .colon.colon colon2 = (.colon.colon)list2;
                        List t = list11 = colon2.next$access$1();
                        if (list instanceof .colon.colon) {
                            Edit.Keep keep;
                            Object a;
                            Object s;
                            .colon.colon colon3 = (.colon.colon)list;
                            Edit edit = (Edit)colon3.head();
                            List list12 = colon3.next$access$1();
                            if (edit instanceof Edit.Delete) {
                                Edit.Delete delete = Edit$Delete$.MODULE$.unapply((Edit.Delete)edit);
                                Object a2 = delete._1();
                                List tail = list12;
                                List list13 = t;
                                List list14 = tail;
                                list5 = list13;
                                list4 = list14;
                                continue;
                            }
                            Object h = colon2.head();
                            if (edit instanceof Edit.Keep && !BoxesRunTime.equals(s = (a = (keep = Edit$Keep$.MODULE$.unapply((Edit.Keep)edit))._1()), (Object)h)) {
                                left = package$.MODULE$.Left().apply((Object)new StringBuilder(34).append("Cannot Keep ").append(s).append(" - current letter is ").append(h).append(".").toString());
                                return left;
                            }
                        }
                    }
                    Nil$ nil$2 = package$.MODULE$.Nil();
                    List list15 = list2;
                    if (!(nil$2 != null ? !nil$2.equals(list15) : list15 != null) && list instanceof .colon.colon) {
                        Edit edit = (Edit)((.colon.colon)list).head();
                        List list16 = ((.colon.colon)list).next$access$1();
                        if (edit instanceof Edit.Keep) {
                            Object a;
                            Edit.Keep keep = Edit$Keep$.MODULE$.unapply((Edit.Keep)edit);
                            Object s = a = keep._1();
                            left = package$.MODULE$.Left().apply((Object)new StringBuilder(37).append("Cannot Keep ").append(s).append(" - no items left to keep.").toString());
                            return left;
                        }
                    }
                    if (list2 instanceof .colon.colon) {
                        .colon.colon colon4 = (.colon.colon)list2;
                        List list17 = colon4.next$access$1();
                        Object h = colon4.head();
                        List t = list17;
                        if (list instanceof .colon.colon) {
                            .colon.colon colon5 = (.colon.colon)list;
                            List list18 = colon5.next$access$1();
                            if (colon5.head() instanceof Edit.Keep) {
                                Edit.Keep keep = Edit$Keep$.MODULE$.unapply((Edit.Keep)colon5.head());
                                Object a = keep._1();
                                List tail = list18;
                                List list19 = t;
                                List list20 = tail;
                                List list21 = (List)list3.$colon$plus(h);
                                list5 = list19;
                                list4 = list20;
                                list3 = list21;
                                continue;
                            }
                        }
                    }
                    List in2 = list2;
                    if (list instanceof .colon.colon) {
                        .colon.colon colon6 = (.colon.colon)list;
                        Edit edit = (Edit)colon6.head();
                        List list22 = colon6.next$access$1();
                        if (edit instanceof Edit.Insert) {
                            Object a;
                            Edit.Insert insert = Edit$Insert$.MODULE$.unapply((Edit.Insert)edit);
                            Object s = a = insert._1();
                            List tail = list22;
                            List list23 = in2;
                            List list24 = tail;
                            List list25 = (List)list3.$colon$plus(s);
                            list5 = list23;
                            list4 = list24;
                            list3 = list25;
                            continue;
                        }
                    }
                    break block24;
                }
                throw new MatchError((Object)tuple2);
            }
            Nil$ nil$ = package$.MODULE$.Nil();
            List list26 = list2;
            if (nil$ == null) {
                if (list26 != null) {
                    throw new MatchError((Object)tuple2);
                }
            } else if (!nil$.equals(list26)) throw new MatchError((Object)tuple2);
            Nil$ nil$3 = package$.MODULE$.Nil();
            List list27 = list;
            if (nil$3 == null) {
                if (list27 != null) {
                    throw new MatchError((Object)tuple2);
                }
            } else if (!nil$3.equals(list27)) throw new MatchError((Object)tuple2);
            left = package$.MODULE$.Right().apply((Object)Chunk$.MODULE$.fromIterable((Iterable)list3));
            return left;
        }
    }

    public static final class NotComparable<A>
    implements Diff<A>,
    Product,
    Serializable {
        public static <A> NotComparable<A> apply() {
            return Diff$NotComparable$.MODULE$.apply();
        }

        public static NotComparable<?> fromProduct(Product product) {
            return Diff$NotComparable$.MODULE$.fromProduct(product);
        }

        public static <A> boolean unapply(NotComparable<A> notComparable) {
            return Diff$NotComparable$.MODULE$.unapply(notComparable);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof NotComparable)) return false;
            NotComparable notComparable = (NotComparable)object;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof NotComparable;
        }

        public int productArity() {
            return 0;
        }

        public String productPrefix() {
            return "NotComparable";
        }

        public Object productElement(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Either<String, A> patch(A input) {
            return package$.MODULE$.Left().apply((Object)"Non-comparable diff cannot be applied");
        }

        @Override
        public boolean isComparable() {
            return false;
        }

        public <A> NotComparable<A> copy() {
            return new NotComparable<A>();
        }
    }

    public static final class Number<A>
    implements Diff<A>,
    Product,
    Serializable {
        private final Object distance;
        private final Numeric<A> ev;

        public static <A> Number<A> apply(A a, Numeric<A> numeric) {
            return Diff$Number$.MODULE$.apply(a, numeric);
        }

        public static <A> Number<A> unapply(Number<A> number) {
            return Diff$Number$.MODULE$.unapply(number);
        }

        public Number(A distance, Numeric<A> ev) {
            this.distance = distance;
            this.ev = ev;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Number)) return false;
            Number number = (Number)object;
            if (!BoxesRunTime.equals(this.distance(), number.distance())) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Number;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Number";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "distance";
        }

        public A distance() {
            return (A)this.distance;
        }

        @Override
        public Either<String, A> patch(A input) {
            return package$.MODULE$.Right().apply(this.ev.minus(input, this.distance()));
        }

        public <A> Number<A> copy(A distance, Numeric<A> ev) {
            return new Number<A>(distance, ev);
        }

        public <A> A copy$default$1() {
            return this.distance();
        }

        public A _1() {
            return this.distance();
        }
    }

    public static final class Record<R>
    implements Diff<R>,
    Product,
    Serializable {
        private final ListMap differences;
        private final Schema.Record schema;

        public static <R> Record<R> apply(ListMap<String, Diff<?>> listMap, Schema.Record<R> record) {
            return Diff$Record$.MODULE$.apply(listMap, record);
        }

        public static Record<?> fromProduct(Product product) {
            return Diff$Record$.MODULE$.fromProduct(product);
        }

        public static <R> Record<R> unapply(Record<R> record) {
            return Diff$Record$.MODULE$.unapply(record);
        }

        public Record(ListMap<String, Diff<?>> differences, Schema.Record<R> schema) {
            this.differences = differences;
            this.schema = schema;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Record)) return false;
            Record record = (Record)object;
            ListMap<String, Diff<?>> listMap = this.differences();
            ListMap<String, Diff<?>> listMap2 = record.differences();
            if (listMap == null) {
                if (listMap2 != null) {
                    return false;
                }
            } else if (!listMap.equals(listMap2)) return false;
            Schema.Record<R> record2 = this.schema();
            Schema.Record<R> record3 = record.schema();
            if (record2 == null) {
                if (record3 == null) return true;
                return false;
            } else {
                if (!record2.equals(record3)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Record;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Record";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            if (0 == n2) {
                object = this._1();
            } else if (1 == n2) {
                object = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "differences";
            } else if (1 == n2) {
                string = "schema";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public ListMap<String, Diff<?>> differences() {
            return this.differences;
        }

        public Schema.Record<R> schema() {
            return this.schema;
        }

        @Override
        public boolean isIdentical() {
            return this.differences().forall((Function1 & Serializable)_$25 -> ((Diff)_$25._2()).isIdentical());
        }

        @Override
        public boolean isComparable() {
            return this.differences().forall((Function1 & Serializable)_$26 -> ((Diff)_$26._2()).isComparable());
        }

        @Override
        public Either<String, R> patch(R input) {
            Left left;
            Chunk<Schema.Field<?>> structure = this.schema().structure();
            DynamicValue dynamicValue = this.schema().toDynamic(input);
            if (dynamicValue instanceof DynamicValue.Record) {
                DynamicValue.Record record = DynamicValue$Record$.MODULE$.unapply((DynamicValue.Record)dynamicValue);
                TypeId typeId = record._1();
                ListMap<String, DynamicValue> listMap = record._2();
                TypeId name = typeId;
                ListMap<String, DynamicValue> values = listMap;
                left = ((Either)this.differences().foldLeft((Object)package$.MODULE$.Right().apply(values), (Function2 & Serializable)(x$1, x$2) -> {
                    Left left;
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 == null) throw new MatchError((Object)tuple2);
                    Either either = (Either)tuple2._1();
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    if (either instanceof Right) {
                        ListMap record = (ListMap)((Right)either).value();
                        if (tuple22 != null) {
                            String key = (String)tuple22._1();
                            Diff diff = (Diff)tuple22._2();
                            Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)structure.find((Function1 & Serializable)_$27 -> {
                                String string = _$27.label();
                                String string2 = key;
                                return !(string != null ? !string.equals(string2) : string2 != null);
                            }).map((Function1 & Serializable)_$28 -> _$28.schema()), (Object)values.get((Object)key));
                            if (tuple23 != null) {
                                Schema schema;
                                Option option = (Option)tuple23._1();
                                Option option2 = (Option)tuple23._2();
                                if (option instanceof Some && (schema = (Schema)((Some)option).value()) instanceof Schema) {
                                    Schema schema2 = schema;
                                    if (option2 instanceof Some) {
                                        DynamicValue oldValue = (DynamicValue)((Some)option2).value();
                                        Either oldVal = oldValue.toTypedValue(schema2);
                                        Either either2 = oldVal.flatMap((Function1 & Serializable)v -> diff.patch(v)).map((Function1 & Serializable)v -> schema2.toDynamic(v));
                                        if (either2 instanceof Left) {
                                            String error = (String)((Left)either2).value();
                                            left = package$.MODULE$.Left().apply((Object)error);
                                            return left;
                                        }
                                        if (!(either2 instanceof Right)) throw new MatchError((Object)either2);
                                        DynamicValue newValue = (DynamicValue)((Right)either2).value();
                                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
                                        left = package$.MODULE$.Right().apply((Object)record.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)newValue)));
                                        return left;
                                    }
                                }
                            }
                            left = package$.MODULE$.Left().apply((Object)new StringBuilder(47).append("Values=").append(values).append(" and structure=").append(structure).append(" have incompatible shape.").toString());
                            return left;
                        }
                    }
                    if (!(either instanceof Left)) throw new MatchError((Object)tuple2);
                    String string = (String)((Left)either).value();
                    left = package$.MODULE$.Left().apply((Object)string);
                    return left;
                })).map((Function1 & Serializable)r -> Tuple2$.MODULE$.apply((Object)name, r));
            } else {
                DynamicValue dv = dynamicValue;
                left = package$.MODULE$.Left().apply((Object)new StringBuilder(66).append("Failed to apply record diff. Unexpected dynamic value for record: ").append(dv).toString());
            }
            Left patchedDynamicValue = left;
            return patchedDynamicValue.flatMap((Function1 & Serializable)newValues -> this.schema().fromDynamic(DynamicValue$Record$.MODULE$.apply((TypeId)newValues._1(), (ListMap<String, DynamicValue>)((ListMap)newValues._2()))));
        }

        public Diff<R> orIdentical() {
            return (Diff)(this.differences().values().forall((Function1 & Serializable)_$29 -> _$29.isIdentical()) ? Diff$.MODULE$.identical() : this);
        }

        public <R> Record<R> copy(ListMap<String, Diff<?>> differences, Schema.Record<R> schema) {
            return new Record<R>(differences, schema);
        }

        public <R> ListMap<String, Diff<?>> copy$default$1() {
            return this.differences();
        }

        public <R> Schema.Record<R> copy$default$2() {
            return this.schema();
        }

        public ListMap<String, Diff<?>> _1() {
            return this.differences();
        }

        public Schema.Record<R> _2() {
            return this.schema();
        }
    }

    public static final class SchemaMigration
    implements Diff<Schema<?>>,
    Product,
    Serializable {
        private final Chunk migrations;

        public static SchemaMigration apply(Chunk<Migration> chunk) {
            return Diff$SchemaMigration$.MODULE$.apply(chunk);
        }

        public static SchemaMigration fromProduct(Product product) {
            return Diff$SchemaMigration$.MODULE$.fromProduct(product);
        }

        public static SchemaMigration unapply(SchemaMigration schemaMigration) {
            return Diff$SchemaMigration$.MODULE$.unapply(schemaMigration);
        }

        public SchemaMigration(Chunk<Migration> migrations) {
            this.migrations = migrations;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SchemaMigration)) return false;
            SchemaMigration schemaMigration = (SchemaMigration)object;
            Chunk<Migration> chunk = this.migrations();
            Chunk<Migration> chunk2 = schemaMigration.migrations();
            if (chunk != null) {
                if (!chunk.equals(chunk2)) return false;
                return true;
            }
            if (chunk2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SchemaMigration;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "SchemaMigration";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "migrations";
        }

        public Chunk<Migration> migrations() {
            return this.migrations;
        }

        @Override
        public Either<String, Schema<?>> patch(Schema<?> input) {
            return package$.MODULE$.Left().apply((Object)"Schema migrations cannot be applied");
        }

        public Diff<Schema<?>> orIdentical() {
            return (Diff)(this.migrations().isEmpty() ? Diff$.MODULE$.identical() : this);
        }

        public SchemaMigration copy(Chunk<Migration> migrations) {
            return new SchemaMigration(migrations);
        }

        public Chunk<Migration> copy$default$1() {
            return this.migrations();
        }

        public Chunk<Migration> _1() {
            return this.migrations();
        }
    }

    public static final class Temporal<A>
    implements Diff<A>,
    Product,
    Serializable {
        private final List distances;
        private final StandardType tpe;

        public static <A> Temporal<A> apply(List<Object> list, StandardType<A> standardType) {
            return Diff$Temporal$.MODULE$.apply(list, standardType);
        }

        public static Temporal<?> fromProduct(Product product) {
            return Diff$Temporal$.MODULE$.fromProduct(product);
        }

        public static <A> Temporal<A> unapply(Temporal<A> temporal) {
            return Diff$Temporal$.MODULE$.unapply(temporal);
        }

        public Temporal(List<Object> distances, StandardType<A> tpe) {
            this.distances = distances;
            this.tpe = tpe;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Temporal)) return false;
            Temporal temporal = (Temporal)object;
            List<Object> list = this.distances();
            List<Object> list2 = temporal.distances();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            StandardType<A> standardType = this.tpe();
            StandardType<A> standardType2 = temporal.tpe();
            if (standardType == null) {
                if (standardType2 == null) return true;
                return false;
            } else {
                if (!standardType.equals(standardType2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Temporal;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Temporal";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            if (0 == n2) {
                object = this._1();
            } else if (1 == n2) {
                object = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "distances";
            } else if (1 == n2) {
                string = "tpe";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public List<Object> distances() {
            return this.distances;
        }

        public StandardType<A> tpe() {
            return this.tpe;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Either<String, A> patch(A a) {
            Right right;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(this.tpe(), this.distances());
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            StandardType standardType = (StandardType)tuple2._1();
            List list = (List)tuple2._2();
            if (standardType == StandardType$YearType$.MODULE$ && list instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                List list2 = colon2.next$access$1();
                long distance = BoxesRunTime.unboxToLong((Object)colon2.head());
                Nil$ nil$ = package$.MODULE$.Nil();
                List list3 = list2;
                if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) {
                    right = package$.MODULE$.Right().apply((Object)Year.of(((Year)a).getValue() - (int)distance));
                    return right;
                }
            }
            if (standardType == StandardType$YearMonthType$.MODULE$ && list instanceof .colon.colon) {
                .colon.colon colon3 = (.colon.colon)list;
                List list4 = colon3.next$access$1();
                long distance = BoxesRunTime.unboxToLong((Object)colon3.head());
                Nil$ nil$ = package$.MODULE$.Nil();
                List list5 = list4;
                if (!(nil$ != null ? !nil$.equals(list5) : list5 != null)) {
                    right = package$.MODULE$.Right().apply((Object)YearMonth.now().with(ChronoField.PROLEPTIC_MONTH, ((YearMonth)a).getLong(ChronoField.PROLEPTIC_MONTH) - distance));
                    return right;
                }
            }
            if (standardType instanceof StandardType.LocalDateType && list instanceof .colon.colon) {
                .colon.colon colon4 = (.colon.colon)list;
                List list6 = colon4.next$access$1();
                long distance = BoxesRunTime.unboxToLong((Object)colon4.head());
                Nil$ nil$ = package$.MODULE$.Nil();
                List list7 = list6;
                if (!(nil$ != null ? !nil$.equals(list7) : list7 != null)) {
                    right = package$.MODULE$.Right().apply((Object)LocalDate.ofEpochDay(((LocalDate)a).toEpochDay() - distance));
                    return right;
                }
            }
            if (standardType instanceof StandardType.InstantType && list instanceof .colon.colon) {
                .colon.colon colon5 = (.colon.colon)list;
                List list8 = colon5.next$access$1();
                long dist1 = BoxesRunTime.unboxToLong((Object)colon5.head());
                if (list8 instanceof .colon.colon) {
                    .colon.colon colon6 = (.colon.colon)list8;
                    List list9 = colon6.next$access$1();
                    long dist2 = BoxesRunTime.unboxToLong((Object)colon6.head());
                    Nil$ nil$ = package$.MODULE$.Nil();
                    List list10 = list9;
                    if (!(nil$ != null ? !nil$.equals(list10) : list10 != null)) {
                        right = package$.MODULE$.Right().apply((Object)Instant.ofEpochSecond(((Instant)a).getEpochSecond() - dist1, (long)((Instant)a).getNano() - dist2));
                        return right;
                    }
                }
            }
            if (standardType instanceof StandardType.LocalTimeType && list instanceof .colon.colon) {
                .colon.colon colon7 = (.colon.colon)list;
                List list11 = colon7.next$access$1();
                long distance = BoxesRunTime.unboxToLong((Object)colon7.head());
                Nil$ nil$ = package$.MODULE$.Nil();
                List list12 = list11;
                if (!(nil$ != null ? !nil$.equals(list12) : list12 != null)) {
                    right = package$.MODULE$.Right().apply((Object)LocalTime.ofNanoOfDay(((LocalTime)a).toNanoOfDay() - distance));
                    return right;
                }
            }
            if (standardType instanceof StandardType.LocalDateTimeType && list instanceof .colon.colon) {
                .colon.colon colon8 = (.colon.colon)list;
                List list13 = colon8.next$access$1();
                long dist1 = BoxesRunTime.unboxToLong((Object)colon8.head());
                if (list13 instanceof .colon.colon) {
                    .colon.colon colon9 = (.colon.colon)list13;
                    List list14 = colon9.next$access$1();
                    long dist2 = BoxesRunTime.unboxToLong((Object)colon9.head());
                    Nil$ nil$ = package$.MODULE$.Nil();
                    List list15 = list14;
                    if (!(nil$ != null ? !nil$.equals(list15) : list15 != null)) {
                        right = package$.MODULE$.Right().apply((Object)LocalDateTime.of(LocalDate.ofEpochDay(((LocalDateTime)a).toLocalDate().toEpochDay() - dist1), LocalTime.ofNanoOfDay(((LocalDateTime)a).toLocalTime().toNanoOfDay() - dist2)));
                        return right;
                    }
                }
            }
            if (standardType instanceof StandardType.OffsetTimeType && list instanceof .colon.colon) {
                .colon.colon colon10 = (.colon.colon)list;
                List list16 = colon10.next$access$1();
                long dist1 = BoxesRunTime.unboxToLong((Object)colon10.head());
                if (list16 instanceof .colon.colon) {
                    .colon.colon colon11 = (.colon.colon)list16;
                    List list17 = colon11.next$access$1();
                    long dist2 = BoxesRunTime.unboxToLong((Object)colon11.head());
                    Nil$ nil$ = package$.MODULE$.Nil();
                    List list18 = list17;
                    if (!(nil$ != null ? !nil$.equals(list18) : list18 != null)) {
                        right = package$.MODULE$.Right().apply((Object)OffsetTime.of(LocalTime.ofNanoOfDay(((OffsetTime)a).toLocalTime().toNanoOfDay() - dist1), ZoneOffset.ofTotalSeconds(((OffsetTime)a).getOffset().getTotalSeconds() - (int)dist2)));
                        return right;
                    }
                }
            }
            if (standardType instanceof StandardType.OffsetDateTimeType && list instanceof .colon.colon) {
                .colon.colon colon12 = (.colon.colon)list;
                List list19 = colon12.next$access$1();
                long dist1 = BoxesRunTime.unboxToLong((Object)colon12.head());
                if (list19 instanceof .colon.colon) {
                    .colon.colon colon13 = (.colon.colon)list19;
                    List list20 = colon13.next$access$1();
                    long dist2 = BoxesRunTime.unboxToLong((Object)colon13.head());
                    if (list20 instanceof .colon.colon) {
                        .colon.colon colon14 = (.colon.colon)list20;
                        List list21 = colon14.next$access$1();
                        long dist3 = BoxesRunTime.unboxToLong((Object)colon14.head());
                        Nil$ nil$ = package$.MODULE$.Nil();
                        List list22 = list21;
                        if (!(nil$ != null ? !nil$.equals(list22) : list22 != null)) {
                            right = package$.MODULE$.Right().apply((Object)OffsetDateTime.of(LocalDate.ofEpochDay(((OffsetDateTime)a).toLocalDate().toEpochDay() - dist1), LocalTime.ofNanoOfDay(((OffsetDateTime)a).toLocalTime().toNanoOfDay() - dist2), ZoneOffset.ofTotalSeconds(((OffsetDateTime)a).getOffset().getTotalSeconds() - (int)dist3)));
                            return right;
                        }
                    }
                }
            }
            if (standardType == StandardType$PeriodType$.MODULE$ && list instanceof .colon.colon) {
                .colon.colon colon15 = (.colon.colon)list;
                List list23 = colon15.next$access$1();
                long dayAdjustment = BoxesRunTime.unboxToLong((Object)colon15.head());
                if (list23 instanceof .colon.colon) {
                    .colon.colon colon16 = (.colon.colon)list23;
                    List list24 = colon16.next$access$1();
                    long monthAdjustment = BoxesRunTime.unboxToLong((Object)colon16.head());
                    if (list24 instanceof .colon.colon) {
                        .colon.colon colon17 = (.colon.colon)list24;
                        List list25 = colon17.next$access$1();
                        long yearAdjustment = BoxesRunTime.unboxToLong((Object)colon17.head());
                        Nil$ nil$ = package$.MODULE$.Nil();
                        List list26 = list25;
                        if (!(nil$ != null ? !nil$.equals(list26) : list26 != null)) {
                            try {
                                right = package$.MODULE$.Right().apply((Object)Period.of(((Period)a).getYears() - (int)yearAdjustment, ((Period)a).getMonths() - (int)monthAdjustment, ((Period)a).getDays() - (int)dayAdjustment));
                                return right;
                            }
                            catch (Throwable throwable) {
                                right = package$.MODULE$.Left().apply((Object)new StringBuilder(30).append("Invalid java.time.Period diff ").append(this).toString());
                                return right;
                            }
                        }
                    }
                }
            }
            if (standardType == StandardType$ZoneOffsetType$.MODULE$ && list instanceof .colon.colon) {
                .colon.colon colon18 = (.colon.colon)list;
                List list27 = colon18.next$access$1();
                long distance = BoxesRunTime.unboxToLong((Object)colon18.head());
                Nil$ nil$ = package$.MODULE$.Nil();
                List list28 = list27;
                if (!(nil$ != null ? !nil$.equals(list28) : list28 != null)) {
                    try {
                        right = package$.MODULE$.Right().apply((Object)ZoneOffset.ofTotalSeconds(((ZoneOffset)a).getTotalSeconds() + (int)distance));
                        return right;
                    }
                    catch (Throwable t) {
                        right = package$.MODULE$.Left().apply((Object)new StringBuilder(27).append("Patched offset is invalid: ").append(t.getMessage()).toString());
                        return right;
                    }
                }
            }
            if (standardType == StandardType$DayOfWeekType$.MODULE$ && list instanceof .colon.colon) {
                .colon.colon colon19 = (.colon.colon)list;
                List list29 = colon19.next$access$1();
                long distance = BoxesRunTime.unboxToLong((Object)colon19.head());
                Nil$ nil$ = package$.MODULE$.Nil();
                List list30 = list29;
                if (!(nil$ != null ? !nil$.equals(list30) : list30 != null)) {
                    right = package$.MODULE$.Right().apply((Object)((DayOfWeek)a).plus(distance));
                    return right;
                }
            }
            if (standardType == StandardType$MonthType$.MODULE$ && list instanceof .colon.colon) {
                .colon.colon colon20 = (.colon.colon)list;
                List list31 = colon20.next$access$1();
                long distance = BoxesRunTime.unboxToLong((Object)colon20.head());
                Nil$ nil$ = package$.MODULE$.Nil();
                List list32 = list31;
                if (!(nil$ != null ? !nil$.equals(list32) : list32 != null)) {
                    right = package$.MODULE$.Right().apply((Object)((Month)a).plus(distance));
                    return right;
                }
            }
            if (standardType == StandardType$DurationType$.MODULE$ && list instanceof .colon.colon) {
                .colon.colon colon21 = (.colon.colon)list;
                List list33 = colon21.next$access$1();
                long dist1 = BoxesRunTime.unboxToLong((Object)colon21.head());
                if (list33 instanceof .colon.colon) {
                    .colon.colon colon22 = (.colon.colon)list33;
                    List list34 = colon22.next$access$1();
                    long dist2 = BoxesRunTime.unboxToLong((Object)colon22.head());
                    Nil$ nil$ = package$.MODULE$.Nil();
                    List list35 = list34;
                    if (!(nil$ != null ? !nil$.equals(list35) : list35 != null)) {
                        right = package$.MODULE$.Right().apply((Object)Duration.ofSeconds(((Duration)a).getSeconds() - dist1, (long)((Duration)a).getNano() - dist2));
                        return right;
                    }
                }
            }
            if (standardType == StandardType$MonthDayType$.MODULE$ && list instanceof .colon.colon) {
                .colon.colon colon23 = (.colon.colon)list;
                List list36 = colon23.next$access$1();
                long regDiff = BoxesRunTime.unboxToLong((Object)colon23.head());
                if (list36 instanceof .colon.colon) {
                    List list37 = ((.colon.colon)list36).next$access$1();
                    Nil$ nil$ = package$.MODULE$.Nil();
                    List list38 = list37;
                    if (!(nil$ != null ? !nil$.equals(list38) : list38 != null)) {
                        right = package$.MODULE$.Right().apply((Object)MonthDay.from(ChronoUnit.DAYS.addTo(((MonthDay)a).atYear(2001), regDiff)));
                        return right;
                    }
                }
            }
            StandardType s = standardType;
            right = package$.MODULE$.Left().apply((Object)new StringBuilder(46).append("Cannot apply temporal diff to value with type ").append(s).toString());
            return right;
        }

        public <A> Temporal<A> copy(List<Object> distances, StandardType<A> tpe) {
            return new Temporal<A>(distances, tpe);
        }

        public <A> List<Object> copy$default$1() {
            return this.distances();
        }

        public <A> StandardType<A> copy$default$2() {
            return this.tpe();
        }

        public List<Object> _1() {
            return this.distances();
        }

        public StandardType<A> _2() {
            return this.tpe();
        }
    }

    public static final class Total<A>
    implements Diff<A>,
    Product,
    Serializable {
        private final Object value;

        public static <A> Total<A> apply(A a) {
            return Diff$Total$.MODULE$.apply(a);
        }

        public static Total<?> fromProduct(Product product) {
            return Diff$Total$.MODULE$.fromProduct(product);
        }

        public static <A> Total<A> unapply(Total<A> total) {
            return Diff$Total$.MODULE$.unapply(total);
        }

        public Total(A value) {
            this.value = value;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Total)) return false;
            Total total = (Total)object;
            if (!BoxesRunTime.equals(this.value(), total.value())) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Total;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Total";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "value";
        }

        public A value() {
            return (A)this.value;
        }

        @Override
        public Either<String, A> patch(A input) {
            return package$.MODULE$.Right().apply(this.value());
        }

        public <A> Total<A> copy(A value) {
            return new Total<A>(value);
        }

        public <A> A copy$default$1() {
            return this.value();
        }

        public A _1() {
            return this.value();
        }
    }

    public static final class Transform<A, B>
    implements Diff<B>,
    Product,
    Serializable {
        private final Diff diff;
        private final Function1 f;
        private final Function1 g;

        public static <A, B> Transform<A, B> apply(Diff<A> diff, Function1<A, Either<String, B>> function1, Function1<B, Either<String, A>> function12) {
            return Diff$Transform$.MODULE$.apply(diff, function1, function12);
        }

        public static Transform<?, ?> fromProduct(Product product) {
            return Diff$Transform$.MODULE$.fromProduct(product);
        }

        public static <A, B> Transform<A, B> unapply(Transform<A, B> transform) {
            return Diff$Transform$.MODULE$.unapply(transform);
        }

        public Transform(Diff<A> diff, Function1<A, Either<String, B>> f, Function1<B, Either<String, A>> g) {
            this.diff = diff;
            this.f = f;
            this.g = g;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Transform)) return false;
            Transform transform = (Transform)object;
            Diff<A> diff = this.diff();
            Diff<A> diff2 = transform.diff();
            if (diff == null) {
                if (diff2 != null) {
                    return false;
                }
            } else if (!diff.equals(diff2)) return false;
            Function1<A, Either<String, B>> function1 = this.f();
            Function1<A, Either<String, B>> function12 = transform.f();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            Function1<B, Either<String, A>> function13 = this.g();
            Function1<B, Either<String, A>> function14 = transform.g();
            if (function13 == null) {
                if (function14 == null) return true;
                return false;
            } else {
                if (!function13.equals(function14)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Transform;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Transform";
        }

        public Object productElement(int n) {
            Diff<A> diff;
            int n2 = n;
            switch (n2) {
                case 0: {
                    diff = this._1();
                    break;
                }
                case 1: {
                    diff = this._2();
                    break;
                }
                case 2: {
                    diff = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return diff;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "diff";
                    break;
                }
                case 1: {
                    string = "f";
                    break;
                }
                case 2: {
                    string = "g";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public Diff<A> diff() {
            return this.diff;
        }

        public Function1<A, Either<String, B>> f() {
            return this.f;
        }

        public Function1<B, Either<String, A>> g() {
            return this.g;
        }

        @Override
        public boolean isIdentical() {
            return this.diff().isIdentical();
        }

        @Override
        public boolean isComparable() {
            return this.diff().isComparable();
        }

        @Override
        public Either<String, B> patch(B input) {
            return ((Either)this.g().apply(input)).flatMap((Function1 & Serializable)a -> this.diff().patch(a).flatMap((Function1 & Serializable)a1 -> ((Either)this.f().apply(a1)).map((Function1 & Serializable)b -> b)));
        }

        public <A, B> Transform<A, B> copy(Diff<A> diff, Function1<A, Either<String, B>> f, Function1<B, Either<String, A>> g) {
            return new Transform<A, B>(diff, f, g);
        }

        public <A, B> Diff<A> copy$default$1() {
            return this.diff();
        }

        public <A, B> Function1<A, Either<String, B>> copy$default$2() {
            return this.f();
        }

        public <A, B> Function1<B, Either<String, A>> copy$default$3() {
            return this.g();
        }

        public Diff<A> _1() {
            return this.diff();
        }

        public Function1<A, Either<String, B>> _2() {
            return this.f();
        }

        public Function1<B, Either<String, A>> _3() {
            return this.g();
        }
    }

    public static final class Tuple<A, B>
    implements Diff<Tuple2<A, B>>,
    Product,
    Serializable {
        private final Diff leftDifference;
        private final Diff rightDifference;

        public static <A, B> Tuple<A, B> apply(Diff<A> diff, Diff<B> diff2) {
            return Diff$Tuple$.MODULE$.apply(diff, diff2);
        }

        public static Tuple<?, ?> fromProduct(Product product) {
            return Diff$Tuple$.MODULE$.fromProduct(product);
        }

        public static <A, B> Tuple<A, B> unapply(Tuple<A, B> tuple) {
            return Diff$Tuple$.MODULE$.unapply(tuple);
        }

        public Tuple(Diff<A> leftDifference, Diff<B> rightDifference) {
            this.leftDifference = leftDifference;
            this.rightDifference = rightDifference;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Tuple)) return false;
            Tuple tuple = (Tuple)object;
            Diff<A> diff = this.leftDifference();
            Diff<A> diff2 = tuple.leftDifference();
            if (diff == null) {
                if (diff2 != null) {
                    return false;
                }
            } else if (!diff.equals(diff2)) return false;
            Diff<B> diff3 = this.rightDifference();
            Diff<B> diff4 = tuple.rightDifference();
            if (diff3 == null) {
                if (diff4 == null) return true;
                return false;
            } else {
                if (!diff3.equals(diff4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Tuple;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Tuple";
        }

        public Object productElement(int n) {
            Diff<Object> diff;
            int n2 = n;
            if (0 == n2) {
                diff = this._1();
            } else if (1 == n2) {
                diff = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return diff;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "leftDifference";
            } else if (1 == n2) {
                string = "rightDifference";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public Diff<A> leftDifference() {
            return this.leftDifference;
        }

        public Diff<B> rightDifference() {
            return this.rightDifference;
        }

        @Override
        public boolean isIdentical() {
            return this.leftDifference().isIdentical() && this.rightDifference().isIdentical();
        }

        @Override
        public Either<String, Tuple2<A, B>> patch(Tuple2<A, B> input) {
            return this.leftDifference().patch(input._1()).flatMap((Function1 & Serializable)l -> this.rightDifference().patch(input._2()).map((Function1 & Serializable)r -> Tuple2$.MODULE$.apply(l, r)));
        }

        public <A, B> Tuple<A, B> copy(Diff<A> leftDifference, Diff<B> rightDifference) {
            return new Tuple<A, B>(leftDifference, rightDifference);
        }

        public <A, B> Diff<A> copy$default$1() {
            return this.leftDifference();
        }

        public <A, B> Diff<B> copy$default$2() {
            return this.rightDifference();
        }

        public Diff<A> _1() {
            return this.leftDifference();
        }

        public Diff<B> _2() {
            return this.rightDifference();
        }
    }

    public static final class ZonedDateTime
    implements Diff<java.time.ZonedDateTime>,
    Product,
    Serializable {
        private final Diff localDateTimeDiff;
        private final Diff zoneIdDiff;

        public static ZonedDateTime apply(Diff<LocalDateTime> diff, Diff<String> diff2) {
            return Diff$ZonedDateTime$.MODULE$.apply(diff, diff2);
        }

        public static ZonedDateTime fromProduct(Product product) {
            return Diff$ZonedDateTime$.MODULE$.fromProduct(product);
        }

        public static ZonedDateTime unapply(ZonedDateTime zonedDateTime) {
            return Diff$ZonedDateTime$.MODULE$.unapply(zonedDateTime);
        }

        public ZonedDateTime(Diff<LocalDateTime> localDateTimeDiff, Diff<String> zoneIdDiff) {
            this.localDateTimeDiff = localDateTimeDiff;
            this.zoneIdDiff = zoneIdDiff;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ZonedDateTime)) return false;
            ZonedDateTime zonedDateTime = (ZonedDateTime)object;
            Diff<LocalDateTime> diff = this.localDateTimeDiff();
            Diff<LocalDateTime> diff2 = zonedDateTime.localDateTimeDiff();
            if (diff == null) {
                if (diff2 != null) {
                    return false;
                }
            } else if (!diff.equals(diff2)) return false;
            Diff<String> diff3 = this.zoneIdDiff();
            Diff<String> diff4 = zonedDateTime.zoneIdDiff();
            if (diff3 == null) {
                if (diff4 == null) return true;
                return false;
            } else {
                if (!diff3.equals(diff4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ZonedDateTime;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ZonedDateTime";
        }

        public Object productElement(int n) {
            Diff<Object> diff;
            int n2 = n;
            if (0 == n2) {
                diff = this._1();
            } else if (1 == n2) {
                diff = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return diff;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "localDateTimeDiff";
            } else if (1 == n2) {
                string = "zoneIdDiff";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public Diff<LocalDateTime> localDateTimeDiff() {
            return this.localDateTimeDiff;
        }

        public Diff<String> zoneIdDiff() {
            return this.zoneIdDiff;
        }

        @Override
        public Either<String, java.time.ZonedDateTime> patch(java.time.ZonedDateTime input) {
            return this.localDateTimeDiff().patch(input.toLocalDateTime()).flatMap((Function1 & Serializable)patchedLocalDateTime -> this.zoneIdDiff().patch(input.getZone().getId()).flatMap((Function1 & Serializable)patchedZoneId -> this.liftedTree3$1((LocalDateTime)patchedLocalDateTime, (String)patchedZoneId).map((Function1 & Serializable)patched -> patched)));
        }

        public ZonedDateTime copy(Diff<LocalDateTime> localDateTimeDiff, Diff<String> zoneIdDiff) {
            return new ZonedDateTime(localDateTimeDiff, zoneIdDiff);
        }

        public Diff<LocalDateTime> copy$default$1() {
            return this.localDateTimeDiff();
        }

        public Diff<String> copy$default$2() {
            return this.zoneIdDiff();
        }

        public Diff<LocalDateTime> _1() {
            return this.localDateTimeDiff();
        }

        public Diff<String> _2() {
            return this.zoneIdDiff();
        }

        private final Either liftedTree3$1(LocalDateTime patchedLocalDateTime$2, String patchedZoneId$1) {
            Right right;
            try {
                right = package$.MODULE$.Right().apply((Object)java.time.ZonedDateTime.of(patchedLocalDateTime$2, ZoneId.of(patchedZoneId$1)));
            }
            catch (Throwable e) {
                right = package$.MODULE$.Left().apply((Object)new StringBuilder(61).append("Patched ZonedDateTime is not valid. Patched values ").append(patchedLocalDateTime$2).append(", ").append(patchedZoneId$1).append(". Error=").append(e.getMessage()).toString());
            }
            return right;
        }
    }
}

