/*
 * Decompiled with CFR 0.152.
 */
package zio.schema.validation;

import java.io.Serializable;
import java.util.regex.Pattern;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import zio.schema.validation.Regex$;
import zio.schema.validation.Regex$Alternate$;
import zio.schema.validation.Regex$Between$;
import zio.schema.validation.Regex$CharacterSet$;
import zio.schema.validation.Regex$Literal$;
import zio.schema.validation.Regex$Repeat$;
import zio.schema.validation.Regex$Sequence$;

public interface Regex {
    public static Regex digit() {
        return Regex$.MODULE$.digit();
    }

    public static Regex digitNonZero() {
        return Regex$.MODULE$.digitNonZero();
    }

    public static Regex digitOrLetter() {
        return Regex$.MODULE$.digitOrLetter();
    }

    public static Regex filter(Function1<Object, Object> function1) {
        return Regex$.MODULE$.filter(function1);
    }

    public static Regex hexDigit() {
        return Regex$.MODULE$.hexDigit();
    }

    public static Regex hexDigitNonZero() {
        return Regex$.MODULE$.hexDigitNonZero();
    }

    public static Regex letter() {
        return Regex$.MODULE$.letter();
    }

    public static Regex literal(String string) {
        return Regex$.MODULE$.literal(string);
    }

    public static Regex oneOf(Seq<Object> seq) {
        return Regex$.MODULE$.oneOf(seq);
    }

    public static int ordinal(Regex regex) {
        return Regex$.MODULE$.ordinal(regex);
    }

    public static String toRegexString(Regex regex) {
        return Regex$.MODULE$.toRegexString(regex);
    }

    public static Regex atLeast$(Regex $this, int n) {
        return $this.atLeast(n);
    }

    default public Regex atLeast(int n) {
        return Regex$Repeat$.MODULE$.apply(this, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)n)), (Option<Object>)None$.MODULE$);
    }

    public static Regex atMost$(Regex $this, int n) {
        return $this.atMost(n);
    }

    default public Regex atMost(int n) {
        return Regex$Repeat$.MODULE$.apply(this, (Option<Object>)None$.MODULE$, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)n)));
    }

    public static Regex between$(Regex $this, int min, int max) {
        return $this.between(min, max);
    }

    default public Regex between(int min, int max) {
        return Regex$Repeat$.MODULE$.apply(this, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)min)), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)max)));
    }

    public static Regex exactly$(Regex $this, int n) {
        return $this.exactly(n);
    }

    default public Regex exactly(int n) {
        return Regex$Repeat$.MODULE$.apply(this, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)n)), (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)n)));
    }

    public static Regex $plus$(Regex $this) {
        return $this.$plus();
    }

    default public Regex $plus() {
        return this.atLeast(1);
    }

    public static Regex $times$(Regex $this) {
        return $this.$times();
    }

    default public Regex $times() {
        return this.atLeast(0);
    }

    public static Regex $qmark$(Regex $this) {
        return $this.$qmark();
    }

    default public Regex $qmark() {
        return this.atMost(1);
    }

    public static Regex $tilde$(Regex $this, Regex that) {
        return $this.$tilde(that);
    }

    default public Regex $tilde(Regex that) {
        return Regex$Sequence$.MODULE$.apply(this, that);
    }

    public static Regex $bar$(Regex $this, Regex that) {
        return $this.$bar(that);
    }

    default public Regex $bar(Regex that) {
        return Regex$Alternate$.MODULE$.apply(this, that);
    }

    public static boolean test$(Regex $this, String string) {
        return $this.test(string);
    }

    default public boolean test(String string) {
        return Pattern.compile(Regex$.MODULE$.toRegexString(this)).matcher(string).matches();
    }

    public static final class Alternate
    implements Regex,
    Product,
    Serializable {
        private final Regex left;
        private final Regex right;

        public static Alternate apply(Regex regex, Regex regex2) {
            return Regex$Alternate$.MODULE$.apply(regex, regex2);
        }

        public static Alternate fromProduct(Product product) {
            return Regex$Alternate$.MODULE$.fromProduct(product);
        }

        public static Alternate unapply(Alternate alternate) {
            return Regex$Alternate$.MODULE$.unapply(alternate);
        }

        public Alternate(Regex left, Regex right) {
            this.left = left;
            this.right = right;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Alternate)) return false;
            Alternate alternate = (Alternate)object;
            Regex regex = this.left();
            Regex regex2 = alternate.left();
            if (regex == null) {
                if (regex2 != null) {
                    return false;
                }
            } else if (!regex.equals(regex2)) return false;
            Regex regex3 = this.right();
            Regex regex4 = alternate.right();
            if (regex3 == null) {
                if (regex4 == null) return true;
                return false;
            } else {
                if (!regex3.equals(regex4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Alternate;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Alternate";
        }

        public Object productElement(int n) {
            Regex regex;
            int n2 = n;
            if (0 == n2) {
                regex = this._1();
            } else if (1 == n2) {
                regex = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return regex;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "left";
            } else if (1 == n2) {
                string = "right";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public Regex left() {
            return this.left;
        }

        public Regex right() {
            return this.right;
        }

        public Alternate copy(Regex left, Regex right) {
            return new Alternate(left, right);
        }

        public Regex copy$default$1() {
            return this.left();
        }

        public Regex copy$default$2() {
            return this.right();
        }

        public Regex _1() {
            return this.left();
        }

        public Regex _2() {
            return this.right();
        }
    }

    public static final class Between
    implements Regex,
    Product,
    Serializable {
        private final char start;
        private final char end;

        public static Between apply(char c, char c2) {
            return Regex$Between$.MODULE$.apply(c, c2);
        }

        public static Between fromProduct(Product product) {
            return Regex$Between$.MODULE$.fromProduct(product);
        }

        public static Between unapply(Between between) {
            return Regex$Between$.MODULE$.unapply(between);
        }

        public Between(char start, char end) {
            this.start = start;
            this.end = end;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.start());
            n = Statics.mix((int)n, (int)this.end());
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Between)) return false;
            Between between = (Between)object;
            if (this.start() != between.start()) return false;
            if (this.end() != between.end()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Between;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Between";
        }

        public Object productElement(int n) {
            char c;
            int n2 = n;
            if (0 == n2) {
                c = this._1();
            } else if (1 == n2) {
                c = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToCharacter((char)c);
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "start";
            } else if (1 == n2) {
                string = "end";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public char start() {
            return this.start;
        }

        public char end() {
            return this.end;
        }

        public Between copy(char start, char end) {
            return new Between(start, end);
        }

        public char copy$default$1() {
            return this.start();
        }

        public char copy$default$2() {
            return this.end();
        }

        public char _1() {
            return this.start();
        }

        public char _2() {
            return this.end();
        }
    }

    public static final class CharacterSet
    implements Regex,
    Product,
    Serializable {
        private final Set set;

        public static CharacterSet apply(Set<Object> set) {
            return Regex$CharacterSet$.MODULE$.apply(set);
        }

        public static CharacterSet fromProduct(Product product) {
            return Regex$CharacterSet$.MODULE$.fromProduct(product);
        }

        public static CharacterSet unapply(CharacterSet characterSet) {
            return Regex$CharacterSet$.MODULE$.unapply(characterSet);
        }

        public CharacterSet(Set<Object> set) {
            this.set = set;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CharacterSet)) return false;
            CharacterSet characterSet = (CharacterSet)object;
            Set<Object> set = this.set();
            Set<Object> set2 = characterSet.set();
            if (set != null) {
                if (!set.equals(set2)) return false;
                return true;
            }
            if (set2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CharacterSet;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "CharacterSet";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "set";
        }

        public Set<Object> set() {
            return this.set;
        }

        public CharacterSet copy(Set<Object> set) {
            return new CharacterSet(set);
        }

        public Set<Object> copy$default$1() {
            return this.set();
        }

        public Set<Object> _1() {
            return this.set();
        }
    }

    public static final class Literal
    implements Regex,
    Product,
    Serializable {
        private final String str;

        public static Literal apply(String string) {
            return Regex$Literal$.MODULE$.apply(string);
        }

        public static Literal fromProduct(Product product) {
            return Regex$Literal$.MODULE$.fromProduct(product);
        }

        public static Literal unapply(Literal literal) {
            return Regex$Literal$.MODULE$.unapply(literal);
        }

        public Literal(String str) {
            this.str = str;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Literal)) return false;
            Literal literal = (Literal)object;
            String string = this.str();
            String string2 = literal.str();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Literal;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Literal";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "str";
        }

        public String str() {
            return this.str;
        }

        public Literal copy(String str) {
            return new Literal(str);
        }

        public String copy$default$1() {
            return this.str();
        }

        public String _1() {
            return this.str();
        }
    }

    public static final class Repeat
    implements Regex,
    Product,
    Serializable {
        private final Regex regex;
        private final Option min;
        private final Option max;

        public static Repeat apply(Regex regex, Option<Object> option, Option<Object> option2) {
            return Regex$Repeat$.MODULE$.apply(regex, option, option2);
        }

        public static Repeat fromProduct(Product product) {
            return Regex$Repeat$.MODULE$.fromProduct(product);
        }

        public static Repeat unapply(Repeat repeat) {
            return Regex$Repeat$.MODULE$.unapply(repeat);
        }

        public Repeat(Regex regex, Option<Object> min, Option<Object> max) {
            this.regex = regex;
            this.min = min;
            this.max = max;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Repeat)) return false;
            Repeat repeat = (Repeat)object;
            Regex regex = this.regex();
            Regex regex2 = repeat.regex();
            if (regex == null) {
                if (regex2 != null) {
                    return false;
                }
            } else if (!regex.equals(regex2)) return false;
            Option<Object> option = this.min();
            Option<Object> option2 = repeat.min();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<Object> option3 = this.max();
            Option<Object> option4 = repeat.max();
            if (option3 == null) {
                if (option4 == null) return true;
                return false;
            } else {
                if (!option3.equals(option4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Repeat;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Repeat";
        }

        public Object productElement(int n) {
            Option<Object> option;
            int n2 = n;
            switch (n2) {
                case 0: {
                    option = this._1();
                    break;
                }
                case 1: {
                    option = this._2();
                    break;
                }
                case 2: {
                    option = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return option;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "regex";
                    break;
                }
                case 1: {
                    string = "min";
                    break;
                }
                case 2: {
                    string = "max";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public Regex regex() {
            return this.regex;
        }

        public Option<Object> min() {
            return this.min;
        }

        public Option<Object> max() {
            return this.max;
        }

        public Repeat copy(Regex regex, Option<Object> min, Option<Object> max) {
            return new Repeat(regex, min, max);
        }

        public Regex copy$default$1() {
            return this.regex();
        }

        public Option<Object> copy$default$2() {
            return this.min();
        }

        public Option<Object> copy$default$3() {
            return this.max();
        }

        public Regex _1() {
            return this.regex();
        }

        public Option<Object> _2() {
            return this.min();
        }

        public Option<Object> _3() {
            return this.max();
        }
    }

    public static final class Sequence
    implements Regex,
    Product,
    Serializable {
        private final Regex first;
        private final Regex second;

        public static Sequence apply(Regex regex, Regex regex2) {
            return Regex$Sequence$.MODULE$.apply(regex, regex2);
        }

        public static Sequence fromProduct(Product product) {
            return Regex$Sequence$.MODULE$.fromProduct(product);
        }

        public static Sequence unapply(Sequence sequence) {
            return Regex$Sequence$.MODULE$.unapply(sequence);
        }

        public Sequence(Regex first, Regex second) {
            this.first = first;
            this.second = second;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Sequence)) return false;
            Sequence sequence = (Sequence)object;
            Regex regex = this.first();
            Regex regex2 = sequence.first();
            if (regex == null) {
                if (regex2 != null) {
                    return false;
                }
            } else if (!regex.equals(regex2)) return false;
            Regex regex3 = this.second();
            Regex regex4 = sequence.second();
            if (regex3 == null) {
                if (regex4 == null) return true;
                return false;
            } else {
                if (!regex3.equals(regex4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Sequence;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Sequence";
        }

        public Object productElement(int n) {
            Regex regex;
            int n2 = n;
            if (0 == n2) {
                regex = this._1();
            } else if (1 == n2) {
                regex = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return regex;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "first";
            } else if (1 == n2) {
                string = "second";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public Regex first() {
            return this.first;
        }

        public Regex second() {
            return this.second;
        }

        public Sequence copy(Regex first, Regex second) {
            return new Sequence(first, second);
        }

        public Regex copy$default$1() {
            return this.first();
        }

        public Regex copy$default$2() {
            return this.second();
        }

        public Regex _1() {
            return this.first();
        }

        public Regex _2() {
            return this.second();
        }
    }
}

