/*
 * Decompiled with CFR 0.152.
 */
package zio.schema.meta;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import zio.Chunk;
import zio.Chunk$;
import zio.prelude.Debug$;
import zio.prelude.package$;
import zio.schema.StandardType;
import zio.schema.TypeId;
import zio.schema.meta.MetaSchema;
import zio.schema.meta.MetaSchema$Dictionary$;
import zio.schema.meta.MetaSchema$Dynamic$;
import zio.schema.meta.MetaSchema$Either$;
import zio.schema.meta.MetaSchema$FailNode$;
import zio.schema.meta.MetaSchema$ListNode$;
import zio.schema.meta.MetaSchema$Product$;
import zio.schema.meta.MetaSchema$Ref$;
import zio.schema.meta.MetaSchema$Sum$;
import zio.schema.meta.MetaSchema$Tuple$;
import zio.schema.meta.MetaSchema$Value$;

public final class AstRenderer$
implements Serializable {
    private static final int INDENT_STEP;
    public static final AstRenderer$ MODULE$;

    private AstRenderer$() {
    }

    static {
        MODULE$ = new AstRenderer$();
        INDENT_STEP = 2;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(AstRenderer$.class);
    }

    public String render(MetaSchema ast) {
        String string;
        MetaSchema metaSchema = ast;
        if (metaSchema instanceof MetaSchema.Value) {
            MetaSchema.Value value = MetaSchema$Value$.MODULE$.unapply((MetaSchema.Value)metaSchema);
            StandardType<?> standardType = value._1();
            Chunk chunk = value._2();
            boolean bl = value._3();
            MetaSchema.Value v = (MetaSchema.Value)metaSchema;
            string = this.renderValue(v, 0, (Option<String>)None$.MODULE$);
        } else if (metaSchema instanceof MetaSchema.FailNode) {
            MetaSchema.FailNode failNode = MetaSchema$FailNode$.MODULE$.unapply((MetaSchema.FailNode)metaSchema);
            String string2 = failNode._1();
            Chunk chunk = failNode._2();
            boolean bl = failNode._3();
            MetaSchema.FailNode f = (MetaSchema.FailNode)metaSchema;
            string = this.renderFail(f, 0, (Option<String>)None$.MODULE$);
        } else if (metaSchema instanceof MetaSchema.Product) {
            MetaSchema.Product product = MetaSchema$Product$.MODULE$.unapply((MetaSchema.Product)metaSchema);
            TypeId typeId = product._1();
            Chunk chunk = product._2();
            Chunk<Tuple2<String, MetaSchema>> chunk2 = product._3();
            boolean bl = product._4();
            Chunk<Tuple2<String, MetaSchema>> fields = chunk2;
            boolean optional = bl;
            StringBuffer buffer = new StringBuffer();
            buffer.append("product");
            if (optional) {
                buffer.append("?");
            }
            string = buffer.append("\n").append(fields.map((Function1 & Serializable)_$63 -> this.renderField((Tuple2<String, MetaSchema>)_$63, INDENT_STEP)).mkString("\n")).toString();
        } else if (metaSchema instanceof MetaSchema.Tuple) {
            MetaSchema.Tuple tuple = MetaSchema$Tuple$.MODULE$.unapply((MetaSchema.Tuple)metaSchema);
            Chunk chunk = tuple._1();
            MetaSchema metaSchema2 = tuple._2();
            MetaSchema metaSchema3 = tuple._3();
            boolean bl = tuple._4();
            MetaSchema left = metaSchema2;
            MetaSchema right = metaSchema3;
            boolean optional = bl;
            StringBuffer buffer = new StringBuffer();
            buffer.append("tuple");
            if (optional) {
                buffer.append("?");
            }
            Object[] objectArray = new Tuple2[2];
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"left");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)left);
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"right");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)right);
            string = buffer.append("\n").append(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).map((Function1 & Serializable)_$64 -> this.renderField((Tuple2<String, MetaSchema>)_$64, INDENT_STEP)).mkString("\n")).toString();
        } else if (metaSchema instanceof MetaSchema.Sum) {
            MetaSchema.Sum sum = MetaSchema$Sum$.MODULE$.unapply((MetaSchema.Sum)metaSchema);
            TypeId typeId = sum._1();
            Chunk chunk = sum._2();
            Chunk<Tuple2<String, MetaSchema>> chunk3 = sum._3();
            boolean bl = sum._4();
            Chunk<Tuple2<String, MetaSchema>> cases = chunk3;
            boolean optional = bl;
            StringBuffer buffer = new StringBuffer();
            buffer.append("enum");
            if (optional) {
                buffer.append("?");
            }
            string = buffer.append("\n").append(cases.map((Function1 & Serializable)_$65 -> this.renderField((Tuple2<String, MetaSchema>)_$65, INDENT_STEP)).mkString("\n")).toString();
        } else if (metaSchema instanceof MetaSchema.Either) {
            MetaSchema.Either either = MetaSchema$Either$.MODULE$.unapply((MetaSchema.Either)metaSchema);
            Chunk chunk = either._1();
            MetaSchema metaSchema4 = either._2();
            MetaSchema metaSchema5 = either._3();
            boolean bl = either._4();
            MetaSchema left = metaSchema4;
            MetaSchema right = metaSchema5;
            boolean optional = bl;
            StringBuffer buffer = new StringBuffer();
            buffer.append("either");
            if (optional) {
                buffer.append("?");
            }
            Object[] objectArray = new Tuple2[2];
            String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"left");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)left);
            String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"right");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)right);
            string = buffer.append("\n").append(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).map((Function1 & Serializable)_$66 -> this.renderField((Tuple2<String, MetaSchema>)_$66, INDENT_STEP)).mkString("\n")).toString();
        } else if (metaSchema instanceof MetaSchema.ListNode) {
            MetaSchema.ListNode listNode = MetaSchema$ListNode$.MODULE$.unapply((MetaSchema.ListNode)metaSchema);
            MetaSchema metaSchema6 = listNode._1();
            Chunk chunk = listNode._2();
            boolean bl = listNode._3();
            MetaSchema items = metaSchema6;
            boolean optional = bl;
            StringBuffer buffer = new StringBuffer();
            buffer.append("list");
            if (optional) {
                buffer.append("?");
            }
            Object[] objectArray = new Tuple2[1];
            String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)"item");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, (Object)items);
            string = buffer.append("\n").append(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).map((Function1 & Serializable)_$67 -> this.renderField((Tuple2<String, MetaSchema>)_$67, INDENT_STEP)).mkString("\n")).toString();
        } else if (metaSchema instanceof MetaSchema.Dictionary) {
            MetaSchema.Dictionary dictionary = MetaSchema$Dictionary$.MODULE$.unapply((MetaSchema.Dictionary)metaSchema);
            MetaSchema metaSchema7 = dictionary._1();
            MetaSchema metaSchema8 = dictionary._2();
            Chunk chunk = dictionary._3();
            boolean bl = dictionary._4();
            MetaSchema keys = metaSchema7;
            MetaSchema values = metaSchema8;
            boolean optional = bl;
            StringBuffer buffer = new StringBuffer();
            buffer.append("map");
            if (optional) {
                buffer.append("?");
            }
            Object[] objectArray = new Tuple2[2];
            String string8 = (String)Predef$.MODULE$.ArrowAssoc((Object)"keys");
            objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string8, (Object)keys);
            String string9 = (String)Predef$.MODULE$.ArrowAssoc((Object)"values");
            objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string9, (Object)values);
            string = buffer.append("\n").append(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).map((Function1 & Serializable)_$68 -> this.renderField((Tuple2<String, MetaSchema>)_$68, INDENT_STEP)).mkString("\n")).toString();
        } else if (metaSchema instanceof MetaSchema.Ref) {
            MetaSchema.Ref ref = MetaSchema$Ref$.MODULE$.unapply((MetaSchema.Ref)metaSchema);
            Chunk chunk = ref._1();
            Chunk chunk4 = ref._2();
            boolean bl = ref._3();
            Chunk refPath = chunk;
            boolean optional = bl;
            StringBuffer buffer = new StringBuffer();
            buffer.append(new StringBuilder(4).append("ref#").append(refPath).toString());
            if (optional) {
                buffer.append("?");
            }
            string = buffer.toString();
        } else if (metaSchema instanceof MetaSchema.Dynamic) {
            MetaSchema.Dynamic dynamic = MetaSchema$Dynamic$.MODULE$.unapply((MetaSchema.Dynamic)metaSchema);
            boolean bl = dynamic._1();
            Chunk chunk = dynamic._2();
            boolean bl2 = dynamic._3();
            boolean withSchema = bl;
            boolean optional = bl2;
            StringBuffer buffer = new StringBuffer();
            buffer.append("list");
            if (optional) {
                buffer.append("?");
            }
            StringBuffer stringBuffer = withSchema ? buffer.append("semidynamic") : buffer.append("dynamic");
            string = buffer.toString();
        } else {
            throw new MatchError((Object)metaSchema);
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String renderField(Tuple2<String, MetaSchema> value, int indent) {
        String string;
        StringBuffer buffer = new StringBuffer();
        Tuple2<String, MetaSchema> tuple2 = value;
        if (tuple2 == null) throw Predef$.MODULE$.$qmark$qmark$qmark();
        String string2 = (String)tuple2._1();
        MetaSchema metaSchema = (MetaSchema)tuple2._2();
        String label = string2;
        if (metaSchema instanceof MetaSchema.Value) {
            MetaSchema.Value value2 = MetaSchema$Value$.MODULE$.unapply((MetaSchema.Value)metaSchema);
            StandardType<?> standardType = value2._1();
            Chunk chunk = value2._2();
            boolean bl = value2._3();
            MetaSchema.Value value3 = (MetaSchema.Value)metaSchema;
            string = this.renderValue(value3, indent, (Option<String>)Some$.MODULE$.apply((Object)label));
            return string;
        } else {
            String label2 = string2;
            if (metaSchema instanceof MetaSchema.FailNode) {
                MetaSchema.FailNode failNode = MetaSchema$FailNode$.MODULE$.unapply((MetaSchema.FailNode)metaSchema);
                String string3 = failNode._1();
                Chunk chunk = failNode._2();
                boolean bl = failNode._3();
                MetaSchema.FailNode fail = (MetaSchema.FailNode)metaSchema;
                string = this.renderFail(fail, indent, (Option<String>)Some$.MODULE$.apply((Object)label2));
                return string;
            } else {
                String label3 = string2;
                if (metaSchema instanceof MetaSchema.Product) {
                    MetaSchema.Product product = MetaSchema$Product$.MODULE$.unapply((MetaSchema.Product)metaSchema);
                    TypeId typeId = product._1();
                    Chunk chunk = product._2();
                    Chunk<Tuple2<String, MetaSchema>> chunk2 = product._3();
                    boolean bl = product._4();
                    Chunk<Tuple2<String, MetaSchema>> fields = chunk2;
                    boolean optional = bl;
                    this.pad(buffer, indent);
                    buffer.append(new StringBuilder(8).append(label3).append(": record").toString());
                    if (optional) {
                        buffer.append("?");
                    }
                    string = buffer.append("\n").append(fields.map((Function1 & Serializable)_$69 -> this.renderField((Tuple2<String, MetaSchema>)_$69, indent + INDENT_STEP)).mkString("\n")).toString();
                    return string;
                } else {
                    String label4 = string2;
                    if (metaSchema instanceof MetaSchema.Tuple) {
                        MetaSchema.Tuple tuple = MetaSchema$Tuple$.MODULE$.unapply((MetaSchema.Tuple)metaSchema);
                        Chunk chunk = tuple._1();
                        MetaSchema metaSchema2 = tuple._2();
                        MetaSchema metaSchema3 = tuple._3();
                        boolean bl = tuple._4();
                        MetaSchema left = metaSchema2;
                        MetaSchema right = metaSchema3;
                        boolean optional = bl;
                        this.pad(buffer, indent);
                        buffer.append(new StringBuilder(7).append(label4).append(": tuple").toString());
                        if (optional) {
                            buffer.append("?");
                        }
                        Object[] objectArray = new Tuple2[2];
                        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"left");
                        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)left);
                        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"right");
                        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)right);
                        string = buffer.append("\n").append(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).map((Function1 & Serializable)_$70 -> this.renderField((Tuple2<String, MetaSchema>)_$70, indent + INDENT_STEP)).mkString("\n")).toString();
                        return string;
                    } else {
                        String label5 = string2;
                        if (metaSchema instanceof MetaSchema.Sum) {
                            MetaSchema.Sum sum = MetaSchema$Sum$.MODULE$.unapply((MetaSchema.Sum)metaSchema);
                            TypeId typeId = sum._1();
                            Chunk chunk = sum._2();
                            Chunk<Tuple2<String, MetaSchema>> chunk3 = sum._3();
                            boolean bl = sum._4();
                            Chunk<Tuple2<String, MetaSchema>> cases = chunk3;
                            boolean optional = bl;
                            this.pad(buffer, indent);
                            buffer.append(new StringBuilder(6).append(label5).append(": enum").toString());
                            if (optional) {
                                buffer.append("?");
                            }
                            string = buffer.append("\n").append(cases.map((Function1 & Serializable)_$71 -> this.renderField((Tuple2<String, MetaSchema>)_$71, indent + INDENT_STEP)).mkString("\n")).toString();
                            return string;
                        } else {
                            String label6 = string2;
                            if (metaSchema instanceof MetaSchema.Either) {
                                MetaSchema.Either either = MetaSchema$Either$.MODULE$.unapply((MetaSchema.Either)metaSchema);
                                Chunk chunk = either._1();
                                MetaSchema metaSchema4 = either._2();
                                MetaSchema metaSchema5 = either._3();
                                boolean bl = either._4();
                                MetaSchema left = metaSchema4;
                                MetaSchema right = metaSchema5;
                                boolean optional = bl;
                                this.pad(buffer, indent);
                                buffer.append(new StringBuilder(8).append(label6).append(": either").toString());
                                if (optional) {
                                    buffer.append("?");
                                }
                                Object[] objectArray = new Tuple2[2];
                                String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"left");
                                objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)left);
                                String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)"right");
                                objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, (Object)right);
                                string = buffer.append("\n").append(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).map((Function1 & Serializable)_$72 -> this.renderField((Tuple2<String, MetaSchema>)_$72, indent + INDENT_STEP)).mkString("\n")).toString();
                                return string;
                            } else {
                                String label7 = string2;
                                if (metaSchema instanceof MetaSchema.ListNode) {
                                    MetaSchema.ListNode listNode = MetaSchema$ListNode$.MODULE$.unapply((MetaSchema.ListNode)metaSchema);
                                    MetaSchema metaSchema6 = listNode._1();
                                    Chunk chunk = listNode._2();
                                    boolean bl = listNode._3();
                                    MetaSchema items = metaSchema6;
                                    boolean optional = bl;
                                    StringBuffer buffer2 = new StringBuffer();
                                    buffer2.append(new StringBuilder(6).append(label7).append(": list").toString());
                                    if (optional) {
                                        buffer2.append("?");
                                    }
                                    Object[] objectArray = new Tuple2[1];
                                    String string8 = (String)Predef$.MODULE$.ArrowAssoc((Object)"item");
                                    objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string8, (Object)items);
                                    string = buffer2.append("\n").append(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).map((Function1 & Serializable)_$73 -> this.renderField((Tuple2<String, MetaSchema>)_$73, INDENT_STEP)).mkString("\n")).toString();
                                    return string;
                                } else {
                                    String label8 = string2;
                                    if (metaSchema instanceof MetaSchema.Dictionary) {
                                        MetaSchema.Dictionary dictionary = MetaSchema$Dictionary$.MODULE$.unapply((MetaSchema.Dictionary)metaSchema);
                                        MetaSchema metaSchema7 = dictionary._1();
                                        MetaSchema metaSchema8 = dictionary._2();
                                        Chunk chunk = dictionary._3();
                                        boolean bl = dictionary._4();
                                        MetaSchema keys = metaSchema7;
                                        MetaSchema values = metaSchema8;
                                        boolean optional = bl;
                                        StringBuffer buffer3 = new StringBuffer();
                                        buffer3.append(new StringBuilder(5).append(label8).append(": map").toString());
                                        if (optional) {
                                            buffer3.append("?");
                                        }
                                        Object[] objectArray = new Tuple2[2];
                                        String string9 = (String)Predef$.MODULE$.ArrowAssoc((Object)"keys");
                                        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string9, (Object)keys);
                                        String string10 = (String)Predef$.MODULE$.ArrowAssoc((Object)"values");
                                        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string10, (Object)values);
                                        string = buffer3.append("\n").append(Chunk$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).map((Function1 & Serializable)_$74 -> this.renderField((Tuple2<String, MetaSchema>)_$74, INDENT_STEP)).mkString("\n")).toString();
                                        return string;
                                    } else {
                                        String label9 = string2;
                                        if (metaSchema instanceof MetaSchema.Ref) {
                                            MetaSchema.Ref ref = MetaSchema$Ref$.MODULE$.unapply((MetaSchema.Ref)metaSchema);
                                            Chunk chunk = ref._1();
                                            Chunk chunk4 = ref._2();
                                            boolean bl = ref._3();
                                            Chunk refPath = chunk;
                                            boolean optional = bl;
                                            this.pad(buffer, indent);
                                            buffer.append(new StringBuilder(2).append(label9).append(": ").toString());
                                            if (optional) {
                                                buffer.append("?");
                                            }
                                            string = buffer.append(new StringBuilder(6).append("{ref#").append(package$.MODULE$.DebugOps((Object)refPath).render(Debug$.MODULE$.ChunkDebug(Debug$.MODULE$.StringDebug()))).append("}").toString()).toString();
                                            return string;
                                        } else {
                                            String label10 = string2;
                                            if (!(metaSchema instanceof MetaSchema.Dynamic)) throw Predef$.MODULE$.$qmark$qmark$qmark();
                                            MetaSchema.Dynamic dynamic = MetaSchema$Dynamic$.MODULE$.unapply((MetaSchema.Dynamic)metaSchema);
                                            boolean bl = dynamic._1();
                                            Chunk chunk = dynamic._2();
                                            boolean bl2 = dynamic._3();
                                            boolean withSchema = bl;
                                            boolean optional = bl2;
                                            this.pad(buffer, indent);
                                            buffer.append(new StringBuilder(2).append(label10).append(": ").toString());
                                            if (optional) {
                                                buffer.append("?");
                                            }
                                            StringBuffer stringBuffer = withSchema ? buffer.append("semidynamic") : buffer.append("dynamic");
                                            string = buffer.toString();
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return string;
    }

    public String renderValue(MetaSchema.Value value, int indent, Option<String> label) {
        StringBuffer buffer = new StringBuffer();
        this.pad(buffer, indent);
        label.foreach((Function1 & Serializable)l -> buffer.append(new StringBuilder(2).append((String)l).append(": ").toString()));
        if (value.optional()) {
            buffer.append("?");
        }
        return buffer.append(value.valueType().tag()).toString();
    }

    public String renderFail(MetaSchema.FailNode fail, int indent, Option<String> label) {
        StringBuffer buffer = new StringBuffer();
        this.pad(buffer, indent);
        label.foreach((Function1 & Serializable)l -> buffer.append(new StringBuilder(2).append((String)l).append(": ").toString()));
        if (fail.optional()) {
            buffer.append("?");
        }
        return buffer.append(new StringBuilder(6).append("FAIL: ").append(fail.message()).toString()).toString();
    }

    private StringBuffer pad(StringBuffer buffer, int indent) {
        if (indent > 0) {
            buffer.append("|");
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), indent).foreach((Function1 & Serializable)x$1 -> this.pad$$anonfun$1(buffer, BoxesRunTime.unboxToInt((Object)x$1)));
        }
        return buffer;
    }

    private final /* synthetic */ StringBuffer pad$$anonfun$1(StringBuffer buffer$3, int x$1) {
        int n = x$1;
        return buffer$3.append("-");
    }
}

