/*
 * Decompiled with CFR 0.152.
 */
package zio.schema.codec;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.nio.ByteBuffer;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.UUID;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.transport.TTransport;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.ListMap;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;
import zio.Chunk;
import zio.Chunk$;
import zio.Unsafe$;
import zio.schema.DynamicValue;
import zio.schema.MutableSchemaBasedValueBuilder;
import zio.schema.MutableSchemaBasedValueProcessor;
import zio.schema.Schema;
import zio.schema.StandardType;
import zio.schema.annotation.fieldDefaultValue;
import zio.schema.annotation.optionalField;
import zio.schema.annotation.transientField;
import zio.schema.codec.BinaryCodec;
import zio.schema.codec.ChunkTransport;
import zio.schema.codec.DecodeError;
import zio.schema.codec.ThriftCodec$;
import zio.schema.codec.ThriftCodec$DecoderContext$;
import zio.schema.codec.ThriftCodec$Encoder$;
import zio.schema.codec.ThriftCodec$Encoder$Context$;

public final class ThriftCodec {
    public static <A> BinaryCodec<A> thriftCodec(Schema<A> schema) {
        return ThriftCodec$.MODULE$.thriftCodec(schema);
    }

    public static class Decoder
    implements MutableSchemaBasedValueBuilder<Object, DecoderContext> {
        private final ChunkTransport.Read read;
        private final TBinaryProtocol p;
        private final DecoderContext initialContext;

        public Decoder(Chunk<Object> chunk) {
            this.read = new ChunkTransport.Read(chunk);
            this.p = new TBinaryProtocol((TTransport)this.read());
            this.initialContext = ThriftCodec$DecoderContext$.MODULE$.apply((Chunk<String>)Chunk$.MODULE$.empty(), (Option<Object>)None$.MODULE$);
        }

        public ChunkTransport.Read read() {
            return this.read;
        }

        public TBinaryProtocol p() {
            return this.p;
        }

        public <A> Function1<Chunk<String>, A> decodePrimitive(Function1<TProtocol, A> f, String name) {
            return (Function1 & Serializable)path -> {
                Object object;
                try {
                    object = f.apply((Object)this.p());
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3 = (Throwable)option.get();
                        throw DecodeError.MalformedFieldWithPath$.MODULE$.apply(path, new StringBuilder(17).append("Unable to decode ").append(name).toString());
                    }
                    throw throwable;
                }
                return object;
            };
        }

        public Function1<Chunk<String>, String> decodeString() {
            return this.decodePrimitive((Function1 & Serializable)_$3 -> _$3.readString(), "String");
        }

        public Function1<Chunk<String>, UUID> decodeUUID() {
            return this.decodePrimitive((Function1 & Serializable)protocol -> UUID.fromString(protocol.readString()), "UUID");
        }

        public Function1<Chunk<String>, Object> decodeByte() {
            return this.decodePrimitive((Function1 & Serializable)_$4 -> _$4.readByte(), "Byte");
        }

        public Function1<Chunk<String>, Object> decodeBoolean() {
            return this.decodePrimitive((Function1 & Serializable)_$5 -> _$5.readBool(), "Boolean");
        }

        public Function1<Chunk<String>, Object> decodeShort() {
            return this.decodePrimitive((Function1 & Serializable)_$6 -> _$6.readI16(), "Short");
        }

        public Function1<Chunk<String>, Object> decodeInt() {
            return this.decodePrimitive((Function1 & Serializable)_$7 -> _$7.readI32(), "Int");
        }

        public Function1<Chunk<String>, Object> decodeLong() {
            return this.decodePrimitive((Function1 & Serializable)_$8 -> _$8.readI64(), "Long");
        }

        public Function1<Chunk<String>, Object> decodeFloat() {
            return this.decodePrimitive((Function1 & Serializable)_$9 -> (float)_$9.readDouble(), "Float");
        }

        public Function1<Chunk<String>, Object> decodeDouble() {
            return this.decodePrimitive((Function1 & Serializable)_$10 -> _$10.readDouble(), "Double");
        }

        public Function1<Chunk<String>, BigInteger> decodeBigInteger() {
            return this.decodePrimitive((Function1 & Serializable)p -> new BigInteger(p.readBinary().array()), "BigInteger");
        }

        public Function1<Chunk<String>, Chunk<Object>> decodeBinary() {
            return this.decodePrimitive((Function1 & Serializable)p -> Chunk$.MODULE$.fromByteBuffer(p.readBinary()), "Binary");
        }

        public Object createPrimitive(DecoderContext context, StandardType<?> typ) {
            StandardType<?> standardType = typ;
            if (StandardType.UnitType$.MODULE$.equals(standardType)) {
                return BoxedUnit.UNIT;
            }
            if (StandardType.StringType$.MODULE$.equals(standardType)) {
                return this.decodeString().apply(context.path());
            }
            if (StandardType.BoolType$.MODULE$.equals(standardType)) {
                return this.decodeBoolean().apply(context.path());
            }
            if (StandardType.ByteType$.MODULE$.equals(standardType)) {
                return this.decodeByte().apply(context.path());
            }
            if (StandardType.ShortType$.MODULE$.equals(standardType)) {
                return this.decodeShort().apply(context.path());
            }
            if (StandardType.IntType$.MODULE$.equals(standardType)) {
                return this.decodeInt().apply(context.path());
            }
            if (StandardType.LongType$.MODULE$.equals(standardType)) {
                return this.decodeLong().apply(context.path());
            }
            if (StandardType.FloatType$.MODULE$.equals(standardType)) {
                return this.decodeFloat().apply(context.path());
            }
            if (StandardType.DoubleType$.MODULE$.equals(standardType)) {
                return this.decodeDouble().apply(context.path());
            }
            if (StandardType.BigIntegerType$.MODULE$.equals(standardType)) {
                return this.decodeBigInteger().apply(context.path());
            }
            if (StandardType.BigDecimalType$.MODULE$.equals(standardType)) {
                this.p().readFieldBegin();
                BigInteger unscaled = (BigInteger)this.decodeBigInteger().apply(context.path());
                this.p().readFieldBegin();
                int precision = BoxesRunTime.unboxToInt((Object)this.decodeInt().apply(context.path()));
                this.p().readFieldBegin();
                int scale = BoxesRunTime.unboxToInt((Object)this.decodeInt().apply(context.path()));
                this.p().readFieldBegin();
                return new BigDecimal(unscaled, scale, new MathContext(precision));
            }
            if (StandardType.BinaryType$.MODULE$.equals(standardType)) {
                return this.decodeBinary().apply(context.path());
            }
            if (StandardType.CharType$.MODULE$.equals(standardType)) {
                String decoded = (String)this.decodeString().apply(context.path());
                if (decoded.length() == 1) {
                    return BoxesRunTime.boxToCharacter((char)decoded.charAt(0));
                }
                return this.fail(context, new StringBuilder(35).append("Expected character, found string \"").append(decoded).append("\"").toString());
            }
            if (StandardType.UUIDType$.MODULE$.equals(standardType)) {
                return this.decodeUUID().apply(context.path());
            }
            if (StandardType.DayOfWeekType$.MODULE$.equals(standardType)) {
                return DayOfWeek.of(BoxesRunTime.unboxToByte((Object)this.decodeByte().apply(context.path())));
            }
            if (StandardType.MonthType$.MODULE$.equals(standardType)) {
                return Month.of(BoxesRunTime.unboxToByte((Object)this.decodeByte().apply(context.path())));
            }
            if (StandardType.MonthDayType$.MODULE$.equals(standardType)) {
                this.p().readFieldBegin();
                int month = BoxesRunTime.unboxToInt((Object)this.decodeInt().apply(context.path()));
                this.p().readFieldBegin();
                int day = BoxesRunTime.unboxToInt((Object)this.decodeInt().apply(context.path()));
                this.p().readFieldBegin();
                return MonthDay.of(month, day);
            }
            if (StandardType.PeriodType$.MODULE$.equals(standardType)) {
                this.p().readFieldBegin();
                int year = BoxesRunTime.unboxToInt((Object)this.decodeInt().apply(context.path()));
                this.p().readFieldBegin();
                int month = BoxesRunTime.unboxToInt((Object)this.decodeInt().apply(context.path()));
                this.p().readFieldBegin();
                int day = BoxesRunTime.unboxToInt((Object)this.decodeInt().apply(context.path()));
                this.p().readFieldBegin();
                return Period.of(year, month, day);
            }
            if (StandardType.YearType$.MODULE$.equals(standardType)) {
                return Year.of(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)this.decodeInt().apply(context.path()))));
            }
            if (StandardType.YearMonthType$.MODULE$.equals(standardType)) {
                this.p().readFieldBegin();
                int year = BoxesRunTime.unboxToInt((Object)this.decodeInt().apply(context.path()));
                this.p().readFieldBegin();
                int month = BoxesRunTime.unboxToInt((Object)this.decodeInt().apply(context.path()));
                this.p().readFieldBegin();
                return YearMonth.of(year, month);
            }
            if (StandardType.ZoneIdType$.MODULE$.equals(standardType)) {
                return ZoneId.of((String)this.decodeString().apply(context.path()));
            }
            if (StandardType.ZoneOffsetType$.MODULE$.equals(standardType)) {
                return ZoneOffset.ofTotalSeconds(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)this.decodeInt().apply(context.path()))));
            }
            if (StandardType.DurationType$.MODULE$.equals(standardType)) {
                this.p().readFieldBegin();
                long seconds = BoxesRunTime.unboxToLong((Object)this.decodeLong().apply(context.path()));
                this.p().readFieldBegin();
                int nano = BoxesRunTime.unboxToInt((Object)this.decodeInt().apply(context.path()));
                this.p().readFieldBegin();
                return Duration.ofSeconds(seconds, nano);
            }
            if (StandardType.InstantType$.MODULE$.equals(standardType)) {
                return Instant.parse((CharSequence)this.decodeString().apply(context.path()));
            }
            if (StandardType.LocalDateType$.MODULE$.equals(standardType)) {
                return LocalDate.parse((CharSequence)this.decodeString().apply(context.path()));
            }
            if (StandardType.LocalTimeType$.MODULE$.equals(standardType)) {
                return LocalTime.parse((CharSequence)this.decodeString().apply(context.path()));
            }
            if (StandardType.LocalDateTimeType$.MODULE$.equals(standardType)) {
                return LocalDateTime.parse((CharSequence)this.decodeString().apply(context.path()));
            }
            if (StandardType.OffsetTimeType$.MODULE$.equals(standardType)) {
                return OffsetTime.parse((CharSequence)this.decodeString().apply(context.path()));
            }
            if (StandardType.OffsetDateTimeType$.MODULE$.equals(standardType)) {
                return OffsetDateTime.parse((CharSequence)this.decodeString().apply(context.path()));
            }
            if (StandardType.ZonedDateTimeType$.MODULE$.equals(standardType)) {
                return ZonedDateTime.parse((CharSequence)this.decodeString().apply(context.path()));
            }
            return this.fail(context, new StringBuilder(27).append("Unsupported primitive type ").append(typ).toString());
        }

        public DecoderContext startCreatingRecord(DecoderContext context, Schema.Record<?> record) {
            return context;
        }

        public Option<Tuple2<DecoderContext, Object>> startReadingField(DecoderContext context, Schema.Record<?> record, int index) {
            if (record.fields().nonEmpty()) {
                TField tfield = this.p().readFieldBegin();
                if (tfield.type == 0) {
                    return None$.MODULE$;
                }
                return Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)context.copy((Chunk<String>)((Chunk)context.path().$colon$plus((Object)new StringBuilder(8).append("fieldId:").append(tfield.id).toString())), context.copy$default$2()), (Object)BoxesRunTime.boxToInteger((int)(tfield.id - 1))));
            }
            byte by = this.p().readByte();
            return None$.MODULE$;
        }

        public Object createRecord(DecoderContext context, Schema.Record<?> record, Chunk<Tuple2<Object, Object>> values) {
            if (record.fields().nonEmpty()) {
                Map valuesMap = values.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                Chunk allValues = record.fields().zipWithIndex().map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Schema.Field field = (Schema.Field)tuple2._1();
                        int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                        Option option = valuesMap.get((Object)BoxesRunTime.boxToInteger((int)idx));
                        if (option instanceof Some) {
                            Object value = ((Some)option).value();
                            return value;
                        }
                        if (None$.MODULE$.equals(option)) {
                            Option option2 = this.emptyValue(field.schema());
                            if (option2 instanceof Some) {
                                Object value = ((Some)option2).value();
                                return value;
                            }
                            if (None$.MODULE$.equals(option2)) {
                                Option optionalFieldAnnotation = field.annotations().collectFirst((PartialFunction)new Serializable(){

                                    public final boolean isDefinedAt(Object x) {
                                        Object object = x;
                                        if (object instanceof optionalField) {
                                            optionalField a = (optionalField)object;
                                            return true;
                                        }
                                        return false;
                                    }

                                    public final Object applyOrElse(Object x, Function1 function1) {
                                        Object object = x;
                                        if (object instanceof optionalField) {
                                            optionalField a = (optionalField)object;
                                            return a;
                                        }
                                        return function1.apply(x);
                                    }
                                });
                                Option transientFieldAnnotation = field.annotations().collectFirst((PartialFunction)new Serializable(){

                                    public final boolean isDefinedAt(Object x) {
                                        Object object = x;
                                        if (object instanceof transientField) {
                                            transientField a = (transientField)object;
                                            return true;
                                        }
                                        return false;
                                    }

                                    public final Object applyOrElse(Object x, Function1 function1) {
                                        Object object = x;
                                        if (object instanceof transientField) {
                                            transientField a = (transientField)object;
                                            return a;
                                        }
                                        return function1.apply(x);
                                    }
                                });
                                Option fieldDefaultValueAnnotation = field.annotations().collectFirst((PartialFunction)new Serializable(){

                                    public final boolean isDefinedAt(Object x) {
                                        Object object = x;
                                        if (object instanceof fieldDefaultValue) {
                                            fieldDefaultValue a = (fieldDefaultValue)object;
                                            return true;
                                        }
                                        return false;
                                    }

                                    public final Object applyOrElse(Object x, Function1 function1) {
                                        Object object = x;
                                        if (object instanceof fieldDefaultValue) {
                                            fieldDefaultValue a = (fieldDefaultValue)object;
                                            return a;
                                        }
                                        return function1.apply(x);
                                    }
                                });
                                if (optionalFieldAnnotation.isDefined() || transientFieldAnnotation.isDefined()) {
                                    return field.schema().defaultValue().toOption().get();
                                }
                                if (fieldDefaultValueAnnotation.isDefined()) {
                                    return ((fieldDefaultValue)fieldDefaultValueAnnotation.get()).value();
                                }
                                return this.fail(context.copy((Chunk<String>)((Chunk)context.path().$colon$plus((Object)field.name())), context.copy$default$2()), "Missing value");
                            }
                            throw new MatchError(option2);
                        }
                        throw new MatchError((Object)option);
                    }
                    throw new MatchError((Object)tuple2);
                });
                return Unsafe$.MODULE$.unsafe((Function1 & Serializable)u -> {
                    Either either = record.construct(allValues, u);
                    if (either instanceof Left) {
                        String message = (String)((Left)either).value();
                        return this.fail(context, message);
                    }
                    if (either instanceof Right) {
                        Object value = ((Right)either).value();
                        return value;
                    }
                    throw new MatchError((Object)either);
                });
            }
            return Unsafe$.MODULE$.unsafe((Function1 & Serializable)u -> {
                Either either = record.construct(Chunk$.MODULE$.empty(), u);
                if (either instanceof Left) {
                    String message = (String)((Left)either).value();
                    return this.fail(context, message);
                }
                if (either instanceof Right) {
                    Object value = ((Right)either).value();
                    return value;
                }
                throw new MatchError((Object)either);
            });
        }

        public Tuple2<DecoderContext, Object> startCreatingEnum(DecoderContext context, Chunk<Schema.Case<?, ?>> cases) {
            TField readField = this.p().readFieldBegin();
            int consIdx = readField.id - 1;
            Schema.Case subtypeCase = (Schema.Case)cases.apply(consIdx);
            return Tuple2$.MODULE$.apply((Object)context.copy((Chunk<String>)((Chunk)context.path().$colon$plus((Object)new StringBuilder(7).append("[case:").append(subtypeCase.id()).append("]").toString())), context.copy$default$2()), (Object)BoxesRunTime.boxToInteger((int)consIdx));
        }

        public Object createEnum(DecoderContext context, Chunk<Schema.Case<?, ?>> cases, int index, Object value) {
            this.p().readFieldBegin();
            return value;
        }

        public Option<DecoderContext> startCreatingSequence(DecoderContext context, Schema.Sequence<?, ?, ?> schema) {
            TList begin = this.p().readListBegin();
            if (begin.size == 0) {
                return None$.MODULE$;
            }
            Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)begin.size));
            Chunk<String> chunk = context.copy$default$1();
            return Some$.MODULE$.apply((Object)context.copy(chunk, (Option<Object>)some));
        }

        public DecoderContext startCreatingOneSequenceElement(DecoderContext context, Schema.Sequence<?, ?, ?> schema) {
            return context;
        }

        public boolean finishedCreatingOneSequenceElement(DecoderContext context, Schema.Sequence<?, ?, ?> schema, int index) {
            return context.expectedCount().map((Function1)(JFunction1.mcII.sp & Serializable)_$11 -> _$11 - (index + 1)).exists((Function1)(JFunction1.mcZI.sp & Serializable)_$12 -> _$12 > 0);
        }

        public Object createSequence(DecoderContext context, Schema.Sequence<?, ?, ?> schema, Chunk<Object> values) {
            return schema.fromChunk().apply(values);
        }

        public Option<DecoderContext> startCreatingDictionary(DecoderContext context, Schema.Map<?, ?> schema) {
            TMap begin = this.p().readMapBegin();
            if (begin.size == 0) {
                return None$.MODULE$;
            }
            Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)begin.size));
            Chunk<String> chunk = context.copy$default$1();
            return Some$.MODULE$.apply((Object)context.copy(chunk, (Option<Object>)some));
        }

        public DecoderContext startCreatingOneDictionaryElement(DecoderContext context, Schema.Map<?, ?> schema) {
            return context;
        }

        public DecoderContext startCreatingOneDictionaryValue(DecoderContext context, Schema.Map<?, ?> schema) {
            return context;
        }

        public boolean finishedCreatingOneDictionaryElement(DecoderContext context, Schema.Map<?, ?> schema, int index) {
            return context.expectedCount().map((Function1)(JFunction1.mcII.sp & Serializable)_$13 -> _$13 - (index + 1)).exists((Function1)(JFunction1.mcZI.sp & Serializable)_$14 -> _$14 > 0);
        }

        public Object createDictionary(DecoderContext context, Schema.Map<?, ?> schema, Chunk<Tuple2<Object, Object>> values) {
            return values.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        public Option<DecoderContext> startCreatingSet(DecoderContext context, Schema.Set<?> schema) {
            TSet begin = this.p().readSetBegin();
            if (begin.size == 0) {
                return None$.MODULE$;
            }
            Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)begin.size));
            Chunk<String> chunk = context.copy$default$1();
            return Some$.MODULE$.apply((Object)context.copy(chunk, (Option<Object>)some));
        }

        public DecoderContext startCreatingOneSetElement(DecoderContext context, Schema.Set<?> schema) {
            return context;
        }

        public boolean finishedCreatingOneSetElement(DecoderContext context, Schema.Set<?> schema, int index) {
            return context.expectedCount().map((Function1)(JFunction1.mcII.sp & Serializable)_$15 -> _$15 - (index + 1)).exists((Function1)(JFunction1.mcZI.sp & Serializable)_$16 -> _$16 > 0);
        }

        public Object createSet(DecoderContext context, Schema.Set<?> schema, Chunk<Object> values) {
            return values.toSet();
        }

        public Option<DecoderContext> startCreatingOptional(DecoderContext context, Schema.Optional<?> schema) {
            TField field = this.p().readFieldBegin();
            short s = field.id;
            if (1 == s) {
                return None$.MODULE$;
            }
            if (2 == s) {
                return Some$.MODULE$.apply((Object)context.copy((Chunk<String>)((Chunk)context.path().$colon$plus((Object)"Some")), context.copy$default$2()));
            }
            short id = s;
            return (Option)this.fail(context, new StringBuilder(40).append("Error decoding optional, wrong field id ").append(id).toString());
        }

        public Object createOptional(DecoderContext context, Schema.Optional<?> schema, Option<Object> value) {
            this.p().readFieldBegin();
            return value;
        }

        public Either<DecoderContext, DecoderContext> startCreatingEither(DecoderContext context, Schema.Either<?, ?> schema) {
            TField readField = this.p().readFieldBegin();
            short s = readField.id;
            if (1 == s) {
                return package$.MODULE$.Left().apply((Object)context.copy((Chunk<String>)((Chunk)context.path().$colon$plus((Object)"either:left")), context.copy$default$2()));
            }
            if (2 == s) {
                return package$.MODULE$.Right().apply((Object)context.copy((Chunk<String>)((Chunk)context.path().$colon$plus((Object)"either:right")), context.copy$default$2()));
            }
            return (Either)this.fail(context, "Failed to decode either.");
        }

        public Object createEither(DecoderContext context, Schema.Either<?, ?> schema, Either<Object, Object> value) {
            return value;
        }

        public DecoderContext startCreatingTuple(DecoderContext context, Schema.Tuple2<?, ?> schema) {
            this.p().readFieldBegin();
            return context;
        }

        public DecoderContext startReadingSecondTupleElement(DecoderContext context, Schema.Tuple2<?, ?> schema) {
            this.p().readFieldBegin();
            return context;
        }

        public Object createTuple(DecoderContext context, Schema.Tuple2<?, ?> schema, Object left, Object right) {
            this.p().readFieldBegin();
            return Tuple2$.MODULE$.apply(left, right);
        }

        public Option<Object> createDynamic(DecoderContext context) {
            return None$.MODULE$;
        }

        public Object transform(DecoderContext context, Object value, Function1<Object, Either<String, Object>> f, Schema<?> schema) {
            Either either = (Either)f.apply(value);
            if (either instanceof Left) {
                String value2 = (String)((Left)either).value();
                return this.fail(context, value2);
            }
            if (either instanceof Right) {
                Object value3 = ((Right)either).value();
                return value3;
            }
            throw new MatchError((Object)either);
        }

        public Object fail(DecoderContext context, String message) {
            throw DecodeError.MalformedFieldWithPath$.MODULE$.apply(context.path(), message);
        }

        public DecoderContext initialContext() {
            return this.initialContext;
        }

        private <A> Option<A> emptyValue(Schema<A> schema) {
            Schema schema2;
            while ((schema2 = schema) instanceof Schema.Lazy) {
                Function0 function0;
                Schema.Lazy lazy = Schema.Lazy$.MODULE$.unapply((Schema.Lazy)schema2);
                Function0 s = function0 = lazy._1();
                schema = (Schema)s.apply();
            }
            if (schema2 instanceof Schema.Optional) {
                Schema.Optional optional = Schema.Optional$.MODULE$.unapply((Schema.Optional)schema2);
                Schema schema3 = optional._1();
                Chunk chunk = optional._2();
                return (Option)Some$.MODULE$.apply((Object)None$.MODULE$);
            }
            if (schema2 instanceof Schema.Sequence) {
                Schema.Sequence sequence = Schema.Sequence$.MODULE$.unapply((Schema.Sequence)schema2);
                Schema schema4 = sequence._1();
                Function1 function1 = sequence._2();
                Function1 function12 = sequence._3();
                Chunk chunk = sequence._4();
                Object object = sequence._5();
                Function1 fromChunk = function1;
                return Some$.MODULE$.apply(fromChunk.apply((Object)Chunk$.MODULE$.empty()));
            }
            if (schema2 instanceof Schema.Primitive) {
                Schema.Primitive primitive = Schema.Primitive$.MODULE$.unapply((Schema.Primitive)schema2);
                StandardType standardType = primitive._1();
                Chunk chunk = primitive._2();
                if (StandardType.UnitType$.MODULE$.equals(standardType)) {
                    return (Option)Some$.MODULE$.apply((Object)BoxedUnit.UNIT);
                }
            }
            return None$.MODULE$;
        }
    }

    public static final class DecoderContext
    implements Product,
    Serializable {
        private final Chunk path;
        private final Option expectedCount;

        public static DecoderContext apply(Chunk<String> chunk, Option<Object> option) {
            return ThriftCodec$DecoderContext$.MODULE$.apply(chunk, option);
        }

        public static DecoderContext fromProduct(Product product) {
            return ThriftCodec$DecoderContext$.MODULE$.fromProduct(product);
        }

        public static DecoderContext unapply(DecoderContext decoderContext) {
            return ThriftCodec$DecoderContext$.MODULE$.unapply(decoderContext);
        }

        public DecoderContext(Chunk<String> path, Option<Object> expectedCount) {
            this.path = path;
            this.expectedCount = expectedCount;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DecoderContext)) return false;
            DecoderContext decoderContext = (DecoderContext)object;
            Chunk<String> chunk = this.path();
            Chunk<String> chunk2 = decoderContext.path();
            if (chunk == null) {
                if (chunk2 != null) {
                    return false;
                }
            } else if (!chunk.equals(chunk2)) return false;
            Option<Object> option = this.expectedCount();
            Option<Object> option2 = decoderContext.expectedCount();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DecoderContext;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "DecoderContext";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "path";
            }
            if (1 == n2) {
                return "expectedCount";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Chunk<String> path() {
            return this.path;
        }

        public Option<Object> expectedCount() {
            return this.expectedCount;
        }

        public DecoderContext copy(Chunk<String> path, Option<Object> expectedCount) {
            return new DecoderContext(path, expectedCount);
        }

        public Chunk<String> copy$default$1() {
            return this.path();
        }

        public Option<Object> copy$default$2() {
            return this.expectedCount();
        }

        public Chunk<String> _1() {
            return this.path();
        }

        public Option<Object> _2() {
            return this.expectedCount();
        }
    }

    public static class Encoder
    implements MutableSchemaBasedValueProcessor<BoxedUnit, Context> {
        private final Context initialContext = ThriftCodec$Encoder$Context$.MODULE$.apply((Option<Object>)None$.MODULE$);
        private final ChunkTransport.Write write = new ChunkTransport.Write();
        private final TBinaryProtocol p = new TBinaryProtocol((TTransport)this.write);

        public void processPrimitive(Context context, Object value, StandardType<Object> typ) {
            this.writeFieldBegin(context.fieldNumber(), ThriftCodec$Encoder$.MODULE$.zio$schema$codec$ThriftCodec$Encoder$$$getPrimitiveType(typ));
            this.writePrimitiveType(typ, value);
        }

        public void startProcessingRecord(Context context, Schema.Record<?> schema) {
            if (schema.fields().nonEmpty()) {
                this.writeFieldBegin(context.fieldNumber(), (byte)12);
                return;
            }
            this.writeFieldBegin(context.fieldNumber(), (byte)3);
            this.writeByte((byte)0);
        }

        public void processRecord(Context context, Schema.Record<?> schema, ListMap<String, BoxedUnit> value) {
            if (schema.fields().nonEmpty()) {
                this.writeFieldEnd();
                return;
            }
        }

        public void startProcessingEnum(Context context, Schema.Enum<?> schema) {
            this.writeFieldBegin(context.fieldNumber(), (byte)12);
        }

        public void processEnum(Context context, Schema.Enum<?> schema, Tuple2<String, BoxedUnit> tuple) {
            this.writeFieldEnd();
        }

        public void startProcessingSequence(Context context, Schema.Sequence<?, ?, ?> schema, int size) {
            this.writeFieldBegin(context.fieldNumber(), (byte)15);
            this.writeListBegin(ThriftCodec$Encoder$.MODULE$.zio$schema$codec$ThriftCodec$Encoder$$$getType(schema.elementSchema()), size);
        }

        public void processSequence(Context context, Schema.Sequence<?, ?, ?> schema, Chunk<BoxedUnit> value) {
        }

        public void startProcessingDictionary(Context context, Schema.Map<?, ?> schema, int size) {
            this.writeFieldBegin(context.fieldNumber(), (byte)13);
            this.writeMapBegin(ThriftCodec$Encoder$.MODULE$.zio$schema$codec$ThriftCodec$Encoder$$$getType(schema.keySchema()), ThriftCodec$Encoder$.MODULE$.zio$schema$codec$ThriftCodec$Encoder$$$getType(schema.valueSchema()), size);
        }

        public void processDictionary(Context context, Schema.Map<?, ?> schema, Chunk<Tuple2<BoxedUnit, BoxedUnit>> value) {
        }

        public void startProcessingSet(Context context, Schema.Set<?> schema, int size) {
            this.writeFieldBegin(context.fieldNumber(), (byte)14);
            this.writeSetBegin(ThriftCodec$Encoder$.MODULE$.zio$schema$codec$ThriftCodec$Encoder$$$getType(schema.elementSchema()), size);
        }

        public void processSet(Context context, Schema.Set<?> schema, Set<BoxedUnit> value) {
        }

        public void startProcessingEither(Context context, Schema.Either<?, ?> schema) {
            this.writeFieldBegin(context.fieldNumber(), (byte)12);
        }

        public void processEither(Context context, Schema.Either<?, ?> schema, Either<BoxedUnit, BoxedUnit> value) {
            this.writeFieldEnd();
        }

        public void startProcessingOption(Context context, Schema.Optional<?> schema) {
            this.writeFieldBegin(context.fieldNumber(), (byte)12);
        }

        public void processOption(Context context, Schema.Optional<?> schema, Option<BoxedUnit> value) {
            Option<BoxedUnit> option = value;
            if (None$.MODULE$.equals(option)) {
                this.processPrimitive(context.copy((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)1))), (Object)BoxedUnit.UNIT, (StandardType<Object>)((StandardType)StandardType.UnitType$.MODULE$));
            }
            this.writeFieldEnd();
        }

        public void startProcessingTuple(Context context, Schema.Tuple2<?, ?> schema) {
            this.writeFieldBegin(context.fieldNumber(), (byte)12);
        }

        public void processTuple(Context context, Schema.Tuple2<?, ?> schema, BoxedUnit left, BoxedUnit right) {
            this.writeFieldEnd();
        }

        public void fail(Context context, String message) {
            this.fail(message);
        }

        public Option<BoxedUnit> processDynamic(Context context, DynamicValue value) {
            return None$.MODULE$;
        }

        public Context initialContext() {
            return this.initialContext;
        }

        public Context contextForRecordField(Context context, int index, Schema.Field<?, ?> field) {
            return context.copy((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)((short)(index + 1)))));
        }

        public Context contextForEnumConstructor(Context context, int index, Schema.Case<?, ?> c) {
            return context.copy((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)((short)(index + 1)))));
        }

        public Context contextForEither(Context context, Either<BoxedUnit, BoxedUnit> e) {
            Either<BoxedUnit, BoxedUnit> either = e;
            if (either instanceof Left) {
                return context.copy((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)1)));
            }
            if (either instanceof Right) {
                return context.copy((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)2)));
            }
            throw new MatchError(either);
        }

        public Context contextForOption(Context context, Option<BoxedUnit> o) {
            Option<BoxedUnit> option = o;
            if (None$.MODULE$.equals(option)) {
                return context.copy((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)1)));
            }
            if (option instanceof Some) {
                return context.copy((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)2)));
            }
            throw new MatchError(option);
        }

        public Context contextForTuple(Context context, int index) {
            return context.copy((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)((short)index))));
        }

        public Context contextForSequence(Context context, Schema.Sequence<?, ?, ?> schema, int index) {
            return context.copy((Option<Object>)None$.MODULE$);
        }

        public Context contextForMap(Context context, Schema.Map<?, ?> schema, int index) {
            return context.copy((Option<Object>)None$.MODULE$);
        }

        public Context contextForSet(Context context, Schema.Set<?> schema, int index) {
            return context.copy((Option<Object>)None$.MODULE$);
        }

        public <A> Chunk<Object> encode(Schema<A> schema, A value) {
            this.process(schema, value);
            return this.write.chunk();
        }

        private void writeFieldBegin(Option<Object> fieldNumber, byte ttype) {
            Option<Object> option = fieldNumber;
            if (option instanceof Some) {
                short num = BoxesRunTime.unboxToShort((Object)((Some)option).value());
                this.p.writeFieldBegin(new TField("", ttype, num));
                return;
            }
            if (None$.MODULE$.equals(option)) {
                return;
            }
            throw new MatchError(option);
        }

        private void writeFieldEnd() {
            this.p.writeFieldStop();
        }

        private void writeString(String value) {
            this.p.writeString(value);
        }

        private void writeBool(boolean value) {
            this.p.writeBool(value);
        }

        private void writeByte(byte value) {
            this.p.writeByte(value);
        }

        private void writeI16(short value) {
            this.p.writeI16(value);
        }

        private void writeI32(int value) {
            this.p.writeI32(value);
        }

        private void writeI64(long value) {
            this.p.writeI64(value);
        }

        private void writeDouble(double value) {
            this.p.writeDouble(value);
        }

        private void writeBinary(Chunk<Object> value) {
            this.p.writeBinary(ByteBuffer.wrap((byte[])value.toArray(ClassTag$.MODULE$.apply(Byte.TYPE))));
        }

        private void writeListBegin(byte ttype, int count) {
            this.p.writeListBegin(new TList(ttype, count));
        }

        private void writeSetBegin(byte ttype, int count) {
            this.p.writeSetBegin(new TSet(ttype, count));
        }

        private void writeMapBegin(byte keyType, byte valueType, int count) {
            this.p.writeMapBegin(new TMap(keyType, valueType, count));
        }

        private void fail(String message) {
            throw new RuntimeException(message);
        }

        private <A> void writePrimitiveType(StandardType<A> standardType, A value) {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(standardType, value);
            if (tuple2 != null) {
                StandardType standardType2 = (StandardType)tuple2._1();
                Object object = tuple2._2();
                if (StandardType.UnitType$.MODULE$.equals(standardType2)) {
                    return;
                }
                if (StandardType.StringType$.MODULE$.equals(standardType2) && object instanceof String) {
                    String str = (String)object;
                    this.writeString(str);
                    return;
                }
                if (StandardType.BoolType$.MODULE$.equals(standardType2) && object instanceof Boolean) {
                    boolean b = BoxesRunTime.unboxToBoolean((Object)object);
                    this.writeBool(b);
                    return;
                }
                if (StandardType.ByteType$.MODULE$.equals(standardType2) && object instanceof Byte) {
                    byte v = BoxesRunTime.unboxToByte((Object)object);
                    this.writeByte(v);
                    return;
                }
                if (StandardType.ShortType$.MODULE$.equals(standardType2) && object instanceof Short) {
                    short v = BoxesRunTime.unboxToShort((Object)object);
                    this.writeI16(v);
                    return;
                }
                if (StandardType.IntType$.MODULE$.equals(standardType2) && object instanceof Integer) {
                    int v = BoxesRunTime.unboxToInt((Object)object);
                    this.writeI32(v);
                    return;
                }
                if (StandardType.LongType$.MODULE$.equals(standardType2) && object instanceof Long) {
                    long v = BoxesRunTime.unboxToLong((Object)object);
                    this.writeI64(v);
                    return;
                }
                if (StandardType.FloatType$.MODULE$.equals(standardType2) && object instanceof Float) {
                    float v = BoxesRunTime.unboxToFloat((Object)object);
                    this.writeDouble(v);
                    return;
                }
                if (StandardType.DoubleType$.MODULE$.equals(standardType2) && object instanceof Double) {
                    double v = BoxesRunTime.unboxToDouble((Object)object);
                    this.writeDouble(v);
                    return;
                }
                if (StandardType.BigIntegerType$.MODULE$.equals(standardType2) && object instanceof BigInteger) {
                    BigInteger v = (BigInteger)object;
                    this.writeBinary((Chunk<Object>)Chunk$.MODULE$.fromArray((Object)v.toByteArray()));
                    return;
                }
                if (StandardType.BigDecimalType$.MODULE$.equals(standardType2) && object instanceof BigDecimal) {
                    BigDecimal v = (BigDecimal)object;
                    BigInteger unscaled = v.unscaledValue();
                    int precision = v.precision();
                    int scale = v.scale();
                    this.writeFieldBegin((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)1)), ThriftCodec$Encoder$.MODULE$.zio$schema$codec$ThriftCodec$Encoder$$$getPrimitiveType(StandardType.BigIntegerType$.MODULE$));
                    this.writePrimitiveType((StandardType<A>)StandardType.BigIntegerType$.MODULE$, (A)unscaled);
                    this.writeFieldBegin((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)2)), ThriftCodec$Encoder$.MODULE$.zio$schema$codec$ThriftCodec$Encoder$$$getPrimitiveType(StandardType.IntType$.MODULE$));
                    this.writePrimitiveType((StandardType<A>)StandardType.IntType$.MODULE$, (A)BoxesRunTime.boxToInteger((int)precision));
                    this.writeFieldBegin((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)3)), ThriftCodec$Encoder$.MODULE$.zio$schema$codec$ThriftCodec$Encoder$$$getPrimitiveType(StandardType.IntType$.MODULE$));
                    this.writePrimitiveType((StandardType<A>)StandardType.IntType$.MODULE$, (A)BoxesRunTime.boxToInteger((int)scale));
                    this.writeFieldEnd();
                    return;
                }
                if (StandardType.BinaryType$.MODULE$.equals(standardType2) && object instanceof Chunk) {
                    Chunk bytes = (Chunk)object;
                    this.writeBinary((Chunk<Object>)Chunk$.MODULE$.fromArray(bytes.toArray(ClassTag$.MODULE$.apply(Byte.TYPE))));
                    return;
                }
                if (StandardType.CharType$.MODULE$.equals(standardType2) && object instanceof Character) {
                    char c = BoxesRunTime.unboxToChar((Object)object);
                    this.writeString(BoxesRunTime.boxToCharacter((char)c).toString());
                    return;
                }
                if (StandardType.UUIDType$.MODULE$.equals(standardType2) && object instanceof UUID) {
                    UUID u = (UUID)object;
                    this.writeString(u.toString());
                    return;
                }
                if (StandardType.DayOfWeekType$.MODULE$.equals(standardType2) && object instanceof DayOfWeek) {
                    DayOfWeek v = (DayOfWeek)object;
                    this.writeByte((byte)v.getValue());
                    return;
                }
                if (StandardType.MonthType$.MODULE$.equals(standardType2) && object instanceof Month) {
                    Month v = (Month)object;
                    this.writeByte((byte)v.getValue());
                    return;
                }
                if (StandardType.MonthDayType$.MODULE$.equals(standardType2) && object instanceof MonthDay) {
                    MonthDay v = (MonthDay)object;
                    this.writeFieldBegin((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)1)), ThriftCodec$Encoder$.MODULE$.zio$schema$codec$ThriftCodec$Encoder$$$getPrimitiveType(StandardType.IntType$.MODULE$));
                    this.writePrimitiveType((StandardType<A>)StandardType.IntType$.MODULE$, (A)BoxesRunTime.boxToInteger((int)v.getMonthValue()));
                    this.writeFieldBegin((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)2)), ThriftCodec$Encoder$.MODULE$.zio$schema$codec$ThriftCodec$Encoder$$$getPrimitiveType(StandardType.IntType$.MODULE$));
                    this.writePrimitiveType((StandardType<A>)StandardType.IntType$.MODULE$, (A)BoxesRunTime.boxToInteger((int)v.getDayOfMonth()));
                    this.writeFieldEnd();
                    return;
                }
                if (StandardType.PeriodType$.MODULE$.equals(standardType2) && object instanceof Period) {
                    Period v = (Period)object;
                    this.writeFieldBegin((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)1)), ThriftCodec$Encoder$.MODULE$.zio$schema$codec$ThriftCodec$Encoder$$$getPrimitiveType(StandardType.IntType$.MODULE$));
                    this.writePrimitiveType((StandardType<A>)StandardType.IntType$.MODULE$, (A)BoxesRunTime.boxToInteger((int)v.getYears()));
                    this.writeFieldBegin((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)2)), ThriftCodec$Encoder$.MODULE$.zio$schema$codec$ThriftCodec$Encoder$$$getPrimitiveType(StandardType.IntType$.MODULE$));
                    this.writePrimitiveType((StandardType<A>)StandardType.IntType$.MODULE$, (A)BoxesRunTime.boxToInteger((int)v.getMonths()));
                    this.writeFieldBegin((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)3)), ThriftCodec$Encoder$.MODULE$.zio$schema$codec$ThriftCodec$Encoder$$$getPrimitiveType(StandardType.IntType$.MODULE$));
                    this.writePrimitiveType((StandardType<A>)StandardType.IntType$.MODULE$, (A)BoxesRunTime.boxToInteger((int)v.getDays()));
                    this.writeFieldEnd();
                    return;
                }
                if (StandardType.YearType$.MODULE$.equals(standardType2) && object instanceof Year) {
                    Year v = (Year)object;
                    this.writeI32(v.getValue());
                    return;
                }
                if (StandardType.YearMonthType$.MODULE$.equals(standardType2) && object instanceof YearMonth) {
                    YearMonth v = (YearMonth)object;
                    this.writeFieldBegin((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)1)), ThriftCodec$Encoder$.MODULE$.zio$schema$codec$ThriftCodec$Encoder$$$getPrimitiveType(StandardType.IntType$.MODULE$));
                    this.writePrimitiveType((StandardType<A>)StandardType.IntType$.MODULE$, (A)BoxesRunTime.boxToInteger((int)v.getYear()));
                    this.writeFieldBegin((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)2)), ThriftCodec$Encoder$.MODULE$.zio$schema$codec$ThriftCodec$Encoder$$$getPrimitiveType(StandardType.IntType$.MODULE$));
                    this.writePrimitiveType((StandardType<A>)StandardType.IntType$.MODULE$, (A)BoxesRunTime.boxToInteger((int)v.getMonthValue()));
                    this.writeFieldEnd();
                    return;
                }
                if (StandardType.ZoneIdType$.MODULE$.equals(standardType2) && object instanceof ZoneId) {
                    ZoneId v = (ZoneId)object;
                    this.writeString(v.getId());
                    return;
                }
                if (StandardType.ZoneOffsetType$.MODULE$.equals(standardType2) && object instanceof ZoneOffset) {
                    ZoneOffset v = (ZoneOffset)object;
                    this.writeI32(v.getTotalSeconds());
                    return;
                }
                if (StandardType.DurationType$.MODULE$.equals(standardType2) && object instanceof Duration) {
                    Duration v = (Duration)object;
                    this.writeFieldBegin((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)1)), ThriftCodec$Encoder$.MODULE$.zio$schema$codec$ThriftCodec$Encoder$$$getPrimitiveType(StandardType.LongType$.MODULE$));
                    this.writePrimitiveType((StandardType<A>)StandardType.LongType$.MODULE$, (A)BoxesRunTime.boxToLong((long)v.getSeconds()));
                    this.writeFieldBegin((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)2)), ThriftCodec$Encoder$.MODULE$.zio$schema$codec$ThriftCodec$Encoder$$$getPrimitiveType(StandardType.IntType$.MODULE$));
                    this.writePrimitiveType((StandardType<A>)StandardType.IntType$.MODULE$, (A)BoxesRunTime.boxToInteger((int)v.getNano()));
                    this.writeFieldEnd();
                    return;
                }
                if (StandardType.InstantType$.MODULE$.equals(standardType2) && object instanceof Instant) {
                    Instant v = (Instant)object;
                    this.p.writeString(v.toString());
                    return;
                }
                if (StandardType.LocalDateType$.MODULE$.equals(standardType2) && object instanceof LocalDate) {
                    LocalDate v = (LocalDate)object;
                    this.p.writeString(v.toString());
                    return;
                }
                if (StandardType.LocalTimeType$.MODULE$.equals(standardType2) && object instanceof LocalTime) {
                    LocalTime v = (LocalTime)object;
                    this.p.writeString(v.toString());
                    return;
                }
                if (StandardType.LocalDateTimeType$.MODULE$.equals(standardType2) && object instanceof LocalDateTime) {
                    LocalDateTime v = (LocalDateTime)object;
                    this.p.writeString(v.toString());
                    return;
                }
                if (StandardType.OffsetTimeType$.MODULE$.equals(standardType2) && object instanceof OffsetTime) {
                    OffsetTime v = (OffsetTime)object;
                    this.p.writeString(v.toString());
                    return;
                }
                if (StandardType.OffsetDateTimeType$.MODULE$.equals(standardType2) && object instanceof OffsetDateTime) {
                    OffsetDateTime v = (OffsetDateTime)object;
                    this.p.writeString(v.toString());
                    return;
                }
                if (StandardType.ZonedDateTimeType$.MODULE$.equals(standardType2) && object instanceof ZonedDateTime) {
                    ZonedDateTime v = (ZonedDateTime)object;
                    this.p.writeString(v.toString());
                    return;
                }
                this.fail(new StringBuilder(15).append("No encoder for ").append(standardType).toString());
                return;
            }
            throw new MatchError((Object)tuple2);
        }

        public static final class Context
        implements Product,
        Serializable {
            private final Option fieldNumber;

            public static Context apply(Option<Object> option) {
                return ThriftCodec$Encoder$Context$.MODULE$.apply(option);
            }

            public static Context fromProduct(Product product) {
                return ThriftCodec$Encoder$Context$.MODULE$.fromProduct(product);
            }

            public static Context unapply(Context context) {
                return ThriftCodec$Encoder$Context$.MODULE$.unapply(context);
            }

            public Context(Option<Object> fieldNumber) {
                this.fieldNumber = fieldNumber;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof Context)) return false;
                Context context = (Context)object;
                Option<Object> option = this.fieldNumber();
                Option<Object> option2 = context.fieldNumber();
                if (option != null) {
                    if (!option.equals(option2)) return false;
                    return true;
                }
                if (option2 == null) return true;
                return false;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof Context;
            }

            public int productArity() {
                return 1;
            }

            public String productPrefix() {
                return "Context";
            }

            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "fieldNumber";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }

            public Option<Object> fieldNumber() {
                return this.fieldNumber;
            }

            public Context copy(Option<Object> fieldNumber) {
                return new Context(fieldNumber);
            }

            public Option<Object> copy$default$1() {
                return this.fieldNumber();
            }

            public Option<Object> _1() {
                return this.fieldNumber();
            }
        }
    }
}

