/*
 * Decompiled with CFR 0.152.
 */
package zio.schema.codec;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.time.Duration;
import java.time.Month;
import java.time.MonthDay;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.util.Either;
import zio.Cause$;
import zio.Chunk;
import zio.Chunk$;
import zio.ChunkCanBuildFrom$;
import zio.ChunkLike$;
import zio.ZIO$;
import zio.schema.Schema;
import zio.schema.StandardType;
import zio.schema.codec.BinaryCodec;
import zio.schema.codec.Codec;
import zio.schema.codec.DecodeError;
import zio.schema.codec.Decoder;
import zio.schema.codec.Encoder;
import zio.schema.codec.MessagePackDecoder;
import zio.schema.codec.MessagePackEncoder;
import zio.schema.validation.Validation;
import zio.stream.ZPipeline;
import zio.stream.ZPipeline$;

public final class MessagePackCodec$
implements BinaryCodec {
    public static MessagePackCodec$ MODULE$;
    private final Seq<Schema.Field<BigDecimal, ?>> bigDecimalStructure;
    private final Seq<Schema.Field<MonthDay, Object>> monthDayStructure;
    private final Seq<Schema.Field<Period, Object>> periodStructure;
    private final Seq<Schema.Field<YearMonth, Object>> yearMonthStructure;
    private final Seq<Schema.Field<Duration, ?>> durationStructure;

    static {
        new MessagePackCodec$();
    }

    public final <A> ZPipeline<Object, Nothing$, A, Object> encoder(Schema<A> schema) {
        return Codec.encoder$((Codec)this, schema);
    }

    public final <A> ZPipeline<Object, DecodeError, Object, A> decoder(Schema<A> schema) {
        return Codec.decoder$((Codec)this, schema);
    }

    public final <A> Function1<A, Chunk<Object>> encode(Schema<A> schema) {
        return Codec.encode$((Codec)this, schema);
    }

    public final <A> Function1<Chunk<Object>, Either<DecodeError, A>> decode(Schema<A> schema) {
        return Codec.decode$((Codec)this, schema);
    }

    public <A> Encoder<Chunk<Object>, Object, A> encoderFor(Schema<A> schema) {
        return new Encoder<Chunk<Object>, Object, A>(schema){
            private final Schema schema$1;

            public Chunk<Object> encode(A value) {
                return new MessagePackEncoder().encode(this.schema$1, value);
            }

            public ZPipeline<Object, Nothing$, A, Object> streamEncoder() {
                MessagePackEncoder encoder = new MessagePackEncoder();
                return ZPipeline$.MODULE$.mapChunks((Function1 & Serializable & scala.Serializable)chunk -> (Chunk)chunk.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> encoder.encode($this.schema$1, x$1), (CanBuildFrom)ChunkLike$.MODULE$.chunkCanBuildFrom(ChunkCanBuildFrom$.MODULE$.chunkCanBuildFromByte())), (Object)"zio.schema.codec.MessagePackCodec.encoderFor.$anon.streamEncoder(MessagePackCodec.scala:20)");
            }
            {
                this.schema$1 = schema$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$streamEncoder$1(zio.schema.codec.MessagePackCodec$$anon$1 zio.schema.codec.MessagePackEncoder zio.Chunk ), $anonfun$streamEncoder$2(zio.schema.codec.MessagePackCodec$$anon$1 zio.schema.codec.MessagePackEncoder java.lang.Object )}, serializedLambda);
            }
        };
    }

    public <A> Decoder<Chunk<Object>, Object, A> decoderFor(Schema<A> schema) {
        return new Decoder<Chunk<Object>, Object, A>(schema){
            private final Schema schema$2;

            public Either<DecodeError, A> decode(Chunk<Object> chunk) {
                if (chunk.isEmpty()) {
                    return package$.MODULE$.Left().apply((Object)new DecodeError.ReadError(Cause$.MODULE$.empty(), "No bytes to decode"));
                }
                return this.decodeChunk(chunk);
            }

            public ZPipeline<Object, DecodeError, Object, A> streamDecoder() {
                return ZPipeline$.MODULE$.mapChunksZIO((Function1 & Serializable & scala.Serializable)chunk -> ZIO$.MODULE$.fromEither((Function0 & Serializable & scala.Serializable)() -> this.decodeChunk((Chunk<Object>)chunk).map((Function1 & Serializable & scala.Serializable)x$2 -> Chunk$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{x$2}))), (Object)"zio.schema.codec.MessagePackCodec.decoderFor.$anon.streamDecoder(MessagePackCodec.scala:36)"), (Object)"zio.schema.codec.MessagePackCodec.decoderFor.$anon.streamDecoder(MessagePackCodec.scala:35)");
            }

            private Either<DecodeError, A> decodeChunk(Chunk<Object> chunk) {
                return new MessagePackDecoder(chunk).decode(this.schema$2).left().map((Function1 & Serializable & scala.Serializable)x -> (DecodeError)Predef$.MODULE$.identity(x));
            }
            {
                this.schema$2 = schema$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$streamDecoder$1(zio.schema.codec.MessagePackCodec$$anon$2 zio.Chunk ), $anonfun$decodeChunk$1(zio.schema.codec.DecodeError ), $anonfun$streamDecoder$3(java.lang.Object ), $anonfun$streamDecoder$2(zio.schema.codec.MessagePackCodec$$anon$2 zio.Chunk )}, serializedLambda);
            }
        };
    }

    public Seq<Schema.Field<BigDecimal, ?>> bigDecimalStructure() {
        return this.bigDecimalStructure;
    }

    public Seq<Schema.Field<MonthDay, Object>> monthDayStructure() {
        return this.monthDayStructure;
    }

    public Seq<Schema.Field<Period, Object>> periodStructure() {
        return this.periodStructure;
    }

    public Seq<Schema.Field<YearMonth, Object>> yearMonthStructure() {
        return this.yearMonthStructure;
    }

    public Seq<Schema.Field<Duration, ?>> durationStructure() {
        return this.durationStructure;
    }

    public static final /* synthetic */ BigDecimal $anonfun$bigDecimalStructure$4(BigDecimal a, int b) {
        return new BigDecimal(a.unscaledValue(), new MathContext(b));
    }

    private MessagePackCodec$() {
        MODULE$ = this;
        Codec.$init$((Codec)this);
        String x$1 = "unscaled";
        Schema.Primitive x$2 = new Schema.Primitive((StandardType)StandardType.BigIntegerType$.MODULE$, Schema.Primitive$.MODULE$.apply$default$2());
        Function1 & Serializable & scala.Serializable x$32 = (Function1 & Serializable & scala.Serializable)x$3 -> x$3.unscaledValue();
        Function2 & Serializable & scala.Serializable x$42 = (Function2 & Serializable & scala.Serializable)(a, b) -> new BigDecimal((BigInteger)b, a.scale());
        Chunk x$52 = Schema.Field$.MODULE$.apply$default$3();
        Validation x$62 = Schema.Field$.MODULE$.apply$default$4();
        String x$72 = "precision";
        Schema.Primitive x$82 = new Schema.Primitive((StandardType)StandardType.IntType$.MODULE$, Schema.Primitive$.MODULE$.apply$default$2());
        Function1 & Serializable & scala.Serializable x$92 = (Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.precision());
        Function2 & Serializable & scala.Serializable x$102 = (Function2 & Serializable & scala.Serializable)(a, b) -> MessagePackCodec$.$anonfun$bigDecimalStructure$4(a, BoxesRunTime.unboxToInt((Object)b));
        Chunk x$112 = Schema.Field$.MODULE$.apply$default$3();
        Validation x$122 = Schema.Field$.MODULE$.apply$default$4();
        String x$132 = "scale";
        Schema.Primitive x$14 = new Schema.Primitive((StandardType)StandardType.IntType$.MODULE$, Schema.Primitive$.MODULE$.apply$default$2());
        Function1 & Serializable & scala.Serializable x$15 = (Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.scale());
        Function2 & Serializable & scala.Serializable x$16 = (Function2 & Serializable & scala.Serializable)(a, b) -> a.setScale(BoxesRunTime.unboxToInt((Object)b));
        Chunk x$17 = Schema.Field$.MODULE$.apply$default$3();
        Validation x$18 = Schema.Field$.MODULE$.apply$default$4();
        this.bigDecimalStructure = new .colon.colon((Object)Schema.Field$.MODULE$.apply(x$1, (Schema)x$2, x$52, x$62, (Function1)x$32, (Function2)x$42), (List)new .colon.colon((Object)Schema.Field$.MODULE$.apply(x$72, (Schema)x$82, x$112, x$122, (Function1)x$92, (Function2)x$102), (List)new .colon.colon((Object)Schema.Field$.MODULE$.apply(x$132, (Schema)x$14, x$17, x$18, (Function1)x$15, (Function2)x$16), (List)Nil$.MODULE$)));
        String x$19 = "month";
        Schema.Primitive x$20 = new Schema.Primitive((StandardType)StandardType.IntType$.MODULE$, Schema.Primitive$.MODULE$.apply$default$2());
        Function1 & Serializable & scala.Serializable x$21 = (Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToInteger((int)v.getMonthValue());
        Function2 & Serializable & scala.Serializable x$22 = (Function2 & Serializable & scala.Serializable)(a, b) -> a.with(Month.of(BoxesRunTime.unboxToInt((Object)b)));
        Chunk x$23 = Schema.Field$.MODULE$.apply$default$3();
        Validation x$24 = Schema.Field$.MODULE$.apply$default$4();
        String x$25 = "day";
        Schema.Primitive x$26 = new Schema.Primitive((StandardType)StandardType.IntType$.MODULE$, Schema.Primitive$.MODULE$.apply$default$2());
        Function1 & Serializable & scala.Serializable x$27 = (Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.getDayOfMonth());
        Function2 & Serializable & scala.Serializable x$28 = (Function2 & Serializable & scala.Serializable)(a, b) -> a.withDayOfMonth(BoxesRunTime.unboxToInt((Object)b));
        Chunk x$29 = Schema.Field$.MODULE$.apply$default$3();
        Validation x$30 = Schema.Field$.MODULE$.apply$default$4();
        this.monthDayStructure = new .colon.colon((Object)Schema.Field$.MODULE$.apply(x$19, (Schema)x$20, x$23, x$24, (Function1)x$21, (Function2)x$22), (List)new .colon.colon((Object)Schema.Field$.MODULE$.apply(x$25, (Schema)x$26, x$29, x$30, (Function1)x$27, (Function2)x$28), (List)Nil$.MODULE$));
        String x$31 = "years";
        Schema.Primitive x$322 = new Schema.Primitive((StandardType)StandardType.IntType$.MODULE$, Schema.Primitive$.MODULE$.apply$default$2());
        Function1 & Serializable & scala.Serializable x$33 = (Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.getYears());
        Function2 & Serializable & scala.Serializable x$34 = (Function2 & Serializable & scala.Serializable)(a, b) -> a.withYears(BoxesRunTime.unboxToInt((Object)b));
        Chunk x$35 = Schema.Field$.MODULE$.apply$default$3();
        Validation x$36 = Schema.Field$.MODULE$.apply$default$4();
        String x$37 = "months";
        Schema.Primitive x$38 = new Schema.Primitive((StandardType)StandardType.IntType$.MODULE$, Schema.Primitive$.MODULE$.apply$default$2());
        Function1 & Serializable & scala.Serializable x$39 = (Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.getMonths());
        Function2 & Serializable & scala.Serializable x$40 = (Function2 & Serializable & scala.Serializable)(a, b) -> a.withMonths(BoxesRunTime.unboxToInt((Object)b));
        Chunk x$41 = Schema.Field$.MODULE$.apply$default$3();
        Validation x$422 = Schema.Field$.MODULE$.apply$default$4();
        String x$43 = "days";
        Schema.Primitive x$44 = new Schema.Primitive((StandardType)StandardType.IntType$.MODULE$, Schema.Primitive$.MODULE$.apply$default$2());
        Function1 & Serializable & scala.Serializable x$45 = (Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.getDays());
        Function2 & Serializable & scala.Serializable x$46 = (Function2 & Serializable & scala.Serializable)(a, b) -> a.withDays(BoxesRunTime.unboxToInt((Object)b));
        Chunk x$47 = Schema.Field$.MODULE$.apply$default$3();
        Validation x$48 = Schema.Field$.MODULE$.apply$default$4();
        this.periodStructure = new .colon.colon((Object)Schema.Field$.MODULE$.apply(x$31, (Schema)x$322, x$35, x$36, (Function1)x$33, (Function2)x$34), (List)new .colon.colon((Object)Schema.Field$.MODULE$.apply(x$37, (Schema)x$38, x$41, x$422, (Function1)x$39, (Function2)x$40), (List)new .colon.colon((Object)Schema.Field$.MODULE$.apply(x$43, (Schema)x$44, x$47, x$48, (Function1)x$45, (Function2)x$46), (List)Nil$.MODULE$)));
        String x$49 = "year";
        Schema.Primitive x$50 = new Schema.Primitive((StandardType)StandardType.IntType$.MODULE$, Schema.Primitive$.MODULE$.apply$default$2());
        Function1 & Serializable & scala.Serializable x$51 = (Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.getYear());
        Function2 & Serializable & scala.Serializable x$522 = (Function2 & Serializable & scala.Serializable)(a, b) -> a.with(Year.of(BoxesRunTime.unboxToInt((Object)b)));
        Chunk x$53 = Schema.Field$.MODULE$.apply$default$3();
        Validation x$54 = Schema.Field$.MODULE$.apply$default$4();
        String x$55 = "month";
        Schema.Primitive x$56 = new Schema.Primitive((StandardType)StandardType.IntType$.MODULE$, Schema.Primitive$.MODULE$.apply$default$2());
        Function1 & Serializable & scala.Serializable x$57 = (Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.getMonthValue());
        Function2 & Serializable & scala.Serializable x$58 = (Function2 & Serializable & scala.Serializable)(a, b) -> a.with(Month.of(BoxesRunTime.unboxToInt((Object)b)));
        Chunk x$59 = Schema.Field$.MODULE$.apply$default$3();
        Validation x$60 = Schema.Field$.MODULE$.apply$default$4();
        this.yearMonthStructure = new .colon.colon((Object)Schema.Field$.MODULE$.apply(x$49, (Schema)x$50, x$53, x$54, (Function1)x$51, (Function2)x$522), (List)new .colon.colon((Object)Schema.Field$.MODULE$.apply(x$55, (Schema)x$56, x$59, x$60, (Function1)x$57, (Function2)x$58), (List)Nil$.MODULE$));
        String x$61 = "seconds";
        Schema.Primitive x$622 = new Schema.Primitive((StandardType)StandardType.LongType$.MODULE$, Schema.Primitive$.MODULE$.apply$default$2());
        Function1 & Serializable & scala.Serializable x$63 = (Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.getSeconds());
        Function2 & Serializable & scala.Serializable x$64 = (Function2 & Serializable & scala.Serializable)(a, b) -> a.plusSeconds(BoxesRunTime.unboxToLong((Object)b));
        Chunk x$65 = Schema.Field$.MODULE$.apply$default$3();
        Validation x$66 = Schema.Field$.MODULE$.apply$default$4();
        String x$67 = "nanos";
        Schema.Primitive x$68 = new Schema.Primitive((StandardType)StandardType.IntType$.MODULE$, Schema.Primitive$.MODULE$.apply$default$2());
        Function1 & Serializable & scala.Serializable x$69 = (Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13.getNano());
        Function2 & Serializable & scala.Serializable x$70 = (Function2 & Serializable & scala.Serializable)(a, b) -> a.plusNanos(BoxesRunTime.unboxToInt((Object)b));
        Chunk x$71 = Schema.Field$.MODULE$.apply$default$3();
        Validation x$722 = Schema.Field$.MODULE$.apply$default$4();
        this.durationStructure = new .colon.colon((Object)Schema.Field$.MODULE$.apply(x$61, (Schema)x$622, x$65, x$66, (Function1)x$63, (Function2)x$64), (List)new .colon.colon((Object)Schema.Field$.MODULE$.apply(x$67, (Schema)x$68, x$71, x$722, (Function1)x$69, (Function2)x$70), (List)Nil$.MODULE$));
    }
}

