/*
 * Decompiled with CFR 0.152.
 */
package zio.schema.doc.generator;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Vector;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;
import scala.util.matching.Regex;
import zio.schema.doc.generator.Main;
import zio.schema.doc.generator.Main$StandardTypeForDoc$;

public final class Main$
implements Serializable {
    private static final File standardTypeFile;
    private static final Main$StandardTypeForDoc$ StandardTypeForDoc;
    public static final Main$ MODULE$;

    private Main$() {
    }

    static {
        MODULE$ = new Main$();
        standardTypeFile = Paths.get(".", "zio-schema", "jvm", "src", "main", "scala", "zio", "schema", "StandardType.scala").toFile();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Main$.class);
    }

    private String convertBooleanToText(boolean bool) {
        if (bool) {
            return "\u2705";
        }
        return "\u274c";
    }

    private String generateStandardTypeFileText(File standardTypeFile) {
        String string;
        Regex standardTypeRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("StandardType\\[.*"));
        Regex suffixRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("((])(?!.*])).*"));
        ObjectRef unsortedStandardTypes = ObjectRef.create((Object)package$.MODULE$.Vector().empty());
        ObjectRef markdownFile = ObjectRef.create((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("---\n        |id: standard-type-reference\n        |title: \"Standard Type Reference\"\n        |---\n        |# Standard Type Reference\n        |\n        |ZIO Schema provides a number of built-in primitive types, that we can use to represent our data. These can be seen in the following table:\n        |\n        ||Standard Type|JVM Support|ScalaJS Support|Scala Native Support|\n        ||--------------|:--------------:|:--------------:|:--------------:|")));
        try (BufferedSource source = Source$.MODULE$.fromFile(standardTypeFile, Codec$.MODULE$.fallbackSystemCodec());){
            source.getLines().foreach((Function1)(JProcedure1 & Serializable)line -> {
                if (line.contains("implicit object")) {
                    Main.StandardTypeForDoc standardTypeForDoc;
                    String unparsedLine = (String)standardTypeRegex.findFirstIn((CharSequence)line).getOrElse(this::$anonfun$1);
                    String trimmedLine = unparsedLine.trim();
                    String lineWithoutPrefix = trimmedLine.replace("StandardType[", "");
                    String standardTypeStr = suffixRegex.replaceFirstIn((CharSequence)lineWithoutPrefix, "");
                    String string = standardTypeStr;
                    if ("java.util.UUID".equals(string)) {
                        String typ = string;
                        standardTypeForDoc = Main$StandardTypeForDoc$.MODULE$.apply(typ, Main$StandardTypeForDoc$.MODULE$.$lessinit$greater$default$2(), false, Main$StandardTypeForDoc$.MODULE$.$lessinit$greater$default$4());
                    } else if ("java.util.Currency".equals(string)) {
                        String typ = string;
                        standardTypeForDoc = Main$StandardTypeForDoc$.MODULE$.apply(typ, Main$StandardTypeForDoc$.MODULE$.$lessinit$greater$default$2(), false, false);
                    } else {
                        String typ = string;
                        standardTypeForDoc = Main$StandardTypeForDoc$.MODULE$.apply(typ, Main$StandardTypeForDoc$.MODULE$.$lessinit$greater$default$2(), Main$StandardTypeForDoc$.MODULE$.$lessinit$greater$default$3(), Main$StandardTypeForDoc$.MODULE$.$lessinit$greater$default$4());
                    }
                    Main.StandardTypeForDoc standardTypeForDoc2 = standardTypeForDoc;
                    Vector vector = (Vector)((Vector)unsortedStandardTypes$1.elem).$colon$plus((Object)standardTypeForDoc2);
                    unsortedStandardTypes$1.elem = vector;
                    vector = null;
                    return;
                }
            });
            Vector sortedStandardTypes = (Vector)((Vector)unsortedStandardTypes.elem).sortBy((Function1 & Serializable)_$1 -> _$1.name(), (Ordering)Ordering.String$.MODULE$);
            sortedStandardTypes.foreach((Function1)(JProcedure1 & Serializable)standardType -> {
                String jsSupport = this.convertBooleanToText(standardType.isJSSupported());
                String jvmSupport = this.convertBooleanToText(standardType.isJVMSupported());
                String nativeSupport = this.convertBooleanToText(standardType.isNativeSupported());
                String string = new StringBuilder(0).append((String)markdownFile$1.elem).append(new StringBuilder(8).append("\n|`").append(standardType.name()).append("`|").append(jvmSupport).append("|").append(jsSupport).append("|").append(nativeSupport).append("|").toString()).toString();
                markdownFile$1.elem = string;
                string = null;
            });
            string = (String)markdownFile.elem;
        }
        return string;
    }

    public void main(String[] args) {
        String table = this.generateStandardTypeFileText(standardTypeFile);
        Files.write(Paths.get(".", "docs", "standard-type-reference.md"), table.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private final String $anonfun$1() {
        return "Expected StandardType to be present in line while parsing standard type doc";
    }
}

